/*
 * Decompiled with CFR 0.152.
 */
package gishur.x;

import gishur.x.Intersectable;
import gishur.x.Intersection;
import gishur.x.IntersectionException;
import gishur.x.XBaseline;
import gishur.x.XLine;
import gishur.x.XPoint;
import gishur.x.XRay;

public class XSegment
extends XBaseline
implements Intersectable,
Cloneable {
    private Object intersection_impl(XBaseline xBaseline) {
        Object object = super.baseIntersection(xBaseline);
        if (object instanceof XPoint) {
            XPoint xPoint = (XPoint)object;
            if (!this.inBounds(xPoint.x, xPoint.y)) {
                return null;
            }
            if (!xBaseline.inBounds(xPoint.x, xPoint.y)) {
                return null;
            }
            return object;
        }
        if (object instanceof XBaseline) {
            if (xBaseline instanceof XLine) {
                return new XSegment(this);
            }
            if (xBaseline instanceof XRay) {
                if (!this.liesOn(xBaseline._source)) {
                    if (xBaseline.liesOn(this._source)) {
                        return new XSegment(this);
                    }
                    return null;
                }
                if (xBaseline.liesOn(this._source)) {
                    return new XSegment(this._source, xBaseline._source);
                }
                if (xBaseline.liesOn(this._target)) {
                    return new XSegment(xBaseline._source, this._target);
                }
                return null;
            }
            if (xBaseline instanceof XSegment) {
                XSegment xSegment = (XSegment)xBaseline;
                if (this.vertical()) {
                    double d;
                    double d2 = Math.max(Math.min(this._source.y, this._target.y), Math.min(xSegment._source.y, xSegment._target.y));
                    if (d2 > (d = Math.min(Math.max(this._source.y, this._target.y), Math.max(xSegment._source.y, xSegment._target.y)))) {
                        return null;
                    }
                    return new XSegment(this._source.x, d2, this._source.x, d);
                }
                XPoint xPoint = this.getStartPoint();
                XPoint xPoint2 = this.getEndPoint();
                XPoint xPoint3 = xSegment.getStartPoint();
                XPoint xPoint4 = xSegment.getEndPoint();
                if (xPoint3.x > xPoint2.x || xPoint4.x < xPoint.x) {
                    return null;
                }
                if (xPoint3.x <= xPoint.x && xPoint4.x >= xPoint2.x) {
                    return new XSegment(xPoint, xPoint2);
                }
                if (xPoint3.x <= xPoint.x && xPoint4.x < xPoint2.x) {
                    return new XSegment(xPoint, xPoint4);
                }
                if (xPoint3.x > xPoint.x && xPoint4.x >= xPoint2.x) {
                    return new XSegment(xPoint3, xPoint2);
                }
                if (xPoint3.x > xPoint.x && xPoint4.x < xPoint2.x) {
                    return new XSegment(xPoint3, xPoint4);
                }
            }
            return null;
        }
        return null;
    }

    boolean inBounds(double d, double d2) {
        if (this.vertical()) {
            return d2 >= Math.min(this._source.y, this._target.y) - 1.0E-7 && d2 <= Math.max(this._source.y, this._target.y) + 1.0E-7;
        }
        return d >= Math.min(this._source.x, this._target.x) - 1.0E-7 && d <= Math.max(this._source.x, this._target.x) + 1.0E-7;
    }

    public XPoint getStartPoint() {
        if (this._source.x < this._target.x) {
            return this._source;
        }
        if (this._source.x > this._target.x) {
            return this._target;
        }
        if (this._source.y <= this._target.y) {
            return this._source;
        }
        return this._target;
    }

    public String toString(boolean bl, boolean bl2, boolean bl3) {
        String string = "";
        if (bl && bl2) {
            string = string + "," + this._source.toString(true) + "-" + this._target.toString(true);
        } else {
            if (bl) {
                string = string + "," + this._source.toString(true);
            }
            if (bl2) {
                string = string + "," + this._target.toString(true);
            }
        }
        if (bl3) {
            string = string + ",slope=" + this.slope();
        }
        return string.substring(1);
    }

    public XSegment() {
        this.set(0.0, 0.0, 0.0, 0.0);
    }

    public XSegment(double d, double d2, double d3, double d4) {
        this.set(d, d2, d3, d4);
    }

    public XSegment(XPoint xPoint, XPoint xPoint2) {
        this.set(xPoint.x(), xPoint.y(), xPoint2.x(), xPoint2.y());
    }

    public XSegment(XSegment xSegment) {
        this.copy(xSegment);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.toString(true, true, true) + "]";
    }

    public boolean contains(double d, double d2) {
        if (this.vertical()) {
            return Math.abs(d - this._source.x) <= 1.0E-7 && d2 >= Math.min(this._source.y, this._target.y) - 1.0E-7 && d2 <= Math.max(this._source.y, this._target.y) + 1.0E-7;
        }
        XPoint xPoint = this.calculatePoint(d);
        if (xPoint != null) {
            return xPoint.equals(d, d2);
        }
        return false;
    }

    public boolean supportsIntersection(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof XPoint) {
            return true;
        }
        if (object instanceof XSegment) {
            return true;
        }
        if (object instanceof XRay) {
            return true;
        }
        return object instanceof XLine;
    }

    public boolean incident(XBaseline xBaseline) {
        if ((xBaseline instanceof XRay || xBaseline instanceof XSegment) && (this._source.equals(xBaseline._source) || this._target.equals(xBaseline._source))) {
            return true;
        }
        return xBaseline instanceof XSegment && (this._source.equals(xBaseline._target) || this._target.equals(xBaseline._target));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSegment) {
            XSegment xSegment = (XSegment)object;
            if (xSegment._source.equals(this._source) && xSegment._target.equals(this._target)) {
                return true;
            }
            return xSegment._target.equals(this._source) && xSegment._source.equals(this._target);
        }
        return false;
    }

    public void copy(XSegment xSegment) {
        if (xSegment == null) {
            return;
        }
        this.set(xSegment._source.x, xSegment._source.y, xSegment._target.x, xSegment._target.y);
    }

    public Intersection intersection(Object object) {
        if (this.supportsIntersection(object)) {
            if (object instanceof XPoint) {
                if (this.liesOn((XPoint)object)) {
                    return new Intersection(((XPoint)object).clone());
                }
                return new Intersection();
            }
            if (object instanceof XBaseline) {
                return new Intersection(this.intersection_impl((XBaseline)object));
            }
        } else {
            if (object instanceof Intersectable && ((Intersectable)object).supportsIntersection(this)) {
                return ((Intersectable)object).intersection(this);
            }
            throw new IntersectionException(this, this, object);
        }
        throw new IntersectionException(this, this, object);
    }

    public XPoint calculatePointOn(double d) {
        XPoint xPoint = d >= 0.0 ? this.getPointInLineDirection(this._source, d) : this.getPointInLineDirection(this._target, d);
        if (this.liesOn(xPoint)) {
            return xPoint;
        }
        return null;
    }

    public void swapPoints() {
        XPoint xPoint = this._source;
        this._source = this._target;
        this._target = xPoint;
    }

    public XPoint calculatePoint(double d) {
        if (this.vertical()) {
            if (Math.abs(d - this._source.x) <= 1.0E-7) {
                return new XPoint(this._source);
            }
            return null;
        }
        if (d <= this._source.x + 1.0E-7 && d >= this._target.x - 1.0E-7 || d >= this._source.x - 1.0E-7 && d <= this._target.x + 1.0E-7) {
            return super.calculatePoint(d);
        }
        return null;
    }

    public XPoint getEndPoint() {
        if (this._source.x < this._target.x) {
            return this._target;
        }
        if (this._source.x > this._target.x) {
            return this._source;
        }
        if (this._source.y <= this._target.y) {
            return this._target;
        }
        return this._source;
    }

    public double length() {
        return this._source.distance(this._target);
    }
}

