/*
 * Decompiled with CFR 0.152.
 */
package gishur.x.voronoi;

import gishur.core.Cloneable;
import gishur.core.ListItem;
import gishur.core.SimpleList;
import gishur.x.Intersectable;
import gishur.x.Intersection;
import gishur.x.XBaseline;
import gishur.x.XLine;
import gishur.x.XObject;
import gishur.x.XParabola;
import gishur.x.XPoint;
import gishur.x.XRay;
import gishur.x.XSegment;
import gishur.x.voronoi.SKR;
import gishur.x.voronoi.Skeleton;
import gishur.x.voronoi.VoronoiException;
import java.util.Hashtable;

public class SkEdge
implements Cloneable {
    public static final byte LINEAR = 0;
    public static final byte PARABOLIC = 1;
    public static final int FREE = 0;
    public static final int CONCAVE_EDGE = 1;
    public static final int LINK_FORWARD = 4;
    public static final int LINK_BACKWARD = 5;
    public static final int LINK_BOTH = 6;
    private SKR left;
    private SKR right;
    private ListItem ID;
    private ListItem ID_left;
    private ListItem ID_right;
    private int linktype = 0;
    private Intersectable base = null;
    private byte type = 0;

    public ListItem leftID() {
        return this.ID_left;
    }

    public XParabola xparabola() {
        if (this.type == 1) {
            return (XParabola)this.base;
        }
        return null;
    }

    public XPoint source() {
        if (this.base == null) {
            return null;
        }
        if (this.type == 0) {
            return ((XSegment)this.base).source();
        }
        if (this.type == 1) {
            return ((XParabola)this.base).source();
        }
        return null;
    }

    public byte type() {
        return this.type;
    }

    public SkEdge nextLeftEdge() {
        return this.left.next(this);
    }

    public SkEdge nextRightEdge() {
        return this.right.prev(this);
    }

    public void setLinktype(SkEdge skEdge) {
        if (this.source() == null || this.target() == null || skEdge.source() == null || skEdge.target() == null) {
            return;
        }
        int n = -1;
        if (this.source().equals(skEdge.target())) {
            n = 5;
        }
        if (this.source().equals(skEdge.source())) {
            n = 5;
        }
        if (this.target().equals(skEdge.target())) {
            n = 4;
        }
        if (this.target().equals(skEdge.source())) {
            n = 4;
        }
        if (n < 0) {
            return;
        }
        if (this.linktype == n || this.linktype == 0) {
            this.linktype = n;
            return;
        }
        if (this.linktype != 1) {
            this.linktype = 6;
        }
    }

    public SkEdge prevLeftEdge() {
        return this.left.prev(this);
    }

    public SkEdge prevRightEdge() {
        return this.right.next(this);
    }

    public SkEdge nextRealLeftEdge() {
        SkEdge skEdge = this.left.next(this);
        SKR sKR = this.left;
        while (skEdge.linktype() == 1) {
            sKR = skEdge.opposite(sKR);
            skEdge = sKR.next(skEdge);
        }
        return skEdge;
    }

    public int linktype() {
        return this.linktype;
    }

    public static XLine constructBisector(XPoint xPoint, XPoint xPoint2) {
        XPoint xPoint3 = new XPoint(xPoint, xPoint2);
        return new XLine(xPoint3.x, xPoint3.y, xPoint3.x - xPoint2.y + xPoint.y, xPoint3.y + xPoint2.x - xPoint.x);
    }

    public static XSegment constructBisector(XSegment xSegment, XSegment xSegment2) {
        XSegment xSegment3 = new XSegment(xSegment);
        xSegment3.flip();
        XSegment xSegment4 = new XLine(xSegment3, xSegment2).getInfiniteSegment();
        XPoint xPoint = xSegment3.plumbTo(xSegment3.source(), xSegment4);
        if (xPoint != null) {
            xSegment4.set(xPoint, xSegment4.target());
        }
        if ((xPoint = xSegment2.plumbTo(xSegment2.source(), xSegment4)) != null) {
            xSegment4.set(xPoint, xSegment4.target());
        }
        if ((xPoint = xSegment3.plumbTo(xSegment3.target(), xSegment4)) == null) {
            return null;
        }
        xSegment4.set(xSegment4.source(), xPoint);
        xPoint = xSegment2.plumbTo(xSegment2.target(), xSegment4);
        if (xPoint != null) {
            xSegment4.set(xSegment4.source(), xPoint);
        }
        return xSegment4;
    }

    public static XParabola constructBisector(XSegment xSegment, XPoint xPoint) {
        return new XParabola(xSegment, xPoint);
    }

    public SKR right() {
        return this.right;
    }

    public Object clone() {
        SkEdge skEdge;
        SKR sKR = this.left;
        SKR sKR2 = this.right;
        ListItem listItem = this.ID;
        ListItem listItem2 = this.ID_left;
        ListItem listItem3 = this.ID_right;
        this.right = null;
        this.left = null;
        this.ID_right = null;
        this.ID_left = null;
        this.ID = null;
        try {
            skEdge = (SkEdge)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Error while cloning");
        }
        skEdge.left = this.left = sKR;
        skEdge.right = this.right = sKR2;
        skEdge.ID = this.ID = listItem;
        skEdge.ID_left = this.ID_left = listItem2;
        skEdge.ID_right = this.ID_right = listItem3;
        if (this.base instanceof XObject) {
            skEdge.base = (Intersectable)((XObject)((Object)this.base)).clone();
        }
        return skEdge;
    }

    public XPoint target() {
        if (this.base == null) {
            return null;
        }
        if (this.type == 0) {
            return ((XSegment)this.base).target();
        }
        if (this.type == 1) {
            return ((XParabola)this.base).target();
        }
        return null;
    }

    public void remove() {
        if (this.left != null) {
            this.left.remove(this);
            this.left = null;
            this.ID_left = null;
        }
        if (this.right != null) {
            this.right.remove(this);
            this.right = null;
            this.ID_right = null;
        }
        SimpleList simpleList = (SimpleList)this.ID.getOwningList();
        simpleList.remove(this.ID);
        this.ID = null;
    }

    public String toString() {
        String string = this.left == null ? "null" : this.left.toShortString();
        String string2 = this.right == null ? "null" : this.right.toShortString();
        return this.getClass().getName() + "[" + this.base + ",left=" + string + ",right=" + string2 + "]";
    }

    private SkEdge(SKR sKR, SKR sKR2, Intersectable intersectable, byte by) {
        this.left = sKR;
        this.right = sKR2;
        this.base = intersectable;
        this.type = by;
        this.ID_right = null;
        this.ID_left = null;
        this.ID = null;
    }

    public SkEdge(Skeleton skeleton, SKR sKR, SKR sKR2) {
        XPoint xPoint;
        XSegment xSegment;
        this.left = sKR;
        this.right = sKR2;
        if (skeleton == null || sKR == null || sKR2 == null) {
            throw new VoronoiException(3, this);
        }
        if (sKR.type() == 0 && sKR2.type() == 0) {
            this.base = SkEdge.constructBisector(sKR.xsegment(), sKR2.xsegment());
            this.type = 0;
        }
        if (sKR.type() == 1 && sKR2.type() == 0) {
            xSegment = sKR2.xsegment();
            xPoint = new XPoint(xSegment.source().x - xSegment.target().y + xSegment.source().y, xSegment.source().y + xSegment.target().x - xSegment.source().x);
            this.base = new XRay(xSegment.source(), xPoint).getInfiniteSegment();
            this.linktype = 1;
            this.type = 0;
        }
        if (sKR.type() == 0 && sKR2.type() == 1) {
            xSegment = sKR.xsegment();
            xPoint = new XPoint(xSegment.target().x - xSegment.target().y + xSegment.source().y, xSegment.target().y + xSegment.target().x - xSegment.source().x);
            this.base = new XRay(xSegment.target(), xPoint).getInfiniteSegment();
            this.linktype = 1;
            this.type = 0;
        }
        if (sKR.type() == 1 && sKR2.type() == 1) {
            throw new VoronoiException(3, this);
        }
        this.ID = skeleton.registerEdge(this);
        this.ID_left = sKR.addleft(null, this);
        this.ID_right = sKR2.addright(null, this);
    }

    public SkEdge(Skeleton skeleton, XPoint xPoint, SKR sKR, SKR sKR2, SkEdge skEdge, SkEdge skEdge2) {
        XObject xObject;
        this.left = sKR;
        this.right = sKR2;
        if (skeleton == null || sKR == null || sKR2 == null) {
            throw new VoronoiException(3, this);
        }
        if (sKR.type() == 0 && sKR2.type() == 0) {
            this.base = SkEdge.constructBisector(sKR.xsegment(), sKR2.xsegment());
            this.type = 0;
        }
        if (sKR.type() == 1 && sKR2.type() == 0) {
            xObject = SkEdge.constructBisector(sKR2.xsegment(), sKR.xpoint());
            this.base = xObject;
            this.type = 1;
        }
        if (sKR.type() == 0 && sKR2.type() == 1) {
            xObject = SkEdge.constructBisector(sKR.xsegment(), sKR2.xpoint());
            ((XParabola)xObject).flip();
            this.base = xObject;
            this.type = 1;
        }
        if (sKR.type() == 1 && sKR2.type() == 1) {
            xObject = SkEdge.constructBisector(sKR.xpoint(), sKR2.xpoint());
            XPoint xPoint2 = ((XBaseline)xObject).getDirectionVector();
            XSegment xSegment = new XRay(xPoint.x, xPoint.y, xPoint.x + xPoint2.x, xPoint.y + xPoint2.y).getInfiniteSegment();
            if (Math.abs(xSegment.source().x - xSegment.target().x) < 1.0E-7) {
                xSegment.set(xSegment.source().x, xSegment.source().y, xSegment.source().x, xSegment.target().y);
            }
            this.base = xSegment;
            this.type = 0;
        }
        this.trim(xPoint, false);
        this.ID = skeleton.registerEdge(this);
        this.ID_left = sKR.addleft(skEdge, this);
        this.ID_right = sKR2.addright(skEdge2, this);
    }

    public void trim(XPoint xPoint, boolean bl) {
        if (this.base == null || xPoint == null) {
            return;
        }
        if (this.type == 0) {
            XSegment xSegment = (XSegment)this.base;
            if (bl) {
                xSegment.set(xSegment.source(), xPoint);
            } else {
                xSegment.set(xPoint, xSegment.target());
            }
        }
        if (this.type == 1) {
            if (bl) {
                ((XParabola)this.base).setTarget(xPoint);
                return;
            }
            ((XParabola)this.base).setSource(xPoint);
        }
    }

    public void trim(XPoint xPoint, boolean bl, SKR sKR) {
        if (sKR != this.left && sKR != this.right) {
            return;
        }
        if (sKR == this.right) {
            bl = !bl;
        }
        this.trim(xPoint, bl);
    }

    public SKR opposite(SKR sKR) {
        if (this.left == sKR) {
            return this.right;
        }
        if (this.right == sKR) {
            return this.left;
        }
        return null;
    }

    public boolean isSkeletonVertex(boolean bl) {
        if (bl) {
            return this.nextRealLeftEdge() != this;
        }
        return this.prevLeftEdge().nextRealLeftEdge() != this.prevLeftEdge();
    }

    public boolean contains(XPoint xPoint) {
        if (this.base == null) {
            return false;
        }
        return this.base.contains(xPoint.x, xPoint.y);
    }

    public ListItem oppositeID(SKR sKR) {
        if (this.left == sKR) {
            return this.ID_right;
        }
        if (this.right == sKR) {
            return this.ID_left;
        }
        return null;
    }

    public ListItem rightID() {
        return this.ID_right;
    }

    public Intersectable base() {
        return this.base;
    }

    public SKR left() {
        return this.left;
    }

    void correctID(ListItem listItem) {
        this.ID = listItem;
    }

    public boolean empty() {
        return this.base == null || this.source().equals(this.target());
    }

    void correctSKRs(Hashtable hashtable) {
        this.left = (SKR)hashtable.get(this.left);
        this.right = (SKR)hashtable.get(this.right);
        this.ID_left = (ListItem)hashtable.get(this.ID_left);
        this.ID_right = (ListItem)hashtable.get(this.ID_right);
    }

    public XSegment xsegment() {
        if (this.type == 0) {
            return (XSegment)this.base;
        }
        return null;
    }

    public ListItem ID() {
        return this.ID;
    }

    public ListItem ID(SKR sKR) {
        if (sKR == this.left) {
            return this.ID_left;
        }
        if (sKR == this.right) {
            return this.ID_right;
        }
        return null;
    }

    public XPoint intersect(SkEdge skEdge, XPoint xPoint) {
        if (this.base == null || skEdge.base == null) {
            return null;
        }
        XPoint xPoint2 = null;
        double d = 0.0;
        if (this.base.contains(skEdge.source().x, skEdge.source().y) && (xPoint2 == null || d > xPoint.squareDistance(skEdge.source()))) {
            xPoint2 = new XPoint(skEdge.source());
            d = xPoint.squareDistance(skEdge.source());
        }
        if (this.base.contains(skEdge.target().x, skEdge.target().y) && (xPoint2 == null || d > xPoint.squareDistance(skEdge.target()))) {
            xPoint2 = new XPoint(skEdge.target());
            d = xPoint.squareDistance(skEdge.target());
        }
        if (skEdge.base.contains(this.source().x, this.source().y) && (xPoint2 == null || d > xPoint.squareDistance(this.source()))) {
            xPoint2 = new XPoint(this.source());
            d = xPoint.squareDistance(this.source());
        }
        if (skEdge.base.contains(this.target().x, this.target().y) && (xPoint2 == null || d > xPoint.squareDistance(this.target()))) {
            xPoint2 = new XPoint(this.target());
            d = xPoint.squareDistance(this.target());
        }
        Intersection intersection = this.type == 1 ? ((XParabola)this.base).intersection(skEdge.base) : ((XSegment)this.base).intersection(skEdge.base);
        int n = 0;
        while (n < intersection.length()) {
            if (xPoint2 == null || d > xPoint.squareDistance(intersection.xpoint(n))) {
                xPoint2 = intersection.xpoint(n);
                d = xPoint.squareDistance(xPoint2);
            }
            ++n;
        }
        return xPoint2;
    }
}

