/*
 * Decompiled with CFR 0.152.
 */
package gishur.x.voronoi;

import gishur.core.BasicList;
import gishur.core.Cloneable;
import gishur.core.List;
import gishur.core.ListItem;
import gishur.core.ListView;
import gishur.core.SimpleList;
import gishur.core.algorithms.TraceExecutor;
import gishur.core.algorithms.Tracer;
import gishur.x.XPoint;
import gishur.x.XPolygon;
import gishur.x.XSegment;
import gishur.x.voronoi.SKR;
import gishur.x.voronoi.SkEdge;
import gishur.x.voronoi.VoronoiException;
import java.util.Hashtable;

public class Skeleton
implements TraceExecutor,
Cloneable,
Runnable {
    public static final int LABEL_TYPE_MERGE_CHAINS = 1;
    public static final int LABEL_TYPE_MERGE_STEP = 2;
    public static final int LABEL_TYPE_MERGE_TRIM = 3;
    private SimpleList edges = new SimpleList();
    private SimpleList chains = new SimpleList();
    private XPolygon polygon = null;
    private Tracer tracer = null;
    public static final double MAX_DISTANCE = 4000.0;

    public XPoint[] MIC() {
        if (this.chains.length() != 1) {
            this.execute();
        }
        XPoint xPoint = null;
        XPoint[] xPointArray = null;
        double d = 0.0;
        ListItem listItem = this.edges.first();
        while (listItem != null) {
            SkEdge skEdge = (SkEdge)listItem.key();
            XPoint xPoint2 = skEdge.target();
            if ((skEdge.linktype() == 0 || skEdge.linktype() == 5) && xPoint2 != null) {
                double d2 = xPoint2.squareDistance(this.getNextPoint(xPoint2, skEdge.left()));
                if ((xPoint == null || d < d2) && d2 < 2.0E7) {
                    xPoint = xPoint2;
                    d = d2;
                    int n = 0;
                    SKR sKR = skEdge.left();
                    SkEdge skEdge2 = sKR.next(skEdge);
                    while (skEdge2 != skEdge) {
                        sKR = skEdge2.opposite(sKR);
                        skEdge2 = sKR.next(skEdge2);
                        ++n;
                    }
                    if (n > 0) {
                        xPointArray = new XPoint[n + 2];
                        xPointArray[0] = new XPoint(xPoint);
                        sKR = skEdge.left();
                        skEdge2 = sKR.next(skEdge);
                        n = 2;
                        xPointArray[1] = this.getNextPoint(xPoint, sKR);
                        while (skEdge2 != skEdge) {
                            sKR = skEdge2.opposite(sKR);
                            xPointArray[n++] = this.getNextPoint(xPoint, sKR);
                            skEdge2 = sKR.next(skEdge2);
                        }
                    }
                }
            }
            listItem = listItem.next();
        }
        return xPointArray;
    }

    private List merge(List list, List list2, boolean bl) {
        SkEdge skEdge;
        SkEdge skEdge2;
        boolean bl2 = true;
        SKR sKR = (SKR)list.last().value();
        SKR sKR2 = (SKR)list2.first().value();
        SkEdge skEdge3 = new SkEdge(this, sKR, sKR2);
        SkEdge skEdge4 = null;
        SkEdge skEdge5 = null;
        SkEdge skEdge6 = null;
        SkEdge skEdge7 = null;
        if (this.tracer != null) {
            this.tracer.object("bisector_new").record((Object)skEdge3);
        }
        do {
            XPoint xPoint = new XPoint();
            XPoint xPoint2 = new XPoint();
            skEdge = sKR.scan(skEdge3, xPoint, true);
            if (skEdge == skEdge5 || skEdge == skEdge7) {
                skEdge = null;
            }
            if ((skEdge2 = sKR2.scan(skEdge3, xPoint2, false)) == skEdge6 || skEdge2 == skEdge7) {
                skEdge2 = null;
            }
            if (skEdge != null && skEdge3.source().distance(xPoint) > 4000.0) {
                skEdge = null;
            }
            if (skEdge2 != null && skEdge3.source().distance(xPoint2) > 4000.0) {
                skEdge2 = null;
            }
            if (skEdge != null || skEdge2 != null) {
                if (this.tracer != null) {
                    this.tracer.object("left_area_edge").record((Object)skEdge);
                    this.tracer.object("right_area_edge").record((Object)skEdge2);
                    this.tracer.recordLabel("Merging Step", 2, 1);
                }
                if (skEdge2 == null || skEdge != null && skEdge3.source().distance(xPoint) < skEdge3.source().distance(xPoint2)) {
                    skEdge5 = skEdge;
                    skEdge3.trim(new XPoint(xPoint), true, sKR);
                    skEdge.trim(new XPoint(xPoint), false, sKR);
                    sKR.cleanup(skEdge3, skEdge);
                    sKR = skEdge.opposite(sKR);
                    skEdge4 = new SkEdge(this, new XPoint(xPoint), sKR, sKR2, skEdge, skEdge3);
                    if (this.tracer != null) {
                        this.tracer.object("bisector").record((Object)skEdge3);
                        this.tracer.object("bisector_new").record((Object)skEdge4);
                        this.tracer.recordLabel("Merging Trim", 3, 1);
                    }
                } else {
                    skEdge6 = skEdge2;
                    skEdge3.trim(new XPoint(xPoint2), true, sKR);
                    skEdge2.trim(new XPoint(xPoint2), true, sKR2);
                    sKR2.cleanup(skEdge2, skEdge3);
                    sKR2 = skEdge2.opposite(sKR2);
                    skEdge4 = new SkEdge(this, new XPoint(xPoint2), sKR, sKR2, skEdge3, skEdge2);
                    if (this.tracer != null) {
                        this.tracer.object("bisector").record((Object)skEdge3);
                        this.tracer.object("bisector_new").record((Object)skEdge4);
                        this.tracer.recordLabel("Merging Trim", 3, 1);
                    }
                }
            }
            bl2 = false;
            skEdge7 = skEdge3;
            skEdge3 = skEdge4;
            if (skEdge4 == null || !skEdge4.empty()) continue;
            skEdge4.remove();
        } while ((skEdge2 != null || skEdge != null) && (skEdge4 == null || !skEdge4.empty()));
        if (bl) {
            sKR.cleanup(skEdge3, true);
            sKR2.cleanup(skEdge3, false);
            if (sKR.xsegment() != null) {
                skEdge3.trim(sKR.xsegment().source(), true, sKR);
            } else {
                throw new VoronoiException(5);
            }
        }
        list.concat((BasicList)list2);
        return list;
    }

    ListItem registerEdge(SkEdge skEdge) {
        return this.edges.add((Object)skEdge);
    }

    private void createInitialSKRs(List list) {
        XSegment xSegment;
        SKR sKR;
        SKR sKR2 = null;
        ListItem listItem = list.first();
        while (listItem.next() != null) {
            sKR = new SKR(listItem.key());
            SKR sKR3 = new SKR(listItem.next().key());
            xSegment = (XSegment)listItem.key();
            if (sKR2 != null) {
                new SkEdge(this, sKR2, sKR);
            }
            new SkEdge(this, sKR, sKR3);
            listItem.setValue((Object)sKR);
            listItem.next().setValue((Object)sKR3);
            sKR2 = sKR3;
            listItem = listItem.next().next();
        }
        xSegment = (XSegment)list.last().key();
        sKR = new SKR(xSegment);
        if (sKR2 != null) {
            new SkEdge(this, sKR2, sKR);
        }
        list.last().setValue((Object)sKR);
    }

    public void execute(Tracer tracer) {
        this.tracer = tracer;
        this.execute();
        this.tracer = null;
    }

    public void execute() {
        if (this.polygon == null || this.polygon.length() < 3) {
            throw new VoronoiException(1, this.polygon);
        }
        this.polygon.setOrientation((byte)1);
        ListItem listItem = this.execute_init();
        if (this.tracer != null) {
            this.tracer.object("skeleton").record((Object)this);
            this.tracer.recordLabel("Initialize Chains", 1, 0);
        }
        while ((listItem = this.execute_step(listItem)) != null) {
        }
    }

    private ListItem execute_init() {
        this.edges.clear();
        this.chains.clear();
        List list = new List();
        list.add((Object)this.polygon.segment(0), null);
        this.chains.add((Object)list);
        XSegment xSegment = null;
        int n = 1;
        while (n < this.polygon.length()) {
            xSegment = this.polygon.segment(n);
            if (xSegment.orientation(this.polygon.point(n - 1)) == 3) {
                xSegment = (XSegment)list.last().key();
                xSegment.set(xSegment.source(), this.polygon.point(n + 1));
            } else if (xSegment.orientation(this.polygon.point(n - 1)) != 2) {
                list = new List();
                list.add((Object)xSegment, null);
                this.chains.add((Object)list);
            } else {
                list.add((Object)new XPoint(this.polygon.point(n)), null);
                list.add((Object)xSegment, null);
            }
            ++n;
        }
        if (xSegment.orientation(this.polygon.point(1)) == 3) {
            List list2 = (List)this.chains.first().key();
            xSegment.set(xSegment.source(), ((XSegment)list2.first().key()).target());
            list2.remove(list2.first());
            if (!list2.empty()) {
                list.concat((BasicList)list2);
            }
            this.chains.remove(this.chains.first());
        } else if (xSegment.orientation(this.polygon.point(1)) == 2) {
            List list3 = (List)this.chains.first().key();
            list.add((Object)this.polygon.point(0), null);
            list.concat((BasicList)list3);
            this.chains.remove(this.chains.first());
        }
        ListItem listItem = this.chains.first();
        while (listItem != null) {
            this.createInitialSKRs((List)listItem.key());
            listItem = listItem.next();
        }
        return this.chains.first();
    }

    public int chainCount() {
        return this.chains.length();
    }

    public Skeleton(XPolygon xPolygon) {
        this.polygon = xPolygon;
    }

    public SimpleList getChain(int n) {
        SimpleList simpleList = new SimpleList();
        ListItem listItem = this.chains.at(n);
        if (listItem == null) {
            return null;
        }
        List list = (List)listItem.key();
        listItem = list.first();
        while (listItem != null) {
            simpleList.add(listItem.key());
            listItem = listItem.next();
        }
        return simpleList;
    }

    private XPoint getNextPoint(XPoint xPoint, SKR sKR) {
        if (sKR == null) {
            return null;
        }
        if (sKR.base() instanceof XPoint) {
            return new XPoint((XPoint)sKR.base());
        }
        if (sKR.base() instanceof XSegment) {
            XSegment xSegment = (XSegment)sKR.base();
            XPoint xPoint2 = xSegment.plumb(xPoint);
            if (xPoint2 == null) {
                if (xPoint.squareDistance(xSegment.source()) < xPoint.squareDistance(xSegment.target())) {
                    return new XPoint(xSegment.source());
                }
                return new XPoint(xSegment.target());
            }
            return xPoint2;
        }
        return null;
    }

    private void clearMarks(List list) {
        ListItem listItem = list.first();
        while (listItem != null) {
            ((SKR)listItem.value()).mark = false;
            listItem = listItem.next();
        }
    }

    public ListView getEdges() {
        return this.edges.getListView();
    }

    private SimpleList getLines(List list, boolean bl) {
        SimpleList simpleList = new SimpleList();
        this.clearMarks(list);
        ListItem listItem = list.first();
        while (listItem != null) {
            SkEdge skEdge;
            SKR sKR = (SKR)listItem.value();
            SkEdge skEdge2 = skEdge = sKR.first();
            Object var6_8 = null;
            if (skEdge != null) {
                do {
                    if (skEdge2.empty() || skEdge2.opposite((SKR)sKR).mark || skEdge2.linktype() == 1 && !bl) continue;
                    simpleList.add((Object)skEdge2.base());
                } while ((skEdge2 = sKR.next(skEdge2)) != null && skEdge2 != skEdge);
            }
            sKR.mark = true;
            listItem = listItem.next();
        }
        return simpleList;
    }

    public SimpleList getLines(boolean bl) {
        if (this.chains.empty()) {
            return new SimpleList();
        }
        return this.getLines((List)this.chains.first().key(), bl);
    }

    public SimpleList getLines(int n, boolean bl) {
        ListItem listItem = this.chains.at(n);
        if (listItem == null) {
            return null;
        }
        return this.getLines((List)listItem.key(), bl);
    }

    private ListItem execute_step(ListItem listItem) {
        if (listItem == null) {
            return null;
        }
        List list = this.merge((List)listItem.key(), (List)listItem.next().key(), this.chains.length() <= 2);
        listItem = listItem.next();
        this.chains.remove(listItem.prev());
        listItem.setKey((Object)list);
        if (this.tracer != null) {
            this.tracer.object("skeleton").record((Object)this);
            this.tracer.object("chain").record((Object)list);
            this.tracer.recordLabel("Merging Chains", 1, 0);
        }
        if ((listItem = listItem.next()) == null || listItem.next() == null) {
            listItem = this.chains.first();
        }
        if (this.chains.length() <= 1) {
            listItem = null;
        }
        return listItem;
    }

    public void checkEdges() {
        ListItem listItem = this.edges.first();
        while (listItem != null) {
            SkEdge skEdge = (SkEdge)listItem.key();
            SKR sKR = skEdge.left();
            SKR sKR2 = skEdge.right();
            if (skEdge.empty()) {
                skEdge.remove();
            } else if (sKR != null && sKR2 != null) {
                SkEdge skEdge2 = sKR.next(skEdge);
                SkEdge skEdge3 = sKR2.prev(skEdge);
                while (skEdge2 != skEdge3 && skEdge2.linktype() == 1) {
                    sKR = skEdge2.opposite(sKR);
                    skEdge2 = sKR.next(skEdge2);
                }
                while (skEdge2 != skEdge3 && skEdge3.linktype() == 1) {
                    sKR2 = skEdge3.opposite(sKR2);
                    skEdge3 = sKR2.prev(skEdge3);
                }
                if (skEdge2 == skEdge3) {
                    skEdge.setLinktype(skEdge2);
                    skEdge2.setLinktype(skEdge);
                }
            }
            listItem = listItem.next();
        }
    }

    private SimpleList getPoints(List list) {
        SimpleList simpleList = new SimpleList();
        this.clearMarks(list);
        boolean bl = false;
        boolean bl2 = false;
        ListItem listItem = list.first();
        while (listItem != null) {
            SkEdge skEdge;
            SKR sKR = (SKR)listItem.value();
            SkEdge skEdge2 = skEdge = sKR.first();
            XPoint xPoint = null;
            if (sKR.base() instanceof XPoint) {
                xPoint = (XPoint)sKR.base();
            }
            if (sKR.base() instanceof XSegment) {
                xPoint = ((XSegment)sKR.base()).target();
            }
            if (skEdge != null) {
                do {
                    if (!(bl = skEdge2.opposite(sKR) != null ? skEdge2.opposite((SKR)sKR).mark : false) && !bl2) {
                        XPoint xPoint2 = skEdge2.left() == sKR ? skEdge2.source() : skEdge2.target();
                        if (!(xPoint != null && xPoint.equals(xPoint2) || skEdge2.linktype() != 0 && skEdge2.linktype() != 4)) {
                            simpleList.add((Object)xPoint2);
                        }
                    }
                    skEdge2 = sKR.next(skEdge2);
                    bl2 = bl;
                } while (skEdge2 != null && skEdge2 != skEdge);
            }
            sKR.mark = true;
            listItem = listItem.next();
        }
        return simpleList;
    }

    public synchronized Object clone() {
        Skeleton skeleton;
        Hashtable<XPoint, XPoint> hashtable = new Hashtable<XPoint, XPoint>();
        SimpleList simpleList = this.edges;
        SimpleList simpleList2 = this.chains;
        Tracer tracer = this.tracer;
        this.chains = null;
        this.edges = null;
        this.tracer = null;
        try {
            skeleton = (Skeleton)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        this.edges = simpleList;
        this.chains = simpleList2;
        skeleton.tracer = this.tracer = tracer;
        int n = 0;
        while (n < this.polygon.length()) {
            hashtable.put(this.polygon.point(n), skeleton.polygon.point(n));
            ++n;
        }
        skeleton.edges = (SimpleList)this.edges.clone(hashtable, -1);
        ListItem listItem = skeleton.edges.first();
        while (listItem != null) {
            ((SkEdge)listItem.key()).correctID(listItem);
            listItem = listItem.next();
        }
        skeleton.chains = (SimpleList)this.chains.clone(hashtable, -1);
        listItem = skeleton.edges.first();
        while (listItem != null) {
            ((SkEdge)listItem.key()).correctSKRs(hashtable);
            listItem = listItem.next();
        }
        return skeleton;
    }

    public void run() {
        this.execute();
    }

    public SimpleList getPoints() {
        if (this.chains.empty()) {
            return new SimpleList();
        }
        return this.getPoints((List)this.chains.first().key());
    }

    public SimpleList getPoints(int n) {
        ListItem listItem = this.chains.at(n);
        if (listItem == null) {
            return null;
        }
        return this.getPoints((List)listItem.key());
    }

    public int getMaxUsedLevel() {
        return 1;
    }
}

