/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.swing.spi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanels;
import org.gvsig.export.swing.spi.ExportPanelsFactory;

public class AbstractExportPanels
implements ExportPanels {
    private final ExportPanelsFactory factory;
    private final ExportParameters parameters;
    private final JExportProcessPanel processPanel;
    private final List<ExportPanel> panels;

    protected AbstractExportPanels(ExportPanelsFactory factory, JExportProcessPanel processPanel, ExportParameters parameters) {
        this.factory = factory;
        this.parameters = parameters;
        this.processPanel = processPanel;
        this.panels = new ArrayList<ExportPanel>();
    }

    @Override
    public ExportPanelsFactory getFactory() {
        return this.factory;
    }

    @Override
    public int size() {
        return this.panels.size();
    }

    @Override
    public ExportPanel get(int index) {
        return this.panels.get(index);
    }

    @Override
    public boolean contains(String panelId) {
        for (ExportPanel panel : this.panels) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)panelId, (CharSequence)panel.getIdPanel())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ExportParameters getParameters() {
        return this.parameters;
    }

    @Override
    public Iterator<ExportPanel> iterator() {
        return this.panels.iterator();
    }

    protected void add(ExportPanel panel) {
        this.panels.add(panel);
    }

    protected JExportProcessPanel getProcessPanel() {
        return this.processPanel;
    }
}

