/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.convexhull;

import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.geoprocess.algorithm.base.util.GeometryUtil;
import org.gvsig.geoprocess.algorithm.convexhull.ConvexHullOperation;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.tools.dispose.DisposableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvexHullAlgorithm
extends AbstractSextanteGeoProcess {
    private static final Logger log = LoggerFactory.getLogger(ConvexHullAlgorithm.class);
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";
    public static final String CHECK = "CHECK";

    public void defineCharacteristics() {
        this.setName(this.getTranslation("ConvexHull"));
        this.setGroup(this.getTranslation("basic_vect_algorithms"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, this.getTranslation("Input_layer"), -1, true);
            this.addOutputVectorLayer(RESULT, this.getTranslation("ConvexHull"), 2);
            this.m_Parameters.addBoolean(CHECK, this.getTranslation("Selected_geometries_convex_hull"), false);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        if (this.existsOutPutFile(RESULT, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        IVectorLayer input = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        boolean selectedGeom = this.m_Parameters.getParameter(CHECK).getParameterValueAsBoolean();
        FeatureStore store = null;
        if (!(input instanceof FlyrVectIVectorLayer)) {
            return false;
        }
        store = ((FlyrVectIVectorLayer)input).getFeatureStore();
        ConvexHullOperation convexHullOperation = new ConvexHullOperation();
        FeatureSet features = null;
        try {
            DisposableIterator it = null;
            if (selectedGeom) {
                features = store.getFeatureSet();
                FeatureSelection ds = store.getFeatureSelection();
                it = ds.iterator();
            } else {
                FeatureQuery query = this.getQueryFromAnalysisExtent(this.m_AnalysisExtent, store);
                features = store.getFeatureSet(query);
                it = features.iterator();
            }
            int numberOfFeatures = (int)features.getSize();
            int iCount = 0;
            while (it.hasNext()) {
                Feature feature = (Feature)it.next();
                List geomList = feature.getGeometries();
                this.setProgress(iCount, numberOfFeatures);
                ++iCount;
                if (geomList == null) {
                    org.gvsig.fmap.geom.Geometry geom = feature.getDefaultGeometry();
                    if (geom == null) continue;
                    convexHullOperation.invoke(geom);
                    continue;
                }
                for (org.gvsig.fmap.geom.Geometry g : geomList) {
                    convexHullOperation.invoke(g);
                }
            }
            org.gvsig.fmap.geom.Geometry g = convexHullOperation.getGeometry();
            if (g == null) {
                return false;
            }
            String[] sNames = new String[]{"ID"};
            Class[] types = new Class[]{Integer.class};
            IVectorLayer output = this.getNewVectorLayer(RESULT, this.getTranslation("ConvexHull"), 2, types, sNames);
            Geometry jtsGeom = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)g);
            output.addFeature(jtsGeom, new Object[]{new Integer(0)});
        }
        catch (DataException e) {
            log.error("", (Throwable)e);
        }
        catch (CreateEnvelopeException e) {
            log.error("Error creating envelope", (Throwable)e);
        }
        return !this.m_Task.isCanceled();
    }
}

