/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.convexhull;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.mapcontrol.swing.dynobject.DynObjectEditor;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvexHullParametersPanel
extends GeoAlgorithmParametersPanel
implements ActionListener {
    private static final long serialVersionUID = 3260891769310434508L;
    private static final Logger LOG = LoggerFactory.getLogger(ConvexHullParametersPanel.class);
    private JComboBox combo = null;
    private JButton button = null;
    private ArrayList<DataStoreParameters> paramList = new ArrayList();

    public void init(GeoAlgorithm algorithm) {
        this.initGUI();
    }

    private void initGUI() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 2, 0, 0);
        this.add(this.getCombo(), gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.insets = new Insets(0, 5, 0, 2);
        this.add(this.getButton(), gbc);
    }

    public JComboBox getCombo() {
        if (this.combo == null) {
            this.combo = new JComboBox();
            this.loadProviderList(this.combo, this.paramList);
            this.combo.addActionListener(this);
            this.combo.setPreferredSize(new Dimension(0, 18));
        }
        return this.combo;
    }

    public JButton getButton() {
        if (this.button == null) {
            this.button = new JButton("...");
            this.button.setPreferredSize(new Dimension(60, 18));
            this.button.addActionListener(this);
        }
        return this.button;
    }

    public void assignParameters() {
    }

    public void setOutputValue(String arg0, String arg1) {
    }

    public void setParameterValue(String arg0, String arg1) {
    }

    private void loadProviderList(JComboBox c, ArrayList<DataStoreParameters> paramList) {
        try {
            DataManager manager = DALLocator.getDataManager();
            List list = manager.getStoreProviders();
            Iterator it = list.iterator();
            c.removeAllItems();
            paramList.clear();
            while (it.hasNext()) {
                try {
                    String provider = it.next().toString();
                    DataStoreParameters param = manager.createStoreParameters(provider);
                    c.addItem(provider);
                    paramList.add(param);
                }
                catch (InitializeException e1) {
                    Sextante.addErrorToLog((Throwable)e1);
                }
                catch (ProviderNotRegisteredException e1) {
                    Sextante.addErrorToLog((Throwable)e1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getButton()) {
            int index = this.getCombo().getSelectedIndex();
            try {
                DynObjectEditor editor = new DynObjectEditor((DynObject)this.paramList.get(index));
                editor.editObject(true);
            }
            catch (ServiceException ex) {
                LOG.error("Error creating a Swing component for the DynObject: " + this.paramList.get(index), (Throwable)ex);
                Sextante.addErrorToLog((Throwable)ex);
            }
        }
        if (e.getSource() == this.getCombo()) {
            // empty if block
        }
    }
}

