/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.swipe.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.swipe.swing.impl.AbstractSwipePanel;
import org.gvsig.swipe.swing.impl.HorizontalSwipeView;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HorizontalSwipePanel
extends AbstractSwipePanel {
    protected static final Logger LOGGER = LoggerFactory.getLogger(HorizontalSwipePanel.class);
    private JScrollPane spLeft;
    private JScrollPane spRight;
    private MapControl mapControlLeft;
    private MapControl mapControlRight;
    protected HorizontalSwipeView view = new HorizontalSwipeView();

    public HorizontalSwipePanel() {
        this.initComponents();
    }

    protected void initComponents() {
        try {
            this.configureCombos();
            this.configureSplitPanel();
            this.getView().pnlLeftPanel.setLayout(new BorderLayout());
            this.spLeft = new JScrollPane(21, 31);
            this.spLeft.setViewportView((Component)this.mapControlLeft);
            this.getView().pnlLeftPanel.add((Component)this.spLeft, "Center");
            this.getView().pnlRightPanel.setLayout(new BorderLayout());
            this.spRight = new JScrollPane(21, 31);
            this.spRight.setViewportView((Component)this.mapControlRight);
            this.getView().pnlRightPanel.add((Component)this.spRight, "Center");
            ToolsSwingUtils.configurePickersButton((AbstractButton)this.getView().btnZoomLeftView, (String)"_Zoom_to_all_left_view", (String)"view-navigation-zoom-all", e -> this.doZoomAllView1(), null);
            ToolsSwingUtils.configurePickersButton((AbstractButton)this.getView().btnZoomRightView, (String)"_Zoom_to_all_right_view", (String)"view-navigation-zoom-all", e -> this.doZoomAllView2(), null);
            this.configureCombosActions();
            this.translate();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't initialize swipe panel", (Throwable)ex);
        }
    }

    protected void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate((JComponent)this.getView().cboLeftView);
        toolsSwingManager.translate((JComponent)this.getView().cboRightView);
        toolsSwingManager.translate((AbstractButton)this.getView().btnZoomLeftView);
        toolsSwingManager.translate((AbstractButton)this.getView().btnZoomRightView);
    }

    @Override
    protected MapControl getMapControl1() {
        if (this.mapControlLeft == null) {
            this.mapControlLeft = this.createMapControl();
        }
        return this.mapControlLeft;
    }

    @Override
    protected MapControl getMapControl2() {
        if (this.mapControlRight == null) {
            this.mapControlRight = this.createMapControl();
        }
        return this.mapControlRight;
    }

    protected JComboBox getComboDocuments1() {
        return this.getView().cboLeftView;
    }

    protected JComboBox getComboDocuments2() {
        return this.getView().cboRightView;
    }

    @Override
    protected void adjustJViewPortWindows() {
        this.spLeft.getViewport().setViewPosition(new Point(0, 0));
        this.spRight.getViewport().setViewPosition(new Point(this.mapControlRight.getWidth(), 0));
    }

    @Override
    protected JSplitPane createSplitPanel() {
        JSplitPane splitPanel = ToolsSwingUtils.createHorizontalSplit((JPanel)this.getView().pnlSplitPanel, (JPanel)this.getView().pnlLeftPanel, (boolean)false, (JPanel)this.getView().pnlRightPanel, (boolean)false);
        splitPanel.setContinuousLayout(true);
        return splitPanel;
    }

    @Override
    protected HorizontalSwipeView getView() {
        return this.view;
    }

    @Override
    protected JPanel getViewSplitPanel() {
        return this.getView().pnlSplitPanel;
    }
}

