/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.swipe.swing.impl;

import java.net.URL;
import javax.swing.ImageIcon;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.swipe.swing.SwipePanel;
import org.gvsig.swipe.swing.SwipeSwingManager;
import org.gvsig.swipe.swing.SwipeSwingServices;
import org.gvsig.swipe.swing.impl.HorizontalSwipePanel;
import org.gvsig.swipe.swing.impl.VerticalSwipePanel;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwipeSwingManagerImpl
implements SwipeSwingManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwipeSwingManagerImpl.class);
    public static final String ICON_GROUP_NAME = "Swipe";
    public static final String ICON_PROVIDER_NAME = "Swipe";
    private SwipeSwingServices services;

    public static void registerIcons(String[][] iconsInfo) {
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        for (String[] icon : iconsInfo) {
            URL url = SwipeSwingManagerImpl.class.getResource("images/" + icon[2] + ".png");
            theme.registerDefault(icon[0], icon[1], icon[2], null, url);
        }
    }

    public static ImageIcon loadImage(String imageName) {
        String name = FilenameUtils.getBaseName((String)imageName);
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
        if (theme.exists(name)) {
            return theme.get(name);
        }
        URL url = SwipeSwingManagerImpl.class.getResource("images/" + name + ".png");
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    public SwipePanel createHorizontalSwipePanel() {
        HorizontalSwipePanel x = new HorizontalSwipePanel();
        return x;
    }

    public SwipePanel createVerticalSwipePanel() {
        VerticalSwipePanel x = new VerticalSwipePanel();
        return x;
    }

    public void setDefaultServices(SwipeSwingServices services) {
        this.services = services;
    }

    public SwipeSwingServices getDefaultServices() {
        return this.services;
    }
}

