/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.swing.impl.panels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.ExportParametersGeometry;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.impl.panels.CheckGeometriesPanelView;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckGeometriesPanel
extends CheckGeometriesPanelView
implements ExportPanel {
    private static final Logger logger = LoggerFactory.getLogger(CheckGeometriesPanel.class);
    private final CheckAction[] checkActions = new CheckAction[]{new CheckAction("_Set_geometry_to_null", 0), new CheckAction("_Skip_entire_feature", 1), new CheckAction("_Abort_process", 2)};
    private final ExportParametersGeometry parameters;
    private boolean updateComponents;

    public CheckGeometriesPanel(JExportProcessPanel processPanel, ExportParameters parameters) {
        this.parameters = (ExportParametersGeometry)parameters;
        this.parameters.setGeometryChecks(0);
        this.parameters.setGeometryChecksAction(0);
        this.parameters.setTryToFixGeometry(true);
        this.updateComponents = true;
        this.initComponents();
    }

    private void initComponents() {
        this.rdbCheckIsCorrupt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckGeometriesPanel.this.onChangeRadioButtons();
            }
        });
        this.rdbCheckIsValid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckGeometriesPanel.this.onChangeRadioButtons();
            }
        });
        this.rdbCheckNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckGeometriesPanel.this.onChangeRadioButtons();
            }
        });
        for (CheckAction checkAction : this.checkActions) {
            this.cboActionIsCorrupt.addItem(checkAction);
            this.cboActionIsValid.addItem(checkAction);
        }
        this.rdbCheckNone.setSelected(true);
        this.rdbCheckIsValid.setSelected(true);
        this.cboActionIsValid.setSelectedItem(this.checkActions[2]);
        this.translate();
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.lblHeader.setText("<html>" + i18nManager.getTranslation("_check_geometries_before_export_header") + "</html>");
        this.rdbCheckNone.setText(i18nManager.getTranslation("_No_realizar_ninguna_comprobacion_sobre_las_geometrias"));
        this.rdbCheckIsCorrupt.setText(i18nManager.getTranslation("_Comprobar_que_la_geometria_no_este_corrupta"));
        this.rdbCheckIsValid.setText(i18nManager.getTranslation("_Comprobar_la_validez_de_las_geometrias_antes_de_insertarlas"));
        this.lblCheckIsCorrupt.setText(i18nManager.getTranslation("_Cuando_la_geometria_este_corrupta"));
        this.lblCheckIsvalid.setText(i18nManager.getTranslation("_Cuando_la_geometria_no_sea_valida"));
        this.chkTryFixGeometry.setText(i18nManager.getTranslation("_Intentar_reparar_la_geometria"));
    }

    public String getIdPanel() {
        return "PANEL_CHECK_GEOMETRIES";
    }

    public String getTitlePanel() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_check_geometries_before_export");
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        return true;
    }

    public void nextPanel() {
        this.parameters.setGeometryChecks(this.getGeometryChecks());
        this.parameters.setGeometryChecksAction(this.getGeometryChecksAction());
        this.parameters.setTryToFixGeometry(this.getTryToFixGeometry());
    }

    public void previousPanel() {
    }

    public void enterPanel() {
        if (this.updateComponents) {
            switch (this.parameters.getGeometryChecks()) {
                case 0: {
                    this.rdbCheckNone.setSelected(true);
                    this.rdbCheckIsCorrupt.setSelected(false);
                    this.cboActionIsCorrupt.setEnabled(false);
                    this.rdbCheckIsValid.setSelected(false);
                    this.cboActionIsValid.setEnabled(false);
                    this.chkTryFixGeometry.setEnabled(false);
                    break;
                }
                case 2: {
                    this.rdbCheckNone.setSelected(false);
                    this.rdbCheckIsCorrupt.setSelected(false);
                    this.cboActionIsCorrupt.setEnabled(false);
                    this.rdbCheckIsValid.setSelected(true);
                    this.cboActionIsValid.setEnabled(true);
                    this.chkTryFixGeometry.setEnabled(true);
                    break;
                }
                case 1: {
                    this.rdbCheckNone.setSelected(false);
                    this.rdbCheckIsCorrupt.setSelected(true);
                    this.cboActionIsCorrupt.setEnabled(true);
                    this.rdbCheckIsValid.setSelected(false);
                    this.cboActionIsValid.setEnabled(false);
                    this.chkTryFixGeometry.setEnabled(false);
                }
            }
            this.chkTryFixGeometry.setSelected(this.parameters.getTryToFixGeometry());
        }
        this.updateComponents = false;
        if (this.parameters.getSourceGeometryFieldName() == null) {
            this.rdbCheckIsCorrupt.setEnabled(false);
            this.rdbCheckIsValid.setEnabled(false);
            this.rdbCheckNone.setEnabled(false);
        } else {
            this.rdbCheckIsCorrupt.setEnabled(true);
            this.rdbCheckIsValid.setEnabled(true);
            this.rdbCheckNone.setEnabled(true);
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    public int getGeometryChecks() {
        if (this.rdbCheckIsCorrupt.isSelected()) {
            return 1;
        }
        if (this.rdbCheckIsValid.isSelected()) {
            return 2;
        }
        return 0;
    }

    public int getGeometryChecksAction() {
        try {
            if (this.rdbCheckIsCorrupt.isSelected()) {
                CheckAction checkAction = (CheckAction)this.cboActionIsCorrupt.getSelectedItem();
                return checkAction.getCode();
            }
            if (this.rdbCheckIsValid.isSelected()) {
                CheckAction checkAction = (CheckAction)this.cboActionIsValid.getSelectedItem();
                return checkAction.getCode();
            }
            return 2;
        }
        catch (Exception ex) {
            logger.warn("Can't get action for geometry check in export to JDBC.", (Throwable)ex);
            return 2;
        }
    }

    public boolean getTryToFixGeometry() {
        return this.chkTryFixGeometry.isSelected();
    }

    private void onChangeRadioButtons() {
        if (this.rdbCheckNone.isSelected()) {
            this.cboActionIsCorrupt.setEnabled(false);
            this.cboActionIsValid.setEnabled(false);
            this.chkTryFixGeometry.setEnabled(false);
        } else if (this.rdbCheckIsCorrupt.isSelected()) {
            this.cboActionIsCorrupt.setEnabled(true);
            this.cboActionIsValid.setEnabled(false);
            this.chkTryFixGeometry.setEnabled(false);
        } else if (this.rdbCheckIsValid.isSelected()) {
            this.cboActionIsCorrupt.setEnabled(false);
            this.cboActionIsValid.setEnabled(true);
            this.chkTryFixGeometry.setEnabled(true);
        }
    }

    private static class CheckAction {
        private final String label;
        private final int code;

        public CheckAction(String label, int code) {
            this.code = code;
            this.label = ToolsLocator.getI18nManager().getTranslation(label);
        }

        public String toString() {
            return this.label;
        }

        public int getCode() {
            return this.code;
        }
    }
}

