/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.swing.impl.panels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.export.ExportLocator;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.Filter;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.impl.panels.SelectFormatPanelView;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.Bookmark;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.bookmarksandhistory.History;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.bookmarkshistory.ActionEventWithCurrentValue;
import org.gvsig.tools.swing.api.bookmarkshistory.BookmarksController;
import org.gvsig.tools.swing.api.bookmarkshistory.HistoryController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectFormatPanel
extends SelectFormatPanelView
implements ExportPanel {
    private static final Logger LOG = LoggerFactory.getLogger(SelectFormatPanel.class);
    private final JExportProcessPanel processPanel;
    private final Filter<ExportServiceFactory> serviceFilter;
    private final ActionListener onExitPanel;
    private ExportParameters parameters;
    private BookmarksController<ExportParameters> bookmarksController;
    private HistoryController<ExportParameters> historyController;

    public SelectFormatPanel(JExportProcessPanel processPanel, ExportParameters parameters, Filter<ExportServiceFactory> serviceFilter, ActionListener onExitPanel) {
        this.processPanel = processPanel;
        this.parameters = parameters;
        this.serviceFilter = serviceFilter;
        this.onExitPanel = onExitPanel;
        this.initComponents();
    }

    private void initComponents() {
        this.txtDescription.setBackground(this.lblEmpty.getBackground());
        this.txtDescription.setForeground(this.lblEmpty.getForeground());
        if (this.txtDescription.getParent().getParent() instanceof JScrollPane) {
            JScrollPane scrollPanel = (JScrollPane)this.txtDescription.getParent().getParent();
            scrollPanel.setBorder(null);
        }
        List factories = ExportLocator.getServiceManager().getServiceFactories(this.serviceFilter);
        DefaultListModel<ListElement> model = new DefaultListModel<ListElement>();
        for (ExportServiceFactory factory : factories) {
            model.addElement(new ListElement(factory.getLabel(), (Object)factory));
        }
        this.lstServices.setModel(model);
        this.lstServices.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SelectFormatPanel.this.doUpdateDescription();
            }
        });
        Predicate<ExportParameters> filter = new Predicate<ExportParameters>(){

            @Override
            public boolean test(ExportParameters params) {
                if (params == null) {
                    return false;
                }
                ExportServiceFactory selectedService = SelectFormatPanel.this.getSelectedService();
                if (selectedService == null) {
                    return false;
                }
                String selectedServiceName = selectedService.getName();
                String paramsServiceName = params.getServiceName();
                return StringUtils.equals((CharSequence)paramsServiceName, (CharSequence)selectedServiceName);
            }
        };
        ActionListener historyAndBookmarkListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionEventWithCurrentValue b = (ActionEventWithCurrentValue)e;
                switch (b.getID()) {
                    case 1002: {
                        break;
                    }
                    case 1001: {
                        ExportParameters exportParams;
                        if (b.getCurrentValue() == null) {
                            return;
                        }
                        try {
                            exportParams = ((ExportParameters)b.getCurrentValue()).clone();
                        }
                        catch (Exception ex) {
                            LOG.warn("Not been able to clone export parameters", (Throwable)ex);
                            return;
                        }
                        SelectFormatPanel.this.setSelectedService(exportParams.getFactory());
                        SelectFormatPanel.this.processPanel.getProcess().setParameters(exportParams);
                        SelectFormatPanel.this.parameters = exportParams;
                    }
                }
            }
        };
        Bookmarks bookmarks = ExportLocator.getManager().getBookmarks();
        this.bookmarksController = ToolsSwingLocator.getToolsSwingManager().createBookmarksController(bookmarks, this.btnBookmark);
        this.bookmarksController.setAllowAddBookmarks(Boolean.valueOf(false));
        this.bookmarksController.setFilter((Predicate)new Predicate<Bookmark<ExportParameters>>(){

            @Override
            public boolean test(Bookmark<ExportParameters> bookmark) {
                ExportParameters params = (ExportParameters)bookmark.getValue();
                if (params == null) {
                    return false;
                }
                ExportServiceFactory selectedService = SelectFormatPanel.this.getSelectedService();
                if (selectedService == null) {
                    return true;
                }
                String selectedServiceName = selectedService.getName();
                String paramsServiceName = params.getServiceName();
                return StringUtils.equals((CharSequence)paramsServiceName, (CharSequence)selectedServiceName);
            }
        });
        this.bookmarksController.addActionListener(historyAndBookmarkListener);
        History history = ExportLocator.getManager().getHistory();
        this.historyController = ToolsSwingLocator.getToolsSwingManager().createHistoryController(history, this.btnHistory);
        this.historyController.setFilter((Predicate)filter);
        this.historyController.addActionListener(historyAndBookmarkListener);
    }

    private void doUpdateDescription() {
        ExportServiceFactory factory = this.getSelectedService();
        if (factory == null) {
            return;
        }
        this.txtDescription.setText(factory.getDescription());
        this.processPanel.setButtonEnabled(1, true);
    }

    public String getIdPanel() {
        return "SelectFormatPanel";
    }

    public String getTitlePanel() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("select_format_to_export");
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ExportServiceFactory factory = this.getSelectedService();
        if (factory == null) {
            throw new ExportPanelValidationException(i18n.getTranslation("_You_must_select_an_item_from_the_list_of-formats"));
        }
        return true;
    }

    public void enterPanel() {
    }

    public void previousPanel() {
    }

    public void nextPanel() {
        this.onExitPanel.actionPerformed(new ActionEvent(this, 0, "exitPanel"));
    }

    public JComponent asJComponent() {
        return this;
    }

    public ExportServiceFactory getSelectedService() {
        ExportServiceFactory factory = (ExportServiceFactory)ListElement.getSelected((JList)this.lstServices);
        return factory;
    }

    public void setSelectedService(ExportServiceFactory factory) {
        ListElement.setSelected((JList)this.lstServices, (Object)factory);
    }
}

