/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.swing.impl.panels;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.ExportParametersGeometry;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.impl.panels.SelectTargetProjectionPanelView;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.ProjectionPickerController;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public class SelectTargetProjectionPanel
extends SelectTargetProjectionPanelView
implements ExportPanel {
    private final ExportParametersGeometry parameters;
    private final JExportProcessPanel processPanel;
    private ProjectionPickerController projectionController;

    public SelectTargetProjectionPanel(JExportProcessPanel processPanel, ExportParameters parameters) {
        this.processPanel = processPanel;
        this.parameters = (ExportParametersGeometry)parameters;
        this.initComponents();
    }

    private void initComponents() {
        this.projectionController = DALSwingLocator.getDataSwingManager().createProjectionPickerController(this.txtUserProjection, this.btnSelectUserProjection);
        this.translate();
        IProjection targetParams = this.parameters.getTargetProjection();
        if (this.parameters.getContextProjection() == this.parameters.getSourceProjection()) {
            this.rdbtnOriginalProjection.setEnabled(this.parameters.getSourceProjection() != null);
            this.txtOriginalProjection.setEnabled(this.parameters.getSourceProjection() != null);
            this.rdbtnViewProjection.setEnabled(false);
            this.txtViewProjection.setEnabled(false);
            this.rdbtnUserProjection.setEnabled(true);
            this.txtUserProjection.setEnabled(true);
        } else {
            this.rdbtnOriginalProjection.setEnabled(this.parameters.getSourceProjection() != null);
            this.txtOriginalProjection.setEnabled(this.parameters.getSourceProjection() != null);
            this.rdbtnViewProjection.setEnabled(this.parameters.getContextProjection() != null);
            this.txtViewProjection.setEnabled(this.parameters.getContextProjection() != null);
            this.rdbtnUserProjection.setEnabled(true);
            this.txtUserProjection.setEnabled(true);
        }
        if (this.parameters.getContextProjection() != null) {
            this.txtViewProjection.setText(this.parameters.getContextProjection().getAbrev());
        }
        if (this.parameters.getSourceProjection() != null) {
            this.txtOriginalProjection.setText(this.parameters.getSourceProjection().getAbrev());
        }
        if (this.parameters.getTargetProjection() == null) {
            this.projectionController.set((Object)this.parameters.getSourceProjection());
        } else {
            this.projectionController.set((Object)this.parameters.getTargetProjection());
        }
        this.rdbtnOriginalProjection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectTargetProjectionPanel.this.doRadioButonsStateChanged();
            }
        });
        this.rdbtnUserProjection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectTargetProjectionPanel.this.doRadioButonsStateChanged();
            }
        });
        this.rdbtnViewProjection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectTargetProjectionPanel.this.doRadioButonsStateChanged();
            }
        });
        this.updateSelectedRadioButton();
    }

    private void doRadioButonsStateChanged() {
        if (this.rdbtnUserProjection.isSelected()) {
            this.projectionController.setEnabled(true);
            this.txtOriginalProjection.setEnabled(false);
            this.txtViewProjection.setEnabled(false);
            this.txtUserProjection.setEnabled(true);
        } else if (this.rdbtnOriginalProjection.isSelected()) {
            this.projectionController.setEnabled(false);
            this.txtOriginalProjection.setEnabled(true);
            this.txtViewProjection.setEnabled(false);
            this.txtUserProjection.setEnabled(false);
        } else if (this.rdbtnViewProjection.isSelected()) {
            this.projectionController.setEnabled(false);
            this.txtOriginalProjection.setEnabled(false);
            this.txtViewProjection.setEnabled(true);
            this.txtUserProjection.setEnabled(false);
        }
    }

    public String getIdPanel() {
        return "PANEL_SELECT_TARGET_PROJECTION";
    }

    public String getTitlePanel() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("_Target_projection");
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        return !(this.parameters instanceof ExportParametersGeometry) || this.getTargetProjection() != null;
    }

    public void previousPanel() {
    }

    public void enterPanel() {
        IProjection targetProjection = this.parameters.getTargetProjection();
        IProjection contextProjection = this.parameters.getContextProjection();
        IProjection sourceProjection = this.parameters.getSourceProjection();
        ICoordTrans trans = this.parameters.getTargetTransformation();
        if (targetProjection != null) {
            this.projectionController.set((Object)targetProjection);
        } else if (contextProjection != null) {
            this.projectionController.set((Object)contextProjection);
        } else if (sourceProjection != null) {
            this.projectionController.set((Object)sourceProjection);
        } else if (this.projectionController.get() == null) {
            this.projectionController.set((Object)CRSFactory.getCRS((String)"EPSG:4326"));
        }
        this.updateSelectedRadioButton();
    }

    private void updateSelectedRadioButton() {
        if (this.parameters.getSourceProjection() == null) {
            this.rdbtnUserProjection.setSelected(true);
        } else if (this.parameters.getTargetProjection() == this.parameters.getSourceProjection()) {
            this.rdbtnOriginalProjection.setSelected(true);
        } else if (this.parameters.getTargetProjection() == this.parameters.getContextProjection()) {
            this.rdbtnViewProjection.setSelected(true);
        } else {
            this.rdbtnUserProjection.setSelected(true);
        }
    }

    private IProjection getTargetProjection() {
        if (this.rdbtnUserProjection.isSelected()) {
            return (IProjection)this.projectionController.get();
        }
        if (this.rdbtnOriginalProjection.isSelected()) {
            return this.parameters.getSourceProjection();
        }
        if (this.rdbtnViewProjection.isSelected()) {
            return this.parameters.getContextProjection();
        }
        return null;
    }

    private ICoordTrans getTargetTransformation() {
        if (this.rdbtnUserProjection.isSelected()) {
            return this.projectionController.getCoordinateTransformation();
        }
        if (this.rdbtnOriginalProjection.isSelected()) {
            return null;
        }
        if (this.rdbtnViewProjection.isSelected()) {
            ICoordTrans targetCT = this.parameters.getSourceProjection().getCT(this.parameters.getContextProjection());
            return targetCT;
        }
        return null;
    }

    public void nextPanel() {
        this.parameters.setTargetProjection(this.getTargetProjection());
        this.parameters.setTargetTransformation(this.getTargetTransformation());
    }

    public JComponent asJComponent() {
        return this;
    }

    private void translate() {
        ToolsSwingManager manager = ToolsSwingLocator.getToolsSwingManager();
        manager.translate(this.lblSelectTargetProjection);
        manager.translate((AbstractButton)this.rdbtnOriginalProjection);
        manager.translate((AbstractButton)this.rdbtnUserProjection);
        manager.translate((AbstractButton)this.rdbtnViewProjection);
    }
}

