/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext;

import org.gvsig.compat.CompatLibrary;
import org.gvsig.fmap.dal.DALLibrary;
import org.gvsig.fmap.mapcontext.ExtentHistory;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.impl.DefaultMapContextDrawer;
import org.gvsig.fmap.mapcontext.layers.ExtendedPropertiesHelper;
import org.gvsig.fmap.mapcontext.layers.FLayerStatus;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.FLyrDefault;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.ReprojectDefaultGeometry;
import org.gvsig.fmap.mapcontext.tools.persistence.ColorPersistenceFactory;
import org.gvsig.fmap.mapcontext.tools.persistence.DimensionPersistenceFactory;
import org.gvsig.fmap.mapcontext.tools.persistence.FontPersistenceFactory;
import org.gvsig.fmap.mapcontext.tools.persistence.Point2DPersistenceFactory;
import org.gvsig.fmap.mapcontext.tools.persistence.Rectangle2DPersistenceFactory;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibraryException;
import org.gvsig.tools.locator.Locator;
import org.gvsig.tools.locator.ReferenceNotRegisteredException;
import org.gvsig.tools.util.Callable;
import org.gvsig.tools.util.impl.DefaultCaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapContextLibrary
extends AbstractLibrary {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapContextLibrary.class);

    public void doRegistration() {
        this.registerAsAPI(MapContextLibrary.class);
        this.require(DALLibrary.class);
        this.require(CompatLibrary.class);
    }

    protected void doInitialize() throws LibraryException {
    }

    protected void doPostInitialize() throws LibraryException {
        DefaultCaller caller = new DefaultCaller();
        MapContextManager manager = MapContextLocator.getMapContextManager();
        if (manager == null) {
            throw new ReferenceNotRegisteredException("mapcontextlocator.manager", (Locator)MapContextLocator.getInstance());
        }
        caller.add((Callable)new FLyrDefault.RegisterMetadata());
        caller.add((Callable)new DefaultMapContextDrawer.RegisterMapContextDrawer());
        caller.add((Callable)new ViewPort.RegisterPersistence());
        caller.add((Callable)new ExtendedPropertiesHelper.RegisterPersistence());
        caller.add((Callable)new MapContext.RegisterPersistence());
        caller.add((Callable)new ExtentHistory.RegisterPersistence());
        caller.add((Callable)new ReprojectDefaultGeometry.RegisterPersistence());
        caller.add((Callable)new FLayerStatus.RegisterPersistence());
        caller.add((Callable)new FLyrDefault.RegisterPersistence());
        caller.add((Callable)new FLyrVect.SelfRegister());
        caller.add((Callable)new FLayers.RegisterPersistence());
        caller.add((Callable)new ColorPersistenceFactory.RegisterPersistence());
        caller.add((Callable)new Point2DPersistenceFactory.RegisterPersistence());
        caller.add((Callable)new FontPersistenceFactory.RegisterPersistence());
        caller.add((Callable)new Rectangle2DPersistenceFactory.RegisterPersistence());
        caller.add((Callable)new DimensionPersistenceFactory.RegisterPersistence());
        if (!caller.call()) {
            throw new LibraryException(MapContextLibrary.class, caller.getExceptions());
        }
        if (!RasterLegendLocator.getInstance().exists("RasterLegendManager")) {
            LOGGER.warn("MapContext API don't has a RasterLegend registered.");
        }
    }
}

