/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cresques.cts.GeoCalc;
import org.cresques.cts.IProjection;
import org.gvsig.compat.CompatLocator;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.ExtentHistory;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.events.ColorEvent;
import org.gvsig.fmap.mapcontext.events.ExtentEvent;
import org.gvsig.fmap.mapcontext.events.ProjectionEvent;
import org.gvsig.fmap.mapcontext.events.listeners.ViewPortListener;
import org.gvsig.fmap.mapcontext.events.listeners.ViewPortListenerEx1;
import org.gvsig.timesupport.Time;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewPort
implements Persistent,
Cloneable {
    private static final String FIELD_DISTANCE_AREA = "distanceArea";
    private static final String FIELD_IMAGE_SIZE = "imageSize";
    private static final String FIELD_PROJ = "proj";
    private static final String FIELD_OFFSET = "offset";
    private static final String FIELD_MAP_UNITS = "mapUnits";
    private static final String FIELD_EXTENT = "extent";
    private static final String FIELD_EXTENTS = "extents";
    private static final String FIELD_DISTANCE_UNITS = "distanceUnits";
    private static final String FIELD_DIST3PIXEL = "dist3pixel";
    private static final String FIELD_DIST1PIXEL = "dist1pixel";
    private static final String FIELD_CLIP = "clip";
    private static final String FIELD_BACK_COLOR = "backColor";
    private static final String FIELD_ADJUSTED_EXTENT = "adjustedExtent";
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(ViewPort.class);
    protected Rectangle2D extent;
    protected Time time;
    protected Rectangle2D adjustedExtent;
    private long drawVersion = 0L;
    protected ExtentHistory extentsHistory = new ExtentHistory();
    private Dimension imageSize;
    private AffineTransform trans = new AffineTransform();
    private int distanceUnits = 1;
    private int distanceArea = 1;
    private int mapUnits = 1;
    private List<ViewPortListener> listeners = new ArrayList<ViewPortListener>();
    private Point2D offset = new Point2D.Double(0.0, 0.0);
    private Color backColor = null;
    private Color selectionColor = MapContext.DEFAULT_SELECTION_COLOR;
    private IProjection proj;
    private double dist1pixel;
    private double dist3pixel;
    private double scale;
    private Rectangle2D cliprect;
    private boolean adjustableExtent = true;
    private Double dpi = null;

    public ViewPort() {
    }

    public ViewPort(IProjection proj) {
        this.proj = proj;
    }

    public void setAdjustable(boolean adjustable) {
        if (adjustable == this.adjustableExtent) {
            return;
        }
        this.adjustableExtent = adjustable;
        this.updateDrawVersion();
    }

    private Collection<ViewPortListener> getListeners() {
        List<ViewPortListener> ll = Collections.unmodifiableList(this.listeners);
        return ll;
    }

    public boolean addViewPortListener(ViewPortListener listener) {
        if (listener == null) {
            return false;
        }
        if (this.listeners.contains(listener)) {
            return false;
        }
        this.listeners.add(listener);
        return true;
    }

    public boolean removeViewPortListener(ViewPortListener listener) {
        if (listener == null) {
            return false;
        }
        return this.listeners.remove(listener);
    }

    public int fromMapDistance(double d) {
        Point2D.Double pWorld = new Point2D.Double(1.0, 1.0);
        Point2D.Double pScreen = new Point2D.Double();
        try {
            this.trans.deltaTransform(pWorld, pScreen);
        }
        catch (Exception e) {
            System.err.print(e.getMessage());
        }
        return (int)(d * pScreen.x);
    }

    public Point2D fromMapPoint(double x, double y) {
        Point2D.Double pWorld = new Point2D.Double(x, y);
        Point2D.Double pScreen = new Point2D.Double();
        try {
            this.trans.transform(pWorld, pScreen);
        }
        catch (Exception e) {
            System.err.print(e.getMessage());
        }
        return pScreen;
    }

    public Point2D fromMapPoint(Point2D point) {
        return this.fromMapPoint(point.getX(), point.getY());
    }

    public Point2D toMapPoint(int x, int y) {
        Point2D.Double pScreen = new Point2D.Double(x, y);
        return this.toMapPoint(pScreen);
    }

    public Rectangle2D toMapRectangle(Rectangle2D r) {
        Rectangle2D.Double rect = new Rectangle2D.Double();
        Point2D p1 = this.toMapPoint((int)r.getX(), (int)r.getY());
        Point2D p2 = this.toMapPoint((int)r.getMaxX(), (int)r.getMaxY());
        rect.setFrameFromDiagonal(p1, p2);
        return rect;
    }

    public double toMapDistance(int d) {
        double dist = (double)d / this.trans.getScaleX();
        return dist;
    }

    public Point2D toMapPoint(Point2D pScreen) {
        Point2D.Double pWorld = new Point2D.Double();
        if (pScreen == null) {
            return null;
        }
        try {
            AffineTransform at = this.trans.createInverse();
            at.transform(pScreen, pWorld);
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException("Non invertible transform Exception", e);
        }
        return pWorld;
    }

    public Point convertToMapPoint(Point2D pScreen) {
        Point2D p = this.toMapPoint(pScreen);
        try {
            Point point = geomManager.createPoint(p.getX(), p.getY(), 0);
            point.setProjection(this.getProjection());
            return point;
        }
        catch (CreateGeometryException e) {
            throw new RuntimeException(e);
        }
    }

    public Point convertToMapPoint(int x, int y) {
        Point2D.Double pScreen = new Point2D.Double(x, y);
        return this.convertToMapPoint(pScreen);
    }

    public double distanceWorld(Point2D pt1, Point2D pt2) {
        double dist = 0.0;
        if (this.proj.isProjected()) {
            dist = pt1.distance(pt2);
            dist *= MapContext.getDistanceTrans2Meter()[this.getMapUnits()];
        } else {
            GeoCalc geocalc = new GeoCalc(this.proj);
            dist = geocalc.distanceVincenty(pt1, pt2);
        }
        return dist;
    }

    public void setPreviousExtent() {
        this.setPreviousEnvelope();
    }

    public void setPreviousEnvelope() {
        this.updateDrawVersion();
        this.extent = this.extentsHistory.setPreviousExtent();
        this.calculateAffineTransform();
        this.callExtentChanged(this.getAdjustedExtent());
    }

    public void setNextEnvelope() {
        this.updateDrawVersion();
        this.extent = this.extentsHistory.setNextExtent();
        this.calculateAffineTransform();
        this.callExtentChanged(this.getAdjustedExtent());
    }

    public Rectangle2D getExtent() {
        return this.extent;
    }

    public Envelope getEnvelope() {
        if (this.extent == null) {
            return null;
        }
        try {
            Envelope envelope = geomManager.createEnvelope(this.extent.getMinX(), this.extent.getMinY(), this.extent.getMaxX(), this.extent.getMaxY(), 0);
            envelope.setProjection(this.proj);
            return envelope;
        }
        catch (CreateEnvelopeException e) {
            logger.warn("Error creating the ViewPort envelope.", (Throwable)e);
            return null;
        }
    }

    public void setEnvelope(Envelope r) {
        Rectangle2D.Double newExtent = null;
        if (r != null && !r.isEmpty()) {
            newExtent = r.getMaximum(0) - r.getMinimum(0) == 0.0 || r.getMaximum(1) - r.getMinimum(1) == 0.0 ? new Rectangle2D.Double(r.getMinimum(0) - 0.1, r.getMinimum(1) - 0.1, r.getMaximum(0) - r.getMinimum(0) + 0.2, r.getMaximum(1) - r.getMinimum(1) + 0.2) : new Rectangle2D.Double(r.getMinimum(0), r.getMinimum(1), Math.abs(r.getMaximum(0) - r.getMinimum(0)), Math.abs(r.getMaximum(1) - r.getMinimum(1)));
        }
        if (this.extent != null && this.extent.equals(newExtent)) {
            return;
        }
        this.updateDrawVersion();
        this.extent = newExtent;
        try {
            this.calculateAffineTransform();
        }
        catch (Exception ex) {
            this.extent = null;
            throw ex;
        }
        this.extentsHistory.put(this.extent);
        this.callExtentChanged(this.getAdjustedExtent());
    }

    public void refreshExtent() {
        if (this.extentsHistory.getCurrent() == null) {
            this.extentsHistory.put(this.extent);
        } else {
            this.extent = this.extentsHistory.getCurrent();
        }
        this.calculateAffineTransform();
        this.callExtentChanged(this.getAdjustedExtent());
    }

    private double getScale() {
        double[] trans2Meter = MapContext.getDistanceTrans2Meter();
        if (this.proj == null) {
            double wmeters = (double)this.getImageSize().width / this.getDPI() * 0.0254;
            return (long)(trans2Meter[this.getMapUnits()] * this.getAdjustedEnvelope().getLength(0) / wmeters);
        }
        return Math.round(this.proj.getScale(this.getAdjustedEnvelope().getMinimum(0) * trans2Meter[this.getMapUnits()], this.getAdjustedEnvelope().getMaximum(0) * trans2Meter[this.getMapUnits()], (double)this.getImageSize().width, this.getDPI()));
    }

    public AffineTransform getAffineTransform() {
        return this.trans;
    }

    public Dimension getImageSize() {
        return this.imageSize;
    }

    public void setImageSize(Dimension imageSize) {
        if (this.imageSize == null || !this.imageSize.equals(imageSize)) {
            this.updateDrawVersion();
            this.imageSize = imageSize;
            this.calculateAffineTransform();
        }
    }

    protected void callExtentChanged(Envelope newRect) {
        ExtentEvent ev = ExtentEvent.createExtentEvent(newRect);
        for (ViewPortListener listener : this.getListeners()) {
            if (listener == null) continue;
            listener.extentChanged(ev);
        }
    }

    protected void callTimeChanged(Time newTime) {
        ExtentEvent viewPortEvent = new ExtentEvent(newTime);
        for (ViewPortListener listener : this.getListeners()) {
            if (listener == null) continue;
            listener.extentChanged(viewPortEvent);
        }
    }

    private void callColorChanged(Color c) {
        ColorEvent ce = ColorEvent.createColorEvent(c);
        for (ViewPortListener listener : this.getListeners()) {
            if (listener == null) continue;
            listener.backColorChanged(ce);
        }
    }

    private void callSelectionColorChanged(Color c) {
        ColorEvent ce = ColorEvent.createColorEvent(c);
        for (ViewPortListener listener : this.getListeners()) {
            if (listener == null || !(listener instanceof ViewPortListenerEx1)) continue;
            ((ViewPortListenerEx1)listener).selectionColorChanged(ce);
        }
    }

    private void callProjectionChanged(IProjection projection) {
        ProjectionEvent ev = ProjectionEvent.createProjectionEvent(projection);
        for (ViewPortListener listener : this.getListeners()) {
            if (listener == null) continue;
            listener.projectionChanged(ev);
        }
    }

    private void calculateAffineTransform() {
        if (this.imageSize == null || this.extent == null || this.imageSize.width <= 0 || this.imageSize.height <= 0) {
            return;
        }
        AffineTransform escalado = new AffineTransform();
        AffineTransform translacion = new AffineTransform();
        double escalaX = (double)this.imageSize.width / this.extent.getWidth();
        double escalaY = (double)this.imageSize.height / this.extent.getHeight();
        double xCenter = this.extent.getCenterX();
        double yCenter = this.extent.getCenterY();
        this.adjustedExtent = new Rectangle2D.Double();
        if (this.adjustableExtent) {
            if (escalaX < escalaY) {
                this.scale = escalaX;
                double newHeight = (double)this.imageSize.height / this.scale;
                this.adjustedExtent.setRect(xCenter - this.extent.getWidth() / 2.0, yCenter - newHeight / 2.0, this.extent.getWidth(), newHeight);
            } else {
                this.scale = escalaY;
                double newWidth = (double)this.imageSize.width / this.scale;
                this.adjustedExtent.setRect(xCenter - newWidth / 2.0, yCenter - this.extent.getHeight() / 2.0, newWidth, this.extent.getHeight());
            }
            escalado.setToScale(this.scale, -this.scale);
        } else {
            this.scale = escalaX;
            this.adjustedExtent.setFrame(this.extent);
            escalado.setToScale(escalaX, -escalaY);
        }
        Envelope env = this.getAdjustedExtent();
        if (env == null) {
            return;
        }
        translacion.setToTranslation(-env.getMinimum(0), -env.getMinimum(1) - this.getAdjustedExtent().getLength(1));
        AffineTransform offsetTrans = new AffineTransform();
        offsetTrans.setToTranslation(this.offset.getX(), this.offset.getY());
        this.trans.setToIdentity();
        this.trans.concatenate(offsetTrans);
        this.trans.concatenate(escalado);
        this.trans.concatenate(translacion);
        try {
            AffineTransform at = this.trans.createInverse();
            Point2D.Float pPixel = new Point2D.Float(1.0f, 1.0f);
            Point2D.Float pProv = new Point2D.Float();
            at.deltaTransform(pPixel, pProv);
            this.dist1pixel = pProv.x;
            this.dist3pixel = 3.0f * pProv.x;
        }
        catch (NoninvertibleTransformException e) {
            String msg = "Can't calculate affine transform for the view port.\nThe extent can be out of range for this projection.\ntransformada afin: " + Objects.toString(this.trans) + "\n" + "extent: " + Objects.toString(this.extent) + "\n" + "imageSize: " + Objects.toString(this.imageSize) + "\n" + "projection: " + Objects.toString(this.proj) + "\n" + e.getLocalizedMessage();
            logger.error(msg, (Throwable)e);
            this.trans.setToIdentity();
            this.scale = 0.0;
            this.adjustedExtent = null;
            this.adjustableExtent = true;
            throw new RuntimeException(msg, e);
        }
    }

    public void setOffset(Point2D p) {
        if (!this.offset.equals(p)) {
            this.updateDrawVersion();
            this.offset = p;
        }
    }

    public Point2D getOffset() {
        return this.offset;
    }

    public void setBackColor(Color c) {
        if (!c.equals(this.backColor)) {
            this.updateDrawVersion();
            this.backColor = c;
            this.callColorChanged(this.backColor);
        }
    }

    public void setSelectionColor(Color c) {
        if (!c.equals(this.selectionColor)) {
            this.updateDrawVersion();
            this.selectionColor = c;
            this.callSelectionColorChanged(this.selectionColor);
        }
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public Envelope getAdjustedExtent() {
        return this.getAdjustedEnvelope();
    }

    public Envelope getAdjustedEnvelope() {
        if (this.adjustedExtent == null) {
            this.calculateAffineTransform();
        }
        if (this.cliprect != null) {
            Rectangle2D r = this.adjustedExtent.createIntersection(this.cliprect);
            try {
                return geomManager.createEnvelope(r.getX(), r.getY(), r.getMaxX(), r.getMaxY(), 0);
            }
            catch (CreateEnvelopeException e) {
                logger.error("Error adjusting the extent", (Throwable)e);
            }
        }
        if (this.adjustedExtent != null) {
            try {
                return geomManager.createEnvelope(this.adjustedExtent.getX(), this.adjustedExtent.getY(), this.adjustedExtent.getMaxX(), this.adjustedExtent.getMaxY(), 0);
            }
            catch (CreateEnvelopeException e) {
                logger.error("Error adjusting the extent", (Throwable)e);
            }
        }
        return null;
    }

    public int getDistanceUnits() {
        return this.distanceUnits;
    }

    public int getDistanceArea() {
        return this.distanceArea;
    }

    public void setDistanceUnits(int distanceUnits) {
        this.distanceUnits = distanceUnits;
    }

    public void setDistanceArea(int distanceArea) {
        this.distanceArea = distanceArea;
    }

    public int getMapUnits() {
        return this.mapUnits;
    }

    public void setMapUnits(int mapUnits) {
        this.mapUnits = mapUnits;
    }

    public int getImageWidth() {
        if (this.imageSize == null) {
            return -1;
        }
        return this.imageSize.width;
    }

    public int getImageHeight() {
        if (this.imageSize == null) {
            return -1;
        }
        return this.imageSize.height;
    }

    public double getDist1pixel() {
        return this.dist1pixel;
    }

    public void setDist1pixel(double dist1pixel) {
        if (dist1pixel == this.dist1pixel) {
            return;
        }
        this.updateDrawVersion();
        this.dist1pixel = dist1pixel;
    }

    public double getDist3pixel() {
        return this.dist3pixel;
    }

    public void setDist3pixel(double dist3pixel) {
        if (this.dist3pixel == dist3pixel) {
            return;
        }
        this.updateDrawVersion();
        this.dist3pixel = dist3pixel;
    }

    public ExtentHistory getExtents() {
        return this.getEnvelopes();
    }

    public ExtentHistory getEnvelopes() {
        return this.extentsHistory;
    }

    public IProjection getProjection() {
        return this.proj;
    }

    public void setProjection(IProjection proj) {
        if (this.proj == null || !this.proj.getAbrev().equals(proj.getAbrev())) {
            this.updateDrawVersion();
            this.proj = proj;
            int metros = MapContext.getDistancePosition("Metros");
            int grados = MapContext.getDistancePosition("Grados");
            if (proj.isProjected()) {
                if (this.getMapUnits() == grados) {
                    this.setMapUnits(metros);
                }
            } else {
                this.setMapUnits(grados);
            }
            this.callProjectionChanged(proj);
        }
    }

    public void setAffineTransform(AffineTransform at) {
        this.trans = at;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(FIELD_ADJUSTED_EXTENT, (Object)this.adjustedExtent);
        state.set(FIELD_BACK_COLOR, (Object)this.backColor);
        state.set(FIELD_CLIP, (Object)this.cliprect);
        state.set(FIELD_DIST1PIXEL, this.dist1pixel);
        state.set(FIELD_DIST3PIXEL, this.dist3pixel);
        state.set(FIELD_DISTANCE_UNITS, this.distanceUnits);
        state.set(FIELD_DISTANCE_AREA, this.distanceArea);
        state.set(FIELD_EXTENT, (Object)this.extent);
        state.set(FIELD_EXTENTS, (Persistent)this.extentsHistory);
        state.set(FIELD_MAP_UNITS, this.mapUnits);
        state.set(FIELD_OFFSET, (Object)this.offset);
        state.set(FIELD_PROJ, (Object)this.proj);
        state.set(FIELD_IMAGE_SIZE, (Object)this.imageSize);
        state.set("selectionColor", (Object)this.getSelectionColor());
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.adjustedExtent = (Rectangle2D)state.get(FIELD_ADJUSTED_EXTENT);
        this.backColor = (Color)state.get(FIELD_BACK_COLOR);
        this.cliprect = (Rectangle2D)state.get(FIELD_CLIP);
        this.dist1pixel = state.getDouble(FIELD_DIST1PIXEL);
        this.dist3pixel = state.getDouble(FIELD_DIST3PIXEL);
        this.distanceUnits = state.getInt(FIELD_DISTANCE_UNITS);
        this.extentsHistory = (ExtentHistory)state.get(FIELD_EXTENTS);
        this.extent = (Rectangle2D)state.get(FIELD_EXTENT);
        this.mapUnits = state.getInt(FIELD_MAP_UNITS);
        this.offset = (Point2D)state.get(FIELD_OFFSET);
        this.proj = (IProjection)state.get(FIELD_PROJ);
        this.imageSize = (Dimension)state.get(FIELD_IMAGE_SIZE);
        this.distanceArea = state.getInt(FIELD_DISTANCE_AREA);
        this.selectionColor = (Color)state.get("selectionColor");
        if (this.selectionColor == null) {
            this.selectionColor = MapContext.DEFAULT_SELECTION_COLOR;
        }
        this.refreshExtent();
    }

    public Object clone() throws CloneNotSupportedException {
        ViewPort clonedViewPort = (ViewPort)super.clone();
        clonedViewPort.listeners = new ArrayList<ViewPortListener>();
        clonedViewPort.extentsHistory = new ExtentHistory();
        if (this.adjustedExtent != null) {
            clonedViewPort.adjustedExtent = (Rectangle2D)this.adjustedExtent.clone();
        }
        if (this.cliprect != null) {
            clonedViewPort.cliprect = (Rectangle2D)this.cliprect.clone();
        }
        if (this.extent != null) {
            clonedViewPort.extent = (Rectangle2D)this.extent.clone();
        }
        if (this.imageSize != null) {
            clonedViewPort.imageSize = (Dimension)this.imageSize.clone();
        }
        if (this.offset != null) {
            clonedViewPort.offset = (Point2D)this.offset.clone();
        }
        if (this.proj != null) {
            clonedViewPort.proj = (IProjection)this.proj.clone();
        }
        clonedViewPort.trans = (AffineTransform)this.trans.clone();
        if (this.selectionColor != null) {
            clonedViewPort.setSelectionColor(this.selectionColor);
        }
        if (this.backColor != null) {
            clonedViewPort.setBackColor(this.backColor);
        }
        return clonedViewPort;
    }

    public String toString() {
        String str = "Datos del viewPort:\nExtent=" + this.extent + "\nadjustedExtent=" + this.adjustedExtent + "\nimageSize=" + this.imageSize + "\nescale=" + this.scale + "\ntrans=" + this.trans;
        return str;
    }

    public void setClipRect(Rectangle2D rectView) {
        this.updateDrawVersion();
        this.cliprect = rectView;
    }

    public Rectangle2D fromMapRectangle(Rectangle2D r) {
        Rectangle2D.Double rect = new Rectangle2D.Double();
        Point2D p1 = this.fromMapPoint((int)r.getX(), (int)r.getY());
        Point2D p2 = this.fromMapPoint((int)r.getMaxX(), (int)r.getMaxY());
        rect.setFrameFromDiagonal(p1, p2);
        return rect;
    }

    public void setScale(long s) {
        double x = this.extent.getX();
        double y = this.extent.getY();
        double escalaX = (double)this.imageSize.width / this.extent.getWidth();
        double difw = escalaX / (double)s;
        double x1 = -x * difw - x + this.extent.getWidth() / 2.0;
        double y1 = -y * difw - y + this.extent.getHeight() / 2.0;
        double w1 = this.extent.getWidth() * difw;
        double h1 = this.extent.getHeight() * difw;
        this.extent.setRect(-x1, -y1, w1, h1);
    }

    public long getDrawVersion() {
        return this.drawVersion;
    }

    protected void updateDrawVersion() {
        ++this.drawVersion;
    }

    public Time getTime() {
        return this.time;
    }

    public void setTime(Time time) {
        this.time = time;
        this.updateDrawVersion();
        this.callTimeChanged(time);
    }

    public double getDPI() {
        if (this.dpi == null) {
            return CompatLocator.getGraphicsUtils().getScreenDPI();
        }
        return this.dpi;
    }

    public void setDPI(double dpi) {
        this.dpi = dpi;
    }

    public void setDPIToScreenDPI() {
        this.dpi = null;
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition("ViewPort") == null) {
                DynStruct definition = manager.addDefinition(ViewPort.class, "ViewPort", "ViewPort Persistence definition", null, null);
                definition.addDynFieldObject(ViewPort.FIELD_ADJUSTED_EXTENT).setClassOfValue(Rectangle2D.class).setMandatory(false);
                definition.addDynFieldObject(ViewPort.FIELD_BACK_COLOR).setClassOfValue(Color.class).setMandatory(false);
                definition.addDynFieldObject(ViewPort.FIELD_CLIP).setClassOfValue(Rectangle2D.class).setMandatory(false);
                definition.addDynFieldDouble(ViewPort.FIELD_DIST1PIXEL).setMandatory(true);
                definition.addDynFieldDouble(ViewPort.FIELD_DIST3PIXEL).setMandatory(true);
                definition.addDynFieldInt(ViewPort.FIELD_DISTANCE_UNITS).setMandatory(true);
                definition.addDynFieldInt(ViewPort.FIELD_DISTANCE_AREA).setMandatory(false);
                definition.addDynFieldObject(ViewPort.FIELD_EXTENT).setClassOfValue(Rectangle2D.class).setMandatory(false);
                definition.addDynFieldObject(ViewPort.FIELD_EXTENTS).setClassOfValue(ExtentHistory.class).setMandatory(true);
                definition.addDynFieldInt(ViewPort.FIELD_MAP_UNITS).setMandatory(true);
                definition.addDynFieldObject(ViewPort.FIELD_OFFSET).setClassOfValue(Point2D.class).setMandatory(false);
                definition.addDynFieldObject(ViewPort.FIELD_PROJ).setClassOfValue(IProjection.class).setMandatory(true);
                definition.addDynFieldObject(ViewPort.FIELD_IMAGE_SIZE).setClassOfValue(Dimension.class).setMandatory(false);
                definition.addDynFieldObject("selectionColor").setClassOfValue(Color.class).setMandatory(false);
            }
            return Boolean.TRUE;
        }
    }
}

