/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.impl;

import java.awt.Color;
import java.awt.Font;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataFactory;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.raster.BandDescriptor;
import org.gvsig.fmap.dal.raster.RasterStore;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextDrawer;
import org.gvsig.fmap.mapcontext.MapContextException;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.MapContextRuntimeException;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.exceptions.CantRetrieveLayerByStoreException;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.impl.DefaultMapContextDrawer;
import org.gvsig.fmap.mapcontext.impl.InvalidRegisteredClassException;
import org.gvsig.fmap.mapcontext.impl.RegisteredClassInstantiationException;
import org.gvsig.fmap.mapcontext.layers.DefaultLayerInformationBuilder;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.LayerInformationBuilder;
import org.gvsig.fmap.mapcontext.layers.operations.SingleLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.GraphicLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.impl.DefaultGraphicLayer;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.driver.ILegendReader;
import org.gvsig.fmap.mapcontext.rendering.legend.driver.ILegendWriter;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelingStrategy;
import org.gvsig.fmap.mapcontext.rendering.symbols.IMultiLayerSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.IWarningSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolException;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolPreferences;
import org.gvsig.raster.lib.legend.api.RasterLegend;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.api.RasterLegendManager;
import org.gvsig.raster.lib.legend.api.colorinterpretation.ColorInterpretation;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.dynobject.exception.DynMethodNotSupportedException;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.observer.Notification;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.swing.api.TransparencySupport;
import org.gvsig.tools.util.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMapContextManager
implements MapContextManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMapContextManager.class);
    private static final double DEFAULT_SYMBOL_TRANSPARENCY = 0.6;
    private Class drawerClazz = DefaultMapContextDrawer.class;
    private final Map<String, Class<ILegend>> legends = new HashMap<String, Class<ILegend>>();
    private final Map<String, Class<ILegendReader>> legendReaders = new LinkedHashMap<String, Class<ILegendReader>>();
    private final Map<String, Map<Class<ILegend>, Class<ILegendWriter>>> legendWriters = new LinkedHashMap<String, Map<Class<ILegend>, Class<ILegendWriter>>>();
    private final Map<Object, Class<? extends FLayer>> layerClassFromStoreClass = new HashMap<Object, Class<? extends FLayer>>();
    private final Map<String, String> iconLayers = new HashMap<String, String>();
    private String defaultVectorLegend;
    private final ObservableHelper observableHelper = new ObservableHelper();
    private File colorTableLibraryFolder = null;
    private String defaultRasterLegend;

    @Override
    public MapContext createMapContext() {
        MapContext mapcontext = new MapContext(new ViewPort());
        return (MapContext)this.notifyObservers("MAPCONTEXTMANAGER_CREATE_MAPCONTEXT", mapcontext).getValue();
    }

    @Override
    public SymbolManager getSymbolManager() {
        return MapContextLocator.getSymbolManager();
    }

    private SymbolPreferences getSymbolPreferences() {
        return this.getSymbolManager().getSymbolPreferences();
    }

    @Override
    public String getSymbolLibraryPath() {
        return this.getSymbolPreferences().getSymbolLibraryPath();
    }

    @Override
    public void setSymbolLibraryPath(String symbolLibraryPath) {
        this.getSymbolPreferences().setSymbolLibraryPath(symbolLibraryPath);
    }

    @Override
    public void resetSymbolLibraryPath() {
        this.getSymbolPreferences().resetSymbolLibraryPath();
    }

    @Override
    public Color getDefaultSymbolColor() {
        return this.getSymbolPreferences().getDefaultSymbolColor();
    }

    @Override
    public Color getDefaultSymbolFillColor() {
        return this.getSymbolPreferences().getDefaultSymbolFillColor();
    }

    @Override
    public Font getDefaultSymbolFont() {
        return this.getSymbolPreferences().getDefaultSymbolFont();
    }

    public String getSymbolFileExtension() {
        return this.getSymbolPreferences().getSymbolFileExtension();
    }

    @Override
    public boolean isDefaultSymbolFillColorAleatory() {
        return this.getSymbolPreferences().isDefaultSymbolFillColorAleatory();
    }

    @Override
    public void resetDefaultSymbolColor() {
        this.getSymbolPreferences().resetDefaultSymbolColor();
    }

    @Override
    public void resetDefaultSymbolFillColor() {
        this.getSymbolPreferences().resetDefaultSymbolFillColor();
    }

    @Override
    public void resetDefaultSymbolFillColorAleatory() {
        this.getSymbolPreferences().resetDefaultSymbolFillColorAleatory();
    }

    @Override
    public void resetDefaultSymbolFont() {
        this.getSymbolPreferences().resetDefaultSymbolFont();
    }

    @Override
    public void setDefaultSymbolColor(Color defaultSymbolColor) {
        this.getSymbolPreferences().setDefaultSymbolColor(defaultSymbolColor);
    }

    @Override
    public void setDefaultSymbolFillColor(Color defaultSymbolFillColor) {
        this.getSymbolPreferences().setDefaultSymbolFillColor(defaultSymbolFillColor);
    }

    @Override
    public void setDefaultSymbolFillColorAleatory(boolean defaultSymbolFillColorAleatory) {
        this.getSymbolPreferences().setDefaultSymbolFillColorAleatory(defaultSymbolFillColorAleatory);
    }

    @Override
    public void setDefaultSymbolFont(Font defaultSymbolFont) {
        this.getSymbolPreferences().setDefaultSymbolFont(defaultSymbolFont);
    }

    public void setSymbolFileExtension(String extension) {
        this.getSymbolPreferences().setSymbolFileExtension(extension);
    }

    @Override
    public int getDefaultCartographicSupportMeasureUnit() {
        return this.getSymbolPreferences().getDefaultCartographicSupportMeasureUnit();
    }

    @Override
    public void setDefaultCartographicSupportMeasureUnit(int defaultCartographicSupportMeasureUnit) {
        this.getSymbolPreferences().setDefaultCartographicSupportMeasureUnit(defaultCartographicSupportMeasureUnit);
    }

    @Override
    public int getDefaultCartographicSupportReferenceSystem() {
        return this.getSymbolPreferences().getDefaultCartographicSupportReferenceSystem();
    }

    @Override
    public void setDefaultCartographicSupportReferenceSystem(int defaultCartographicSupportReferenceSystem) {
        this.getSymbolPreferences().setDefaultCartographicSupportReferenceSystem(defaultCartographicSupportReferenceSystem);
    }

    @Override
    public MapContextDrawer createMapContextDrawerInstance(Class drawerClazz) throws MapContextException {
        return this.createMapContextDrawerInstance(drawerClazz, "NONE");
    }

    @Override
    public MapContextDrawer createDefaultMapContextDrawerInstance() throws MapContextException {
        return this.createMapContextDrawerInstance(this.drawerClazz, "default");
    }

    private MapContextDrawer createMapContextDrawerInstance(Class drawerClazz, String name) throws RegisteredClassInstantiationException {
        try {
            MapContextDrawer drawer = (MapContextDrawer)drawerClazz.newInstance();
            this.notifyObservers("MAPCONTEXTMANAGER_CREATE_MAPCONTEXT_DRAWER", drawer);
            return drawer;
        }
        catch (Exception ex) {
            throw new RegisteredClassInstantiationException(MapContextDrawer.class, drawerClazz, name, ex);
        }
    }

    @Override
    public void setDefaultMapContextDrawer(Class drawerClazz) throws MapContextException {
        this.validateMapContextDrawer(drawerClazz);
        this.drawerClazz = drawerClazz;
        this.notifyObservers("MAPCONTEXTMANAGER_SET_MAPCONTEXT_DRAWER", drawerClazz);
    }

    @Override
    public void validateMapContextDrawer(Class drawerClazz) throws MapContextException {
        if (!MapContextDrawer.class.isAssignableFrom(drawerClazz)) {
            throw new InvalidRegisteredClassException(MapContextDrawer.class, drawerClazz, "UNKNOWN");
        }
    }

    @Override
    public GraphicLayer createGraphicsLayer(IProjection projection) {
        DefaultGraphicLayer layer = new DefaultGraphicLayer();
        try {
            layer.initialize(projection);
            layer.setLegend((IVectorLegend)this.createLegend("VectorialUniqueValue"));
        }
        catch (Exception e) {
            LOGGER.error("Error initializing the graphics layer", (Throwable)e);
        }
        return (GraphicLayer)this.notifyObservers("MAPCONTEXTMANAGER_CREATE_GRAPHICS_LAYER", layer).getValue();
    }

    @Override
    public String getDefaultVectorLegend() {
        return this.defaultVectorLegend;
    }

    @Override
    public void setDefaultVectorLegend(String defaultVectorLegend) {
        this.defaultVectorLegend = defaultVectorLegend;
    }

    @Override
    public String getDefaultRasterLegend() {
        return this.defaultRasterLegend;
    }

    @Override
    public void setDefaultRasterLegend(String defaultRasterLegend) {
        this.defaultRasterLegend = defaultRasterLegend;
    }

    @Override
    public void registerLegend(String legendName, Class legendClass) throws MapContextRuntimeException {
        if (legendClass == null || !ILegend.class.isAssignableFrom(legendClass)) {
            throw new InvalidRegisteredClassException(ILegend.class, legendClass, legendName);
        }
        this.legends.put(legendName, legendClass);
        this.notifyObservers("MAPCONTEXTMANAGER_REGISTER_LEGEND", legendName, legendClass);
    }

    @Override
    public ILegend createLegend(String legendName) throws MapContextRuntimeException {
        Class<ILegend> legendClass = this.legends.get(legendName);
        if (legendClass != null) {
            try {
                ILegend legend = legendClass.newInstance();
                return (ILegend)this.notifyObservers("MAPCONTEXTMANAGER_CREATE_LEGEND", legend).getValue();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RegisteredClassInstantiationException(ILegend.class, legendClass, legendName, e);
            }
        }
        return null;
    }

    @Override
    public IVectorLegend createDefaultVectorLegend(int shapeType) throws MapContextRuntimeException {
        try {
            IVectorLegend legend = (IVectorLegend)this.createLegend(this.getDefaultVectorLegend());
            if (legend == null) {
                return null;
            }
            legend.setShapeType(shapeType);
            ISymbol symbol = this.getSymbolManager().createSymbol(shapeType);
            if (symbol == null) {
                String msg = "Can't create a legend for the shape type " + shapeType + ". The type can be incorrect or there is not registered a symbol by default for that value. If this a was obtained from the store settings, review your FeatureType have correctly configured this value.";
                throw new RuntimeException(msg);
            }
            if (symbol instanceof TransparencySupport && (GeometryUtils.isSubtype((int)3, (int)shapeType) || GeometryUtils.isSubtype((int)9, (int)shapeType))) {
                ((TransparencySupport)symbol).setTransparency(0.6);
            }
            legend.setDefaultSymbol(symbol);
            return legend;
        }
        catch (Exception e) {
            throw new MapContextRuntimeException(e);
        }
    }

    @Override
    public RasterLegend createDefaultRasterLegend(List<BandDescriptor> bands) throws MapContextRuntimeException {
        try {
            ColorInterpretation colorInterpretation;
            RasterLegend legend = (RasterLegend)this.createLegend(this.getDefaultRasterLegend());
            if (legend == null) {
                return null;
            }
            RasterLegendManager legendManager = RasterLegendLocator.getRasterLegendManager();
            switch (bands.size()) {
                case 3: {
                    colorInterpretation = legendManager.createColorInterpretation("RGB");
                    break;
                }
                case 4: {
                    colorInterpretation = legendManager.createColorInterpretation("ARGB");
                    break;
                }
                default: {
                    String[] colorBands = new String[bands.size()];
                    colorBands[0] = "Gray";
                    for (int i = 1; i < colorBands.length; ++i) {
                        colorBands[i] = "Undefined";
                    }
                    colorInterpretation = legendManager.createColorInterpretation(colorBands);
                }
            }
            legend.setColorInterpretation(colorInterpretation);
            legend.addLinearStretchEnhancementOperationIfNeeded(colorInterpretation, bands, 0);
            return legend;
        }
        catch (Exception e) {
            throw new MapContextRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Class<ILegend>, Class<ILegendWriter>> getLegendWritersForFormat(String format) {
        Map<String, Map<Class<ILegend>, Class<ILegendWriter>>> map = this.legendWriters;
        synchronized (map) {
            return this.legendWriters.get(format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<ILegendReader> getLegendReaderForFormat(String format) {
        Map<String, Class<ILegendReader>> map = this.legendReaders;
        synchronized (map) {
            return this.legendReaders.get(format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getLegendReadingFormats() {
        Map<String, Class<ILegendReader>> map = this.legendReaders;
        synchronized (map) {
            ArrayList<String> resp = new ArrayList<String>();
            resp.addAll(this.legendReaders.keySet());
            return resp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getLegendWritingFormats() {
        Map<String, Map<Class<ILegend>, Class<ILegendWriter>>> map = this.legendWriters;
        synchronized (map) {
            ArrayList<String> resp = new ArrayList<String>();
            resp.addAll(this.legendWriters.keySet());
            return resp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerLegendReader(String format, Class readerClass) throws MapContextRuntimeException {
        if (readerClass == null || !ILegendReader.class.isAssignableFrom(readerClass)) {
            throw new InvalidRegisteredClassException(ILegendReader.class, readerClass, format);
        }
        Map<String, Class<ILegendReader>> map = this.legendReaders;
        synchronized (map) {
            this.legendReaders.put(format, readerClass);
        }
        this.notifyObservers("MAPCONTEXTMANAGER_REGISTER_LEGEND_READER", format, readerClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerLegendWriter(Class legendClass, String format, Class writerClass) throws MapContextRuntimeException {
        if (writerClass == null || legendClass == null || !ILegendWriter.class.isAssignableFrom(writerClass) || !ILegend.class.isAssignableFrom(legendClass)) {
            throw new InvalidRegisteredClassException(ILegendWriter.class, writerClass, format.concat("-").concat(legendClass == null ? "Null" : legendClass.getName()));
        }
        Map<String, Map<Class<ILegend>, Class<ILegendWriter>>> map = this.legendWriters;
        synchronized (map) {
            Map<Class<ILegend>, Class<ILegendWriter>> legendWriterOfFormat = this.legendWriters.get(format);
            if (legendWriterOfFormat == null) {
                legendWriterOfFormat = new LinkedHashMap<Class<ILegend>, Class<ILegendWriter>>();
                this.legendWriters.put(format, legendWriterOfFormat);
            }
            legendWriterOfFormat.put(legendClass, writerClass);
        }
        this.notifyObservers("MAPCONTEXTMANAGER_REGISTER_LEGEND_WRITER", format, writerClass);
    }

    @Override
    public ILegendReader createLegendReader(String format) throws MapContextRuntimeException {
        Class<ILegendReader> legendReaderClazz = this.getLegendReaderForFormat(format);
        if (legendReaderClazz != null) {
            try {
                ILegendReader reader = legendReaderClazz.newInstance();
                return (ILegendReader)this.notifyObservers("MAPCONTEXTMANAGER_CREATE_LEGEND_READER", reader).getValue();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RegisteredClassInstantiationException(ILegendReader.class, legendReaderClazz, format, e);
            }
        }
        return null;
    }

    @Override
    public ILegendWriter createLegendWriter(Class legendClass, String format) throws MapContextRuntimeException {
        if (legendClass == null || format == null) {
            return null;
        }
        Map<Class<ILegend>, Class<ILegendWriter>> legendFormatWriters = this.getLegendWritersForFormat(format);
        if (legendFormatWriters != null) {
            Class<ILegendWriter> legendWriterClazz = legendFormatWriters.get(legendClass);
            if (legendWriterClazz != null) {
                try {
                    ILegendWriter writer = legendWriterClazz.newInstance();
                    return (ILegendWriter)this.notifyObservers("MAPCONTEXTMANAGER_CREATE_LEGEND_READER", writer).getValue();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RegisteredClassInstantiationException(ILegendWriter.class, legendWriterClazz, format.concat("-").concat(legendClass.getName()), e);
                }
            }
            try {
                return this.getSuperClassLegendWriter(legendFormatWriters, legendClass);
            }
            catch (Exception exc) {
                throw new MapContextRuntimeException(exc);
            }
        }
        return null;
    }

    private ILegendWriter getSuperClassLegendWriter(Map<Class<ILegend>, Class<ILegendWriter>> clsToWtr, Class<ILegend> legclass) throws Exception {
        for (Class<ILegend> oitem : clsToWtr.keySet()) {
            Class<Object> citem;
            if (!(oitem instanceof Class) || !(citem = oitem).isAssignableFrom(legclass)) continue;
            citem = clsToWtr.get(oitem);
            return (ILegendWriter)citem.newInstance();
        }
        return null;
    }

    @Override
    public IMultiLayerSymbol createMultiLayerSymbol(int shapeType) throws MapContextRuntimeException {
        IMultiLayerSymbol symbol = this.getSymbolManager().createMultiLayerSymbol(shapeType);
        return (IMultiLayerSymbol)this.notifyObservers("MAPCONTEXTMANAGER_CREATE_SYMBOL", symbol).getValue();
    }

    @Override
    public IMultiLayerSymbol createMultiLayerSymbol(String symbolName) throws MapContextRuntimeException {
        IMultiLayerSymbol symbol = this.getSymbolManager().createMultiLayerSymbol(symbolName);
        return (IMultiLayerSymbol)this.notifyObservers("MAPCONTEXTMANAGER_CREATE_SYMBOL", symbol).getValue();
    }

    @Override
    public ISymbol createSymbol(int shapeType, Color color) throws MapContextRuntimeException {
        ISymbol symbol = this.getSymbolManager().createSymbol(shapeType, color);
        return (ISymbol)this.notifyObservers("MAPCONTEXTMANAGER_CREATE_SYMBOL", symbol).getValue();
    }

    @Override
    public ISymbol createSymbol(int shapeType) throws MapContextRuntimeException {
        ISymbol symbol = this.getSymbolManager().createSymbol(shapeType);
        return (ISymbol)this.notifyObservers("MAPCONTEXTMANAGER_CREATE_SYMBOL", symbol).getValue();
    }

    @Override
    public ISymbol createSymbol(String symbolName, Color color) throws MapContextRuntimeException {
        ISymbol symbol = this.getSymbolManager().createSymbol(symbolName, color);
        return (ISymbol)this.notifyObservers("MAPCONTEXTMANAGER_CREATE_SYMBOL", symbol).getValue();
    }

    @Override
    public ISymbol createSymbol(String symbolName) throws MapContextRuntimeException {
        ISymbol symbol = this.getSymbolManager().createSymbol(symbolName);
        return (ISymbol)this.notifyObservers("MAPCONTEXTMANAGER_CREATE_SYMBOL", symbol).getValue();
    }

    @Override
    public IWarningSymbol getWarningSymbol(String message, String symbolDesc, int symbolDrawExceptionType) throws MapContextRuntimeException {
        return this.getSymbolManager().getWarningSymbol(message, symbolDesc, symbolDrawExceptionType);
    }

    public ISymbol[] loadSymbols(File folder, FileFilter filter) throws SymbolException {
        ISymbol[] symbols = this.getSymbolManager().loadSymbols(folder, filter);
        return (ISymbol[])this.notifyObservers("MAPCONTEXTMANAGER_LOAD_SYMBOLS", symbols).getValue();
    }

    public ISymbol[] loadSymbols(File folder) throws SymbolException {
        ISymbol[] symbols = this.getSymbolManager().loadSymbols(folder);
        return (ISymbol[])this.notifyObservers("MAPCONTEXTMANAGER_LOAD_SYMBOLS", symbols).getValue();
    }

    @Override
    public void registerMultiLayerSymbol(String symbolName, Class symbolClass) throws MapContextRuntimeException {
        this.getSymbolManager().registerMultiLayerSymbol(symbolName, symbolClass);
        this.notifyObservers("MAPCONTEXTMANAGER_REGISTER_MULTILAYER_SYMBOL", symbolName, symbolClass);
    }

    @Override
    public void registerMultiLayerSymbol(String symbolName, int[] shapeTypes, Class symbolClass) throws MapContextRuntimeException {
        this.getSymbolManager().registerMultiLayerSymbol(symbolName, shapeTypes, symbolClass);
        this.notifyObservers("MAPCONTEXTMANAGER_REGISTER_MULTILAYER_SYMBOL", symbolName, symbolClass, shapeTypes);
    }

    @Override
    public void registerSymbol(String symbolName, Class symbolClass) throws MapContextRuntimeException {
        this.getSymbolManager().registerSymbol(symbolName, symbolClass);
        this.notifyObservers("MAPCONTEXTMANAGER_REGISTER_SYMBOL", symbolName, symbolClass);
    }

    @Override
    public void registerSymbol(String symbolName, int[] shapeTypes, Class symbolClass) throws MapContextException {
        this.getSymbolManager().registerSymbol(symbolName, shapeTypes, symbolClass);
        this.notifyObservers("MAPCONTEXTMANAGER_REGISTER_SYMBOL", symbolName, symbolClass, shapeTypes);
    }

    public void saveSymbol(ISymbol symbol, String fileName, File folder, boolean overwrite) throws SymbolException {
        this.getSymbolManager().saveSymbol(symbol, fileName, folder, overwrite);
    }

    public void saveSymbol(ISymbol symbol, String fileName, File folder) throws SymbolException {
        this.getSymbolManager().saveSymbol(symbol, fileName, folder);
    }

    @Override
    public boolean registerLayer(Class theClass, Class<? extends FLayer> layerClass) {
        this.layerClassFromStoreClass.put(theClass, layerClass);
        return true;
    }

    @Override
    public boolean registerLayer(Factory<FLayer> factory) {
        this.layerClassFromStoreClass.put(factory, null);
        return true;
    }

    private FLayer newLayerFromFactories(DataStore dataStore) {
        for (Map.Entry<Object, Class<? extends FLayer>> entry : this.layerClassFromStoreClass.entrySet()) {
            Object currentKey = entry.getKey();
            if (!(currentKey instanceof Factory)) continue;
            Factory factory = (Factory)currentKey;
            FLayer layer = (FLayer)factory.create(new Object[]{dataStore.getParameters(), dataStore});
            if (layer == null) continue;
            return layer;
        }
        return null;
    }

    private Class<? extends FLayer> getLayerClass(Class keyClass) {
        Class<? extends FLayer> layerClass = this.layerClassFromStoreClass.get(keyClass);
        if (layerClass != null) {
            return layerClass;
        }
        for (Map.Entry<Object, Class<? extends FLayer>> entry : this.layerClassFromStoreClass.entrySet()) {
            Object currentKey = entry.getKey();
            if (!(currentKey instanceof Class)) continue;
            Class currentKeyClass = (Class)currentKey;
            layerClass = entry.getValue();
            if (!currentKeyClass.isAssignableFrom(keyClass)) continue;
            return layerClass;
        }
        return null;
    }

    @Override
    public FLayer createLayer(String layerName, DataStoreParameters dataParameters) throws LoadLayerException {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            DataStore dataStore = dataManager.openStore(dataParameters.getDataStoreName(), dataParameters);
            return this.createLayer(layerName, dataStore, null);
        }
        catch (Exception e) {
            throw new LoadLayerException(layerName, e);
        }
    }

    @Override
    public FLayer createLayer(String layerName, DataStore dataStore) throws LoadLayerException {
        return this.createLayer(layerName, dataStore, null);
    }

    @Override
    public FLayer createLayer(String layerName, MapContextManager.CreateLayerParameters parameters) throws LoadLayerException {
        try {
            FLayer layer;
            DataManager dataManager = DALLocator.getDataManager();
            DataStoreParameters dataParameters = parameters.getDataParameters();
            DataFactory sf = dataManager.getStoreFactory(dataParameters);
            if (sf == null || !StringUtils.equalsIgnoreCase((CharSequence)sf.getName(), (CharSequence)"FeatureStore") || parameters.getCoordTrans() != null || parameters.useCache() || parameters.isVisible()) {
                DataStore dataStore = dataManager.openStore(dataParameters.getProviderName(), dataParameters);
                return this.createLayer(layerName, dataStore, parameters);
            }
            Class<? extends FLayer> layerClass = this.getLayerClass(FeatureStore.class);
            if (layerClass == null) {
                throw new CantRetrieveLayerByStoreException(layerName, FeatureStore.class.getName());
            }
            try {
                layer = layerClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new LoadLayerException(layerName, e);
            }
            layer.setName(layerName);
            layer.setVisible(false);
            ((FLyrVect)layer).setDataStoreParameters(dataParameters);
            layer.load();
            return (FLayer)this.notifyObservers("MAPCONTEXTMANAGER_CREATE_LAYER", layer).getValue();
        }
        catch (Exception e) {
            throw new LoadLayerException(layerName, e);
        }
    }

    @Override
    public FLayer createLayer(String layerName, DataStore dataStore, MapContextManager.CreateLayerParameters parameters) throws LoadLayerException {
        try {
            FLayer layer;
            DataStoreProviderFactory factory;
            boolean useCache = false;
            ICoordTrans coordTrans = null;
            IProjection projection = (IProjection)dataStore.getDynValue("CRS");
            if (parameters != null) {
                if (parameters.getDataParameters() != dataStore.getParameters()) {
                    throw new IllegalArgumentException("The dataStore parameters are not the same of the store pased to create layer.");
                }
                useCache = parameters.useCache();
                coordTrans = parameters.getCoordTrans();
            }
            if (useCache && (factory = dataStore.getProviderFactory()).isTiledSupported() != 2 && !factory.getClass().getSimpleName().equals("TileProviderFactory")) {
                DataManager dataManager = DALLocator.getDataManager();
                DataStoreParameters tileParameters = dataManager.createStoreParameters("TileCache");
                FoldersManager folderManager = ToolsLocator.getFoldersManager();
                File applicationHome = folderManager.get("ApplicationHome");
                File cacheFolder = applicationHome == null ? folderManager.getTemporaryFile(new String[]{"gvsig_rcache"}) : new File(applicationHome, "gvsig_rcache");
                if (tileParameters.getDynClass().getDynField("rootFolder") != null) {
                    tileParameters.setDynValue("rootFolder", (Object)cacheFolder);
                }
                try {
                    dataStore.useCache("TileCache", (DynObject)tileParameters);
                }
                catch (DataException e) {
                    LOGGER.warn("Can't cache the layer.", (Throwable)e);
                }
            }
            if ((layer = this.newLayerFromFactories(dataStore)) == null) {
                Class<? extends FLayer> layerClass = this.getLayerClass(dataStore.getParameters().getClass());
                if (layerClass == null) {
                    layerClass = this.getLayerClass(dataStore.getProviderFactory().getClass());
                    if (layerClass == null) {
                        layerClass = this.getLayerClass(dataStore.getClass());
                    }
                    if (layerClass == null) {
                        throw new CantRetrieveLayerByStoreException(layerName, dataStore.getName());
                    }
                }
                try {
                    layer = layerClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new LoadLayerException(layerName, e);
                }
                ((SingleLayer)layer).setDataStore(dataStore);
            }
            layer.setName(layerName);
            if (projection != null) {
                layer.setProjection(projection);
                if (coordTrans != null) {
                    layer.setCoordTrans(coordTrans);
                }
            }
            layer.load();
            return (FLayer)this.notifyObservers("MAPCONTEXTMANAGER_CREATE_LAYER", layer).getValue();
        }
        catch (Exception e) {
            throw new LoadLayerException(layerName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILegend getLegend(DataStore dataStore) {
        ILegend legend;
        block28: {
            legend = null;
            ResourcesStorage resourcesStorage = null;
            try {
                resourcesStorage = dataStore.getResourcesStorage();
                if (resourcesStorage == null) break block28;
                ResourcesStorage.Resource resource = resourcesStorage.getResource(".gvsleg".substring(1));
                try {
                    if (resource != null && resource.exists()) {
                        PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
                        InputStream is = resource.asInputStream();
                        legend = (ILegend)persistenceManager.getObject(is);
                        is.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Can't loasd legend", (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)resource);
                }
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)resourcesStorage);
            }
        }
        if (legend == null) {
            try {
                legend = (ILegend)dataStore.invokeDynMethod("getLegend", null);
            }
            catch (DynMethodNotSupportedException e) {
                LOGGER.debug("This store {} does not provide a legend.", (Object)dataStore.getName());
            }
            catch (DynMethodException e) {
                LOGGER.warn("Can't load the specific legend provided for the store {}.", (Object)dataStore.getName(), (Object)e);
            }
        }
        if (legend == null) {
            if (dataStore instanceof FeatureStore) {
                try {
                    FeatureType featureType = ((FeatureStore)dataStore).getDefaultFeatureType();
                    int indexGeom = featureType.getDefaultGeometryAttributeIndex();
                    if (indexGeom < 0) {
                        throw new IllegalArgumentException("The layer don't has a geometry column.");
                    }
                    int typeShape = featureType.getAttributeDescriptor(indexGeom).getGeometryType();
                    legend = this.createDefaultVectorLegend(typeShape);
                }
                catch (DataException e) {
                    LOGGER.warn("Error getting the default feature type", (Throwable)e);
                }
            } else if (dataStore instanceof RasterStore) {
                RasterStore rasterStore = (RasterStore)dataStore;
                List bands = rasterStore.getBandDescriptors();
                legend = this.createDefaultRasterLegend(bands);
            }
        }
        if (legend instanceof RasterLegend) {
            RasterLegend rasterLegend = (RasterLegend)legend;
            RasterStore rasterStore = (RasterStore)dataStore;
            ColorInterpretation colorInterpretation = rasterLegend.getColorInterpretation();
            if (colorInterpretation.isPalette()) {
                rasterLegend.addColorTableOperation(colorInterpretation, 0);
            } else {
                rasterLegend.addLinearStretchEnhancementOperationIfNeeded(colorInterpretation, rasterStore.getBandDescriptors(), 0);
            }
            if (colorInterpretation.hasAnyHSLBand()) {
                rasterLegend.addHSLToRGBOperation(colorInterpretation);
            } else if (colorInterpretation.hasAnyCMYKBand()) {
                rasterLegend.addCMYKToRGBOperation(colorInterpretation);
            } else if (colorInterpretation.hasAnyYCBCRBand()) {
                // empty if block
            }
        }
        return legend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILabelingStrategy getLabelingStrategy(DataStore dataStore) {
        ILabelingStrategy labelingStrategy = null;
        ResourcesStorage resourcesStorage = dataStore.getResourcesStorage();
        if (resourcesStorage != null) {
            ResourcesStorage.Resource resource = resourcesStorage.getResource(".gvslab".substring(1));
            try {
                if (resource != null && resource.exists()) {
                    PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
                    InputStream is = resource.asInputStream();
                    labelingStrategy = (ILabelingStrategy)persistenceManager.getObject(is);
                    is.close();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Can't load Label strategy", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((Closeable)resource);
            }
        }
        if (labelingStrategy == null) {
            try {
                labelingStrategy = (ILabelingStrategy)dataStore.invokeDynMethod("getLabeling", null);
            }
            catch (DynMethodNotSupportedException e1) {
                labelingStrategy = null;
            }
            catch (DynMethodException e1) {
                LOGGER.error("Can't load the specific labeling strategy provided for the datastore {}.", (Object)dataStore.getName(), (Object)e1);
            }
        }
        return labelingStrategy;
    }

    private Object call(Object instance, String methodName, Class[] signature, Object[] params) {
        try {
            Method method = instance.getClass().getMethod(methodName, signature);
            if (method == null) {
                return null;
            }
            Object value = method.invoke(instance, params);
            return value;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void registerIconLayer(String storeProviderName, String iconName) {
        if (storeProviderName == null || iconName == null) {
            LOGGER.info("registerIconLayer, storeProviderName or iconName are null");
            return;
        }
        String storeName = storeProviderName.trim().toLowerCase();
        if (storeName.length() == 0 || iconName.trim().length() == 0) {
            LOGGER.info("registerIconLayer, invalid storeProviderName or iconName");
            return;
        }
        this.iconLayers.put(storeName, iconName);
        this.notifyObservers("MAPCONTEXTMANAGER_REGISTER_ICON_LAYER", storeName, iconName);
    }

    @Override
    public String getIconLayer(DataStore store) {
        try {
            return this.getIconLayer(store.getProviderName());
        }
        catch (Throwable th) {
            return "layer-icon";
        }
    }

    @Override
    public String getIconLayer(String providerName) {
        String name = null;
        try {
            name = this.iconLayers.get(providerName.trim().toLowerCase());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (StringUtils.isEmpty(name)) {
            name = "layer-icon";
        }
        return name;
    }

    @Override
    public IProjection getDefaultCRS() {
        IProjection crs = CRSFactory.getCRS((String)"EPSG:4326");
        return (IProjection)this.notifyObservers("MAPCONTEXTMANAGER_GET_DEFAULT_CRS", crs).getValue();
    }

    public Notification notifyLoadMapContext(MapContext mapContext) {
        return this.observableHelper.notifyObservers((Observable)this, "MAPCONTEXTMANAGER_LOAD_MAPCONTEXT", (Object)mapContext);
    }

    public Notification notifyLoadLayer(FLayer layer) {
        return this.observableHelper.notifyObservers((Observable)this, "MAPCONTEXTMANAGER_LOAD_LAYER", (Object)layer);
    }

    public void addObserver(Observer o) {
        this.observableHelper.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.observableHelper.deleteObserver(o);
    }

    public void deleteObservers() {
        this.observableHelper.deleteObservers();
    }

    protected Notification notifyObservers(String type, Object value) {
        return this.observableHelper.notifyObservers((Observable)this, type, value);
    }

    protected Notification notifyObservers(String type, Object value1, Object value2) {
        return this.observableHelper.notifyObservers((Observable)this, type, value1, value2);
    }

    protected Notification notifyObservers(String type, Object value1, Object value2, Object value3) {
        return this.observableHelper.notifyObservers((Observable)this, type, value1, value2, value3);
    }

    @Override
    public File getColorTableLibraryFolder() {
        if (this.colorTableLibraryFolder == null) {
            String colorTableLibraryPath = System.getProperty("user.home") + File.separator + "gvSIG" + File.separator + "colortable";
            this.colorTableLibraryFolder = new File(colorTableLibraryPath);
        }
        return this.colorTableLibraryFolder;
    }

    @Override
    public void setColorTableLibraryFolder(File colorTableLibraryFolder) {
        this.colorTableLibraryFolder = colorTableLibraryFolder;
    }

    @Override
    public LayerInformationBuilder createLayerInformationBuilder() {
        return new DefaultLayerInformationBuilder();
    }

    @Override
    public Icon getIcon(int geometryType, boolean withSelection) {
        try {
            String name;
            switch (geometryType) {
                case 18: {
                    name = "layer-type-line";
                    break;
                }
                case 1: {
                    name = "layer-type-point";
                    break;
                }
                case 19: {
                    name = "layer-type-polygon";
                    break;
                }
                case 21: {
                    name = "layer-type-multiline";
                    break;
                }
                case 7: {
                    name = "layer-type-multipoint";
                    break;
                }
                case 22: {
                    name = "layer-type-multipolygon";
                    break;
                }
                case 0: {
                    name = "layer-type-mix";
                    break;
                }
                default: {
                    return null;
                }
            }
            if (withSelection) {
                name = name + "-sel";
            }
            name = name + ".png";
            URL url = this.getClass().getResource("/layertypes/" + name);
            if (url == null) {
                return null;
            }
            ImageIcon icon = new ImageIcon(url);
            return icon;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

