/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.layers;

import java.awt.Image;
import java.awt.geom.Point2D;
import java.io.File;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.exceptions.ReloadLayerException;
import org.gvsig.fmap.mapcontext.exceptions.StartEditionLayerException;
import org.gvsig.fmap.mapcontext.impl.DefaultMapContextManager;
import org.gvsig.fmap.mapcontext.layers.AbstractLinkProperties;
import org.gvsig.fmap.mapcontext.layers.ExtendedPropertiesHelper;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayerHidesArea;
import org.gvsig.fmap.mapcontext.layers.FLayerStatus;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.LayerChangeSupport;
import org.gvsig.fmap.mapcontext.layers.LayerEvent;
import org.gvsig.fmap.mapcontext.layers.LayerInformationBuilder;
import org.gvsig.fmap.mapcontext.layers.LayerListener;
import org.gvsig.fmap.mapcontext.layers.operations.ComposedLayer;
import org.gvsig.fmap.mapcontext.layers.operations.SingleLayer;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendChangedEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.listeners.LegendListener;
import org.gvsig.metadata.Metadata;
import org.gvsig.metadata.MetadataContainer;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.metadata.MetadataManager;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FLyrDefault
extends AbstractDisposable
implements FLayer,
FLayerHidesArea,
LayerListener {
    private static final Logger logger = LoggerFactory.getLogger(FLyrDefault.class);
    private static final int TOL = 7;
    private LayerChangeSupport layerChangeSupport;
    private boolean temporary;
    private FLayers parentLayer = null;
    private int transparency = 255;
    private ICoordTrans ct;
    private double minScale = -1.0;
    private double maxScale = -1.0;
    protected Set<LayerListener> layerListeners = new HashSet<LayerListener>();
    private FLayerStatus status = new FLayerStatus();
    private Image tocStatusImage;
    protected MetadataContainer metadataContainer;
    protected long drawVersion = 0L;
    protected ExtendedPropertiesHelper properties = new ExtendedPropertiesHelper();

    public FLyrDefault(MetadataContainer metadataContainer) {
        this.layerChangeSupport = new LayerChangeSupport();
        this.metadataContainer = metadataContainer;
    }

    public FLyrDefault() {
        this(MetadataLocator.getMetadataManager().createMetadataContainer("Layer"));
    }

    @Override
    public Object getProperty(Object key) {
        return this.properties.getProperty(key);
    }

    @Override
    public void setProperty(Object key, Object val) {
        this.properties.setProperty(key, val);
    }

    @Override
    public Map getExtendedProperties() {
        return this.properties.getExtendedProperties();
    }

    @Override
    public void setActive(boolean selected) {
        if (this.status.active == selected) {
            return;
        }
        this.status.active = selected;
        this.callActivationChanged(LayerEvent.createActivationChangedEvent(this, "active"));
    }

    @Override
    public boolean isActive() {
        return this.status.active;
    }

    @Override
    public void setName(String name) {
        this.metadataContainer.setDynValue("name", (Object)name);
        this.callNameChanged(LayerEvent.createNameChangedEvent(this, "name"));
    }

    @Override
    public String getName() {
        String name = "(unknow)";
        try {
            name = (String)this.metadataContainer.getDynValue("name");
        }
        catch (Throwable th) {
            logger.warn("Can't retrive the layer name.");
        }
        return name;
    }

    @Override
    public void load() throws LoadLayerException {
        MetadataManager manager = MetadataLocator.getMetadataManager();
        try {
            manager.loadMetadata((Metadata)this);
        }
        catch (MetadataException e) {
            throw new LoadLayerException("Can't load metadata.", e);
        }
        DefaultMapContextManager mcmanager = (DefaultMapContextManager)MapContextLocator.getMapContextManager();
        mcmanager.notifyLoadLayer(this);
    }

    @Override
    public void setVisible(boolean visibility) {
        if (this.status.visible != visibility) {
            this.status.visible = visibility;
            this.updateDrawVersion();
            this.callVisibilityChanged(LayerEvent.createVisibilityChangedEvent(this, "visible"));
        }
    }

    @Override
    public boolean isVisible() {
        return this.status.visible && this.status.available;
    }

    @Override
    public FLayers getParentLayer() {
        return this.parentLayer;
    }

    @Override
    public void setParentLayer(FLayers root) {
        if (this.parentLayer != root) {
            this.parentLayer = root;
            this.updateDrawVersion();
        }
    }

    @Override
    public void setProjection(IProjection proj) {
        IProjection curProj = this.getProjection();
        if (curProj == proj) {
            return;
        }
        if (curProj != null && curProj.equals(proj)) {
            return;
        }
        this.updateDrawVersion();
        this.metadataContainer.setDynValue("CRS", (Object)proj);
        if (proj != null && this.getMapContext() != null && !proj.equals(this.getMapContext().getProjection())) {
            ICoordTrans coordTrans = proj.getCT(this.getMapContext().getProjection());
            this.setCoordTrans(coordTrans);
            logger.debug("Cambio proyecci\u00f3n: FMap con " + this.getMapContext().getProjection().getAbrev() + " y capa " + this.getName() + " con " + proj.getAbrev());
        }
    }

    public IProjection getProjection() {
        return (IProjection)this.metadataContainer.getDynValue("CRS");
    }

    public void reProject(ICoordTrans arg0) {
    }

    public int getTransparency() {
        return this.transparency;
    }

    public void setTransparency(int trans) {
        if (this.transparency != trans) {
            this.transparency = trans;
            this.updateDrawVersion();
        }
    }

    @Override
    public MapContext getMapContext() {
        if (this.getParentLayer() != null) {
            return this.getParentLayer().getMapContext();
        }
        return null;
    }

    @Override
    public boolean addLayerListener(LayerListener o) {
        if (o == null) {
            return true;
        }
        return this.layerListeners.add(o);
    }

    @Override
    public LayerListener[] getLayerListeners() {
        return this.layerListeners.toArray(new LayerListener[0]);
    }

    @Override
    public boolean removeLayerListener(LayerListener o) {
        return this.layerListeners.remove(o);
    }

    private void callDrawValueChanged(LayerEvent e) {
        for (LayerListener listener : this.layerListeners) {
            try {
                listener.drawValueChanged(e);
            }
            catch (Exception ex) {
                logger.warn("Error calling listener '" + listener.toString() + "'.", (Throwable)ex);
            }
        }
    }

    private void callNameChanged(LayerEvent e) {
        for (LayerListener listener : this.layerListeners) {
            try {
                listener.nameChanged(e);
            }
            catch (Exception ex) {
                logger.warn("Error calling listener '" + listener.toString() + "'.", (Throwable)ex);
            }
        }
    }

    private void callVisibilityChanged(LayerEvent e) {
        for (LayerListener listener : this.layerListeners) {
            try {
                listener.visibilityChanged(e);
            }
            catch (Exception ex) {
                logger.warn("Error calling listener '" + listener.toString() + "'.", (Throwable)ex);
            }
        }
    }

    private void callActivationChanged(LayerEvent e) {
        for (LayerListener listener : this.layerListeners) {
            try {
                listener.activationChanged(e);
            }
            catch (Exception ex) {
                logger.warn("Error calling listener '" + listener.toString() + "'.", (Throwable)ex);
            }
        }
    }

    @Override
    public void setCoordTrans(ICoordTrans ct) {
        if (this.ct == ct) {
            return;
        }
        if (this.ct != null && this.ct.equals(ct)) {
            return;
        }
        this.ct = ct;
        this.updateDrawVersion();
    }

    @Override
    public ICoordTrans getCoordTrans() {
        return this.ct;
    }

    public void wakeUp() throws LoadLayerException {
    }

    @Override
    public double getMinScale() {
        return this.minScale;
    }

    @Override
    public double getMaxScale() {
        return this.maxScale;
    }

    @Override
    public void setMinScale(double minScale) {
        if (this.minScale != minScale) {
            this.minScale = minScale;
            this.updateDrawVersion();
        }
    }

    @Override
    public void setMaxScale(double maxScale) {
        if (this.maxScale != maxScale) {
            this.maxScale = maxScale;
            this.updateDrawVersion();
        }
    }

    @Override
    public boolean isWithinScale(double scale) {
        boolean bVisible = true;
        if (this.getMinScale() != -1.0 && scale < this.getMinScale()) {
            bVisible = false;
        }
        if (this.getMaxScale() != -1.0 && scale > this.getMaxScale()) {
            bVisible = false;
        }
        return bVisible;
    }

    @Override
    public void setEditing(boolean b) throws StartEditionLayerException {
        this.status.editing = b;
    }

    protected void callEditionChanged(LayerEvent e) {
        for (LayerListener listener : this.layerListeners) {
            try {
                listener.editionChanged(e);
            }
            catch (Exception ex) {
                logger.warn("Error calling listener '" + listener.toString() + "'.", (Throwable)ex);
            }
        }
    }

    @Override
    public boolean isEditing() {
        return this.status.editing;
    }

    @Override
    public String getTocImageIcon() {
        return "layer-icon";
    }

    @Override
    public boolean isInTOC() {
        return this.status.inTOC;
    }

    @Override
    public void setInTOC(boolean b) {
        this.status.inTOC = b;
    }

    @Override
    public boolean isAvailable() {
        return this.status.available;
    }

    @Override
    public void setAvailable(boolean available) {
        if (this.status.available != available) {
            this.status.available = available;
            this.updateDrawVersion();
        }
    }

    @Override
    public void reload() throws ReloadLayerException {
        if (this.ct != null) {
            IProjection srcProj = this.ct.getPOrig();
            if (!this.getProjection().equals(srcProj)) {
                this.ct = this.getProjection().getCT(this.ct.getPDest());
            }
        }
        this.setAvailable(true);
    }

    @Override
    public FLayerStatus getFLayerStatus() {
        return this.status.cloneStatus();
    }

    @Override
    public void setFLayerStatus(FLayerStatus status) {
        if (!this.status.equals(status)) {
            this.status = status;
            this.updateDrawVersion();
        }
    }

    @Override
    public boolean isOk() {
        return this.status.isOk();
    }

    @Override
    public int getNumErrors() {
        return this.status.getNumErrors();
    }

    @Override
    public Throwable getError(int i) {
        return this.status.getError(i);
    }

    @Override
    public List<Throwable> getErrors() {
        return this.status.getErrors();
    }

    @Override
    public void addError(Throwable exception) {
        this.status.addLayerError(exception);
    }

    @Override
    public void setError(Throwable ex) {
        this.status.setLayerError(ex);
    }

    @Override
    public boolean visibleRequired() {
        return this.status.visible;
    }

    @Override
    public String getInfoString() {
        Envelope env = null;
        DataStore store = null;
        try {
            env = this.getFullEnvelope();
        }
        catch (ReadException readException) {
            // empty catch block
        }
        try {
            store = ((SingleLayer)((Object)this)).getDataStore();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LayerInformationBuilder builder = MapContextLocator.getMapContextManager().createLayerInformationBuilder();
        if (store != null) {
            File f;
            builder.title().labelkey("Data_source");
            builder.property().labelkey("Source_type").value(store.getProviderName(), new Object[0]);
            builder.property().labelkey("origen").value(store.getFullName(), new Object[0]);
            if (store.getParameters() instanceof FilesystemStoreParameters && (f = ((FilesystemStoreParameters)store.getParameters()).getFile()) != null && f.exists()) {
                builder.property().labelkey("_Size").value("%d bytes", f.length());
            }
        }
        builder.title().labelkey("_Coordenadas_geograficas");
        if (this.isAvailable()) {
            builder.envelope().value(env);
        }
        builder.title().labelkey("_Projection");
        if (this.isAvailable()) {
            builder.property().value(this.getProjection());
            builder.text().asWKT(this.getProjection());
        }
        return builder.toString();
    }

    @Override
    public boolean isWritable() {
        return this.status.writable;
    }

    @Override
    public FLayer cloneLayer() throws Exception {
        logger.warn("Use of cloneLayer and this is not implemented.");
        return this;
    }

    @Override
    public Image getTocStatusImage() {
        return this.tocStatusImage;
    }

    public void setTocStatusImage(Image tocStatusImage) {
        this.tocStatusImage = tocStatusImage;
        logger.debug("setTocStatusImage " + tocStatusImage + " sobre capa " + this.getName());
    }

    @Override
    public ComposedLayer newComposedLayer() {
        return null;
    }

    @Override
    public boolean allowLinks() {
        return false;
    }

    @Override
    public AbstractLinkProperties getLinkProperties() {
        return null;
    }

    @Override
    public URI[] getLink(Point2D point, double tolerance) throws ReadException {
        return null;
    }

    public void addLegendListener(LegendListener listener) {
        if (listener == null) {
            return;
        }
        this.layerChangeSupport.addLayerListener(listener);
    }

    protected void callLegendChanged(LegendChangedEvent e) {
        this.layerChangeSupport.callLegendChanged(e);
        if (this.parentLayer != null) {
            this.parentLayer.callLegendChanged(e);
        }
    }

    public void removeLegendListener(LegendListener listener) {
        this.layerChangeSupport.removeLayerListener(listener);
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public void delegate(DynObject dynObject) {
        this.metadataContainer.delegate(dynObject);
    }

    public DynClass getDynClass() {
        return this.metadataContainer.getDynClass();
    }

    public Object getDynValue(String name) throws DynFieldNotFoundException {
        return this.metadataContainer.getDynValue(name);
    }

    public boolean hasDynValue(String name) {
        return this.metadataContainer.hasDynValue(name);
    }

    public void implement(DynClass dynClass) {
        this.metadataContainer.implement(dynClass);
    }

    public Object invokeDynMethod(int code, Object[] args) throws DynMethodException {
        return this.metadataContainer.invokeDynMethod((Object)this, code, args);
    }

    public Object invokeDynMethod(String name, Object[] args) throws DynMethodException {
        return this.metadataContainer.invokeDynMethod((Object)this, name, args);
    }

    public void setDynValue(String name, Object value) throws DynFieldNotFoundException {
        this.metadataContainer.setDynValue(name, value);
    }

    @Override
    public long getDrawVersion() {
        return this.drawVersion;
    }

    protected void updateDrawVersion() {
        this.updateDrawVersion(true);
    }

    protected void updateDrawVersion(boolean fireEvents) {
        ++this.drawVersion;
        if (fireEvents) {
            this.callDrawValueChanged(LayerEvent.createDrawValuesChangedEvent(this, ""));
        }
        if (this.parentLayer != null) {
            this.parentLayer.updateDrawVersion();
        }
    }

    public boolean hasChangedForDrawing(long value) {
        return this.drawVersion > value;
    }

    @Override
    public void activationChanged(LayerEvent e) {
    }

    @Override
    public void drawValueChanged(LayerEvent e) {
        this.updateDrawVersion();
    }

    @Override
    public void editionChanged(LayerEvent e) {
    }

    @Override
    public void nameChanged(LayerEvent e) {
    }

    @Override
    public void visibilityChanged(LayerEvent e) {
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        try {
            state.set("name", this.getName());
            state.set("minScale", this.minScale);
            state.set("maxScale", this.maxScale);
            state.set("transparency", this.transparency);
            state.set("coordTrans", (Object)this.ct);
            state.set("crs", (Object)this.getProjection());
            state.set("properties", this.properties.getExtendedProperties());
            state.set("status", (Persistent)this.status);
            state.set("parentLayer", (Persistent)this.parentLayer);
        }
        catch (RuntimeException | PersistenceException ex) {
            logger.warn("Can't save to persistent state the layer '" + this.getName() + "'.");
            throw ex;
        }
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        try {
            String name = state.getString("name");
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = "Unknown";
            }
            try {
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                dialogs.message("Loading '" + name + "'...", 1);
            }
            catch (Throwable th) {
                logger.debug("Can't show user feedback", th);
            }
            this.setDynValue("name", name);
            this.setDynValue("CRS", state.get("crs"));
            this.parentLayer = (FLayers)state.get("parentLayer");
            this.status = (FLayerStatus)state.get("status");
            if (this.status == null) {
                this.status = new FLayerStatus();
                this.setAvailable(false);
                this.addError(new RuntimeException("Can't retreieve the status of the layer."));
            }
            this.minScale = state.getDouble("minScale", -1.0);
            this.maxScale = state.getDouble("maxScale", -1.0);
            this.transparency = state.getInt("transparency", 255);
            this.ct = (ICoordTrans)state.get("coordTrans");
            this.properties.setExtendedProperties((Map)state.get("properties"));
        }
        catch (Exception ex) {
            logger.warn("Can't load from persietent state the layer '" + this.getName() + "'.");
            throw ex;
        }
    }

    public void clear() {
        if (this.metadataContainer != null) {
            this.metadataContainer.clear();
        }
    }

    public String getMetadataName() throws MetadataException {
        return "Layer";
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean hidesThisArea(Envelope area) {
        return false;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    @Override
    public int getDefaultTolerance() {
        return 7;
    }

    @Override
    public void invalidate() {
    }

    public static class RegisterMetadata
    implements Callable {
        public Object call() {
            MetadataManager metadataManager = MetadataLocator.getMetadataManager();
            DynStruct metadataDefinition = metadataManager.getDefinition("Layer");
            if (metadataDefinition == null) {
                try {
                    metadataDefinition = metadataManager.addDefinition("Layer", "Basic layer metadata definition");
                    metadataDefinition.addDynField("name").setMandatory(true);
                    IProjection ipr = MapContextLocator.getMapContextManager().getDefaultCRS();
                    metadataDefinition.addDynFieldObject("CRS").setType(65).setMandatory(true).setDefaultFieldValue((Object)ipr);
                }
                catch (MetadataException e) {
                    logger.warn("Can't create metadata definition for 'Layer'", (Throwable)e);
                }
            }
            return Boolean.TRUE;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            DynStruct definition = manager.addDefinition(FLyrDefault.class, "FLyrDefault", "FLyrDefault Persistence definition", null, null);
            definition.addDynFieldString("name").setMandatory(false);
            definition.addDynFieldInt("transparency").setMandatory(true);
            definition.addDynFieldDouble("minScale").setMandatory(true);
            definition.addDynFieldDouble("maxScale").setMandatory(true);
            definition.addDynFieldObject("crs").setClassOfValue(IProjection.class).setMandatory(false);
            definition.addDynFieldObject("parentLayer").setClassOfValue(FLayers.class).setMandatory(false);
            definition.addDynFieldObject("coordTrans").setClassOfValue(ICoordTrans.class).setMandatory(false);
            definition.addDynFieldObject("status").setClassOfValue(FLayerStatus.class).setMandatory(true);
            definition.addDynFieldMap("properties").setClassOfItems(Object.class).setMandatory(true);
            return Boolean.TRUE;
        }
    }
}

