/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.layers.operations;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.LayerDrawEvent;
import org.gvsig.tools.task.Cancellable;

public abstract class ComposedLayer {
    ArrayList pendingLayersEvents = new ArrayList();
    MapContext mapContext = null;

    public void setMapContext(MapContext mapContext) {
        this.mapContext = mapContext;
    }

    public abstract boolean canAdd(FLayer var1);

    public final void add(FLayer layer) throws Exception {
        if (this.mapContext == null) {
            this.mapContext = layer.getMapContext();
        }
        this.doAdd(layer);
        this.pendingLayersEvents.add(layer);
    }

    public final void draw(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale) throws ReadException {
        this.fireLayerDrawingEvents(g, viewPort, 101);
        this.doDraw(image, g, viewPort, cancel, scale);
        this.fireLayerDrawingEvents(g, viewPort, 102);
        this.pendingLayersEvents.clear();
    }

    public final void print(Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, PrintAttributes properties) throws ReadException {
        this.doPrint(g, viewPort, cancel, scale, properties);
        this.pendingLayersEvents.clear();
    }

    private void fireLayerDrawingEvents(Graphics2D g, ViewPort viewPort, int eventType) {
        Iterator iter = this.pendingLayersEvents.iterator();
        FLayer layer = null;
        while (iter.hasNext()) {
            layer = (FLayer)iter.next();
            LayerDrawEvent afterEvent = new LayerDrawEvent(layer, g, viewPort, eventType);
            this.mapContext.fireLayerDrawingEvent(afterEvent);
        }
    }

    protected abstract void doAdd(FLayer var1) throws Exception;

    protected abstract void doDraw(BufferedImage var1, Graphics2D var2, ViewPort var3, Cancellable var4, double var5) throws ReadException;

    protected abstract void doPrint(Graphics2D var1, ViewPort var2, Cancellable var3, double var4, PrintAttributes var6) throws ReadException;
}

