/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.layers.vectorial;

import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.tools.evaluator.AbstractEvaluator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.evaluator.EvaluatorException;

public class OutGeometryEvaluator
extends AbstractEvaluator {
    private final String geomName;
    private final Geometry geometry;
    private final Geometry geometryTrans;
    private final boolean isDefault;
    private final GeometryExpressionBuilder builder;
    private final IProjection projection;
    private final FeatureAttributeDescriptor fad;

    OutGeometryEvaluator(Geometry geometry, IProjection envelopeProjection, FeatureType featureType, String geomName, GeometryExpressionBuilder builder) {
        this.fad = (FeatureAttributeDescriptor)featureType.get(geomName);
        this.isDefault = featureType.getDefaultGeometryAttributeName().equals(geomName);
        this.geometry = geometry;
        this.geometryTrans = geometry.cloneGeometry();
        this.projection = envelopeProjection;
        this.builder = builder;
        IProjection fad_proj = this.fad.getSRS();
        ICoordTrans ct = null;
        if (fad_proj != null && !fad_proj.equals(envelopeProjection)) {
            ct = envelopeProjection.getCT(fad_proj);
        }
        if (ct != null) {
            this.geometryTrans.reProject(ct);
        }
        this.geomName = geomName;
        this.getFieldsInfo().addFieldValue(geomName);
    }

    public Object evaluate(EvaluatorData data) throws EvaluatorException {
        try {
            Geometry geom;
            if (this.isDefault) {
                Feature feature = (Feature)data.getContextValue("feature");
                geom = feature.getDefaultGeometry();
            } else {
                geom = (Geometry)data.getDataValue(this.geomName);
            }
            if (geom == null) {
                return Boolean.FALSE;
            }
            return !this.geometryTrans.contains(geom) && !this.geometryTrans.intersects(geom);
        }
        catch (Exception e) {
            throw new EvaluatorException((Throwable)e);
        }
    }

    public String getName() {
        return "out of geometry";
    }

    public String getSQL() {
        return this.builder.set((ExpressionBuilder.Value)this.builder.not((ExpressionBuilder.Value)this.builder.ST_Contains((ExpressionBuilder.Value)this.builder.geometry(this.geometry, this.projection), (ExpressionBuilder.Value)this.builder.column(this.fad.getName())))).toString();
    }
}

