/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.layers.vectorial;

import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.layers.vectorial.ContainsEnvelopeEvaluator;
import org.gvsig.fmap.mapcontext.layers.vectorial.ContainsGeometryEvaluator;
import org.gvsig.fmap.mapcontext.layers.vectorial.CrossEnvelopeEvaluator;
import org.gvsig.fmap.mapcontext.layers.vectorial.CrossesGeometryEvaluator;
import org.gvsig.fmap.mapcontext.layers.vectorial.DisjointGeometryEvaluator;
import org.gvsig.fmap.mapcontext.layers.vectorial.EqualsGeometryEvaluator;
import org.gvsig.fmap.mapcontext.layers.vectorial.IntersectsEnvelopeEvaluator;
import org.gvsig.fmap.mapcontext.layers.vectorial.IntersectsGeometryEvaluator;
import org.gvsig.fmap.mapcontext.layers.vectorial.OutGeometryEvaluator;
import org.gvsig.fmap.mapcontext.layers.vectorial.OverlapsGeometryEvaluator;
import org.gvsig.fmap.mapcontext.layers.vectorial.TouchesGeometryEvaluator;
import org.gvsig.fmap.mapcontext.layers.vectorial.WithinGeometryEvaluator;
import org.gvsig.tools.evaluator.Evaluator;

public class SpatialEvaluatorsFactory {
    private static final SpatialEvaluatorsFactory factory = new SpatialEvaluatorsFactory();

    public static SpatialEvaluatorsFactory getInstance() {
        return factory;
    }

    private SpatialEvaluatorsFactory() {
    }

    private Evaluator intersects(Geometry geometry, IProjection projection, FeatureType featureType, String geomName, GeometryExpressionBuilder builder) {
        return new IntersectsGeometryEvaluator(geometry, projection, featureType, geomName, builder);
    }

    private Evaluator intersects(Envelope envelope, IProjection projection, FeatureType featureType, String geomName, GeometryExpressionBuilder builder) {
        return new IntersectsEnvelopeEvaluator(envelope, projection, featureType, geomName, builder);
    }

    public Evaluator intersects(Geometry geometry, IProjection projection, FeatureStore store) {
        try {
            FeatureType featureType = store.getDefaultFeatureType();
            String geomName = featureType.getDefaultGeometryAttributeName();
            GeometryExpressionBuilder builder = GeometryExpressionUtils.createExpressionBuilder();
            return this.intersects(geometry, projection, featureType, geomName, builder);
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't create intersects evaluator.", ex);
        }
    }

    public Evaluator intersects(Geometry geometry, IProjection projection, FeatureStore store, String geomfield) {
        try {
            FeatureType featureType = store.getDefaultFeatureType();
            GeometryExpressionBuilder builder = GeometryExpressionUtils.createExpressionBuilder();
            return this.intersects(geometry, projection, featureType, geomfield, builder);
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't create intersects evaluator.", ex);
        }
    }

    public Evaluator intersects(Envelope envelope, IProjection projection, FeatureStore store) {
        try {
            FeatureType featureType = store.getDefaultFeatureType();
            String geomName = featureType.getDefaultGeometryAttributeName();
            GeometryExpressionBuilder builder = GeometryExpressionUtils.createExpressionBuilder();
            return this.intersects(envelope, projection, featureType, geomName, builder);
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't create intersects evaluator.", ex);
        }
    }

    private Evaluator contains(Envelope envelope, IProjection projection, FeatureType featureType, String geomName, GeometryExpressionBuilder builder) {
        return new ContainsEnvelopeEvaluator(envelope, projection, featureType, geomName, builder);
    }

    private Evaluator contains(Geometry geometry, IProjection projection, FeatureType featureType, String geomName, GeometryExpressionBuilder builder) {
        return new ContainsGeometryEvaluator(geometry, projection, featureType, geomName, builder);
    }

    public Evaluator contains(Geometry geometry, IProjection projection, FeatureStore store) {
        try {
            FeatureType featureType = store.getDefaultFeatureType();
            String geomName = featureType.getDefaultGeometryAttributeName();
            GeometryExpressionBuilder builder = GeometryExpressionUtils.createExpressionBuilder();
            return this.contains(geometry, projection, featureType, geomName, builder);
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't create contains evaluator.", ex);
        }
    }

    public Evaluator contains(Envelope envelope, IProjection projection, FeatureStore store) {
        try {
            FeatureType featureType = store.getDefaultFeatureType();
            String geomName = featureType.getDefaultGeometryAttributeName();
            GeometryExpressionBuilder builder = GeometryExpressionUtils.createExpressionBuilder();
            return this.contains(envelope, projection, featureType, geomName, builder);
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't create contains evaluator.", ex);
        }
    }

    private Evaluator not_contains(Geometry geometry, IProjection projection, FeatureType featureType, String geomName, GeometryExpressionBuilder builder) {
        return new OutGeometryEvaluator(geometry, projection, featureType, geomName, builder);
    }

    public Evaluator not_contains(Geometry geometry, IProjection projection, FeatureStore store) {
        try {
            FeatureType featureType = store.getDefaultFeatureType();
            String geomName = featureType.getDefaultGeometryAttributeName();
            GeometryExpressionBuilder builder = GeometryExpressionUtils.createExpressionBuilder();
            return this.not_contains(geometry, projection, featureType, geomName, builder);
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't create not_contains evaluator.", ex);
        }
    }

    public Evaluator crosses(Geometry geometry, IProjection projection, FeatureType featureType, String geomName, GeometryExpressionBuilder builder) {
        return new CrossesGeometryEvaluator(geometry, projection, featureType, geomName, builder);
    }

    private Evaluator crosses(Envelope envelope, IProjection projection, FeatureType featureType, String geomName, GeometryExpressionBuilder builder) {
        return new CrossEnvelopeEvaluator(envelope, projection, featureType, geomName, builder);
    }

    public Evaluator crosses(Geometry geometry, IProjection projection, FeatureStore store) {
        try {
            FeatureType featureType = store.getDefaultFeatureType();
            String geomName = featureType.getDefaultGeometryAttributeName();
            GeometryExpressionBuilder builder = GeometryExpressionUtils.createExpressionBuilder();
            return this.crosses(geometry, projection, featureType, geomName, builder);
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't create crosses evaluator.", ex);
        }
    }

    public Evaluator crosses(Envelope envelope, IProjection projection, FeatureStore store) {
        try {
            FeatureType featureType = store.getDefaultFeatureType();
            String geomName = featureType.getDefaultGeometryAttributeName();
            GeometryExpressionBuilder builder = GeometryExpressionUtils.createExpressionBuilder();
            return this.crosses(envelope, projection, featureType, geomName, builder);
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't create crosses evaluator.", ex);
        }
    }

    private Evaluator disjoint(Geometry geometry, IProjection projection, FeatureType featureType, String geomName, GeometryExpressionBuilder builder) {
        return new DisjointGeometryEvaluator(geometry, projection, featureType, geomName, builder);
    }

    public Evaluator disjoint(Geometry geometry, IProjection projection, FeatureStore store) {
        try {
            FeatureType featureType = store.getDefaultFeatureType();
            String geomName = featureType.getDefaultGeometryAttributeName();
            GeometryExpressionBuilder builder = GeometryExpressionUtils.createExpressionBuilder();
            return this.disjoint(geometry, projection, featureType, geomName, builder);
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't create disjoint evaluator.", ex);
        }
    }

    private Evaluator overlaps(Geometry geometry, IProjection projection, FeatureType featureType, String geomName, GeometryExpressionBuilder builder) {
        return new OverlapsGeometryEvaluator(geometry, projection, featureType, geomName, builder);
    }

    public Evaluator overlaps(Geometry geometry, IProjection projection, FeatureStore store) {
        try {
            FeatureType featureType = store.getDefaultFeatureType();
            String geomName = featureType.getDefaultGeometryAttributeName();
            GeometryExpressionBuilder builder = GeometryExpressionUtils.createExpressionBuilder();
            return this.overlaps(geometry, projection, featureType, geomName, builder);
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't create overlaps evaluator.", ex);
        }
    }

    private Evaluator touches(Geometry geometry, IProjection projection, FeatureType featureType, String geomName, GeometryExpressionBuilder builder) {
        return new TouchesGeometryEvaluator(geometry, projection, featureType, geomName, builder);
    }

    public Evaluator touches(Geometry geometry, IProjection projection, FeatureStore store) {
        try {
            FeatureType featureType = store.getDefaultFeatureType();
            String geomName = featureType.getDefaultGeometryAttributeName();
            GeometryExpressionBuilder builder = GeometryExpressionUtils.createExpressionBuilder();
            return this.touches(geometry, projection, featureType, geomName, builder);
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't create touches evaluator.", ex);
        }
    }

    private Evaluator within(Geometry geometry, IProjection projection, FeatureType featureType, String geomName, GeometryExpressionBuilder builder) {
        return new WithinGeometryEvaluator(geometry, projection, featureType, geomName, builder);
    }

    public Evaluator within(Geometry geometry, IProjection projection, FeatureStore store) {
        try {
            FeatureType featureType = store.getDefaultFeatureType();
            String geomName = featureType.getDefaultGeometryAttributeName();
            GeometryExpressionBuilder builder = GeometryExpressionUtils.createExpressionBuilder();
            return this.within(geometry, projection, featureType, geomName, builder);
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't create within evaluator.", ex);
        }
    }

    private Evaluator equals(Geometry geometry, IProjection projection, FeatureType featureType, String geomName, GeometryExpressionBuilder builder) {
        return new EqualsGeometryEvaluator(geometry, projection, featureType, geomName, builder);
    }

    public Evaluator equals(Geometry geometry, IProjection projection, FeatureStore store) {
        try {
            FeatureType featureType = store.getDefaultFeatureType();
            String geomName = featureType.getDefaultGeometryAttributeName();
            GeometryExpressionBuilder builder = GeometryExpressionUtils.createExpressionBuilder();
            return this.equals(geometry, projection, featureType, geomName, builder);
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't create equals evaluator.", ex);
        }
    }
}

