/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.tools.persistence;

import java.awt.Font;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.AbstractSinglePersistenceFactory;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;

public class FontPersistenceFactory
extends AbstractSinglePersistenceFactory {
    static final String FIELD_NAME = "name";
    static final String FIELD_STYLE = "style";
    static final String FIELD_SIZE = "size";
    private static final String DYNCLASS_NAME = "AwtFont";
    private static final String DYNCLASS_DESCRIPTION = "Awt Font";

    public FontPersistenceFactory() {
        super(Font.class, DYNCLASS_NAME, DYNCLASS_DESCRIPTION, null, null);
        DynStruct definition = this.getDefinition();
        definition.addDynFieldString(FIELD_NAME).setMandatory(true);
        definition.addDynFieldInt(FIELD_STYLE).setMandatory(true);
        definition.addDynFieldInt(FIELD_SIZE).setMandatory(true);
    }

    public Object createFromState(PersistentState state) throws PersistenceException {
        String name = state.getString(FIELD_NAME);
        int style = state.getInt(FIELD_STYLE);
        int size = state.getInt(FIELD_SIZE);
        return new Font(name, style, size);
    }

    public void saveToState(PersistentState state, Object obj) throws PersistenceException {
        Font font = (Font)obj;
        state.set(FIELD_NAME, font.getName());
        state.set(FIELD_STYLE, font.getStyle());
        state.set(FIELD_SIZE, font.getSize());
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
            persistenceManager.registerFactory((PersistenceFactory)new FontPersistenceFactory());
            return Boolean.TRUE;
        }
    }
}

