/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl;

import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolPreferences;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.CartographicSupportToolkit;

public abstract class AbstractCartographicSupport
implements CartographicSupport {
    private int unit;
    private int referenceSystem;
    private CartographicSupport.CartographicContext cartographicContext;

    public AbstractCartographicSupport() {
        SymbolPreferences preferences = MapContextLocator.getSymbolManager().getSymbolPreferences();
        this.unit = preferences.getDefaultCartographicSupportMeasureUnit();
        this.referenceSystem = preferences.getDefaultCartographicSupportReferenceSystem();
    }

    @Override
    public void setCartographicContext(ViewPort viewPort, double dpi, Geometry geom) {
        if (viewPort == null) {
            this.setCartographicContext((CartographicSupport.CartographicContext)null);
        } else {
            this.setCartographicContext(CartographicSupportToolkit.createCartographicContext(viewPort, dpi, geom));
        }
    }

    @Override
    public void setCartographicContext(ViewPort viewPort, PrintAttributes properties, Geometry geometry) {
        int dpi = (int)CartographicSupportToolkit.getScreenDpi();
        if (viewPort != null) {
            dpi = (int)viewPort.getDPI();
        }
        if (properties != null) {
            int pq = properties.getPrintQuality();
            switch (pq) {
                case 1: {
                    dpi = 300;
                    break;
                }
                case 2: {
                    dpi = 600;
                    break;
                }
                case 0: {
                    dpi = 72;
                    break;
                }
            }
        }
        this.setCartographicContext(CartographicSupportToolkit.createCartographicContext(viewPort, dpi, geometry));
    }

    @Override
    public void setCartographicContext(double dpi) {
        this.setCartographicContext(CartographicSupportToolkit.createCartographicContext(null, dpi, null));
    }

    @Override
    public void setCartographicContext(PrintAttributes properties) {
        int dpi = (int)CartographicSupportToolkit.getScreenDpi();
        if (properties != null) {
            int pq = properties.getPrintQuality();
            switch (pq) {
                case 1: {
                    dpi = 300;
                    break;
                }
                case 2: {
                    dpi = 600;
                    break;
                }
                case 0: {
                    dpi = 72;
                    break;
                }
            }
        }
        this.setCartographicContext(CartographicSupportToolkit.createCartographicContext(null, dpi, null));
    }

    @Override
    public CartographicSupport.CartographicContext getCartographicContext() {
        return this.cartographicContext;
    }

    @Override
    public double toCartographicUnits(double value) {
        if (this.isInPixels()) {
            return value;
        }
        return CartographicSupportToolkit.getCartographicLength(this, value, this.getCartographicContext());
    }

    @Override
    public void setCartographicContext(CartographicSupport.CartographicContext ctx) {
        this.cartographicContext = ctx;
    }

    @Override
    public void copyCartographicContext(CartographicSupport element) {
        this.cartographicContext = element.getCartographicContext();
    }

    @Override
    public void setUnit(int unitIndex) {
        this.unit = unitIndex;
    }

    @Override
    public int getUnit() {
        return this.unit;
    }

    @Override
    public int getReferenceSystem() {
        return this.referenceSystem;
    }

    @Override
    public void setReferenceSystem(int system) {
        this.referenceSystem = system;
    }

    public boolean isInPixels() {
        return this.getCartographicContext() == null || this.getUnit() == -1;
    }
}

