/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;

public class CartographicSupportToolkit {
    private static double screenDpi = 97.0;
    public static int DefaultMeasureUnit = -1;
    public static int DefaultReferenceSystem = 0;

    public static CartographicSupport.CartographicContext createCartographicContext(ViewPort viewPort, double dpi, Geometry geom) {
        return new CartographicContextImpl(viewPort, dpi, geom);
    }

    public static double getCartographicLength(CartographicSupport cartographicElement, double length, double dist1Pixel, int mapUnits, double dpi) {
        int unit = cartographicElement.getUnit();
        double lengthInPixel = length;
        if (unit != -1) {
            double[] trans2Meter = MapContext.getDistanceTrans2Meter();
            if (cartographicElement.getReferenceSystem() == 0) {
                double dist1PixelInMeters = dist1Pixel * trans2Meter[mapUnits];
                double realWidthMeter = length * trans2Meter[unit];
                lengthInPixel = realWidthMeter / dist1PixelInMeters;
            } else if (cartographicElement.getReferenceSystem() == 1) {
                double lengthInInches = 1.0 / trans2Meter[7] * trans2Meter[unit] * length;
                lengthInPixel = lengthInInches * dpi;
            }
        } else {
            double scale = dpi / screenDpi;
            lengthInPixel *= scale;
        }
        return lengthInPixel;
    }

    public static double getCartographicLength(CartographicSupport cartographicElement, double length, ViewPort viewPort, double dpi) {
        return CartographicSupportToolkit.getCartographicLength(cartographicElement, length, viewPort.getDist1pixel(), viewPort.getMapUnits(), dpi);
    }

    public static double getCartographicLength(CartographicSupport cartographicElement, double length, CartographicSupport.CartographicContext ctx) {
        return CartographicSupportToolkit.getCartographicLength(cartographicElement, length, ctx.getDist1pixel(), ctx.getMapUnits(), ctx.getDpi());
    }

    public static void setScreenDpi(double dpi) {
        screenDpi = dpi;
    }

    public static double getScreenDpi() {
        return screenDpi;
    }

    private static class CartographicContextImpl
    implements CartographicSupport.CartographicContext {
        private final ViewPort viewPort;
        private final double dpi;
        private final Geometry geom;

        public CartographicContextImpl(ViewPort viewPort, double dpi, Geometry geom) {
            this.viewPort = viewPort;
            this.dpi = dpi;
            this.geom = geom;
        }

        @Override
        public double getDist1pixel() {
            if (this.viewPort == null) {
                return 1.0;
            }
            return this.viewPort.getDist1pixel();
        }

        @Override
        public int getMapUnits() {
            if (this.viewPort == null) {
                return -1;
            }
            return this.viewPort.getMapUnits();
        }

        @Override
        public GeometryType getGeometryType() {
            return this.geom.getGeometryType();
        }

        @Override
        public double getDpi() {
            return this.dpi;
        }
    }
}

