/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gdal.app.mainplugin.common;

import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.gdal.gdal.ProgressCallback;
import org.gdal.gdal.TermProgressCallback;
import org.gdal.gdal.gdal;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Driver;
import org.gdal.ogr.Feature;
import org.gdal.ogr.FeatureDefn;
import org.gdal.ogr.FieldDefn;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.Layer;
import org.gdal.ogr.ogr;
import org.gdal.osr.CoordinateTransformation;
import org.gdal.osr.SpatialReference;
import org.gvsig.gdal.app.mainplugin.common.GDALScaledProgress;

public class ogr2ogr {
    static boolean bSkipFailures = false;
    static int nGroupTransactions = 200;
    static boolean bPreserveFID = false;
    static final int OGRNullFID = -1;
    static int nFIDToFetch = -1;

    public static void System_exit(int status) {
        throw new ExitException(status);
    }

    public static void main(String[] args) {
        DataSource poDS;
        DataSource poODS;
        block140: {
            String pszFormat = "ESRI Shapefile";
            String pszDataSource = null;
            String pszDestDataSource = null;
            Vector<String> papszLayers = new Vector<String>();
            Vector<String> papszDSCO = new Vector<String>();
            Vector<String> papszLCO = new Vector<String>();
            boolean bTransform = false;
            boolean bAppend = false;
            boolean bUpdate = false;
            boolean bOverwrite = false;
            String pszOutputSRSDef = null;
            String pszSourceSRSDef = null;
            SpatialReference poOutputSRS = null;
            SpatialReference poSourceSRS = null;
            String pszNewLayerName = null;
            String pszWHERE = null;
            Geometry poSpatialFilter = null;
            Vector<String> papszSelFields = null;
            String pszSQLStatement = null;
            int eGType = -2;
            GeomOperation eGeomOp = GeomOperation.NONE;
            double dfGeomOpParam = 0.0;
            Vector<String> papszFieldTypesToString = new Vector<String>();
            boolean bDisplayProgress = false;
            Object pfnProgress = null;
            boolean bClipSrc = false;
            Geometry poClipSrc = null;
            String pszClipSrcDS = null;
            String pszClipSrcSQL = null;
            String pszClipSrcLayer = null;
            String pszClipSrcWhere = null;
            Geometry poClipDst = null;
            String pszClipDstDS = null;
            String pszClipDstSQL = null;
            String pszClipDstLayer = null;
            String pszClipDstWhere = null;
            Object pszSrcEncoding = null;
            Object pszDstEncoding = null;
            boolean bExplodeCollections = false;
            String pszZField = null;
            poODS = null;
            Driver poDriver = null;
            poDS = null;
            try {
                int iLayer;
                int posPoint;
                File f;
                Layer poLayer;
                int iLayer2;
                int iDriver;
                ogr.DontUseExceptions();
                if (ogr.GetDriverCount() == 0) {
                    ogr.RegisterAll();
                }
                if ((args = ogr.GeneralCmdLineProcessor((String[])args)).length < 2) {
                    ogr2ogr.Usage();
                    ogr2ogr.System_exit(-1);
                }
                block2: for (int iArg = 0; iArg < args.length; ++iArg) {
                    StringTokenizer tokenizer;
                    double ymax;
                    double xmax;
                    double ymin;
                    double xmin;
                    Geometry oRing;
                    if (args[iArg].equalsIgnoreCase("-f") && iArg < args.length - 1) {
                        pszFormat = args[++iArg];
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-dsco") && iArg < args.length - 1) {
                        papszDSCO.addElement(args[++iArg]);
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-lco") && iArg < args.length - 1) {
                        papszLCO.addElement(args[++iArg]);
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-preserve_fid")) {
                        bPreserveFID = true;
                        continue;
                    }
                    if (args[iArg].length() >= 5 && args[iArg].substring(0, 5).equalsIgnoreCase("-skip")) {
                        bSkipFailures = true;
                        nGroupTransactions = 1;
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-append")) {
                        bAppend = true;
                        bUpdate = true;
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-overwrite")) {
                        bOverwrite = true;
                        bUpdate = true;
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-update")) {
                        bUpdate = true;
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-fid") && args[iArg + 1] != null) {
                        nFIDToFetch = Integer.parseInt(args[++iArg]);
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-sql") && args[iArg + 1] != null) {
                        pszSQLStatement = args[++iArg];
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-nln") && iArg < args.length - 1) {
                        pszNewLayerName = args[++iArg];
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-nlt") && iArg < args.length - 1) {
                        if (args[iArg + 1].equalsIgnoreCase("NONE")) {
                            eGType = 100;
                        } else if (args[iArg + 1].equalsIgnoreCase("GEOMETRY")) {
                            eGType = 0;
                        } else if (args[iArg + 1].equalsIgnoreCase("POINT")) {
                            eGType = 1;
                        } else if (args[iArg + 1].equalsIgnoreCase("LINESTRING")) {
                            eGType = 2;
                        } else if (args[iArg + 1].equalsIgnoreCase("POLYGON")) {
                            eGType = 3;
                        } else if (args[iArg + 1].equalsIgnoreCase("GEOMETRYCOLLECTION")) {
                            eGType = 7;
                        } else if (args[iArg + 1].equalsIgnoreCase("MULTIPOINT")) {
                            eGType = 4;
                        } else if (args[iArg + 1].equalsIgnoreCase("MULTILINESTRING")) {
                            eGType = 5;
                        } else if (args[iArg + 1].equalsIgnoreCase("MULTIPOLYGON")) {
                            eGType = 6;
                        } else if (args[iArg + 1].equalsIgnoreCase("GEOMETRY25D")) {
                            eGType = Integer.MIN_VALUE;
                        } else if (args[iArg + 1].equalsIgnoreCase("POINT25D")) {
                            eGType = -2147483647;
                        } else if (args[iArg + 1].equalsIgnoreCase("LINESTRING25D")) {
                            eGType = -2147483646;
                        } else if (args[iArg + 1].equalsIgnoreCase("POLYGON25D")) {
                            eGType = -2147483645;
                        } else if (args[iArg + 1].equalsIgnoreCase("GEOMETRYCOLLECTION25D")) {
                            eGType = -2147483641;
                        } else if (args[iArg + 1].equalsIgnoreCase("MULTIPOINT25D")) {
                            eGType = -2147483644;
                        } else if (args[iArg + 1].equalsIgnoreCase("MULTILINESTRING25D")) {
                            eGType = -2147483643;
                        } else if (args[iArg + 1].equalsIgnoreCase("MULTIPOLYGON25D")) {
                            eGType = -2147483642;
                        } else {
                            System.err.println("-nlt " + args[iArg + 1] + ": type not recognised.");
                            ogr2ogr.System_exit(1);
                        }
                        ++iArg;
                        continue;
                    }
                    if ((args[iArg].equalsIgnoreCase("-tg") || args[iArg].equalsIgnoreCase("-gt")) && iArg < args.length - 1) {
                        nGroupTransactions = Integer.parseInt(args[++iArg]);
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-s_srs") && iArg < args.length - 1) {
                        pszSourceSRSDef = args[++iArg];
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-a_srs") && iArg < args.length - 1) {
                        pszOutputSRSDef = args[++iArg];
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-t_srs") && iArg < args.length - 1) {
                        pszOutputSRSDef = args[++iArg];
                        bTransform = true;
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-spat") && iArg + 4 < args.length) {
                        oRing = new Geometry(101);
                        xmin = new Double(args[++iArg]);
                        ymin = new Double(args[++iArg]);
                        xmax = new Double(args[++iArg]);
                        ymax = new Double(args[++iArg]);
                        oRing.AddPoint(xmin, ymin);
                        oRing.AddPoint(xmin, ymax);
                        oRing.AddPoint(xmax, ymax);
                        oRing.AddPoint(xmax, ymin);
                        oRing.AddPoint(xmin, ymin);
                        poSpatialFilter = new Geometry(3);
                        poSpatialFilter.AddGeometry(oRing);
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-where") && args[iArg + 1] != null) {
                        pszWHERE = args[++iArg];
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-select") && args[iArg + 1] != null) {
                        String pszSelect = args[++iArg];
                        tokenizer = new StringTokenizer(pszSelect, " ,");
                        papszSelFields = new Vector<String>();
                        while (tokenizer.hasMoreElements()) {
                            papszSelFields.addElement(tokenizer.nextToken());
                        }
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-simplify") && iArg < args.length - 1) {
                        eGeomOp = GeomOperation.SIMPLIFY_PRESERVE_TOPOLOGY;
                        dfGeomOpParam = new Double(args[++iArg]);
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-segmentize") && iArg < args.length - 1) {
                        eGeomOp = GeomOperation.SEGMENTIZE;
                        dfGeomOpParam = new Double(args[++iArg]);
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-fieldTypeToString") && iArg < args.length - 1) {
                        tokenizer = new StringTokenizer(args[++iArg], " ,");
                        while (tokenizer.hasMoreElements()) {
                            String token = tokenizer.nextToken();
                            if (token.equalsIgnoreCase("Integer") || token.equalsIgnoreCase("Real") || token.equalsIgnoreCase("String") || token.equalsIgnoreCase("Date") || token.equalsIgnoreCase("Time") || token.equalsIgnoreCase("DateTime") || token.equalsIgnoreCase("Binary") || token.equalsIgnoreCase("IntegerList") || token.equalsIgnoreCase("RealList") || token.equalsIgnoreCase("StringList")) {
                                papszFieldTypesToString.addElement(token);
                                continue;
                            }
                            if (token.equalsIgnoreCase("All")) {
                                papszFieldTypesToString = null;
                                papszFieldTypesToString.addElement("All");
                                continue block2;
                            }
                            System.err.println("Unhandled type for fieldtypeasstring option : " + token);
                            ogr2ogr.Usage();
                        }
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-progress")) {
                        bDisplayProgress = true;
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-clipsrc") && iArg < args.length - 1) {
                        bClipSrc = true;
                        if (ogr2ogr.IsNumber(args[iArg + 1]) && iArg < args.length - 4) {
                            oRing = new Geometry(101);
                            xmin = new Double(args[++iArg]);
                            ymin = new Double(args[++iArg]);
                            xmax = new Double(args[++iArg]);
                            ymax = new Double(args[++iArg]);
                            oRing.AddPoint(xmin, ymin);
                            oRing.AddPoint(xmin, ymax);
                            oRing.AddPoint(xmax, ymax);
                            oRing.AddPoint(xmax, ymin);
                            oRing.AddPoint(xmin, ymin);
                            poClipSrc = new Geometry(3);
                            poClipSrc.AddGeometry(oRing);
                            continue;
                        }
                        if (args[iArg + 1].length() >= 7 && args[iArg + 1].substring(0, 7).equalsIgnoreCase("POLYGON") || args[iArg + 1].length() >= 12 && args[iArg + 1].substring(0, 12).equalsIgnoreCase("MULTIPOLYGON")) {
                            poClipSrc = Geometry.CreateFromWkt((String)args[iArg + 1]);
                            if (poClipSrc == null) {
                                System.err.print("FAILURE: Invalid geometry. Must be a valid POLYGON or MULTIPOLYGON WKT\n\n");
                                ogr2ogr.Usage();
                            }
                            ++iArg;
                            continue;
                        }
                        if (args[iArg + 1].equalsIgnoreCase("spat_extent")) {
                            ++iArg;
                            continue;
                        }
                        pszClipSrcDS = args[iArg + 1];
                        ++iArg;
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-clipsrcsql") && iArg < args.length - 1) {
                        pszClipSrcSQL = args[iArg + 1];
                        ++iArg;
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-clipsrclayer") && iArg < args.length - 1) {
                        pszClipSrcLayer = args[iArg + 1];
                        ++iArg;
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-clipsrcwhere") && iArg < args.length - 1) {
                        pszClipSrcWhere = args[iArg + 1];
                        ++iArg;
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-clipdst") && iArg < args.length - 1) {
                        if (ogr2ogr.IsNumber(args[iArg + 1]) && iArg < args.length - 4) {
                            oRing = new Geometry(101);
                            xmin = new Double(args[++iArg]);
                            ymin = new Double(args[++iArg]);
                            xmax = new Double(args[++iArg]);
                            ymax = new Double(args[++iArg]);
                            oRing.AddPoint(xmin, ymin);
                            oRing.AddPoint(xmin, ymax);
                            oRing.AddPoint(xmax, ymax);
                            oRing.AddPoint(xmax, ymin);
                            oRing.AddPoint(xmin, ymin);
                            poClipDst = new Geometry(3);
                            poClipDst.AddGeometry(oRing);
                            continue;
                        }
                        if (args[iArg + 1].length() >= 7 && args[iArg + 1].substring(0, 7).equalsIgnoreCase("POLYGON") || args[iArg + 1].length() >= 12 && args[iArg + 1].substring(0, 12).equalsIgnoreCase("MULTIPOLYGON")) {
                            poClipDst = Geometry.CreateFromWkt((String)args[iArg + 1]);
                            if (poClipDst == null) {
                                System.err.print("FAILURE: Invalid geometry. Must be a valid POLYGON or MULTIPOLYGON WKT\n\n");
                                ogr2ogr.Usage();
                            }
                            ++iArg;
                            continue;
                        }
                        if (args[iArg + 1].equalsIgnoreCase("spat_extent")) {
                            ++iArg;
                            continue;
                        }
                        pszClipDstDS = args[iArg + 1];
                        ++iArg;
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-clipdstsql") && iArg < args.length - 1) {
                        pszClipDstSQL = args[iArg + 1];
                        ++iArg;
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-clipdstlayer") && iArg < args.length - 1) {
                        pszClipDstLayer = args[iArg + 1];
                        ++iArg;
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-clipdstwhere") && iArg < args.length - 1) {
                        pszClipDstWhere = args[iArg + 1];
                        ++iArg;
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-explodecollections")) {
                        bExplodeCollections = true;
                        continue;
                    }
                    if (args[iArg].equalsIgnoreCase("-zfield") && iArg < args.length - 1) {
                        pszZField = args[iArg + 1];
                        ++iArg;
                        continue;
                    }
                    if (args[iArg].charAt(0) == '-') {
                        ogr2ogr.Usage();
                        continue;
                    }
                    if (pszDestDataSource == null) {
                        pszDestDataSource = args[iArg];
                        continue;
                    }
                    if (pszDataSource == null) {
                        pszDataSource = args[iArg];
                        continue;
                    }
                    papszLayers.addElement(args[iArg]);
                }
                if (pszDataSource == null) {
                    ogr2ogr.Usage();
                }
                if (bPreserveFID && bExplodeCollections) {
                    System.err.print("FAILURE: cannot use -preserve_fid and -explodecollections at the same time\n\n");
                    ogr2ogr.Usage();
                }
                if (bClipSrc && pszClipSrcDS != null) {
                    poClipSrc = ogr2ogr.LoadGeometry(pszClipSrcDS, pszClipSrcSQL, pszClipSrcLayer, pszClipSrcWhere);
                    if (poClipSrc == null) {
                        System.err.print("FAILURE: cannot load source clip geometry\n\n");
                        ogr2ogr.Usage();
                    }
                } else if (bClipSrc && poClipSrc == null) {
                    if (poSpatialFilter != null) {
                        poClipSrc = poSpatialFilter.Clone();
                    }
                    if (poClipSrc == null) {
                        System.err.print("FAILURE: -clipsrc must be used with -spat option or a\nbounding box, WKT string or datasource must be specified\n\n");
                        ogr2ogr.Usage();
                    }
                }
                if (pszClipDstDS != null && (poClipDst = ogr2ogr.LoadGeometry(pszClipDstDS, pszClipDstSQL, pszClipDstLayer, pszClipDstWhere)) == null) {
                    System.err.print("FAILURE: cannot load dest clip geometry\n\n");
                    ogr2ogr.Usage();
                }
                if ((poDS = ogr.Open(pszDataSource, (boolean)false)) == null) {
                    System.err.println("FAILURE:\nUnable to open datasource ` " + pszDataSource + "' with the following drivers.");
                    for (iDriver = 0; iDriver < ogr.GetDriverCount(); ++iDriver) {
                        System.err.println("  . " + ogr.GetDriver((int)iDriver).GetName());
                    }
                    ogr2ogr.System_exit(1);
                }
                if (bUpdate) {
                    poODS = ogr.Open(pszDestDataSource, (boolean)true);
                    if (poODS == null) {
                        if (bOverwrite || bAppend) {
                            poODS = ogr.Open(pszDestDataSource, (boolean)false);
                            if (poODS == null) {
                                bUpdate = false;
                            } else {
                                poODS.delete();
                                poODS = null;
                            }
                        }
                        if (bUpdate) {
                            System.err.println("FAILURE:\nUnable to open existing output datasource `" + pszDestDataSource + "'.");
                            ogr2ogr.System_exit(1);
                        }
                    } else if (papszDSCO.size() > 0) {
                        System.err.println("WARNING: Datasource creation options ignored since an existing datasource\n         being updated.");
                    }
                    if (poODS != null) {
                        poDriver = poODS.GetDriver();
                    }
                }
                if (!bUpdate) {
                    File f2;
                    poDriver = ogr.GetDriverByName((String)pszFormat);
                    if (poDriver == null) {
                        System.err.println("Unable to find driver `" + pszFormat + "'.");
                        System.err.println("The following drivers are available:");
                        for (iDriver = 0; iDriver < ogr.GetDriverCount(); ++iDriver) {
                            System.err.println("  . " + ogr.GetDriver((int)iDriver).GetName());
                        }
                        ogr2ogr.System_exit(1);
                    }
                    if (!poDriver.TestCapability("CreateDataSource")) {
                        System.err.println(pszFormat + " driver does not support data source creation.");
                        ogr2ogr.System_exit(1);
                    }
                    if (poDriver.GetName().equalsIgnoreCase("ESRI Shapefile") && pszSQLStatement == null && (papszLayers.size() > 1 || papszLayers.size() == 0 && poDS.GetLayerCount() > 1) && pszNewLayerName == null && (pszDestDataSource.endsWith(".shp") || pszDestDataSource.endsWith(".SHP")) && !(f2 = new File(pszDestDataSource)).exists() && !f2.mkdir()) {
                        System.err.println("Failed to create directory " + pszDestDataSource + "\n" + "for shapefile datastore.");
                        ogr2ogr.System_exit(1);
                    }
                    if ((poODS = poDriver.CreateDataSource(pszDestDataSource, papszDSCO)) == null) {
                        System.err.println(pszFormat + " driver failed to create " + pszDestDataSource);
                        ogr2ogr.System_exit(1);
                    }
                }
                if (pszOutputSRSDef != null && (poOutputSRS = new SpatialReference()).SetFromUserInput(pszOutputSRSDef) != 0) {
                    System.err.println("Failed to process SRS definition: " + pszOutputSRSDef);
                    ogr2ogr.System_exit(1);
                }
                if (pszSourceSRSDef != null && (poSourceSRS = new SpatialReference()).SetFromUserInput(pszSourceSRSDef) != 0) {
                    System.err.println("Failed to process SRS definition: " + pszSourceSRSDef);
                    ogr2ogr.System_exit(1);
                }
                if (pszSQLStatement != null) {
                    Layer poResultSet;
                    if (pszWHERE != null) {
                        System.err.println("-where clause ignored in combination with -sql.");
                    }
                    if (papszLayers.size() > 0) {
                        System.err.println("layer names ignored in combination with -sql.");
                    }
                    if ((poResultSet = poDS.ExecuteSQL(pszSQLStatement, poSpatialFilter, null)) != null) {
                        int posPoint2;
                        File f3;
                        long nCountLayerFeatures = 0L;
                        if (bDisplayProgress) {
                            if (!poResultSet.TestCapability("FastFeatureCount")) {
                                System.err.println("Progress turned off as fast feature count is not available.");
                                bDisplayProgress = false;
                            } else {
                                nCountLayerFeatures = poResultSet.GetFeatureCount();
                                pfnProgress = new TermProgressCallback();
                            }
                        }
                        if (poDriver.GetName().equalsIgnoreCase("ESRI Shapefile") && pszNewLayerName == null && (f3 = new File(pszDestDataSource)).exists() && f3.listFiles() == null && (posPoint2 = (pszNewLayerName = f3.getName()).lastIndexOf(46)) != -1) {
                            pszNewLayerName = pszNewLayerName.substring(0, posPoint2);
                        }
                        if (!ogr2ogr.TranslateLayer(poDS, poResultSet, poODS, papszLCO, pszNewLayerName, bTransform, poOutputSRS, poSourceSRS, papszSelFields, bAppend, eGType, bOverwrite, eGeomOp, dfGeomOpParam, papszFieldTypesToString, nCountLayerFeatures, poClipSrc, poClipDst, bExplodeCollections, pszZField, pszWHERE, (ProgressCallback)pfnProgress)) {
                            System.err.println("Terminating translation prematurely after failed\ntranslation from sql statement.");
                            ogr2ogr.System_exit(1);
                        }
                        poDS.ReleaseResultSet(poResultSet);
                    }
                    break block140;
                }
                int nLayerCount = 0;
                Layer[] papoLayers = null;
                if (papszLayers.size() == 0) {
                    nLayerCount = poDS.GetLayerCount();
                    papoLayers = new Layer[nLayerCount];
                    for (iLayer2 = 0; iLayer2 < nLayerCount; ++iLayer2) {
                        poLayer = poDS.GetLayer(iLayer2);
                        if (poLayer == null) {
                            System.err.println("FAILURE: Couldn't fetch advertised layer " + iLayer2 + "!");
                            ogr2ogr.System_exit(1);
                        }
                        papoLayers[iLayer2] = poLayer;
                    }
                } else {
                    nLayerCount = papszLayers.size();
                    papoLayers = new Layer[nLayerCount];
                    for (iLayer2 = 0; iLayer2 < papszLayers.size(); ++iLayer2) {
                        poLayer = poDS.GetLayerByName((String)papszLayers.get(iLayer2));
                        if (poLayer == null) {
                            System.err.println("FAILURE: Couldn't fetch advertised layer " + (String)papszLayers.get(iLayer2) + "!");
                            ogr2ogr.System_exit(1);
                        }
                        papoLayers[iLayer2] = poLayer;
                    }
                }
                if (poDriver.GetName().equalsIgnoreCase("ESRI Shapefile") && nLayerCount == 1 && pszNewLayerName == null && (f = new File(pszDestDataSource)).exists() && f.listFiles() == null && (posPoint = (pszNewLayerName = f.getName()).lastIndexOf(46)) != -1) {
                    pszNewLayerName = pszNewLayerName.substring(0, posPoint);
                }
                long[] panLayerCountFeatures = new long[nLayerCount];
                long nCountLayersFeatures = 0L;
                long nAccCountFeatures = 0L;
                for (iLayer = 0; iLayer < nLayerCount; ++iLayer) {
                    Layer poLayer2 = papoLayers[iLayer];
                    if (pszWHERE != null && poLayer2.SetAttributeFilter(pszWHERE) != 0) {
                        System.err.println("FAILURE: SetAttributeFilter(" + pszWHERE + ") failed.");
                        if (!bSkipFailures) {
                            ogr2ogr.System_exit(1);
                        }
                    }
                    if (poSpatialFilter != null) {
                        poLayer2.SetSpatialFilter(poSpatialFilter);
                    }
                    if (!bDisplayProgress) continue;
                    if (!poLayer2.TestCapability("FastFeatureCount")) {
                        System.err.println("Progress turned off as fast feature count is not available.");
                        bDisplayProgress = false;
                        continue;
                    }
                    panLayerCountFeatures[iLayer] = poLayer2.GetFeatureCount();
                    nCountLayersFeatures += panLayerCountFeatures[iLayer];
                }
                for (iLayer = 0; iLayer < nLayerCount; ++iLayer) {
                    Layer poLayer3 = papoLayers[iLayer];
                    if (bDisplayProgress) {
                        pfnProgress = new GDALScaledProgress((double)nAccCountFeatures * 1.0 / (double)nCountLayersFeatures, (double)(nAccCountFeatures + panLayerCountFeatures[iLayer]) * 1.0 / (double)nCountLayersFeatures, (ProgressCallback)new TermProgressCallback());
                    }
                    nAccCountFeatures += panLayerCountFeatures[iLayer];
                    if (ogr2ogr.TranslateLayer(poDS, poLayer3, poODS, papszLCO, pszNewLayerName, bTransform, poOutputSRS, poSourceSRS, papszSelFields, bAppend, eGType, bOverwrite, eGeomOp, dfGeomOpParam, papszFieldTypesToString, panLayerCountFeatures[iLayer], poClipSrc, poClipDst, bExplodeCollections, pszZField, pszWHERE, (ProgressCallback)pfnProgress) || bSkipFailures) continue;
                    System.err.println("Terminating translation prematurely after failed\ntranslation of layer " + poLayer3.GetLayerDefn().GetName() + " (use -skipfailures to skip errors)");
                    ogr2ogr.System_exit(1);
                }
            }
            catch (ExitException exitException) {
                // empty catch block
            }
        }
        if (poODS != null) {
            poODS.delete();
        }
        if (poDS != null) {
            poDS.delete();
        }
    }

    static void Usage() {
        System.out.print("Usage: ogr2ogr [--help-general] [-skipfailures] [-append] [-update] [-gt n]\n               [-select field_list] [-where restricted_where] \n               [-progress] [-sql <sql statement>] \n               [-spat xmin ymin xmax ymax] [-preserve_fid] [-fid FID]\n               [-a_srs srs_def] [-t_srs srs_def] [-s_srs srs_def]\n               [-f format_name] [-overwrite] [[-dsco NAME=VALUE] ...]\n               [-simplify tolerance]\n               [-fieldTypeToString All|(type1[,type2]*)] [-explodecollections]\n               dst_datasource_name src_datasource_name\n               [-lco NAME=VALUE] [-nln name] [-nlt type] [layer [layer ...]]\n\n -f format_name: output file format name, possible values are:\n");
        for (int iDriver = 0; iDriver < ogr.GetDriverCount(); ++iDriver) {
            Driver poDriver = ogr.GetDriver((int)iDriver);
            if (!poDriver.TestCapability("CreateDataSource")) continue;
            System.out.print("     -f \"" + poDriver.GetName() + "\"\n");
        }
        System.out.print(" -append: Append to existing layer instead of creating new if it exists\n -overwrite: delete the output layer and recreate it empty\n -update: Open existing output datasource in update mode\n -progress: Display progress on terminal. Only works if input layers have the \"fast feature count\" capability\n -select field_list: Comma-delimited list of fields from input layer to\n                     copy to the new layer (defaults to all)\n -where restricted_where: Attribute query (like SQL WHERE)\n -sql statement: Execute given SQL statement and save result.\n -skipfailures: skip features or layers that fail to convert\n -gt n: group n features per transaction (default 200)\n -spat xmin ymin xmax ymax: spatial query extents\n -simplify tolerance: distance tolerance for simplification.\n -dsco NAME=VALUE: Dataset creation option (format specific)\n -lco  NAME=VALUE: Layer creation option (format specific)\n -nln name: Assign an alternate name to the new layer\n -nlt type: Force a geometry type for new layer.  One of NONE, GEOMETRY,\n      POINT, LINESTRING, POLYGON, GEOMETRYCOLLECTION, MULTIPOINT,\n      MULTIPOLYGON, or MULTILINESTRING.  Add \"25D\" for 3D layers.\n      Default is type of source layer.\n -fieldTypeToString type1,...: Converts fields of specified types to\n      fields of type string in the new layer. Valid types are : \n      Integer, Real, String, Date, Time, DateTime, Binary, IntegerList, RealList,\n      StringList. Special value All can be used to convert all fields to strings.\n");
        System.out.print(" -a_srs srs_def: Assign an output SRS\n -t_srs srs_def: Reproject/transform to this SRS on output\n -s_srs srs_def: Override source SRS\n\n Srs_def can be a full WKT definition (hard to escape properly),\n or a well known definition (i.e. EPSG:4326) or a file with a WKT\n definition.\n");
        ogr2ogr.System_exit(1);
    }

    static int CSLFindString(Vector v, String str) {
        int i = 0;
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String strIter = (String)e.nextElement();
            if (strIter.equalsIgnoreCase(str)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static boolean IsNumber(String pszStr) {
        try {
            Double.parseDouble(pszStr);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    static Geometry LoadGeometry(String pszDS, String pszSQL, String pszLyr, String pszWhere) {
        Feature poFeat;
        Geometry poGeom = null;
        DataSource poDS = ogr.Open((String)pszDS, (boolean)false);
        if (poDS == null) {
            return null;
        }
        Layer poLyr = pszSQL != null ? poDS.ExecuteSQL(pszSQL, null, null) : (pszLyr != null ? poDS.GetLayerByName(pszLyr) : poDS.GetLayer(0));
        if (poLyr == null) {
            System.err.print("Failed to identify source layer from datasource.\n");
            poDS.delete();
            return null;
        }
        if (pszWhere != null) {
            poLyr.SetAttributeFilter(pszWhere);
        }
        while ((poFeat = poLyr.GetNextFeature()) != null) {
            Geometry poSrcGeom = poFeat.GetGeometryRef();
            if (poSrcGeom == null) continue;
            int eType = ogr2ogr.wkbFlatten(poSrcGeom.GetGeometryType());
            if (poGeom == null) {
                poGeom = new Geometry(6);
            }
            if (eType == 3) {
                poGeom.AddGeometry(poSrcGeom);
                continue;
            }
            if (eType == 6) {
                int nGeomCount = poSrcGeom.GetGeometryCount();
                for (int iGeom = 0; iGeom < nGeomCount; ++iGeom) {
                    poGeom.AddGeometry(poSrcGeom.GetGeometryRef(iGeom));
                }
                continue;
            }
            System.err.print("ERROR: Geometry not of polygon type.\n");
            if (pszSQL != null) {
                poDS.ReleaseResultSet(poLyr);
            }
            poDS.delete();
            return null;
        }
        if (pszSQL != null) {
            poDS.ReleaseResultSet(poLyr);
        }
        poDS.delete();
        return poGeom;
    }

    static int wkbFlatten(int eType) {
        return eType & Integer.MAX_VALUE;
    }

    static void SetZ(Geometry poGeom, double dfZ) {
        if (poGeom == null) {
            return;
        }
        switch (ogr2ogr.wkbFlatten(poGeom.GetGeometryType())) {
            case 1: {
                poGeom.SetPoint(0, poGeom.GetX(), poGeom.GetY(), dfZ);
                break;
            }
            case 2: 
            case 101: {
                for (int i = 0; i < poGeom.GetPointCount(); ++i) {
                    poGeom.SetPoint(i, poGeom.GetX(i), poGeom.GetY(i), dfZ);
                }
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                for (int i = 0; i < poGeom.GetGeometryCount(); ++i) {
                    ogr2ogr.SetZ(poGeom.GetGeometryRef(i), dfZ);
                }
                break;
            }
        }
    }

    static boolean TranslateLayer(DataSource poSrcDS, Layer poSrcLayer, DataSource poDstDS, Vector papszLCO, String pszNewLayerName, boolean bTransform, SpatialReference poOutputSRS, SpatialReference poSourceSRS, Vector papszSelFields, boolean bAppend, int eGType, boolean bOverwrite, GeomOperation eGeomOp, double dfGeomOpParam, Vector papszFieldTypesToString, long nCountLayerFeatures, Geometry poClipSrc, Geometry poClipDst, boolean bExplodeCollections, String pszZField, String pszWHERE, ProgressCallback pfnProgress) {
        int iField;
        boolean bForceToPolygon = false;
        boolean bForceToMultiPolygon = false;
        boolean bForceToMultiLineString = false;
        if (pszNewLayerName == null) {
            pszNewLayerName = poSrcLayer.GetLayerDefn().GetName();
        }
        if (ogr2ogr.wkbFlatten(eGType) == 3) {
            bForceToPolygon = true;
        } else if (ogr2ogr.wkbFlatten(eGType) == 6) {
            bForceToMultiPolygon = true;
        } else if (ogr2ogr.wkbFlatten(eGType) == 5) {
            bForceToMultiLineString = true;
        }
        CoordinateTransformation poCT = null;
        if (bTransform) {
            if (poSourceSRS == null) {
                poSourceSRS = poSrcLayer.GetSpatialRef();
            }
            if (poSourceSRS == null) {
                System.err.println("Can't transform coordinates, source layer has no\ncoordinate system.  Use -s_srs to set one.");
                ogr2ogr.System_exit(1);
            }
            if ((poCT = CoordinateTransformation.CreateCoordinateTransformation((SpatialReference)poSourceSRS, (SpatialReference)poOutputSRS)) == null) {
                String pszWKT = null;
                System.err.println("Failed to create coordinate transformation between the\nfollowing coordinate systems.  This may be because they\nare not transformable, or because projection services\n(PROJ.4 DLL/.so) could not be loaded.");
                pszWKT = poSourceSRS.ExportToPrettyWkt(0);
                System.err.println("Source:\n" + pszWKT);
                pszWKT = poOutputSRS.ExportToPrettyWkt(0);
                System.err.println("Target:\n" + pszWKT);
                ogr2ogr.System_exit(1);
            }
        }
        FeatureDefn poSrcFDefn = poSrcLayer.GetLayerDefn();
        if (poOutputSRS == null) {
            poOutputSRS = poSrcLayer.GetSpatialRef();
        }
        gdal.PushErrorHandler((String)"CPLQuietErrorHandler");
        Layer poDstLayer = poDstDS.GetLayerByName(pszNewLayerName);
        gdal.PopErrorHandler();
        gdal.ErrorReset();
        int iLayer = -1;
        if (poDstLayer != null) {
            Layer poLayer;
            int nLayerCount = poDstDS.GetLayerCount();
            for (iLayer = 0; !(iLayer >= nLayerCount || (poLayer = poDstDS.GetLayer(iLayer)) != null && poLayer.GetName().equals(poDstLayer.GetName())); ++iLayer) {
            }
            if (iLayer == nLayerCount) {
                poDstLayer = null;
            }
        }
        if (poDstLayer != null && bOverwrite) {
            if (poDstDS.DeleteLayer(iLayer) != 0) {
                System.err.println("DeleteLayer() failed when overwrite requested.");
                return false;
            }
            poDstLayer = null;
        }
        if (poDstLayer == null) {
            if (eGType == -2) {
                eGType = poSrcFDefn.GetGeomType();
                if (bExplodeCollections) {
                    int n25DBit = eGType & Integer.MIN_VALUE;
                    if (ogr2ogr.wkbFlatten(eGType) == 4) {
                        eGType = 1 | n25DBit;
                    } else if (ogr2ogr.wkbFlatten(eGType) == 5) {
                        eGType = 2 | n25DBit;
                    } else if (ogr2ogr.wkbFlatten(eGType) == 6) {
                        eGType = 3 | n25DBit;
                    } else if (ogr2ogr.wkbFlatten(eGType) == 7) {
                        eGType = 0 | n25DBit;
                    }
                }
                if (pszZField != null) {
                    eGType |= Integer.MIN_VALUE;
                }
            }
            if (!poDstDS.TestCapability("CreateLayer")) {
                System.err.println("Layer " + pszNewLayerName + "not found, and CreateLayer not supported by driver.");
                return false;
            }
            gdal.ErrorReset();
            poDstLayer = poDstDS.CreateLayer(pszNewLayerName, poOutputSRS, eGType, papszLCO);
            if (poDstLayer == null) {
                return false;
            }
            bAppend = false;
        } else {
            if (!bAppend) {
                System.err.println("FAILED: Layer " + pszNewLayerName + "already exists, and -append not specified.\n" + "        Consider using -append, or -overwrite.");
                return false;
            }
            if (papszLCO.size() > 0) {
                System.err.println("WARNING: Layer creation options ignored since an existing layer is\n         being appended to.");
            }
        }
        int nSrcFieldCount = poSrcFDefn.GetFieldCount();
        int[] panMap = new int[nSrcFieldCount];
        for (iField = 0; iField < nSrcFieldCount; ++iField) {
            panMap[iField] = -1;
        }
        FeatureDefn poDstFDefn = poDstLayer.GetLayerDefn();
        if (papszSelFields != null && !bAppend) {
            int iSrcField;
            int nDstFieldCount = 0;
            if (poDstFDefn != null) {
                nDstFieldCount = poDstFDefn.GetFieldCount();
            }
            for (iField = 0; iField < papszSelFields.size(); ++iField) {
                iSrcField = poSrcFDefn.GetFieldIndex((String)papszSelFields.get(iField));
                if (iSrcField >= 0) {
                    FieldDefn poSrcFieldDefn = poSrcFDefn.GetFieldDefn(iSrcField);
                    FieldDefn oFieldDefn = new FieldDefn(poSrcFieldDefn.GetNameRef(), poSrcFieldDefn.GetFieldType());
                    oFieldDefn.SetWidth(poSrcFieldDefn.GetWidth());
                    oFieldDefn.SetPrecision(poSrcFieldDefn.GetPrecision());
                    if (papszFieldTypesToString != null && (ogr2ogr.CSLFindString(papszFieldTypesToString, "All") != -1 || ogr2ogr.CSLFindString(papszFieldTypesToString, ogr.GetFieldTypeName((int)poSrcFDefn.GetFieldDefn(iSrcField).GetFieldType())) != -1)) {
                        oFieldDefn.SetType(4);
                    }
                    int iDstField = -1;
                    if (poDstFDefn != null) {
                        iDstField = poDstFDefn.GetFieldIndex(oFieldDefn.GetNameRef());
                    }
                    if (iDstField >= 0) {
                        panMap[iSrcField] = iDstField;
                        continue;
                    }
                    if (poDstLayer.CreateField(oFieldDefn) != 0) continue;
                    if (poDstFDefn == null) {
                        poDstFDefn = poDstLayer.GetLayerDefn();
                    }
                    if (poDstFDefn != null && poDstFDefn.GetFieldCount() != nDstFieldCount + 1) {
                        System.err.println("The output driver has claimed to have added the " + oFieldDefn.GetNameRef() + " field, but it did not!");
                        continue;
                    }
                    panMap[iSrcField] = nDstFieldCount++;
                    continue;
                }
                System.err.println("Field '" + (String)papszSelFields.get(iField) + "' not found in source layer.");
                if (bSkipFailures) continue;
                return false;
            }
            if (poSrcLayer.TestCapability("IgnoreFields") && pszWHERE == null) {
                Vector<String> papszIgnoredFields = new Vector<String>();
                for (iSrcField = 0; iSrcField < nSrcFieldCount; ++iSrcField) {
                    String pszFieldName = poSrcFDefn.GetFieldDefn(iSrcField).GetNameRef();
                    boolean bFieldRequested = false;
                    for (iField = 0; iField < papszSelFields.size(); ++iField) {
                        if (!pszFieldName.equalsIgnoreCase((String)papszSelFields.get(iField))) continue;
                        bFieldRequested = true;
                        break;
                    }
                    if (pszZField != null && pszFieldName.equalsIgnoreCase(pszZField)) {
                        bFieldRequested = true;
                    }
                    if (bFieldRequested) continue;
                    papszIgnoredFields.addElement(pszFieldName);
                }
                poSrcLayer.SetIgnoredFields(papszIgnoredFields);
            }
        } else if (!bAppend) {
            int nDstFieldCount = 0;
            if (poDstFDefn != null) {
                nDstFieldCount = poDstFDefn.GetFieldCount();
            }
            for (iField = 0; iField < nSrcFieldCount; ++iField) {
                FieldDefn poSrcFieldDefn = poSrcFDefn.GetFieldDefn(iField);
                FieldDefn oFieldDefn = new FieldDefn(poSrcFieldDefn.GetNameRef(), poSrcFieldDefn.GetFieldType());
                oFieldDefn.SetWidth(poSrcFieldDefn.GetWidth());
                oFieldDefn.SetPrecision(poSrcFieldDefn.GetPrecision());
                if (papszFieldTypesToString != null && (ogr2ogr.CSLFindString(papszFieldTypesToString, "All") != -1 || ogr2ogr.CSLFindString(papszFieldTypesToString, ogr.GetFieldTypeName((int)poSrcFDefn.GetFieldDefn(iField).GetFieldType())) != -1)) {
                    oFieldDefn.SetType(4);
                }
                int iDstField = -1;
                if (poDstFDefn != null) {
                    iDstField = poDstFDefn.GetFieldIndex(oFieldDefn.GetNameRef());
                }
                if (iDstField >= 0) {
                    panMap[iField] = iDstField;
                    continue;
                }
                if (poDstLayer.CreateField(oFieldDefn) != 0) continue;
                if (poDstFDefn == null) {
                    poDstFDefn = poDstLayer.GetLayerDefn();
                }
                if (poDstFDefn != null && poDstFDefn.GetFieldCount() != nDstFieldCount + 1) {
                    System.err.println("The output driver has claimed to have added the " + oFieldDefn.GetNameRef() + " field, but it did not!");
                    continue;
                }
                panMap[iField] = nDstFieldCount++;
            }
        } else {
            if (poDstFDefn == null) {
                System.err.println("poDstFDefn == NULL.\n");
                return false;
            }
            for (iField = 0; iField < nSrcFieldCount; ++iField) {
                FieldDefn poSrcFieldDefn = poSrcFDefn.GetFieldDefn(iField);
                int iDstField = poDstFDefn.GetFieldIndex(poSrcFieldDefn.GetNameRef());
                if (iDstField < 0) continue;
                panMap[iField] = iDstField;
            }
        }
        int nFeaturesInTransaction = 0;
        long nCount = 0L;
        int iSrcZField = -1;
        if (pszZField != null) {
            iSrcZField = poSrcFDefn.GetFieldIndex(pszZField);
        }
        poSrcLayer.ResetReading();
        if (nGroupTransactions > 0) {
            poDstLayer.StartTransaction();
        }
        while (true) {
            Geometry poSrcGeometry;
            Feature poDstFeature = null;
            Object poFeature = nFIDToFetch != -1 ? (nFeaturesInTransaction == 0 ? poSrcLayer.GetFeature(nFIDToFetch) : null) : poSrcLayer.GetNextFeature();
            if (poFeature == null) break;
            int nParts = 0;
            int nIters = 1;
            if (bExplodeCollections && (poSrcGeometry = poFeature.GetGeometryRef()) != null) {
                switch (ogr2ogr.wkbFlatten(poSrcGeometry.GetGeometryType())) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        nIters = nParts = poSrcGeometry.GetGeometryCount();
                        if (nIters != 0) break;
                        nIters = 1;
                    }
                }
            }
            for (int iPart = 0; iPart < nIters; ++iPart) {
                Geometry poDstGeometry;
                if (++nFeaturesInTransaction == nGroupTransactions) {
                    poDstLayer.CommitTransaction();
                    poDstLayer.StartTransaction();
                    nFeaturesInTransaction = 0;
                }
                gdal.ErrorReset();
                poDstFeature = new Feature(poDstLayer.GetLayerDefn());
                if (poDstFeature.SetFromWithMap(poFeature, 1, panMap) != 0) {
                    if (nGroupTransactions > 0) {
                        poDstLayer.CommitTransaction();
                    }
                    System.err.println("Unable to translate feature " + poFeature.GetFID() + " from layer " + poSrcFDefn.GetName());
                    poFeature.delete();
                    poFeature = null;
                    poDstFeature.delete();
                    poDstFeature = null;
                    return false;
                }
                if (bPreserveFID) {
                    poDstFeature.SetFID(poFeature.GetFID());
                }
                if ((poDstGeometry = poDstFeature.GetGeometryRef()) != null) {
                    Geometry poClipped;
                    Geometry poNewGeom;
                    if (nParts > 0) {
                        Geometry poPart = poDstGeometry.GetGeometryRef(iPart).Clone();
                        poDstFeature.SetGeometryDirectly(poPart);
                        poDstGeometry = poPart;
                    }
                    if (iSrcZField != -1) {
                        ogr2ogr.SetZ(poDstGeometry, poFeature.GetFieldAsDouble(iSrcZField));
                        Geometry poDupGeometry = poDstGeometry.Clone();
                        poDstFeature.SetGeometryDirectly(poDupGeometry);
                        poDstGeometry = poDupGeometry;
                    }
                    if (eGeomOp != GeomOperation.SEGMENTIZE && eGeomOp == GeomOperation.SIMPLIFY_PRESERVE_TOPOLOGY && dfGeomOpParam > 0.0 && (poNewGeom = poDstGeometry.SimplifyPreserveTopology(dfGeomOpParam)) != null) {
                        poDstFeature.SetGeometryDirectly(poNewGeom);
                        poDstGeometry = poNewGeom;
                    }
                    if (poClipSrc != null) {
                        poClipped = poDstGeometry.Intersection(poClipSrc);
                        if (poClipped == null || poClipped.IsEmpty()) {
                            ++nCount;
                            if (pfnProgress != null) {
                                pfnProgress.run((double)nCount * 1.0 / (double)nCountLayerFeatures, "");
                            }
                            poDstFeature.delete();
                            continue;
                        }
                        poDstFeature.SetGeometryDirectly(poClipped);
                        poDstGeometry = poClipped;
                    }
                    if (poCT != null) {
                        int eErr = poDstGeometry.Transform(poCT);
                        if (eErr != 0) {
                            if (nGroupTransactions > 0) {
                                poDstLayer.CommitTransaction();
                            }
                            System.err.println("Failed to reproject feature" + poFeature.GetFID() + " (geometry probably out of source or destination SRS).");
                            if (!bSkipFailures) {
                                poFeature.delete();
                                poFeature = null;
                                poDstFeature.delete();
                                poDstFeature = null;
                                return false;
                            }
                        }
                    } else if (poOutputSRS != null) {
                        poDstGeometry.AssignSpatialReference(poOutputSRS);
                    }
                    if (poClipDst != null) {
                        poClipped = poDstGeometry.Intersection(poClipDst);
                        if (poClipped == null || poClipped.IsEmpty()) {
                            ++nCount;
                            if (pfnProgress != null) {
                                pfnProgress.run((double)nCount * 1.0 / (double)nCountLayerFeatures, "");
                            }
                            poDstFeature.delete();
                            continue;
                        }
                        poDstFeature.SetGeometryDirectly(poClipped);
                        poDstGeometry = poClipped;
                    }
                    if (bForceToPolygon) {
                        poDstFeature.SetGeometryDirectly(ogr.ForceToPolygon((Geometry)poDstGeometry));
                    } else if (bForceToMultiPolygon) {
                        poDstFeature.SetGeometryDirectly(ogr.ForceToMultiPolygon((Geometry)poDstGeometry));
                    } else if (bForceToMultiLineString) {
                        poDstFeature.SetGeometryDirectly(ogr.ForceToMultiLineString((Geometry)poDstGeometry));
                    }
                }
                gdal.ErrorReset();
                if (poDstLayer.CreateFeature(poDstFeature) != 0 && !bSkipFailures) {
                    if (nGroupTransactions > 0) {
                        poDstLayer.RollbackTransaction();
                    }
                    poDstFeature.delete();
                    poDstFeature = null;
                    return false;
                }
                poDstFeature.delete();
                poDstFeature = null;
            }
            poFeature.delete();
            poFeature = null;
            ++nCount;
            if (pfnProgress == null) continue;
            pfnProgress.run((double)nCount * 1.0 / (double)nCountLayerFeatures, "");
        }
        if (nGroupTransactions > 0) {
            poDstLayer.CommitTransaction();
        }
        return true;
    }

    public static class ExitException
    extends RuntimeException {
        public int status = 0;

        public ExitException(int status) {
            this.status = status;
        }
    }

    static class GeomOperation {
        public static GeomOperation NONE = new GeomOperation();
        public static GeomOperation SEGMENTIZE = new GeomOperation();
        public static GeomOperation SIMPLIFY_PRESERVE_TOPOLOGY = new GeomOperation();

        private GeomOperation() {
        }
    }
}

