/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.groupby;

import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.geoprocess.algorithm.base.util.GeometryUtil;
import org.gvsig.geoprocess.algorithm.base.util.JTSFacade;
import org.gvsig.geoprocess.algorithm.groupby.GroupByParametersPanel;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.timesupport.AbsoluteInstant;
import org.gvsig.timesupport.Instant;
import org.gvsig.timesupport.RelativeInstant;
import org.gvsig.timesupport.Time;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.namestranslator.NamesTranslator;
import org.gvsig.tools.util.CompareUtils;

public class GroupByAlgorithm
extends AbstractSextanteGeoProcess {
    public static final String RESULT = "RESULT";
    public static final String LAYER = "LAYER";
    public static final String FIELD = "FIELD";
    public static final String FIELD_DATE = "FIELD_DATE";
    public static final String FIELD_LIST = "FIELD_LIST";
    public static final String LAYER_NAME = "LAYER_NAME";
    public static final String GEOM_OPTION = "GEOM_OPTION";
    public static final String FUNCTION_LIST = "FUNCTION_LIST";
    public static final String[] Summary = new String[]{"Min", "Max", "Sum", "Avg", "Last", "Any"};

    public void defineCharacteristics() {
        this.setName(this.getTranslation("groupby"));
        this.setGroup(this.getTranslation("basic_vect_algorithms"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, this.getTranslation("Input_layer"), -1, true);
            this.m_Parameters.addString(FIELD, this.getTranslation("Field"));
            this.m_Parameters.addString(FIELD_DATE, this.getTranslation("Field_date"));
            this.m_Parameters.addString(FIELD_LIST, this.getTranslation("Field_list"));
            this.m_Parameters.addString(FUNCTION_LIST, this.getTranslation("Function_list"));
            this.m_Parameters.addString(LAYER_NAME, this.getTranslation("Layer_name"));
            this.m_Parameters.addNumericalValue(GEOM_OPTION, this.getTranslation("Geom"), -1.0, 1);
            this.addOutputVectorLayer(RESULT, this.getTranslation("group_by"), -1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        if (this.existsOutPutFile(RESULT, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        String groupByField = this.m_Parameters.getParameterValueAsString(FIELD);
        String fieldDate = this.m_Parameters.getParameterValueAsString(FIELD_DATE);
        String fieldsString = this.m_Parameters.getParameterValueAsString(FIELD_LIST);
        String functionsString = this.m_Parameters.getParameterValueAsString(FUNCTION_LIST);
        String layerName = this.m_Parameters.getParameterValueAsString(LAYER_NAME);
        int geomOption = this.m_Parameters.getParameterValueAsInt(GEOM_OPTION);
        int inputShapeType = layer.getShapeType();
        String[] funcList = functionsString.split(";");
        String[] fieldList = null;
        if (!fieldsString.equals("")) {
            fieldList = fieldsString.split(";");
        }
        if (fieldList != null && funcList != null && fieldList.length != funcList.length) {
            Sextante.addErrorToLog((String)"invalid_input_parameters");
        }
        FeatureStore featureStore = null;
        if (!(layer instanceof FlyrVectIVectorLayer)) {
            return false;
        }
        featureStore = ((FlyrVectIVectorLayer)layer).getFeatureStore();
        try {
            FeatureType featureType = featureStore.getDefaultFeatureType();
            FeatureAttributeDescriptor desc = featureType.getAttributeDescriptor(groupByField);
            String fieldNameGrouped = desc.getName();
            FeatureStore outFeatStore = this.buildOutPutStore(featureType, layerName, groupByField, fieldList, funcList, geomOption, inputShapeType);
            Set<Object> groupedValues = this.getGroupedValues(featureStore, groupByField);
            int numberOfFeatures = groupedValues.size();
            if (this.getStatus() != null) {
                this.getStatus().setRangeOfValues(0L, (long)numberOfFeatures);
            }
            int cont = 0;
            Iterator<Object> it = groupedValues.iterator();
            while (it.hasNext()) {
                if (this.getStatus() != null) {
                    this.getStatus().setCurValue((long)cont);
                }
                this.setProgress(cont, numberOfFeatures);
                Object groupedValue = it.next();
                this.loadFeature(featureStore, outFeatStore, fieldNameGrouped, fieldDate, groupedValue, fieldList, funcList, geomOption);
                ++cont;
            }
            outFeatStore.finishEditing();
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return true;
    }

    private void loadFeature(FeatureStore inStore, FeatureStore outStore, String fieldNameGrouped, String fieldDate, Object groupedValue, String[] fieldList, String[] funcList, int geomOption) throws DataException {
        DataManager manager = DALLocator.getDataManager();
        EditableFeature feat = outStore.createNewFeature(outStore.getDefaultFeatureType(), true);
        FeatureQuery query = inStore.createFeatureQuery();
        ExpressionBuilder expressionBuilder = outStore.createExpressionBuilder();
        Evaluator filter = manager.createFilter(expressionBuilder.column(fieldNameGrouped) + " = " + expressionBuilder.constant(groupedValue));
        query.setFilter(filter);
        query.retrievesAllAttributes();
        FeatureSet featSet = inStore.getFeatureSet(query);
        DisposableIterator it = featSet.iterator();
        ArrayList<org.gvsig.fmap.geom.Geometry> geomList = new ArrayList<org.gvsig.fmap.geom.Geometry>();
        Object[] values = null;
        if (fieldList != null) {
            values = new Object[fieldList.length];
        }
        int nFeaturesByGroup = 0;
        Timestamp lastDate = null;
        while (it.hasNext()) {
            Feature feature = (Feature)it.next();
            if (fieldList != null) {
                for (int i = 0; i < fieldList.length; ++i) {
                    Object v = feature.get(fieldList[i]);
                    if (v instanceof Number) {
                        if (funcList[i].compareToIgnoreCase("Min") == 0) {
                            if (values[i] == null) {
                                values[i] = Double.POSITIVE_INFINITY;
                            }
                            values[i] = this.updateMinimum(values[i], v);
                        }
                        if (funcList[i].compareToIgnoreCase("Max") == 0) {
                            if (values[i] == null) {
                                values[i] = Double.NEGATIVE_INFINITY;
                            }
                            values[i] = this.updateMaximum(values[i], v);
                        }
                        if (funcList[i].compareToIgnoreCase("Sum") == 0 || funcList[i].compareToIgnoreCase("Average") == 0) {
                            if (values[i] == null) {
                                values[i] = 0L;
                            }
                            values[i] = this.sum(values[i], v);
                        }
                    }
                    if (funcList[i].compareToIgnoreCase("First") == 0 && values[i] == null) {
                        values[i] = this.objectConversion(v);
                    }
                    if (funcList[i].compareToIgnoreCase("Last") != 0 || fieldDate == null || lastDate != null && values[i] != null && ((Date)lastDate).getTime() <= feature.getTimestamp(fieldDate).getTime()) continue;
                    lastDate = feature.getTimestamp(fieldDate);
                    values[i] = this.objectConversion(v);
                }
            }
            if (geomOption >= 0) {
                switch (geomOption) {
                    case 0: {
                        if (nFeaturesByGroup != 0) break;
                        org.gvsig.fmap.geom.Geometry g = feature.getDefaultGeometry();
                        if (!(g instanceof MultiPrimitive)) {
                            ArrayList<org.gvsig.fmap.geom.Geometry> gList = new ArrayList<org.gvsig.fmap.geom.Geometry>();
                            gList.add(g);
                            g = this.buildMultiGeometry(gList);
                        }
                        feat.set(outStore.getDefaultFeatureType().getDefaultGeometryAttributeName(), (Object)g);
                        break;
                    }
                    case 1: 
                    case 2: {
                        geomList.add(feature.getDefaultGeometry().cloneGeometry());
                    }
                }
            }
            ++nFeaturesByGroup;
        }
        featSet.dispose();
        feat.set(fieldNameGrouped, groupedValue);
        if (fieldList != null) {
            for (int i = 0; i < values.length; ++i) {
                if (funcList[i].compareToIgnoreCase("Average") == 0) {
                    values[i] = ((Number)values[i]).doubleValue() / (double)nFeaturesByGroup;
                }
                feat.set(i + 1, values[i]);
            }
        }
        if (geomOption == 1 && geomList.size() > 0) {
            feat.set(outStore.getDefaultFeatureType().getDefaultGeometryAttributeName(), (Object)this.buildMultiGeometry(geomList));
        }
        if (geomOption == 2 && geomList.size() > 0) {
            feat.set(outStore.getDefaultFeatureType().getDefaultGeometryAttributeName(), (Object)this.computesUnion(geomList));
        }
        outStore.insert(feat);
    }

    private Object objectConversion(Object obj) {
        if (obj instanceof Instant) {
            return this.convertInstantToDate((Instant)obj);
        }
        return obj;
    }

    private Date convertInstantToDate(Instant instant) {
        if (instant instanceof AbsoluteInstant) {
            int year = ((AbsoluteInstant)instant).getYears();
            int month = ((AbsoluteInstant)instant).getMonths();
            int day = ((AbsoluteInstant)instant).getDays();
            int min = ((AbsoluteInstant)instant).getMinutes();
            int hour = ((AbsoluteInstant)instant).getHours();
            int second = ((AbsoluteInstant)instant).getSeconds();
            int millis = ((AbsoluteInstant)instant).getMillis();
            Calendar c = Calendar.getInstance();
            c.set(year, month, day, hour, min);
            return new Date(c.getTimeInMillis() + (long)(second * 1000) + (long)millis);
        }
        if (instant instanceof RelativeInstant) {
            return new Date(((RelativeInstant)instant).toMillis());
        }
        return null;
    }

    private org.gvsig.fmap.geom.Geometry buildMultiGeometry(List<org.gvsig.fmap.geom.Geometry> geomList) {
        MultiPoint newGeom = null;
        for (int i = 0; i < geomList.size(); ++i) {
            if (i == 0) {
                try {
                    int geomType = geomList.get(0).getType();
                    int geomSubtype = geomList.get(0).getGeometryType().getSubType();
                    if (GeometryUtils.isSubtype((int)1, (int)geomType) || GeometryUtils.isSubtype((int)7, (int)geomType)) {
                        newGeom = (MultiPoint)this.geomManager.create(7, geomSubtype);
                    } else if (GeometryUtils.isSubtype((int)2, (int)geomType) || GeometryUtils.isSubtype((int)8, (int)geomType)) {
                        newGeom = (MultiCurve)this.geomManager.create(21, geomSubtype);
                    } else if (GeometryUtils.isSubtype((int)3, (int)geomType) || GeometryUtils.isSubtype((int)9, (int)geomType)) {
                        newGeom = (MultiSurface)this.geomManager.create(9, geomSubtype);
                    }
                }
                catch (CreateGeometryException e) {
                    LOGGER.warn("Can't create geometry.", (Throwable)e);
                }
            }
            org.gvsig.fmap.geom.Geometry geom = geomList.get(i);
            ((MultiPrimitive)newGeom).addPrimitives(geom);
        }
        return newGeom;
    }

    private org.gvsig.fmap.geom.Geometry computesUnion(List<org.gvsig.fmap.geom.Geometry> listInput) {
        Geometry newGeom;
        ArrayList<Geometry> listResult = new ArrayList<Geometry>();
        for (int i = listInput.size() - 1; i >= 0; --i) {
            listResult.add(GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)listInput.get(i)));
            listInput.remove(i);
        }
        Geometry geometry = newGeom = listResult.size() > 0 ? (Geometry)listResult.get(0) : null;
        while (listResult.size() > 1) {
            ArrayList list = new ArrayList();
            for (int i = 0; i < listResult.size(); i += 2) {
                if (i == listResult.size() - 1) {
                    list.add(listResult.get(i));
                    continue;
                }
                newGeom = JTSFacade.union((Geometry)((Geometry)listResult.get(i)), (Geometry)((Geometry)listResult.get(i + 1)));
                list.add(newGeom);
            }
            listResult = list;
        }
        return GeometryUtil.jtsToGeom((Geometry)newGeom);
    }

    private Double updateAny(Double min, Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        return min;
    }

    private Object updateMinimum(Object min, Object value) {
        if (value instanceof Comparable && min instanceof Comparable && CompareUtils.compare((Comparable)((Comparable)value), (Comparable)((Comparable)min)) < 0) {
            return value;
        }
        return min;
    }

    private Object updateMaximum(Object max, Object value) {
        if (value instanceof Comparable && max instanceof Comparable && CompareUtils.compare((Comparable)((Comparable)value), (Comparable)((Comparable)max)) > 0) {
            return value;
        }
        return max;
    }

    private Object sum(Object current, Object value) {
        if (!(current instanceof Number) || !(value instanceof Number)) {
            return current;
        }
        if (current instanceof Double || value instanceof Double) {
            return ((Number)value).doubleValue() + ((Number)current).doubleValue();
        }
        if (current instanceof Float || value instanceof Float) {
            return Float.valueOf(((Number)value).floatValue() + ((Number)current).floatValue());
        }
        return ((Number)value).longValue() + ((Number)current).longValue();
    }

    private Set<Object> getGroupedValues(FeatureStore featureStore, String groupByField) throws DataException {
        HashSet<Object> valueGrouped = new HashSet<Object>();
        FeatureSet featureSet = featureStore.getFeatureSet();
        for (Feature feature : featureSet) {
            Object obj = feature.get(groupByField);
            valueGrouped.add(obj);
        }
        featureSet.dispose();
        return valueGrouped;
    }

    private FeatureStore buildOutPutStore(FeatureType featureType, String sextanteLayerName, String groupByField, String[] fieldList, String[] funcList, int geomOption, int inputShapeType) {
        int len = fieldList != null ? fieldList.length + 2 : 2;
        Class[] types = new Class[len];
        this.attrNames = new String[len];
        FeatureAttributeDescriptor desc = featureType.getAttributeDescriptor(groupByField);
        this.attrNames[0] = desc.getName();
        types[0] = desc.getObjectClass();
        if (fieldList != null) {
            int i;
            NamesTranslator nTranslator = NamesTranslator.createTrimTranslator((int)10);
            block35: for (i = 1; i < this.attrNames.length - 1; ++i) {
                desc = featureType.getAttributeDescriptor(fieldList[i - 1]);
                switch (funcList[i - 1].toLowerCase()) {
                    case "max": {
                        nTranslator.addSource("max_" + desc.getName());
                        continue block35;
                    }
                    case "min": {
                        nTranslator.addSource("min_" + desc.getName());
                        continue block35;
                    }
                    case "first": {
                        nTranslator.addSource("fst_" + desc.getName());
                        continue block35;
                    }
                    case "average": {
                        nTranslator.addSource("avg_" + desc.getName());
                        continue block35;
                    }
                    case "sum": {
                        nTranslator.addSource("sum_" + desc.getName());
                        continue block35;
                    }
                    case "last": {
                        nTranslator.addSource("lst_" + desc.getName());
                    }
                }
            }
            block36: for (i = 1; i < this.attrNames.length - 1; ++i) {
                desc = featureType.getAttributeDescriptor(fieldList[i - 1]);
                switch (funcList[i - 1].toLowerCase()) {
                    case "min": {
                        this.attrNames[i] = nTranslator.getTranslation("min_" + desc.getName());
                        types[i] = desc.getObjectClass();
                        continue block36;
                    }
                    case "max": {
                        this.attrNames[i] = nTranslator.getTranslation("max_" + desc.getName());
                        types[i] = desc.getObjectClass();
                        continue block36;
                    }
                    case "first": {
                        this.attrNames[i] = nTranslator.getTranslation("fst_" + desc.getName());
                        types[i] = desc.getObjectClass();
                        continue block36;
                    }
                    case "last": {
                        this.attrNames[i] = nTranslator.getTranslation("lst_" + desc.getName());
                        types[i] = desc.getObjectClass();
                        continue block36;
                    }
                    case "sum": {
                        this.attrNames[i] = nTranslator.getTranslation("sum_" + desc.getName());
                        if (Double.class.isAssignableFrom(desc.getObjectClass())) {
                            types[i] = Double.class;
                            continue block36;
                        }
                        if (Float.class.isAssignableFrom(desc.getObjectClass())) {
                            types[i] = Double.class;
                            continue block36;
                        }
                        if (Number.class.isAssignableFrom(desc.getObjectClass())) {
                            types[i] = Long.class;
                            continue block36;
                        }
                        types[i] = desc.getObjectClass();
                        continue block36;
                    }
                    case "average": {
                        this.attrNames[i] = nTranslator.getTranslation("avg_" + desc.getName());
                        types[i] = Double.class;
                    }
                }
            }
        }
        this.attrNames[this.attrNames.length - 1] = featureType.getDefaultGeometryAttributeName();
        types[types.length - 1] = featureType.getDefaultGeometryAttribute().getObjectClass();
        for (int i = 0; i < types.length; ++i) {
            if (!Time.class.isAssignableFrom(types[i])) continue;
            types[i] = Date.class;
        }
        try {
            IVectorLayer output = this.getNewVectorLayer(RESULT, sextanteLayerName, inputShapeType, types, this.attrNames);
            return ((FlyrVectIVectorLayer)output).getFeatureStore();
        }
        catch (UnsupportedOutputChannelException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (GeoAlgorithmExecutionException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return null;
    }

    private int[] getFieldList(String fieldsString) {
        String[] list = fieldsString.split(";");
        int[] l = new int[list.length];
        for (int i = 0; i < list.length; ++i) {
            try {
                l[i] = new Integer(list[i]);
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return l;
    }

    public Class<? extends GeoAlgorithmParametersPanel> getCustomParametersPanelClass() {
        return GroupByParametersPanel.class;
    }
}

