/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.groupby;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import es.unex.sextante.gui.algorithm.OutputChannelSelectionPanel;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.outputs.Output;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.gvsig.geoprocess.lib.api.GeoProcessLocator;
import org.gvsig.geoprocess.sextante.gui.algorithm.AlgorithmOutputPanel;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.swing.treeTable.AbstractCellEditor;
import org.gvsig.timesupport.Instant;

public class GroupByParametersPanel_old
extends GeoAlgorithmParametersPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private GeoAlgorithm m_Algorithm = null;
    private JButton buttonAdd = null;
    private JButton buttonDel = null;
    private JComboBox groupingField = null;
    private JComboBox timeField = null;
    private JComboBox layersCombo = null;
    private JList fieldList = null;
    private JScrollPane jlistScroll = null;
    private AlgorithmOutputPanel output = null;
    private String[] opList = null;
    private final String[] columnNames = new String[]{Messages.getText((String)"Field"), Messages.getText((String)"Function")};
    private JTable table = null;
    private JScrollPane jtableScroll = null;
    private JRadioButton firstGeom = null;
    private JRadioButton multiGeom = null;
    private JRadioButton spatialFusion = null;
    private OutputChannelSelectionPanel outputChannelSelectionPanel;
    private JPanel outputPanel;

    public void init(GeoAlgorithm algorithm) {
        this.m_Algorithm = algorithm;
        this.loadOperationListArray(0);
        this.initGUI();
    }

    private void initGUI() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.setBorder(BorderFactory.createLineBorder(Color.gray));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 4, 4, 4);
        gbc.gridy = 0;
        this.add(this.getComboPanel(GeoProcessLocator.getGeoProcessManager().getTranslation("grouping_layer"), this.getLayers1Combo()), gbc);
        gbc.gridy = 1;
        this.add(this.getComboPanel(GeoProcessLocator.getGeoProcessManager().getTranslation("grouping_field"), this.getFields1Combo()), gbc);
        gbc.gridy = 2;
        this.add(this.getComboPanel(GeoProcessLocator.getGeoProcessManager().getTranslation("time_field"), this.getFields2Combo()), gbc);
        gbc.gridy = 3;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add(this.getTablePanel(), gbc);
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.gridy = 4;
        this.add(this.getGeometryPanel(), gbc);
        gbc.gridy = 5;
        this.add(this.getOutputChannelSelectionPanel(), gbc);
    }

    private JPanel getOutputChannelSelectionPanel() {
        if (this.outputPanel == null) {
            try {
                this.outputPanel = new JPanel();
                this.outputPanel.setLayout(new BorderLayout());
                OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
                Output out = ooSet.getOutput("RESULT");
                this.outputChannelSelectionPanel = new OutputChannelSelectionPanel(out, this.m_Algorithm.getParameters());
                this.outputPanel.add((Component)new JLabel("GroupBy [Vectorial]                        "), "West");
                this.outputPanel.add((Component)this.outputChannelSelectionPanel, "Center");
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
        return this.outputPanel;
    }

    private AlgorithmOutputPanel getAlgorithmOutputPanel() {
        if (this.output == null) {
            this.output = new AlgorithmOutputPanel();
        }
        return this.output;
    }

    public JPanel getComboPanel(String text, JComboBox combo) {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 2, 0, 5);
        JLabel label = new JLabel(text);
        label.setPreferredSize(new Dimension(180, 18));
        panel.add((Component)label, gbc);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 2, 0, 0);
        panel.add((Component)combo, gbc);
        return panel;
    }

    public JComboBox getFields1Combo() {
        if (this.groupingField == null) {
            this.groupingField = new JComboBox();
            this.groupingField.setPreferredSize(new Dimension(0, 18));
            DefaultComboBoxModel<String> comboModel = new DefaultComboBoxModel<String>(this.getFieldList());
            this.groupingField.setModel(comboModel);
            this.groupingField.addActionListener(this);
        }
        return this.groupingField;
    }

    public JComboBox getFields2Combo() {
        if (this.timeField == null) {
            this.timeField = new JComboBox();
            this.timeField.setPreferredSize(new Dimension(0, 18));
            DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(this.getTimeFieldList().toArray());
            this.timeField.setModel(comboModel);
            this.timeField.addActionListener(this);
        }
        return this.timeField;
    }

    public JPanel getTablePanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        p.add((Component)this.getJList(), gbc);
        gbc.gridx = 2;
        p.add((Component)this.getJTable(), gbc);
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        p.add((Component)this.getButtonsPanel(), gbc);
        return p;
    }

    public JComboBox getLayers1Combo() {
        if (this.layersCombo == null) {
            this.layersCombo = new JComboBox();
            this.layersCombo.setPreferredSize(new Dimension(0, 18));
            DefaultComboBoxModel<ObjectAndDescription> comboModel = new DefaultComboBoxModel<ObjectAndDescription>(this.getLayerList());
            this.layersCombo.setModel(comboModel);
            this.layersCombo.addActionListener(this);
        }
        return this.layersCombo;
    }

    private JPanel getButtonsPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        p.add((Component)this.getButtonAdd(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        p.add((Component)this.getButtonDel(), gbc);
        return p;
    }

    public JButton getButtonAdd() {
        if (this.buttonAdd == null) {
            this.buttonAdd = new JButton(">>");
            this.buttonAdd.setPreferredSize(new Dimension(32, 32));
            this.buttonAdd.addActionListener(this);
        }
        return this.buttonAdd;
    }

    public JButton getButtonDel() {
        if (this.buttonDel == null) {
            this.buttonDel = new JButton("<<");
            this.buttonDel.setPreferredSize(new Dimension(32, 32));
            this.buttonDel.addActionListener(this);
        }
        return this.buttonDel;
    }

    public JScrollPane getJTable() {
        if (this.table == null) {
            ArrayList<JComboBox> combos = new ArrayList<JComboBox>();
            GroupByTableModel model = new GroupByTableModel(this.columnNames, combos);
            this.table = new JTable(model);
            this.table.setRowHeight(24);
            this.jtableScroll = new JScrollPane(this.table);
            TableColumn column = this.table.getColumnModel().getColumn(1);
            GroupByRenderer render = new GroupByRenderer();
            column.setCellRenderer(render);
            column.setCellEditor(new GroupByEditor(combos));
        }
        return this.jtableScroll;
    }

    public JScrollPane getJList() {
        if (this.fieldList == null) {
            this.fieldList = new JList();
            this.fieldList.setModel(new DefaultListModel());
            this.jlistScroll = new JScrollPane(this.fieldList);
            this.fieldList.setSelectionMode(2);
            this.fieldList.addMouseListener(this);
            String[] list = this.getFieldList();
            for (int i = 0; i < list.length; ++i) {
                ((DefaultListModel)this.fieldList.getModel()).addElement(list[i]);
            }
        }
        return this.jlistScroll;
    }

    public JPanel getGeometryPanel() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.getButtonFirstGeom());
        group.add(this.getButtonMultiGeom());
        group.add(this.getButtonSpatialFusion());
        JPanel panel = new JPanel();
        String text = GeoProcessLocator.getGeoProcessManager().getTranslation("geom");
        panel.setBorder(BorderFactory.createTitledBorder(text));
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 2, 4, 0);
        panel.add((Component)this.getButtonFirstGeom(), gbc);
        gbc.gridy = 1;
        panel.add((Component)this.getButtonMultiGeom(), gbc);
        gbc.gridy = 2;
        panel.add((Component)this.getButtonSpatialFusion(), gbc);
        return panel;
    }

    private JRadioButton getButtonFirstGeom() {
        if (this.firstGeom == null) {
            String text = GeoProcessLocator.getGeoProcessManager().getTranslation("first_geom");
            this.firstGeom = new JRadioButton(text);
        }
        return this.firstGeom;
    }

    private JRadioButton getButtonMultiGeom() {
        if (this.multiGeom == null) {
            String text = GeoProcessLocator.getGeoProcessManager().getTranslation("multi_geom");
            this.multiGeom = new JRadioButton(text);
        }
        return this.multiGeom;
    }

    private JRadioButton getButtonSpatialFusion() {
        if (this.spatialFusion == null) {
            String text = GeoProcessLocator.getGeoProcessManager().getTranslation("spatial_fusion");
            this.spatialFusion = new JRadioButton(text);
        }
        return this.spatialFusion;
    }

    private void reloadFields() {
        for (int i = ((DefaultTableModel)this.table.getModel()).getRowCount() - 1; i >= 0; --i) {
            ((DefaultTableModel)this.table.getModel()).removeRow(i);
        }
        String[] list = this.getFieldList();
        this.groupingField.removeAllItems();
        ((DefaultListModel)this.fieldList.getModel()).clear();
        for (int i = 0; i < list.length; ++i) {
            ((DefaultListModel)this.fieldList.getModel()).addElement(list[i]);
            this.groupingField.addItem(list[i]);
        }
        this.loadOperationListArray(this.getLayers1Combo().getSelectedIndex());
        ArrayList<JComboBox> combos = new ArrayList<JComboBox>();
        GroupByTableModel model = new GroupByTableModel(this.columnNames, combos);
        this.table.setModel(model);
        TableColumn column = this.table.getColumnModel().getColumn(1);
        GroupByRenderer render = new GroupByRenderer();
        column.setCellRenderer(render);
        column.setCellEditor(new GroupByEditor(combos));
        this.getFields2Combo().removeAllItems();
        List<String> timeFieldList = this.getTimeFieldList();
        for (int i = 0; i < timeFieldList.size(); ++i) {
            this.getFields2Combo().addItem(timeFieldList.get(i));
        }
        IVectorLayer layer = this.getSelectedVectorLayer();
        if (layer.getShapeType() != 2) {
            this.getButtonSpatialFusion().setEnabled(false);
        } else {
            this.getButtonSpatialFusion().setEnabled(true);
        }
    }

    private IVectorLayer getSelectedVectorLayer() {
        if (this.layersCombo.getSelectedItem() != null) {
            return (IVectorLayer)((ObjectAndDescription)this.layersCombo.getSelectedItem()).getObject();
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int row;
        if (e.getSource() == this.getLayers1Combo()) {
            this.reloadFields();
        }
        if (e.getSource() == this.getButtonAdd()) {
            this.addRowToTable();
        }
        if (e.getSource() == this.getButtonDel() && (row = this.table.getSelectedRow()) >= 0 && row < this.table.getRowCount()) {
            ((GroupByTableModel)this.table.getModel()).removeRow(row);
        }
    }

    public void assignParameters() {
        try {
            ParametersSet params = this.m_Algorithm.getParameters();
            params.getParameter("LAYER_NAME").setParameterValue((Object)"GroupBy_Layer");
            params.getParameter("LAYER").setParameterValue((Object)this.getSelectedVectorLayer());
            params.getParameter("FIELD").setParameterValue((Object)this.getFields1Combo().getSelectedIndex());
            String[] fList = this.getFieldList();
            String dateField = (String)this.getFields2Combo().getSelectedItem();
            int dateFieldPosition = -1;
            if (this.getFields2Combo().getItemCount() > 0) {
                for (int i = 0; i < fList.length; ++i) {
                    if (!fList[i].equals(dateField)) continue;
                    dateFieldPosition = i;
                }
            }
            params.getParameter("FIELD_DATE").setParameterValue((Object)dateFieldPosition);
            params.getParameter("FIELD_LIST").setParameterValue((Object)this.getFieldStringList());
            params.getParameter("FUNCTION_LIST").setParameterValue((Object)this.getFunctionStringList());
            int geom = this.getButtonFirstGeom().isSelected() ? 0 : (this.getButtonMultiGeom().isSelected() ? 1 : (this.getButtonSpatialFusion().isSelected() ? 2 : -1));
            params.getParameter("GEOM_OPTION").setParameterValue((Object)geom);
            OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
            Output out = ooSet.getOutput("RESULT");
            out.setOutputChannel(this.outputChannelSelectionPanel.getOutputChannel());
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private String getFunctionStringList() {
        if (this.table != null) {
            String value = "";
            for (int i = 0; i < ((GroupByTableModel)this.table.getModel()).getRowCount(); ++i) {
                Object obj = ((GroupByTableModel)this.table.getModel()).getValueAt(i, 1);
                if (!(obj instanceof Integer)) continue;
                value = value.compareTo("") == 0 ? this.opList[(Integer)obj] : value + ";" + this.opList[(Integer)obj];
            }
            return value;
        }
        return null;
    }

    private String getFieldStringList() {
        if (this.table != null) {
            String value = "";
            for (int i = 0; i < ((GroupByTableModel)this.table.getModel()).getRowCount(); ++i) {
                Object obj = ((GroupByTableModel)this.table.getModel()).getValueAt(i, 0);
                if (!(obj instanceof String)) continue;
                String[] fList = this.getFieldList();
                for (int j = 0; j < fList.length; ++j) {
                    if (fList[j].compareTo((String)obj) != 0) continue;
                    value = value.compareTo("") == 0 ? j + "" : value + ";" + j;
                }
            }
            return value;
        }
        return null;
    }

    public void setOutputValue(String arg0, String arg1) {
    }

    public void setParameterValue(String arg0, String arg1) {
    }

    private ObjectAndDescription[] getLayerList() {
        IVectorLayer[] layers = SextanteGUI.getInputFactory().getVectorLayers(-1);
        ObjectAndDescription[] oad = new ObjectAndDescription[layers.length];
        for (int i = 0; i < layers.length; ++i) {
            oad[i] = new ObjectAndDescription(layers[i].getName(), (Object)layers[i]);
        }
        return oad;
    }

    public String[] getFieldList() {
        IVectorLayer layer = this.getSelectedVectorLayer();
        String[] data = new String[layer.getFieldCount()];
        for (int i = 0; i < layer.getFieldCount(); ++i) {
            data[i] = layer.getFieldName(i);
        }
        return data;
    }

    public List<String> getTimeFieldList() {
        IVectorLayer layer = this.getSelectedVectorLayer();
        ArrayList<String> data = new ArrayList<String>();
        for (int i = 0; i < layer.getFieldCount(); ++i) {
            Class type = layer.getFieldType(i);
            if (!Instant.class.isAssignableFrom(type)) continue;
            data.add(layer.getFieldName(i));
        }
        return data;
    }

    private void addRowToTable() {
        Object[] values = this.fieldList.getSelectedValues();
        for (int i = 0; i < values.length; ++i) {
            ((GroupByTableModel)this.table.getModel()).addRow(new Object[]{values[i], 0});
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.addRowToTable();
        }
    }

    private void loadOperationListArray(int positionLayer) {
        IVectorLayer[] layers = SextanteGUI.getInputFactory().getVectorLayers(-1);
        if (layers != null && layers.length > 0) {
            boolean existsTimeField = false;
            for (int i = 0; i < layers[positionLayer].getFieldCount(); ++i) {
                Class type = layers[positionLayer].getFieldType(i);
                if (!Instant.class.isAssignableFrom(type)) continue;
                existsTimeField = true;
            }
            if (layers[positionLayer].getShapeType() != 2) {
                this.getButtonSpatialFusion().setEnabled(false);
            }
            this.opList = existsTimeField ? new String[]{"first", "sum", "average", "max", "min", "last"} : new String[]{"first", "sum", "average", "max", "min"};
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    class GroupByRenderer
    extends JComboBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public GroupByRenderer() {
            for (int i = 0; i < GroupByParametersPanel_old.this.opList.length; ++i) {
                this.addItem(GroupByParametersPanel_old.this.opList[i]);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this;
        }
    }

    class GroupByEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private List<JComboBox> combos = null;

        public GroupByEditor(List<JComboBox> c) {
            this.combos = c;
        }

        private void loadCombo(JComboBox combo) {
            for (int i = 0; i < GroupByParametersPanel_old.this.opList.length; ++i) {
                combo.addItem(GroupByParametersPanel_old.this.opList[i]);
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof Integer) {
                if (row < this.combos.size()) {
                    JComboBox c = this.combos.get(row);
                    c.setSelectedIndex((Integer)value);
                    return c;
                }
                int dist = row - (this.combos.size() - 1);
                for (int i = 0; i < dist; ++i) {
                    JComboBox c = new JComboBox();
                    this.loadCombo(c);
                    this.combos.add(c);
                    c.setSelectedIndex((Integer)value);
                }
                JComboBox c = this.combos.get(row);
                c.setSelectedIndex((Integer)value);
                return c;
            }
            return null;
        }
    }

    public class GroupByTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -3370601314380922368L;
        private List<JComboBox> combos;

        public GroupByTableModel(String[] columnNames, List<JComboBox> c) {
            super(new Object[0][columnNames.length], columnNames);
            this.combos = null;
            this.combos = c;
        }

        public Object[] getNewLine() {
            return new Object[]{"", new Integer(0)};
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        @Override
        public void addRow(Object[] list) {
            if (list.length <= 2 && list[1] instanceof Integer && list[0] instanceof String) {
                super.addRow(list);
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object obj = super.getValueAt(row, column);
            if (column == 1 && row < this.combos.size()) {
                return this.combos.get(row).getSelectedIndex();
            }
            return obj;
        }
    }
}

