/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.join;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.join.dal.feature.JoinTransform;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.gui.FeatureTableDocumentPanel;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreTransform;
import org.gvsig.fmap.dal.feature.FeatureStoreTransforms;
import org.gvsig.fmap.mapcontext.layers.vectorial.VectorLayer;

public class RemoveTableUnion
extends Extension {
    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"table-remove-join", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        if ("table-remove-join".equalsIgnoreCase(actionCommand)) {
            FeatureAttributeDescriptor geomAttr;
            FeatureTableDocumentPanel t = (FeatureTableDocumentPanel)PluginServices.getMDIManager().getActiveWindow();
            TableDocument pt = t.getModel();
            FeatureStore fs = pt.getStore();
            this.removeJoinTransfor(fs);
            VectorLayer layer = pt.getAssociatedLayer();
            if (layer != null && (geomAttr = fs.getDefaultFeatureTypeQuietly().getDefaultGeometryAttribute()) == null) {
                layer.getParentLayer().remove((Object)layer);
            }
            t.getModel().setModified(true);
        }
    }

    public void removeJoinTransfor(FeatureStore store) {
        FeatureStoreTransforms transforms = store.getTransforms();
        int size = transforms.size();
        if (size < 1) {
            return;
        }
        FeatureStoreTransform join = transforms.getTransform(size - 1);
        if (!(join instanceof JoinTransform)) {
            return;
        }
        transforms.remove(join);
    }

    public boolean hasJoinTransform(FeatureStore store) {
        FeatureStoreTransforms transforms = store.getTransforms();
        int size = transforms.size();
        if (size < 1) {
            return false;
        }
        return transforms.getTransform(size - 1) instanceof JoinTransform;
    }

    public boolean isEnabled() {
        IWindow v = PluginServices.getMDIManager().getActiveWindow();
        if (v == null) {
            return false;
        }
        if (v.getClass() == FeatureTableDocumentPanel.class) {
            FeatureTableDocumentPanel t = (FeatureTableDocumentPanel)v;
            TableDocument pt = t.getModel();
            FeatureStore fs = pt.getStore();
            return this.hasJoinTransform(fs);
        }
        return false;
    }

    public boolean isVisible() {
        IWindow v = PluginServices.getMDIManager().getActiveWindow();
        if (v == null) {
            return false;
        }
        return v instanceof FeatureTableDocumentPanel;
    }
}

