/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.join.dal.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.AbstractFeatureStoreTransform;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreProviderFactory;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.SetReadOnlyAttributeException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.evaluator.EvaluatorException;
import org.gvsig.tools.evaluator.EvaluatorFieldsInfo;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinTransform
extends AbstractFeatureStoreTransform {
    private static final Logger logger = LoggerFactory.getLogger(JoinTransform.class);
    public static final String PERSISTENCE_DEFINITION_NAME = "JoinTransform";
    private FeatureStore store2;
    private String keyAttr1;
    private String keyAttr2;
    private String[] attrs;
    private final Map<String, String> store1NamesMap = new HashMap<String, String>();
    private final Map<String, String> store2NamesMap = new HashMap<String, String>();
    private JoinTransformEvaluator evaluator = null;
    private FeatureType originalFeatureType;
    private String[] attrsForQuery;
    private String prefix1;
    private String prefix2;
    private CoercionContext attr1Context;
    private boolean hasGeometryAdded = false;
    private Object previousMetadataEnvelope;

    public void setValues(FeatureStore store1, FeatureStore store2, String keyAttr1, String keyAttr2, String prefix1, String prefix2, String[] attrs) {
        if (store1 == store2) {
            throw new IllegalArgumentException("store1 == store2");
        }
        this.setFeatureStore(store1);
        this.store2 = store2;
        this.keyAttr1 = keyAttr1;
        this.keyAttr2 = keyAttr2;
        this.prefix1 = prefix1;
        this.prefix2 = prefix2;
        this.attrs = attrs;
        this.attr1Context = store1.getDefaultFeatureTypeQuietly().getAttributeDescriptor(this.keyAttr1).getCoercionContext();
    }

    private boolean containsIgnoreCase(List<String> l, String item) {
        for (String x : l) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)item, (CharSequence)x)) continue;
            return true;
        }
        return false;
    }

    public void setUp() throws Exception {
        this.originalFeatureType = this.getFeatureStore().getDefaultFeatureType();
        int orig_geom_field_index = this.originalFeatureType.getDefaultGeometryAttributeIndex();
        FeatureAttributeDescriptor orig_geom_field_att = this.originalFeatureType.getDefaultGeometryAttribute();
        EditableFeatureType editableFeatureType = this.getFeatureStore().getDefaultFeatureType().getEditable();
        FeatureAttributeDescriptor[] featureAttributeDescriptors = editableFeatureType.getAttributeDescriptors();
        for (int i = 0; i < featureAttributeDescriptors.length; ++i) {
            editableFeatureType.remove(featureAttributeDescriptors[i].getName());
        }
        this.addFeatureType(editableFeatureType, featureAttributeDescriptors, this.prefix1, this.store1NamesMap);
        if (orig_geom_field_index >= 0) {
            EditableFeatureAttributeDescriptor ed_att = null;
            ed_att = (EditableFeatureAttributeDescriptor)editableFeatureType.getAttributeDescriptor(orig_geom_field_index);
            ed_att.setSRS(orig_geom_field_att.getSRS());
            ed_att.setObjectClass(orig_geom_field_att.getObjectClass());
            ed_att.setGeometryType(orig_geom_field_att.getGeomType());
            ed_att.setDefaultValue(orig_geom_field_att.getDefaultValue());
            String new_geom_field_name = ed_att.getName();
            editableFeatureType.setDefaultGeometryAttributeName(new_geom_field_name);
        }
        FeatureType featureType2 = this.store2.getDefaultFeatureType();
        for (int i = 0; i < this.attrs.length; ++i) {
            this.addFeatureType(editableFeatureType, featureType2.getAttributeDescriptor(this.attrs[i]), this.prefix2, this.store2NamesMap);
        }
        ArrayList<String> list1 = new ArrayList<String>();
        for (String attr : this.attrs) {
            if (this.containsIgnoreCase(list1, attr)) continue;
            list1.add(attr);
        }
        if (!this.containsIgnoreCase(list1, this.keyAttr2)) {
            list1.add(this.keyAttr2);
        }
        ArrayList<String> list2 = new ArrayList<String>(list1);
        for (String attrname : list1) {
            FeatureAttributeDescriptor attrdesc = featureType2.getAttributeDescriptor(attrname);
            String[] requiredAttrs = attrdesc.getRequiredFieldNames();
            if (requiredAttrs == null) continue;
            for (String requiredAttr : requiredAttrs) {
                if (this.containsIgnoreCase(list2, requiredAttr)) continue;
                list2.add(requiredAttr);
            }
        }
        this.attrsForQuery = list2.toArray(new String[0]);
        FeatureType[] types = new FeatureType[]{editableFeatureType.getNotEditableCopy()};
        this.setFeatureTypes(Arrays.asList(types), types[0]);
        if (((FeatureStoreProviderFactory)this.store2.getProviderFactory()).useLocalIndexesCanImprovePerformance() == 1 && this.store2.getIndexes().getFeatureIndex(this.keyAttr2) == null) {
            this.store2.createIndex(featureType2, this.keyAttr2, this.keyAttr2, (Observer)null);
        }
    }

    private void addFeatureType(EditableFeatureType targetFeatureType, FeatureAttributeDescriptor[] featureAttributeDescriptors, String prefix, Map<String, String> storeMap) throws DataException {
        for (int i = 0; i < featureAttributeDescriptors.length; ++i) {
            this.addFeatureType(targetFeatureType, featureAttributeDescriptors[i], prefix, storeMap);
        }
    }

    private void addFeatureType(EditableFeatureType targetFeatureType, FeatureAttributeDescriptor featureAttributeDescriptor, String prefix, Map<String, String> storeMap) throws DataException {
        String attName = featureAttributeDescriptor.getName();
        if (prefix != null && !prefix.equals("")) {
            attName = prefix + attName;
        }
        FeatureAttributeDescriptor geomAttr = targetFeatureType.getDefaultGeometryAttribute();
        int j = 0;
        while (targetFeatureType.getIndex(attName) >= 0) {
            attName = targetFeatureType.getAttributeDescriptor(attName).getName() + ++j;
        }
        EditableFeatureAttributeDescriptor editableFeatureAttributeDescriptor = targetFeatureType.add(attName, featureAttributeDescriptor.getType(), featureAttributeDescriptor.getSize());
        editableFeatureAttributeDescriptor.setPrecision(featureAttributeDescriptor.getPrecision());
        editableFeatureAttributeDescriptor.setScale(featureAttributeDescriptor.getScale());
        if (featureAttributeDescriptor.getType() == 66) {
            editableFeatureAttributeDescriptor.setGeometryType(featureAttributeDescriptor.getGeomType());
            if (geomAttr == null) {
                this.hasGeometryAdded = true;
            }
        }
        storeMap.put(featureAttributeDescriptor.getName(), attName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyTransform(Feature source, EditableFeature target) throws DataException {
        this.copySourceToTarget(source, target);
        JoinTransformEvaluator eval = this.getEvaluator();
        eval.updateValue(source.get(this.keyAttr1), this.attr1Context);
        FeatureQuery query = this.store2.createFeatureQuery();
        query.setAttributeNames(this.attrsForQuery);
        query.setFilter((Evaluator)eval);
        FeatureSet set = null;
        DisposableIterator itFeat = null;
        try {
            set = this.store2.getFeatureSet(query);
            itFeat = set.fastIterator();
            if (itFeat.hasNext()) {
                Feature feat = (Feature)itFeat.next();
                this.copyJoinToTarget(feat, target);
            }
        }
        finally {
            if (itFeat != null) {
                itFeat.dispose();
            }
            if (set != null) {
                set.dispose();
            }
        }
    }

    private void copyJoinToTarget(Feature join, EditableFeature target) {
        Iterator<Map.Entry<String, String>> iter = this.store2NamesMap.entrySet().iterator();
        FeatureType trgType = target.getType();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            FeatureAttributeDescriptor attr = trgType.getAttributeDescriptor(entry.getValue());
            if (attr == null || attr.isReadOnly()) continue;
            target.set(attr.getIndex(), join.get(entry.getKey()));
        }
    }

    private void copySourceToTarget(Feature source, EditableFeature target) {
        FeatureType ftSrc = source.getType();
        FeatureType ftTrg = target.getType();
        for (int i = 0; i < source.getType().size(); ++i) {
            FeatureAttributeDescriptor attr = ftSrc.getAttributeDescriptor(i);
            FeatureAttributeDescriptor attrTrg = ftTrg.getAttributeDescriptor(this.store1NamesMap.get(attr.getName()));
            if (attrTrg == null) continue;
            try {
                if (attrTrg.isReadOnly()) continue;
                target.set(attrTrg.getIndex(), source.get(i));
                continue;
            }
            catch (SetReadOnlyAttributeException setReadOnlyAttributeException) {
                continue;
            }
            catch (IllegalArgumentException e) {
                attrTrg = ftTrg.getAttributeDescriptor(attr.getName());
                target.set(attrTrg.getIndex(), attrTrg.getDefaultValue());
            }
        }
    }

    private JoinTransformEvaluator getEvaluator() {
        if (this.evaluator == null) {
            FeatureType ft2 = null;
            try {
                ft2 = this.store2.getDefaultFeatureType();
            }
            catch (DataException e) {
                logger.warn("Can't access to the feature type to build the evaluator.", (Throwable)e);
                throw new RuntimeException("Can't access to the feature type to build the evaluator.", e);
            }
            FeatureAttributeDescriptor att2 = ft2.getAttributeDescriptor(this.keyAttr2);
            boolean is_num = att2.getDataType().isNumeric();
            this.evaluator = new JoinTransformEvaluator(this.keyAttr2, is_num);
        }
        return this.evaluator;
    }

    public FeatureType getSourceFeatureTypeFrom(FeatureType arg0) {
        return this.originalFeatureType;
    }

    public static void registerPersistent() {
        DynStruct definition;
        PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
        if (persistenceManager.getDefinition(AbstractFeatureStoreTransform.class) == null) {
            AbstractFeatureStoreTransform.registerPersistent();
        }
        if ((definition = persistenceManager.getDefinition(PERSISTENCE_DEFINITION_NAME)) == null) {
            definition = persistenceManager.addDefinition(JoinTransform.class, PERSISTENCE_DEFINITION_NAME, "JoinTransform Persistence definition", null, null);
            definition.extend("Persistence", "AbstractFeatureStoreTransform");
            definition.addDynFieldObject("store2").setClassOfValue(FeatureStore.class).setMandatory(true);
            definition.addDynFieldString("keyAttr1").setMandatory(true);
            definition.addDynFieldString("keyAttr2").setMandatory(true);
            definition.addDynFieldString("prefix1").setMandatory(false);
            definition.addDynFieldString("prefix2").setMandatory(false);
            definition.addDynFieldList("attrs").setClassOfItems(String.class).setMandatory(true);
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("store2", (Persistent)this.store2);
        state.set("keyAttr1", this.keyAttr1);
        state.set("keyAttr2", this.keyAttr2);
        state.set("prefix1", this.prefix1);
        state.set("prefix2", this.prefix2);
        state.set("attrs", this.attrs);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.store2 = (FeatureStore)state.get("store2");
        this.keyAttr1 = state.getString("keyAttr1");
        this.keyAttr2 = state.getString("keyAttr2");
        this.prefix1 = state.getString("prefix1");
        this.prefix2 = state.getString("prefix2");
        this.attrs = (String[])state.getArray("attrs", String.class);
    }

    public Object getDynValue(String name) throws DynFieldNotFoundException {
        if (super.hasDynValue(name)) {
            return super.getDynValue(name);
        }
        switch (name) {
            case "Envelope": 
            case "CRS": {
                if (!this.hasGeometryAdded) break;
                return this.store2.getDynValue(name);
            }
        }
        return null;
    }

    public boolean hasDynValue(String name) {
        if (super.hasDynValue(name)) {
            return true;
        }
        switch (name) {
            case "Envelope": 
            case "CRS": {
                if (!this.hasGeometryAdded) break;
                return this.store2.hasDynValue(name);
            }
        }
        return false;
    }

    private class JoinTransformEvaluator
    implements Evaluator {
        private String attribute;
        private boolean isNumeric = false;
        private Object value;
        private String sql;
        private EvaluatorFieldsInfo info = null;
        private Coercion coercion;
        private CoercionContext context;

        public JoinTransformEvaluator(String attribute, boolean is_numeric) {
            this.attribute = attribute;
            this.isNumeric = is_numeric;
            this.value = null;
            this.info = new EvaluatorFieldsInfo();
        }

        public void updateValue(Object value, CoercionContext context) {
            this.value = value;
            this.coercion = null;
            this.context = context;
            if (this.value != null) {
                DataType dataType = ToolsLocator.getDataTypesManager().getDataType(value.getClass());
                if (dataType != null) {
                    this.coercion = dataType.getCoercion();
                }
                String qt = this.isNumeric ? "" : "'";
                this.sql = this.attribute + " = " + qt + this.value + qt;
            } else {
                this.sql = this.attribute + " = null";
            }
            this.info = new EvaluatorFieldsInfo();
            this.info.addMatchFieldValue(this.attribute, value);
        }

        public Object evaluate(EvaluatorData arg0) throws EvaluatorException {
            Object curValue = arg0.getDataValue(this.attribute);
            if (curValue == null) {
                return this.value == null;
            }
            if (this.value == null) {
                return false;
            }
            if (this.coercion == null) {
                return StringUtils.equals((CharSequence)Objects.toString(curValue), (CharSequence)Objects.toString(this.value));
            }
            try {
                Object coerceValue = this.coercion.coerce(curValue, this.context);
                return coerceValue.equals(this.value);
            }
            catch (CoercionException ex) {
                return StringUtils.equals((CharSequence)Objects.toString(curValue), (CharSequence)Objects.toString(this.value));
            }
        }

        public String getSQL() {
            return this.sql;
        }

        public String getDescription() {
            return "Evaluates join transform match";
        }

        public String getName() {
            return "JoinTransformEvaluator";
        }

        public EvaluatorFieldsInfo getFieldsInfo() {
            return this.info;
        }
    }
}

