/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.join.daltransform;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.join.utils.TransformUtils;
import org.gvsig.daltransform.swing.DataTransformWizardPanel;
import org.gvsig.daltransform.swing.impl.AbstractDataTransformWizardPanel;
import org.gvsig.daltransform.swing.impl.components.FeatureTypeAttributesCombo;
import org.gvsig.daltransform.swing.impl.components.FeatureTypeAttributesList;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ParameterMissingException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectParametersWizardPanel
extends AbstractDataTransformWizardPanel
implements DataTransformWizardPanel,
ActionListener {
    private static Logger logger = LoggerFactory.getLogger(SelectParametersWizardPanel.class);
    private JLabel attributesLabel;
    private FeatureTypeAttributesList attributesList;
    private JScrollPane attributesScroll;
    private FeatureTypeAttributesCombo key1Combo;
    private JLabel key1Label;
    private FeatureTypeAttributesCombo key2_Combo;
    private JLabel key2Label;
    private JLabel prefix1Label;
    private JTextField prefix1Text;
    private JLabel prefix2Label;
    private JTextField prefix2Text;
    private FeatureStore secondFeatStore = null;

    public void updatePanel() {
        this.initComponents();
        this.initLabels();
        try {
            this.updateFeatureStores();
        }
        catch (DataException e) {
            logger.error("While updating feature stores", (Throwable)e);
        }
    }

    private void initLabels() {
        this.key1Label.setText(PluginServices.getText((Object)this, (String)"join_first_key"));
        this.key2Label.setText(PluginServices.getText((Object)this, (String)"join_second_key"));
        this.prefix1Label.setText(PluginServices.getText((Object)this, (String)"join_first_prefix"));
        this.prefix2Label.setText(PluginServices.getText((Object)this, (String)"join_second_prefix"));
        this.attributesLabel.setText(PluginServices.getText((Object)this, (String)"join_select_attributes"));
    }

    private void initComponents() {
        this.removeAll();
        this.prefix2Text = new JTextField();
        this.key2_Combo = new FeatureTypeAttributesCombo();
        this.prefix1Text = new JTextField();
        this.key1Label = new JLabel();
        this.key1Combo = new FeatureTypeAttributesCombo();
        this.key1Combo.addActionListener((ActionListener)this);
        this.key2Label = new JLabel();
        this.prefix1Label = new JLabel();
        this.prefix2Label = new JLabel();
        this.attributesLabel = new JLabel();
        this.attributesScroll = new JScrollPane();
        this.attributesList = new FeatureTypeAttributesList();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 3, 2);
        this.add(this.prefix2Text, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 3, 2);
        this.add((Component)this.key2_Combo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 3, 2);
        this.add(this.prefix1Text, gridBagConstraints);
        this.key1Label.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add(this.key1Label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 3, 2);
        this.add((Component)this.key1Combo, gridBagConstraints);
        this.key2Label.setText("jLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 2, 2, 2);
        this.add(this.key2Label, gridBagConstraints);
        this.prefix1Label.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 2, 2, 2);
        this.add(this.prefix1Label, gridBagConstraints);
        this.prefix2Label.setText("jLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 2, 2, 2);
        this.add(this.prefix2Label, gridBagConstraints);
        this.attributesLabel.setText("attributesLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 2, 2, 2);
        this.add(this.attributesLabel, gridBagConstraints);
        this.attributesScroll.setViewportView((Component)this.attributesList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add(this.attributesScroll, gridBagConstraints);
    }

    public String getKeyAttr1() {
        return this.key1Combo.getSelectedFeatureAttributeDescriptor().getName();
    }

    public String getkeyAtrr2() {
        return this.key2_Combo.getSelectedFeatureAttributeDescriptor().getName();
    }

    public String getPrefix1() {
        return this.prefix1Text.getText();
    }

    public String getPrefix2() {
        return this.prefix2Text.getText();
    }

    public String[] getAttributes() {
        return this.attributesList.getAttributesName();
    }

    public void setSecondFeatureStore(FeatureStore selectedFeatureStore) {
        this.secondFeatStore = selectedFeatureStore;
    }

    public void updateFeatureStores() throws DataException {
        if (this.secondFeatStore == null) {
            throw new ParameterMissingException("Second feature store");
        }
        this.key1Combo.addFeatureAttributes(this.getFeatureStore().getDefaultFeatureType());
        this.attributesList.addFeatureAttributes(this.secondFeatStore.getDefaultFeatureType());
        if (this.key1Combo.getItemCount() == 0) {
            String _msg = Messages.getText((String)"_First_table_has_no_fields");
            String _tit = Messages.getText((String)"_Join");
            JOptionPane.showMessageDialog((Component)((Object)this), _msg, _tit, 0);
            this.getDataTransformWizard().setApplicable(false);
        } else {
            this.key1Combo.setSelectedIndex(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FeatureAttributeDescriptor att;
        Object src = e.getSource();
        if (src == this.key1Combo && this.key1Combo != null && this.key2_Combo != null && this.secondFeatStore != null && (att = this.key1Combo.getSelectedFeatureAttributeDescriptor()) != null) {
            int the_type = att.getType();
            this.key2_Combo.removeAllItems();
            FeatureType ft = null;
            try {
                ft = this.secondFeatStore.getDefaultFeatureType();
            }
            catch (DataException de) {
                logger.info("While getting feat type: " + de.getMessage());
                this.getDataTransformWizard().setApplicable(false);
                ApplicationLocator.getManager().message(Messages.getText((String)"_Error_getting_attributes"), 0);
                return;
            }
            ArrayList<Integer> comparable_types = TransformUtils.getComparableDataTypes(ft, the_type);
            if (this.key2_Combo.addFeatureAttributes(ft, comparable_types) == 0) {
                String _msg = Messages.getText((String)"_No_compatible_field_in_second_table");
                String _tit = Messages.getText((String)"_Join");
                JOptionPane.showMessageDialog((Component)((Object)this), _msg, _tit, 0);
                this.getDataTransformWizard().setApplicable(false);
            } else {
                this.getDataTransformWizard().setApplicable(true);
            }
        }
    }
}

