/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.epsg;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;

public class CrsAxisOrder {
    private static HashSet<String> yxAxisOrder = null;

    private static HashSet<String> getYxAxisOrder() {
        if (yxAxisOrder == null) {
            yxAxisOrder = new HashSet();
            try {
                InputStream is = CrsAxisOrder.class.getClassLoader().getResourceAsStream("/axisOrder/mapaxisorder.csv");
                if (is != null) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
                    String line = reader.readLine();
                    while ((line = reader.readLine()) != null) {
                        yxAxisOrder.add(line);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return yxAxisOrder;
    }

    public static boolean isXyAxisOrder(int epsgCode) {
        return !CrsAxisOrder.getYxAxisOrder().contains(Integer.toString(epsgCode));
    }

    public static boolean isXyAxisOrder(String epsgCode) {
        if (epsgCode != null) {
            if (epsgCode.toUpperCase().startsWith("EPSG:")) {
                epsgCode = epsgCode.substring(5);
            }
            if (CrsAxisOrder.getYxAxisOrder().contains(epsgCode)) {
                return false;
            }
        }
        return true;
    }
}

