/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wms;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.remoteclient.RasterClient;
import org.gvsig.remoteclient.exceptions.ServerErrorException;
import org.gvsig.remoteclient.exceptions.WMSException;
import org.gvsig.remoteclient.ogc.OGCServiceInformation;
import org.gvsig.remoteclient.utils.BoundaryBox;
import org.gvsig.remoteclient.wms.WMSLayer;
import org.gvsig.remoteclient.wms.WMSProtocolHandler;
import org.gvsig.remoteclient.wms.WMSProtocolHandlerFactory;
import org.gvsig.remoteclient.wms.WMSServiceInformation;
import org.gvsig.remoteclient.wms.WMSStatus;
import org.gvsig.remoteclient.wms.WMSStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMSClient
extends RasterClient {
    private static final Logger logger = LoggerFactory.getLogger(WMSClient.class);
    private WMSProtocolHandler handler;

    public WMSLayer getRootLayer() {
        return this.handler.rootLayer;
    }

    public WMSClient(String host) throws ConnectException, IOException {
        this.setHost(host);
        try {
            this.handler = WMSProtocolHandlerFactory.negotiate(host);
            this.handler.setHost(host);
        }
        catch (ConnectException conE) {
            logger.warn("Can't create WMS protocol handler for host '" + host + "'.", (Throwable)conE);
            throw conE;
        }
        catch (IOException ioE) {
            logger.warn("Can't create WMS protocol handler for host '" + host + "'.", (Throwable)ioE);
            throw ioE;
        }
        catch (Exception e) {
            logger.warn("Can't create WMS protocol handler for host '" + host + "'.", (Throwable)e);
        }
    }

    public String getVersion() {
        return this.handler.getVersion();
    }

    public File getMap(WMSStatus status, ICancellable cancel) throws WMSException, ServerErrorException {
        return this.handler.getMap(status, cancel);
    }

    public URL getGetMapURL(WMSStatus status, ICancellable cancel) throws WMSException, ServerErrorException {
        return this.handler.getMapURL(status, cancel);
    }

    public String getExceptionMessage(File file) throws IOException {
        return this.handler.getExceptionMessage(file);
    }

    public void getCapabilities(WMSStatus status, boolean override, ICancellable cancel) {
        this.handler.getCapabilities(status, override, cancel);
    }

    public String getFeatureInfo(WMSStatus status, int x, int y, int featureCount, ICancellable cancel) throws WMSException {
        return this.handler.getFeatureInfo(status, x, y, featureCount, cancel);
    }

    public File getLegendGraphic(WMSStatus status, String layerName, ICancellable cancel) throws WMSException, ServerErrorException {
        return this.handler.getLegendGraphic(status, layerName, cancel);
    }

    public TreeMap getLayers() {
        return this.handler.layers;
    }

    public int getNumberOfLayers() {
        if (this.handler.layers != null) {
            return this.handler.layers.size();
        }
        return 0;
    }

    public WMSLayer getLayer(String _name) {
        if (this.handler.layers.get(_name) != null) {
            return (WMSLayer)this.handler.layers.get(_name);
        }
        return null;
    }

    public String[] getLayerNames() {
        WMSLayer[] lyrs = this.handler.layers.values().toArray(new WMSLayer[0]);
        String[] names = new String[lyrs.length];
        for (int i = 0; i < lyrs.length; ++i) {
            names[i] = lyrs[i].getName();
        }
        return names;
    }

    public String[] getLayerTitles() {
        WMSLayer[] lyrs = this.handler.layers.values().toArray(new WMSLayer[0]);
        String[] titles = new String[lyrs.length];
        for (int i = 0; i < lyrs.length; ++i) {
            titles[i] = lyrs[i].getTitle();
        }
        return titles;
    }

    public Vector getFormats() {
        return ((WMSServiceInformation)this.handler.getServiceInformation()).formats;
    }

    public Vector getInfoFormats() {
        return ((WMSServiceInformation)this.handler.getServiceInformation()).infoformats;
    }

    public boolean isQueryable() {
        return ((WMSServiceInformation)this.handler.getServiceInformation()).isQueryable();
    }

    public boolean hasLegendGraphic() {
        return ((WMSServiceInformation)this.handler.getServiceInformation()).hasLegendGraphic();
    }

    public void close() {
    }

    public Rectangle2D getLayersExtent(String[] layerNames, String srs) {
        try {
            if (layerNames == null) {
                return null;
            }
            BoundaryBox bbox = null;
            WMSLayer layer = this.getLayer(layerNames[0]);
            bbox = layer.getBbox(srs);
            if (bbox == null) {
                return null;
            }
            double xmin = bbox.getXmin();
            double xmax = bbox.getXmax();
            double ymin = bbox.getYmin();
            double ymax = bbox.getYmax();
            for (int i = 1; i < layerNames.length; ++i) {
                layer = this.getLayer(layerNames[i]);
                bbox = layer.getBbox(srs);
                if (bbox == null) {
                    return null;
                }
                if (bbox.getXmin() < xmin) {
                    xmin = bbox.getXmin();
                }
                if (bbox.getYmin() < ymin) {
                    ymin = bbox.getYmin();
                }
                if (bbox.getXmax() > xmax) {
                    xmax = bbox.getXmax();
                }
                if (!(bbox.getYmax() > ymax)) continue;
                ymax = bbox.getYmax();
            }
            Rectangle2D.Double extent = new Rectangle2D.Double(xmin, ymin, Math.abs(xmax - xmin), Math.abs(ymax - ymin));
            return extent;
        }
        catch (Exception e) {
            String msg = null;
            try {
                msg = "Can't get layers extent, layers='" + StringUtils.join((Object[])layerNames, (String)",") + "', srs='" + srs + "'.";
            }
            catch (Exception ex) {
                msg = "Can't get layers extent.";
            }
            logger.warn(msg, (Throwable)e);
            return null;
        }
    }

    public WMSServiceInformation getServiceInformation() {
        return (WMSServiceInformation)this.handler.getServiceInformation();
    }

    public boolean connect(boolean override, ICancellable cancel) {
        return this.connect(null, override, cancel);
    }

    public boolean connect(WMSStatus status, boolean override, ICancellable cancel) {
        String host = this.getHost();
        try {
            if (this.handler == null) {
                if (host.trim().length() > 0) {
                    this.handler = WMSProtocolHandlerFactory.negotiate(host);
                    this.handler.setHost(host);
                } else {
                    return false;
                }
            }
            this.getCapabilities(status, override, cancel);
            this.propageCredentials();
            return true;
        }
        catch (Exception e) {
            logger.warn("Can't connect to host '" + host + "'.", (Throwable)e);
            return false;
        }
    }

    private void propageCredentials() throws IOException {
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        String url = this.getHost();
        OGCServiceInformation theServiceInformation = this.handler.getServiceInformation();
        Hashtable operations = theServiceInformation.getSupportedOperationsByName();
        HashSet servicesUrls = new HashSet(operations.values());
        for (Object layer0 : this.handler.layers.values()) {
            WMSLayer layer = (WMSLayer)layer0;
            for (Object style0 : layer.styles) {
                WMSStyle style = (WMSStyle)style0;
                String serviceUrl = style.getLegendURLOnlineResourceHRef();
                if (!StringUtils.isNotBlank((CharSequence)serviceUrl)) continue;
                servicesUrls.add(serviceUrl);
            }
        }
        downloader.propagateCredentials(url, servicesUrls);
    }

    public WMSLayer getLayersRoot() {
        return this.handler.rootLayer;
    }

    public boolean connect(ICancellable cancel) {
        return this.connect(false, cancel);
    }
}

