/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wms.wms_1_1_0;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.gvsig.compat.CompatLocator;
import org.gvsig.compat.lang.StringUtils;
import org.gvsig.remoteclient.utils.BoundaryBox;
import org.gvsig.remoteclient.utils.Utilities;
import org.gvsig.remoteclient.wms.WMSDimension;
import org.gvsig.remoteclient.wms.WMSExtent;
import org.gvsig.remoteclient.wms.WMSLayer;
import org.gvsig.remoteclient.wms.wms_1_1_0.WMSStyle1_1_0;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class WMSLayer1_1_0
extends WMSLayer {
    private static final StringUtils stringUtils = CompatLocator.getStringUtils();
    private ArrayList extents = new ArrayList();

    public ArrayList getExtents() {
        return this.extents;
    }

    public WMSExtent getExtent(String name) {
        for (int i = 0; i < this.extents.size(); ++i) {
            if (((WMSExtent)this.extents.get(i)).getName().compareTo(name) != 0) continue;
            return (WMSExtent)this.extents.get(i);
        }
        return null;
    }

    public void addExtent(WMSExtent extent) {
        this.extents.add(extent);
    }

    @Override
    public ArrayList getDimensions() {
        for (int i = 0; i < this.dimensions.size(); ++i) {
            WMSDimension dimension = (WMSDimension)this.dimensions.get(i);
            WMSExtent extent = this.getExtent(dimension.getName());
            if (extent == null) continue;
            ((WMSDimension)this.dimensions.get(i)).setDimensionExpression(extent.getExtentExpression());
        }
        ArrayList myDimensions = (ArrayList)this.dimensions.clone();
        if (this.parent != null) {
            ArrayList pDimensions = this.parent.getDimensions();
            for (int i = 0; i < pDimensions.size(); ++i) {
                WMSDimension pDimension = (WMSDimension)pDimensions.get(i);
                WMSDimension myDimension = this.getDimension(pDimension.getName());
                if (myDimension == null) continue;
                pDimensions.remove(pDimension);
            }
            myDimensions.addAll(pDimensions);
        }
        return myDimensions;
    }

    public WMSLayer1_1_0() {
        this.children = new ArrayList();
    }

    @Override
    public void parse(KXmlParser parser, TreeMap layerTreeMap) throws IOException, XmlPullParserException {
        boolean end = false;
        parser.require(2, null, "Layer");
        String value = parser.getAttributeValue("", "queryable");
        if (value != null) {
            if (value.compareTo("0") == 0) {
                this.setQueryable(false);
            } else {
                this.setQueryable(true);
            }
        }
        int currentTag = parser.nextTag();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    BoundaryBox bbox;
                    if (parser.getName().compareTo("Layer") == 0) {
                        WMSLayer1_1_0 lyr = new WMSLayer1_1_0();
                        lyr.parse(parser, layerTreeMap);
                        lyr.setParent(this);
                        this.children.add(lyr);
                        if (lyr.getName() == null) break;
                        layerTreeMap.put(lyr.getName(), lyr);
                        break;
                    }
                    if (parser.getName().compareTo("Attribution") == 0) {
                        parser.skipSubTree();
                        break;
                    }
                    if (parser.getName().compareTo("Name") == 0) {
                        value = parser.nextText();
                        if (value == null) break;
                        this.setName(value);
                        break;
                    }
                    if (parser.getName().compareTo("Title") == 0) {
                        value = parser.nextText();
                        if (value == null) break;
                        this.setTitle(value);
                        break;
                    }
                    if (parser.getName().compareTo("Abstract") == 0) {
                        value = parser.nextText();
                        if (value == null) break;
                        this.setAbstract(value);
                        break;
                    }
                    if (parser.getName().compareTo("SRS") == 0) {
                        value = parser.nextText();
                        if (value == null) break;
                        String[] mySRSs = stringUtils.split(value, " ");
                        for (int i = 0; i < mySRSs.length; ++i) {
                            this.addSrs(mySRSs[i]);
                        }
                        break;
                    }
                    if (parser.getName().compareTo("BoundingBox") == 0) {
                        bbox = new BoundaryBox();
                        value = parser.getAttributeValue("", "SRS");
                        if (value != null) {
                            bbox.setSrs(value);
                        }
                        if ((value = parser.getAttributeValue("", "minx")) != null && Utilities.isNumber((String)value)) {
                            bbox.setXmin(Double.parseDouble(value));
                        }
                        if ((value = parser.getAttributeValue("", "miny")) != null && Utilities.isNumber((String)value)) {
                            bbox.setYmin(Double.parseDouble(value));
                        }
                        if ((value = parser.getAttributeValue("", "maxx")) != null && Utilities.isNumber((String)value)) {
                            bbox.setXmax(Double.parseDouble(value));
                        }
                        if ((value = parser.getAttributeValue("", "maxy")) != null && Utilities.isNumber((String)value)) {
                            bbox.setYmax(Double.parseDouble(value));
                        }
                        this.addBBox(bbox);
                        this.addSrs(bbox.getSrs());
                        break;
                    }
                    if (parser.getName().compareTo("LatLonBoundingBox") == 0) {
                        bbox = new BoundaryBox();
                        bbox.setSrs("EPSG:4326");
                        value = parser.getAttributeValue("", "minx");
                        if (value != null && Utilities.isNumber((String)value)) {
                            bbox.setXmin(Double.parseDouble(value));
                        }
                        if ((value = parser.getAttributeValue("", "miny")) != null && Utilities.isNumber((String)value)) {
                            bbox.setYmin(Double.parseDouble(value));
                        }
                        if ((value = parser.getAttributeValue("", "maxx")) != null && Utilities.isNumber((String)value)) {
                            bbox.setXmax(Double.parseDouble(value));
                        }
                        if ((value = parser.getAttributeValue("", "maxy")) != null && Utilities.isNumber((String)value)) {
                            bbox.setYmax(Double.parseDouble(value));
                        }
                        this.addBBox(bbox);
                        this.setLatLonBox(bbox);
                        break;
                    }
                    if (parser.getName().compareTo("ScaleHint") == 0) {
                        value = parser.getAttributeValue("", "min");
                        if (value != null && Utilities.isNumber((String)value)) {
                            this.setScaleMin(Double.parseDouble(value));
                        }
                        if ((value = parser.getAttributeValue("", "max")) == null || !Utilities.isNumber((String)value)) break;
                        this.setScaleMax(Double.parseDouble(value));
                        break;
                    }
                    if (parser.getName().compareTo("Style") == 0) {
                        WMSStyle1_1_0 style = new WMSStyle1_1_0();
                        style.parse(parser);
                        if (style == null || style.getName() == null) break;
                        this.styles.add(style);
                        break;
                    }
                    if (parser.getName().compareTo("Dimension") == 0) {
                        WMSDimension dim = new WMSDimension();
                        dim.parse(parser);
                        if (dim == null || dim.getName() == null) break;
                        this.addDimension(dim);
                        break;
                    }
                    if (parser.getName().compareTo("Extent") != 0) break;
                    WMSExtent extent = new WMSExtent();
                    extent.parse(parser);
                    if (extent == null || extent.getName() == null) break;
                    this.addExtent(extent);
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("Layer") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
        parser.require(3, null, "Layer");
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

