/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wms.wms_1_1_0;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.TreeMap;
import org.gvsig.remoteclient.utils.EncodingXMLParser;
import org.gvsig.remoteclient.wms.WMSProtocolHandler;
import org.gvsig.remoteclient.wms.WMSServiceInformation;
import org.gvsig.remoteclient.wms.WMSStatus;
import org.gvsig.remoteclient.wms.request.WMSGetCapabilitiesRequest;
import org.gvsig.remoteclient.wms.request.WMSGetFeatureInfoRequest;
import org.gvsig.remoteclient.wms.request.WMSGetLegendGraphicRequest;
import org.gvsig.remoteclient.wms.request.WMSGetMapRequest;
import org.gvsig.remoteclient.wms.wms_1_1_0.WMSLayer1_1_0;
import org.gvsig.remoteclient.wms.wms_1_1_0.request.WMSGetCapabilitiesRequest1_1_0;
import org.gvsig.remoteclient.wms.wms_1_1_0.request.WMSGetFeatureInfoRequest1_1_0;
import org.gvsig.remoteclient.wms.wms_1_1_0.request.WMSGetLegendGraphicRequest1_1_0;
import org.gvsig.remoteclient.wms.wms_1_1_0.request.WMSGetMapRequest1_1_0;
import org.kxml2.io.KXmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

public class WMSProtocolHandler1_1_0
extends WMSProtocolHandler {
    private static final Logger logger = LoggerFactory.getLogger(WMSProtocolHandler1_1_0.class);
    private WMSLayer1_1_0 fakeRootLayer;

    public WMSProtocolHandler1_1_0() {
        this.version = "1.1.0";
        this.name = "WMS1.1.0";
        this.serviceInfo = new WMSServiceInformation();
        this.layers = new TreeMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseCapabilities(File f) {
        this.rootLayer = null;
        EncodingXMLParser kxmlParser = null;
        kxmlParser = new EncodingXMLParser();
        try {
            kxmlParser.setInput(f);
            kxmlParser.nextTag();
            if (kxmlParser.getEventType() != 1) {
                kxmlParser.require(2, null, "WMT_MS_Capabilities");
                int tag = kxmlParser.nextTag();
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (kxmlParser.getName().compareTo("Service") == 0) {
                                this.parseServiceTag((KXmlParser)kxmlParser);
                                break;
                            }
                            if (kxmlParser.getName().compareTo("Capability") != 0) break;
                            this.parseCapabilityTag((KXmlParser)kxmlParser);
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                    tag = kxmlParser.next();
                }
                kxmlParser.require(1, null, null);
            }
        }
        catch (XmlPullParserException parser_ex) {
            logger.warn("Error parsing capabilites.", (Throwable)parser_ex);
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            logger.warn("Error parsing capabilites.", (Throwable)ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            return true;
        }
    }

    private void parseServiceTag(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        parser.require(2, null, "Service");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("Name") == 0) {
                        this.serviceInfo.name = parser.nextText();
                        break;
                    }
                    if (parser.getName().compareTo("Title") == 0) {
                        this.serviceInfo.title = parser.nextText();
                        break;
                    }
                    if (parser.getName().compareTo("Abstract") == 0) {
                        this.serviceInfo.abstr = parser.nextText();
                        break;
                    }
                    if (parser.getName().compareTo("OnlineResource") == 0) {
                        String value = null;
                        value = parser.getAttributeValue("", "xlink:href");
                        if (value == null) break;
                        this.serviceInfo.online_resource = value;
                        break;
                    }
                    if (parser.getName().compareTo("KeywordList") != 0 && parser.getName().compareTo("ContactInformation") != 0) break;
                    parser.skipSubTree();
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("Service") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
        parser.require(3, null, "Service");
    }

    private void parseCapabilityTag(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        parser.require(2, null, "Capability");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("Request") == 0) {
                        this.parseRequestTag(parser);
                        break;
                    }
                    if (parser.getName().compareTo("Exception") == 0) break;
                    if (parser.getName().compareTo("Layer") == 0) {
                        WMSLayer1_1_0 lyr = new WMSLayer1_1_0();
                        if (this.rootLayer == null) {
                            this.rootLayer = lyr;
                        } else {
                            if (!this.rootLayer.equals(this.getFakeRootLayer())) {
                                WMSLayer1_1_0 aux = (WMSLayer1_1_0)this.rootLayer;
                                this.rootLayer = this.getFakeRootLayer();
                                this.rootLayer.getChildren().add(aux);
                            }
                            this.rootLayer.getChildren().add(lyr);
                        }
                        lyr.parse(parser, this.layers);
                        if (lyr.getName() == null) break;
                        this.layers.put(lyr.getName(), lyr);
                        break;
                    }
                    if (parser.getName().compareTo("VendorSpecificCapabilities") != 0 && parser.getName().compareTo("UserDefinedSymbolization") != 0) break;
                    parser.skipSubTree();
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("Capability") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    private WMSLayer1_1_0 getFakeRootLayer() {
        if (this.fakeRootLayer == null) {
            this.fakeRootLayer = new WMSLayer1_1_0();
            this.fakeRootLayer.setTitle(this.serviceInfo.title);
            this.fakeRootLayer.setQueryable(false);
            this.fakeRootLayer.setName(null);
        }
        return this.fakeRootLayer;
    }

    @Override
    protected String parseException(byte[] data) {
        ArrayList<String> errors = new ArrayList<String>();
        KXmlParser kxmlParser = new KXmlParser();
        try {
            kxmlParser.setInput((InputStream)new ByteArrayInputStream(data), this.encoding);
            kxmlParser.nextTag();
            if (kxmlParser.getEventType() != 1) {
                kxmlParser.require(2, null, "ServiceExceptionReport");
                int tag = kxmlParser.nextTag();
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (kxmlParser.getName().compareTo("ServiceException") != 0) break;
                            String errorCode = kxmlParser.getAttributeValue("", "code");
                            errorCode = errorCode != null ? "[" + errorCode + "] " : "";
                            String errorMessage = kxmlParser.nextText();
                            errors.add(errorCode + errorMessage);
                            break;
                        }
                    }
                    tag = kxmlParser.nextTag();
                }
            }
        }
        catch (XmlPullParserException parser_ex) {
            logger.warn("", (Throwable)parser_ex);
        }
        catch (IOException ioe) {
            logger.warn("", (Throwable)ioe);
        }
        String message = errors.size() > 0 ? "" : null;
        for (int i = 0; i < errors.size(); ++i) {
            message = message + (String)errors.get(i) + "\n";
        }
        return message;
    }

    @Override
    protected WMSGetFeatureInfoRequest createGetFeatureInfoRequest(WMSStatus status, int x, int y) {
        return new WMSGetFeatureInfoRequest1_1_0(status, this, x, y);
    }

    @Override
    protected WMSGetMapRequest createGetMapRequest(WMSStatus status) {
        return new WMSGetMapRequest1_1_0(status, this);
    }

    @Override
    protected WMSGetLegendGraphicRequest createGetLegendGraphicRequest(WMSStatus status, String layerName) {
        return new WMSGetLegendGraphicRequest1_1_0(status, this, layerName);
    }

    @Override
    protected WMSGetCapabilitiesRequest createGetCapabilitiesRequest(WMSStatus status) {
        return new WMSGetCapabilitiesRequest1_1_0(status, this);
    }
}

