/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.ui.mdiFrame;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.Launcher;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.actioninfo.ActionInfo;
import org.gvsig.andami.actioninfo.ActionInfoManager;
import org.gvsig.andami.actioninfo.ActionInfoStatusCache;
import org.gvsig.andami.plugins.ExtensionDecorator;
import org.gvsig.andami.plugins.IExtension;
import org.gvsig.andami.plugins.PluginClassLoader;
import org.gvsig.andami.plugins.config.generate.ActionTool;
import org.gvsig.andami.plugins.config.generate.Label;
import org.gvsig.andami.plugins.config.generate.Menu;
import org.gvsig.andami.plugins.config.generate.PopupMenu;
import org.gvsig.andami.plugins.config.generate.SelectableTool;
import org.gvsig.andami.plugins.config.generate.SkinExtensionType;
import org.gvsig.andami.plugins.config.generate.ToolBar;
import org.gvsig.andami.ui.mdiFrame.DefaultThreadSafeDialogs;
import org.gvsig.andami.ui.mdiFrame.DropDownButton;
import org.gvsig.andami.ui.mdiFrame.EnableTextSupport;
import org.gvsig.andami.ui.mdiFrame.JMenuItem;
import org.gvsig.andami.ui.mdiFrame.JPopUpMenu;
import org.gvsig.andami.ui.mdiFrame.JToolBarButton;
import org.gvsig.andami.ui.mdiFrame.JToolBarToggleButton;
import org.gvsig.andami.ui.mdiFrame.KeyMapping;
import org.gvsig.andami.ui.mdiFrame.MainFrame;
import org.gvsig.andami.ui.mdiFrame.NewStatusBar;
import org.gvsig.andami.ui.mdiFrame.NoSuchMenuException;
import org.gvsig.andami.ui.mdiFrame.SelectableToolBar;
import org.gvsig.andami.ui.mdiFrame.ToggleButtonModel;
import org.gvsig.andami.ui.mdiFrame.TranslatableButtonHelper;
import org.gvsig.andami.ui.mdiManager.MDIManager;
import org.gvsig.andami.ui.mdiManager.MDIManagerFactory;
import org.gvsig.gui.beans.controls.IControl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.future.FutureUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDIFrame
extends JFrame
implements ComponentListener,
ContainerListener,
ActionListener,
MainFrame {
    private static final long serialVersionUID = -2472484309160847654L;
    private static Logger logger = LoggerFactory.getLogger(MDIFrame.class);
    private static MDIFrame instance = null;
    private MDIManager mdiManager = MDIManagerFactory.createManager();
    private boolean refreshingControls = false;
    private JMenuBar menuBar = new JMenuBar();
    private JPanel toolBars = new JPanel();
    private NewStatusBar bEstado = null;
    private HashMap toolBarMap = new HashMap();
    private HashMap buttonGroupMap = new HashMap();
    private HashMap initialSelectedTools = new HashMap();
    private Map selectedTool = null;
    private String defaultGroup = "unico";
    private HashMap popupMap = new HashMap();
    private List<JComponent> controls = new ArrayList<JComponent>();
    private HashMap classLabels = new HashMap();
    private ArrayList progressListeners = new ArrayList();
    private Timer progressTimer = null;
    private Class lastLabelClass;
    private TooltipListener tooltipListener = new TooltipListener();
    private HashMap infoCodedMenus = new HashMap();
    private String titlePrefix;
    private Map<JComponent, IExtension> control2extensions = new HashMap<JComponent, IExtension>();

    private MDIFrame() {
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public static MDIFrame getInstance() {
        if (instance == null) {
            instance = new MDIFrame();
        }
        return instance;
    }

    public void init() {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Not Event Dispatch Thread");
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Launcher.closeApplication();
            }
        });
        this.addComponentListener(this);
        this.setDefaultCloseOperation(0);
        this.setJMenuBar(this.menuBar);
        this.getContentPane().setLayout(new BorderLayout());
        FlowLayout layout = new FlowLayout(0);
        layout.setHgap(0);
        layout.setVgap(0);
        this.toolBars.setLayout(layout);
        this.getContentPane().add((Component)this.toolBars, "First");
        this.bEstado = new NewStatusBar();
        this.getContentPane().add((Component)this.bEstado, "South");
        this.toolBars.addContainerListener(this);
        this.setSize(MainFrame.MAIN_FRAME_SIZE_DEFAULT[0], MainFrame.MAIN_FRAME_SIZE_DEFAULT[1]);
        this.setLocation(MainFrame.MAIN_FRAME_POS_DEFAULT[0], MainFrame.MAIN_FRAME_POS_DEFAULT[1]);
        this.setExtendedState(6);
        this.mdiManager.init(this);
    }

    @Override
    public void setTitle(final String title) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MDIFrame.this.setTitle(title);
                }
            });
            return;
        }
        super.setTitle(this.titlePrefix + " : " + title);
    }

    private SelectableToolBar getToolBar(String toolBarName, String pluginName) {
        SelectableToolBar jtb = (SelectableToolBar)this.toolBarMap.get(toolBarName);
        if (jtb == null) {
            jtb = new SelectableToolBar(toolBarName);
            jtb.setRollover(true);
            jtb.setAndamiVisibility(true);
            this.toolBarMap.put(toolBarName, jtb);
            this.toolBars.add(jtb);
        }
        return jtb;
    }

    public SelectableToolBar addToolBar(String toolBarName, String description, int position) {
        SelectableToolBar toolBar = (SelectableToolBar)this.toolBarMap.get(toolBarName);
        if (toolBar == null) {
            toolBar = new SelectableToolBar(toolBarName, description, position);
            toolBar.setRollover(true);
            toolBar.setAndamiVisibility(true);
            this.toolBarMap.put(toolBarName, toolBar);
            this.toolBars.add(toolBar);
        } else if (toolBar.getPosition() < 1) {
            toolBar.setPosition(position);
        } else if (toolBar.getPosition() != position) {
            logger.warn("Add duplicate tool-bar (" + toolBarName + ") with diferent position.");
        }
        return toolBar;
    }

    public void addTool(final PluginClassLoader loader, final SkinExtensionType ext, final ToolBar toolBar, final SelectableTool selectableTool) throws ClassNotFoundException {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MDIFrame.this.addTool(loader, ext, toolBar, selectableTool);
                        }
                        catch (ClassNotFoundException ex) {
                            logger.warn("Eehh????", (Throwable)ex);
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        ButtonGroup group = (ButtonGroup)this.buttonGroupMap.get(selectableTool.getGroup());
        if (group == null) {
            group = new ButtonGroup();
            this.buttonGroupMap.put(selectableTool.getGroup(), group);
        }
        String name = toolBar.getName();
        SelectableToolBar jtb = this.getToolBar(name, loader.getPluginName());
        if (selectableTool.getDropDownGroup() != null) {
            ActionInfoManager actionManager = PluginsLocator.getActionInfoManager();
            ActionInfo action = actionManager.getAction(selectableTool.getName());
            if (action != null) {
                DropDownButton dropDownButton = (DropDownButton)jtb.findComponent(selectableTool.getDropDownGroup());
                if (dropDownButton == null) {
                    ToggleButtonModel buttonModel = new ToggleButtonModel();
                    dropDownButton = new DropDownButton();
                    dropDownButton.setModel(buttonModel);
                    dropDownButton.setName(selectableTool.getDropDownGroup());
                    dropDownButton.setMargin(new Insets(2, 2, 2, 2));
                    jtb.addButton(group, dropDownButton);
                    this.addControl(dropDownButton);
                    buttonModel.setGroupName(selectableTool.getGroup());
                }
                dropDownButton.add(actionManager.getTranslated(action));
            }
            return;
        }
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        ImageIcon image = PluginServices.getIconTheme().get(selectableTool.getIcon());
        if (image == null) {
            logger.warn("Unable to find icon '" + selectableTool.getIcon() + "'.");
            image = PluginServices.getIconTheme().getDefaultIcon();
        }
        ToggleButtonModel buttonModel = new ToggleButtonModel();
        JToolBarToggleButton btn = new JToolBarToggleButton(selectableTool.getText(), image);
        btn.setModel(buttonModel);
        btn.setMargin(new Insets(2, 2, 2, 2));
        btn.addMouseListener(this.tooltipListener);
        btn.addActionListener(this);
        btn.setFocusable(false);
        btn.setActionCommand(selectableTool.getActionCommand());
        btn.setToolTipText(selectableTool.getTooltip());
        btn.setEnabled(false);
        btn.setVisible(false);
        jtb.addButton(group, btn);
        buttonModel.setGroupName(selectableTool.getGroup());
        if (selectableTool.getIsDefault()) {
            btn.setSelected(true);
            this.initialSelectedTools.put(selectableTool.getGroup(), btn.getActionCommand());
        }
        this.addControl(btn);
        if (selectableTool.getName() != null) {
            btn.setName(selectableTool.getName());
        }
        if (selectableTool.getTooltip() != null) {
            btn.setToolTip(i18nManager.getTranslation(selectableTool.getTooltip()));
            btn.setToolTipKey(selectableTool.getTooltip());
        }
        if (selectableTool.getEnableText() != null) {
            btn.setEnableText(i18nManager.getTranslation(selectableTool.getEnableText()));
        }
        if (selectableTool.getLast()) {
            jtb.addSeparator();
        }
    }

    private boolean addDropdownTool(SelectableToolBar jtb, ActionInfo action) {
        String dropDownGroup;
        if (action != null && (dropDownGroup = (String)action.getValue("DropDownGroup")) != null) {
            DropDownButton dropDownButton = (DropDownButton)jtb.findComponent(dropDownGroup);
            if (dropDownButton == null) {
                dropDownButton = new DropDownButton();
                dropDownButton.setName(dropDownGroup);
                jtb.add(dropDownButton);
                this.addControl(dropDownButton);
            }
            ActionInfoManager actionManager = PluginsLocator.getActionInfoManager();
            dropDownButton.add(actionManager.getTranslated(action));
            return true;
        }
        return false;
    }

    public void addTool(final PluginClassLoader loader, final SkinExtensionType ext, final ToolBar toolBar, final ActionTool actionTool) throws ClassNotFoundException {
        ActionInfoManager actionManager;
        ActionInfo action;
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MDIFrame.this.addTool(loader, ext, toolBar, actionTool);
                        }
                        catch (ClassNotFoundException ex) {
                            logger.warn("Eehh????", (Throwable)ex);
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        String name = toolBar.getName();
        SelectableToolBar jtb = this.getToolBar(name, loader.getPluginName());
        if (this.addDropdownTool(jtb, action = (actionManager = PluginsLocator.getActionInfoManager()).getAction(actionTool.getName()))) {
            return;
        }
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        ImageIcon image = IconThemeHelper.getImageIcon(actionTool.getIcon());
        if (image == null) {
            logger.warn("Unable to find icon '" + actionTool.getIcon() + "'.");
            image = PluginServices.getIconTheme().getDefaultIcon();
        }
        JToolBarButton btn = new JToolBarButton(actionTool.getText(), image);
        btn.setMargin(new Insets(2, 2, 2, 2));
        btn.addMouseListener(this.tooltipListener);
        btn.addActionListener(this);
        btn.setFocusable(false);
        btn.setActionCommand(actionTool.getActionCommand());
        btn.setEnabled(false);
        btn.setVisible(false);
        jtb.add(btn);
        this.addControl(btn);
        if (actionTool.getName() != null) {
            btn.setName(actionTool.getName());
        }
        if (actionTool.getTooltip() != null) {
            btn.setToolTip(i18nManager.getTranslation(actionTool.getTooltip()));
            btn.setToolTipKey(actionTool.getTooltip());
        }
        if (actionTool.getEnableText() != null) {
            btn.setEnableText(i18nManager.getTranslation(actionTool.getEnableText()));
        }
        if (actionTool.getLast()) {
            jtb.addSeparator();
        }
    }

    @Override
    public void addTool(final ActionInfo action, final String toolBarName, final String dropDownName) {
        DropDownButton dropDownButton;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MDIFrame.this.addTool(action, toolBarName, dropDownName);
                }
            });
            return;
        }
        ActionInfoManager actionManager = PluginsLocator.getActionInfoManager();
        SelectableToolBar jtb = this.getToolBar(toolBarName, action.getPluginName());
        Component button = jtb.findComponent(dropDownName);
        if (button == null) {
            dropDownButton = new DropDownButton();
            dropDownButton.setName(dropDownName);
            this.addControl(dropDownButton);
            jtb.add(dropDownButton);
            button = dropDownButton;
        }
        if (button instanceof DropDownButton) {
            dropDownButton = (DropDownButton)button;
            dropDownButton.add(actionManager.getTranslated(action));
        } else {
            JToolBarButton toolBarButton = (JToolBarButton)button;
            jtb.remove(toolBarButton);
            this.removeControl(toolBarButton);
            String actionName = toolBarButton.getName();
            ActionInfo action2 = actionManager.getAction(actionName);
            DropDownButton dropDownButton2 = new DropDownButton();
            dropDownButton2.setName(dropDownName);
            this.addControl(dropDownButton2);
            jtb.add(dropDownButton2);
            dropDownButton2.add(actionManager.getTranslated(action2));
            dropDownButton2.add(actionManager.getTranslated(action));
        }
    }

    @Override
    public void addTool(ActionInfo action, String toolBarName) {
        this.addTool(action, toolBarName, false);
    }

    @Override
    public void addTool(final ActionInfo action, final String toolBarName, final boolean useText) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MDIFrame.this.addTool(action, toolBarName, useText);
                }
            });
            return;
        }
        SelectableToolBar jtb = this.getToolBar(toolBarName, action.getPluginName());
        if (this.addDropdownTool(jtb, action)) {
            return;
        }
        JToolBarButton btn = new JToolBarButton(action.getIcon());
        btn.setMargin(new Insets(2, 2, 2, 2));
        btn.addMouseListener(this.tooltipListener);
        btn.addActionListener(this);
        btn.setFocusable(false);
        btn.setActionCommand(action.getCommand());
        btn.setEnabled(false);
        btn.setVisible(false);
        btn.setName(action.getName());
        if (useText) {
            btn.setText(action.getLabel());
        }
        if (action.getTooltip() != null) {
            btn.setToolTip(i18nManager.getTranslation(action.getTooltip()));
            btn.setToolTipKey(action.getTooltip());
        }
        jtb.add(btn);
        this.addControl(btn);
    }

    @Override
    public void addSelectableTool(final ActionInfo action, final String toolBarName, final String groupName, final boolean useText) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MDIFrame.this.addSelectableTool(action, toolBarName, groupName, useText);
                }
            });
            return;
        }
        ButtonGroup group = (ButtonGroup)this.buttonGroupMap.get(groupName);
        if (group == null) {
            group = new ButtonGroup();
            this.buttonGroupMap.put(groupName, group);
        }
        ToggleButtonModel buttonModel = new ToggleButtonModel();
        buttonModel.setGroupName(groupName);
        JToolBarToggleButton btn = new JToolBarToggleButton(action.getIcon());
        btn.setModel(buttonModel);
        btn.setMargin(new Insets(2, 2, 2, 2));
        btn.addMouseListener(this.tooltipListener);
        btn.addActionListener(this);
        btn.setFocusable(false);
        btn.setActionCommand(action.getCommand());
        btn.setEnabled(false);
        btn.setVisible(false);
        btn.setName(action.getName());
        if (useText) {
            btn.setText(action.getLabel());
        }
        if (action.getTooltip() != null) {
            btn.setToolTip(i18nManager.getTranslation(action.getTooltip()));
            btn.setToolTipKey(action.getTooltip());
        }
        SelectableToolBar jtb = this.getToolBar(toolBarName, action.getPluginName());
        jtb.addButton(group, btn);
        this.addControl(btn);
    }

    private JMenu createMenuAncestors(Menu menu, PluginClassLoader loader) {
        return this.createMenuAncestors(menu.getText());
    }

    private JMenu createMenuAncestors(String text) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        javax.swing.JMenuItem menuPadre = null;
        String[] menues = text.split("/");
        ArrayList<String> menuList = new ArrayList<String>();
        menuList.add(menues[0]);
        menuPadre = this.getMenu(menuList, this.menuBar);
        JMenu padre = null;
        if (menuPadre == null) {
            padre = new JMenuTraslatable(i18nManager.getTranslation(menues[0]));
            ((JMenuTraslatable)padre).setTextKey(menues[0]);
            padre.setName(menues[0]);
            this.addControl(padre);
            this.menuBar.add(padre);
        } else if (menuPadre instanceof JMenu) {
            padre = (JMenu)menuPadre;
        } else {
            logger.warn("Error creating menu. Ancestor does not exist (" + text + ").");
            return null;
        }
        ArrayList<String> temp = new ArrayList<String>();
        for (int i = 1; i < menues.length - 1; ++i) {
            temp.add(menues[i]);
        }
        menuPadre = this.createMenus(temp, padre);
        return (JMenu)menuPadre;
    }

    public void addMenu(final PluginClassLoader loader, final SkinExtensionType ext, final Menu menu) throws ClassNotFoundException {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MDIFrame.this.addMenu(loader, ext, menu);
                        }
                        catch (ClassNotFoundException ex) {
                            logger.warn("\u00c2\u00bf\u00c2\u00bf\u00c2\u00bf Eehh????", (Throwable)ex);
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        JMenu menuPadre = this.createMenuAncestors(menu, loader);
        if (menu.getIs_separator()) {
            menuPadre.addSeparator();
            return;
        }
        JMenuItem nuevoMenu = this.createJMenuItem(loader, menu);
        nuevoMenu.addMouseListener(this.tooltipListener);
        menuPadre.add(nuevoMenu);
        this.addControl(nuevoMenu);
    }

    @Override
    public void addMenu(final ActionInfo action, final String text) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MDIFrame.this.addMenu(action, text);
                }
            });
            return;
        }
        JMenu menuPadre = this.createMenuAncestors(text);
        JMenuItem nuevoMenu = this.createJMenuItem(action, text);
        nuevoMenu.addMouseListener(this.tooltipListener);
        menuPadre.add(nuevoMenu);
        menuPadre.invalidate();
        Class<?> classExtension = action.getExtension().getClass();
        this.addControl(nuevoMenu);
    }

    private javax.swing.JMenuItem getMenu(List nombres, MenuElement parent) {
        if (parent instanceof JMenu) {
            JMenu parentItem = (JMenu)parent;
            for (int i = 0; i < parentItem.getMenuComponentCount(); ++i) {
                String item_name = parentItem.getMenuComponent(i).getName();
                if ((item_name == null || item_name.compareTo((String)nombres.get(0)) != 0) && !this.lastMenuItemWithoutName(parentItem.getMenuComponent(i), nombres)) continue;
                nombres.remove(0);
                if (nombres.isEmpty()) {
                    if (parentItem.getMenuComponent(i) instanceof javax.swing.JMenuItem) {
                        return (javax.swing.JMenuItem)parentItem.getMenuComponent(i);
                    }
                    logger.error(PluginServices.getText(this, "Menu_type_not_supported_") + " " + parentItem.getMenuComponent(i).getClass().getName());
                    return null;
                }
                return this.getMenu(nombres, (MenuElement)((Object)parentItem.getMenuComponent(i)));
            }
        } else if (parent instanceof JMenuBar) {
            JMenuBar parentItem = (JMenuBar)parent;
            for (int i = 0; i < parentItem.getMenuCount(); ++i) {
                if (parentItem.getMenu(i).getName() == null || parentItem.getMenu(i).getName().compareTo((String)nombres.get(0)) != 0) continue;
                nombres.remove(0);
                if (nombres.isEmpty()) {
                    if (parentItem.getMenu(i) instanceof javax.swing.JMenuItem) {
                        return parentItem.getMenu(i);
                    }
                    logger.error(PluginServices.getText(this, "Menu_type_not_supported_") + " " + parentItem.getMenu(i).getClass().getName());
                    return null;
                }
                return this.getMenu(nombres, parentItem.getMenu(i));
            }
        } else {
            logger.error(PluginServices.getText(this, "Menu_type_not_supported_") + " " + parent.getClass().getName() + " " + parent.toString());
        }
        return null;
    }

    private boolean lastMenuItemWithoutName(Component mc, List names) {
        if (names == null || names.size() != 1) {
            return false;
        }
        if (!(mc instanceof JMenuItem)) {
            return false;
        }
        JMenuItem jmi = (JMenuItem)mc;
        if (jmi.getName() != null) {
            return false;
        }
        if (jmi.getText() == null) {
            return false;
        }
        return jmi.getText().compareTo((String)names.get(0)) == 0;
    }

    private JMenu createMenus(ArrayList nombres, JMenu padre) {
        if (!SwingUtilities.isEventDispatchThread()) {
            logger.warn("Este metodo requiere que se este ejecutando en el hilo de eventos de AWT.");
            throw new RuntimeException("No Event Dispatch Thread");
        }
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        if (nombres.isEmpty()) {
            return padre;
        }
        JMenu buscado = null;
        for (int i = 0; i < padre.getMenuComponentCount(); ++i) {
            try {
                JMenu hijo = (JMenu)padre.getMenuComponent(i);
                if (hijo.getName().compareTo((String)nombres.get(0)) != 0) continue;
                buscado = hijo;
                continue;
            }
            catch (ClassCastException hijo) {
                // empty catch block
            }
        }
        if (buscado != null) {
            nombres.remove(0);
            return this.createMenus(nombres, buscado);
        }
        String nombre = (String)nombres.get(0);
        JMenuTraslatable menuPadre = new JMenuTraslatable(i18nManager.getTranslation(nombre));
        menuPadre.setTextKey(nombre);
        menuPadre.setName(nombre);
        this.addControl(menuPadre);
        padre.add(menuPadre);
        nombres.remove(0);
        return this.createMenus(nombres, menuPadre);
    }

    private void ajustarToolBar() {
        int margen = 8;
        int numFilas = 1;
        double acum = margen;
        int toolHeight = 0;
        for (int i = 0; i < this.toolBars.getComponentCount(); ++i) {
            Component c = this.toolBars.getComponent(i);
            if (!c.isVisible()) continue;
            double width = c.getPreferredSize().getWidth();
            if ((acum += width) > (double)this.getWidth()) {
                ++numFilas;
                acum = width + (double)margen;
            }
            if (!(c.getPreferredSize().getHeight() > (double)toolHeight)) continue;
            toolHeight = c.getPreferredSize().height;
        }
        this.toolBars.setPreferredSize(new Dimension(this.getWidth(), numFilas * toolHeight));
        this.toolBars.updateUI();
    }

    public void setClassesExtensions(Map<Class<? extends IExtension>, ExtensionDecorator> classesExtensions) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionName = "(unknow)";
        try {
            JComponent control = (JComponent)e.getSource();
            actionName = control.getName();
            ActionInfoManager actionManager = PluginsLocator.getActionInfoManager();
            ActionInfo action = actionManager.getAction(control.getName());
            Object[] args = null;
            if (control instanceof IControl) {
                args = ((IControl)control).getValue();
            } else if (FutureUtils.use((String)"ADD_EVENT_MODIFIERS_IN_ACTION_EXECUTE")) {
                args = new Object[]{"--awtmodifiers=", e.getModifiers()};
            }
            if (args == null) {
                action.execute();
            } else {
                action.execute((Object)args);
            }
            String actionCommand = e.getActionCommand();
            try {
                JToolBarToggleButton toggle = (JToolBarToggleButton)control;
                ToggleButtonModel model = (ToggleButtonModel)toggle.getModel();
                this.selectedTool.put(model.getGroupName(), actionCommand);
            }
            catch (ClassCastException classCastException) {
            }
            catch (NullPointerException nullPointerException) {}
        }
        catch (Throwable ex) {
            logger.error("Can't perform action '" + actionName + "'.", ex);
        }
        this.enableControls();
        this.showMemory();
    }

    private String getName(String name, PluginClassLoader loader) {
        if (name.indexOf(46) == -1) {
            return loader.getPluginName() + "." + name;
        }
        return name;
    }

    public void addPopupMenu(PluginClassLoader loader, PopupMenu menu) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("No Event Dispatch Thread");
        }
        String name = this.getName(menu.getName(), loader);
        JPopUpMenu popupMenu = (JPopUpMenu)this.popupMap.get(name);
        if (popupMenu == null) {
            popupMenu = new JPopUpMenu(menu.getName());
            this.popupMap.put(name, popupMenu);
        }
        Menu[] menues = menu.getMenu();
        for (int i = 0; i < menues.length; ++i) {
            JMenuItem nuevoMenu = this.createJMenuItem(loader, menues[i]);
            popupMenu.add(nuevoMenu);
        }
    }

    private JMenuItem createJMenuItem(PluginClassLoader loader, Menu menu) {
        ActionInfoManager actionManager;
        ActionInfo actionInfo;
        JMenuItem nuevoMenu = null;
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        String text = menu.getText();
        int n = text.lastIndexOf(47);
        if (n >= 0) {
            text = text.substring(n + 1);
        }
        String translatedText = i18nManager.getTranslation(text);
        IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        if (menu.getIcon() != null) {
            if (iconTheme.exists(menu.getIcon())) {
                ImageIcon image = iconTheme.get(menu.getIcon());
                nuevoMenu = new JMenuItem(translatedText, image);
            } else {
                nuevoMenu = new JMenuItem(translatedText);
                logger.info("menu icon '" + menu.getIcon() + "' not exists.");
            }
        } else {
            nuevoMenu = new JMenuItem(translatedText);
        }
        nuevoMenu.setTextKey(text);
        nuevoMenu.setName(menu.getName());
        if (menu.getKey() != null) {
            nuevoMenu.setAccelerator(KeyMapping.getKeyStroke(menu.getKey()));
        }
        nuevoMenu.setActionCommand(menu.getActionCommand());
        if (menu.getTooltip() != null) {
            nuevoMenu.setToolTip(i18nManager.getTranslation(menu.getTooltip()));
            nuevoMenu.setToolTipKey(menu.getTooltip());
        }
        if (menu.getEnableText() != null) {
            nuevoMenu.setEnableText(i18nManager.getTranslation(menu.getEnableText()));
        }
        nuevoMenu.setEnabled(true);
        nuevoMenu.setVisible(true);
        if (menu.getName() != null && (actionInfo = (actionManager = PluginsLocator.getActionInfoManager()).getAction(menu.getName())) != null) {
            nuevoMenu.addActionListener(actionInfo);
        }
        return nuevoMenu;
    }

    private JMenuItem createJMenuItem(ActionInfo action, String text) {
        KeyStroke key;
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        String label = null;
        if (text == null) {
            label = action.getLabel();
        } else if (text.contains("/")) {
            String[] ss = text.split("/");
            label = ss[ss.length - 1];
        } else {
            label = text;
        }
        JMenuItem nuevoMenu = new JMenuItem();
        nuevoMenu.setTextKey(label);
        nuevoMenu.setText(i18nManager.getTranslation(label));
        nuevoMenu.setName(action.getName());
        if (action.getIconName() != null) {
            nuevoMenu.setIcon(action.getIcon());
        }
        if ((key = action.getKeyStroke()) != null) {
            nuevoMenu.setAccelerator(key);
        }
        nuevoMenu.setActionCommand(action.getCommand());
        if (action.getTooltip() != null) {
            nuevoMenu.setToolTip(i18nManager.getTranslation(action.getTooltip()));
            nuevoMenu.setToolTipKey(action.getTooltip());
        }
        nuevoMenu.setEnabled(true);
        nuevoMenu.setVisible(true);
        ActionInfoManager actionManager = PluginsLocator.getActionInfoManager();
        nuevoMenu.addActionListener(e -> {
            ActionInfo a = actionManager.getAction(action.getName());
            if (a == null) {
                action.actionPerformed(e);
            } else {
                a.actionPerformed(e);
            }
        });
        return nuevoMenu;
    }

    private void showPopupMenu(String name, int x, int y, Component c) {
        JPopupMenu menu = (JPopupMenu)this.popupMap.get(name);
        if (menu != null) {
            menu.show(c, x, y);
        }
    }

    public void removePopupMenuListener(String name, ActionListener listener) {
        JPopupMenu menu = (JPopupMenu)this.popupMap.get(name);
        if (menu != null) {
            Component[] jmenuitems = menu.getComponents();
            for (int i = 0; i < jmenuitems.length; ++i) {
                if (!(jmenuitems[i] instanceof JMenuItem)) continue;
                ((JMenuItem)jmenuitems[i]).removeActionListener(listener);
            }
        }
    }

    public void addPopupMenuListener(String popupName, Component c, ActionListener listener, PluginClassLoader loader) {
        final String name = this.getName(popupName, loader);
        JPopupMenu menu = (JPopupMenu)this.popupMap.get(name);
        if (menu != null) {
            Component[] jmenuitems = menu.getComponents();
            for (int i = 0; i < jmenuitems.length; ++i) {
                if (!(jmenuitems[i] instanceof JMenuItem)) continue;
                ((JMenuItem)jmenuitems[i]).addActionListener(listener);
            }
        }
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    MDIFrame.this.showPopupMenu(name, e.getX(), e.getY(), e.getComponent());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    MDIFrame.this.showPopupMenu(name, e.getX(), e.getY(), e.getComponent());
                }
            }
        });
    }

    @Override
    public void enableControls() {
        JPanel f;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MDIFrame.this.enableControls();
                }
            });
            return;
        }
        ActionInfoManager actionManager = PluginsLocator.getActionInfoManager();
        ActionInfoStatusCache cache = actionManager.createActionStatusCache();
        Iterator<JComponent> e = this.controlsIterator();
        while (e.hasNext()) {
            JComponent control = e.next();
            String actionName = control.getName();
            if (StringUtils.isEmpty((CharSequence)actionName)) continue;
            ActionInfo action = actionManager.getAction(actionName);
            try {
                boolean enabled = false;
                boolean visible = false;
                if (action == null) {
                    if (control instanceof DropDownButton) {
                        DropDownButton dropDownButton = (DropDownButton)control;
                        visible = !dropDownButton.isAllHiden();
                        boolean bl = enabled = !dropDownButton.isAllDisabled();
                        if (visible && enabled) {
                            dropDownButton.updateMainButton();
                        }
                    } else if (control instanceof JMenuTraslatable) {
                        enabled = true;
                        visible = true;
                    } else {
                        IExtension extension = this.control2extensions.get(control);
                        if (extension != null) {
                            enabled = extension.isEnabled();
                            visible = extension.isVisible();
                        } else {
                            logger.warn("Can't enable/show control '" + control.getClass().getName() + "/" + control.getName() + ".");
                            enabled = true;
                            visible = true;
                        }
                    }
                } else {
                    enabled = false;
                    visible = cache.isVisible(action);
                    if (visible) {
                        enabled = cache.isEnabled(action);
                    }
                }
                control.setEnabled(enabled);
                control.setVisible(visible);
            }
            catch (Throwable ex) {
                logger.info("Can't enable/show control '" + actionName + "'.", ex);
                this.message("Can't enable/show control '" + actionName + "'.", 0);
                try {
                    control.setEnabled(false);
                    control.setVisible(false);
                }
                catch (Exception visible) {}
            }
        }
        for (int i = 0; i < this.menuBar.getMenuCount(); ++i) {
            String text;
            char mnemonic;
            JMenu menu = this.menuBar.getMenu(i);
            this.hideMenus(menu);
            if (!(menu instanceof JMenu)) continue;
            Component[] comps = menu.getMenuComponents();
            char[] mnemonics = new char[comps.length];
            if (comps.length > 0 && ' ' != (mnemonic = this.getMnemonic(text = menu.getText(), mnemonics))) {
                menu.setMnemonic(mnemonic);
                mnemonics[0] = mnemonic;
            }
            this.hideSeparatorsAndMakeMnemonics(menu, mnemonics);
        }
        for (JComponent t : this.toolBarMap.values()) {
            boolean todosOcultos = true;
            for (int i = 0; i < t.getComponentCount(); ++i) {
                if (t.getComponent(i) instanceof JSeparator || !t.getComponent(i).isVisible()) continue;
                todosOcultos = false;
            }
            if (todosOcultos) {
                t.setVisible(false);
                continue;
            }
            if (t instanceof SelectableToolBar) {
                t.setVisible(((SelectableToolBar)t).getAndamiVisibility());
                continue;
            }
            t.setVisible(true);
        }
        if (this.mdiManager != null && (f = (JPanel)((Object)this.mdiManager.getActiveWindow())) != null && this.lastLabelClass != f.getClass()) {
            this.lastLabelClass = f.getClass();
            Label[] lbls = (Label[])this.classLabels.get(this.lastLabelClass);
            if (lbls != null) {
                this.bEstado.setLabelSet(lbls);
            }
        }
        this.ajustarToolBar();
        this.showMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void refreshControls() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MDIFrame.this.refreshControls();
                }
            });
            return;
        }
        if (this.refreshingControls) {
            return;
        }
        try {
            this.refreshingControls = true;
            ActionInfoManager actionManager = PluginsLocator.getActionInfoManager();
            ActionInfoStatusCache cache = actionManager.createActionStatusCache();
            IconTheme icontheme = ToolsSwingLocator.getIconThemeManager().getCurrent();
            Iterator<JComponent> e = this.controlsIterator();
            while (e.hasNext()) {
                String actionlName;
                ActionInfo action;
                JComponent control = e.next();
                if (control instanceof TranslatableButtonHelper.TranslatableButton) {
                    ((TranslatableButtonHelper.TranslatableButton)((Object)control)).translate();
                }
                if ((action = actionManager.getAction(actionlName = control.getName())) == null || !(control instanceof AbstractButton)) continue;
                AbstractButton button = (AbstractButton)control;
                if (control instanceof javax.swing.JMenuItem) {
                    if (action.getIconName() == null || action.getIconName().length() <= 0 || !icontheme.exists(action.getIconName())) continue;
                    button.setIcon(action.getIcon());
                    continue;
                }
                button.setIcon(action.getIcon());
            }
            this.enableControls();
        }
        finally {
            this.refreshingControls = false;
        }
    }

    @Override
    public void message(String msg, int messageTyoe) {
        this.getStatusBar().message(msg, messageTyoe);
    }

    private boolean hideMenus(MenuElement menu) {
        MenuElement[] submenus = menu.getSubElements();
        if (submenus.length == 0) {
            return menu.getComponent().isVisible();
        }
        boolean visible = false;
        for (int i = 0; i < submenus.length; ++i) {
            if (!this.hideMenus(submenus[i])) continue;
            if (!(menu instanceof JPopupMenu)) {
                menu.getComponent().setVisible(true);
            }
            visible = true;
        }
        if (visible) {
            return true;
        }
        menu.getComponent().setVisible(false);
        return false;
    }

    private void hideSeparatorsAndMakeMnemonics(MenuElement menu, char[] mnemonics) {
        boolean allowSeparator = false;
        Component[] comps = ((JMenu)menu).getMenuComponents();
        if (comps.length < 1) {
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            String text;
            char mnemonic;
            if (comps[i] instanceof JSeparator) {
                if (allowSeparator) {
                    comps[i].setVisible(false);
                    for (int j = i; j < comps.length; ++j) {
                        if (comps[j] instanceof JSeparator || !comps[j].isVisible()) continue;
                        comps[i].setVisible(true);
                        break;
                    }
                } else {
                    comps[i].setVisible(false);
                }
                allowSeparator = false;
                continue;
            }
            if (comps[i] instanceof JMenu) {
                Component[] scomps = ((JMenu)comps[i]).getMenuComponents();
                char[] smnemonics = new char[scomps.length];
                this.hideSeparatorsAndMakeMnemonics((MenuElement)((Object)comps[i]), smnemonics);
                if (!comps[i].isVisible()) continue;
                allowSeparator = true;
                String text2 = ((JMenu)comps[i]).getText();
                char mnemonic2 = this.getMnemonic(text2, mnemonics);
                if (' ' == mnemonic2) continue;
                ((JMenu)comps[i]).setMnemonic(mnemonic2);
                mnemonics[i] = mnemonic2;
                continue;
            }
            if (!comps[i].isVisible()) continue;
            if (comps[i] instanceof JMenuItem && ' ' != (mnemonic = this.getMnemonic(text = ((JMenuItem)comps[i]).getText(), mnemonics))) {
                ((JMenuItem)comps[i]).setMnemonic(mnemonic);
                mnemonics[i] = mnemonic;
            }
            allowSeparator = true;
        }
    }

    private char getMnemonic(String text, char[] mnemonics) {
        if (text == null) {
            return ' ';
        }
        Vector<String> words = new Vector<String>();
        StringTokenizer t = new StringTokenizer(text);
        int maxsize = 0;
        while (t.hasMoreTokens()) {
            String word = t.nextToken();
            if (word.length() > maxsize) {
                maxsize = word.length();
            }
            words.addElement(word);
        }
        words.trimToSize();
        for (int i = 0; i < maxsize; ++i) {
            char mnemonic = this.getMnemonic(words, mnemonics, i);
            if (' ' == mnemonic) continue;
            return mnemonic;
        }
        return ' ';
    }

    private char getMnemonic(Vector words, char[] mnemonics, int index) {
        int numwords = words.size();
        for (int i = 0; i < numwords; ++i) {
            char c;
            String word = (String)words.elementAt(i);
            if (index >= word.length() || this.isMnemonicExists(c = word.charAt(index), mnemonics) || c == ':' || c == '.' || c == ',' || c == ';' || c == '-' || c == '+' || c == '/' || c == '\\' || c == '\'' || c == '\"' || c == ' ' || c == '=' || c == '(' || c == ')' || c == '[' || c == ']' || c == '{' || c == '}' || c == '$' || c == '*' || c == '&' || c == '%' || c == '!' || c == '?' || c == '#' || c == '~' || c == '_') continue;
            return c;
        }
        return ' ';
    }

    private boolean isMnemonicExists(char c, char[] mnemonics) {
        int num = mnemonics.length;
        for (int i = 0; i < num; ++i) {
            if (mnemonics[i] != c) continue;
            return true;
        }
        return false;
    }

    private void showMemory() {
        Runtime r = Runtime.getRuntime();
        long mem = r.totalMemory() - r.freeMemory();
        logger.debug(PluginServices.getText(this, "memory_usage") + " " + mem / 1024L + " KB");
    }

    public MDIManager getMDIManager() {
        return this.mdiManager;
    }

    @Override
    public NewStatusBar getStatusBar() {
        return this.bEstado;
    }

    @Override
    public void setSelectedTool(String actionCommand) {
        this.setSelectedTool(this.defaultGroup, actionCommand);
    }

    public void setSelectedTool(String groupName, String actionCommand) {
        ButtonGroup group = (ButtonGroup)this.buttonGroupMap.get(groupName);
        if (group == null) {
            return;
        }
        Enumeration<AbstractButton> enumeration = group.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            if (button instanceof DropDownButton) {
                ((DropDownButton)button).setSelected(actionCommand, true);
                continue;
            }
            if (!button.getActionCommand().equals(actionCommand)) continue;
            button.setSelected(true);
        }
        this.selectedTool.put(groupName, actionCommand);
    }

    public void setSelectedTools(Map selectedTools) {
        this.selectedTool = selectedTools;
        if (selectedTools == null) {
            return;
        }
        Iterator groupNames = selectedTools.keySet().iterator();
        while (groupNames.hasNext()) {
            try {
                String groupName = (String)groupNames.next();
                ButtonGroup group = (ButtonGroup)this.buttonGroupMap.get(groupName);
                Enumeration<AbstractButton> enumeration = group.getElements();
                String actionCommand = (String)selectedTools.get(groupName);
                if (actionCommand == null) continue;
                while (enumeration.hasMoreElements()) {
                    AbstractButton button = enumeration.nextElement();
                    if (button == null || !StringUtils.equals((CharSequence)button.getActionCommand(), (CharSequence)actionCommand)) continue;
                    button.setSelected(true);
                }
            }
            catch (ClassCastException ex) {
                logger.error("selectedTool should only contain pairs (String groupName, JToolBarToggleButton button)", (Throwable)ex);
            }
        }
    }

    @Override
    public void setStatusBarLabels(Class<?> clase, Label[] label) {
        this.classLabels.put(clase, label);
    }

    @Override
    public void removeStatusBarLabels(Class<?> clase) {
        this.classLabels.remove(clase);
    }

    @Override
    public void addStatusBarControl(Class<?> extensionClass, IControl control) {
        control.addActionListener((ActionListener)this);
        this.bEstado.addControl(control.getName(), (Component)control);
        if (control instanceof JComponent) {
            this.addControl((JComponent)control);
            PluginsManager pluginsManager = PluginsLocator.getManager();
            IExtension extension = pluginsManager.getExtension(extensionClass);
            this.control2extensions.put((JComponent)control, extension);
        }
    }

    @Override
    public void addToolBarControl(Class<?> extensionClass, JToolBar control, String name) {
        this.toolBars.add(control);
        this.addControl(control);
        PluginsManager pluginsManager = PluginsLocator.getManager();
        IExtension extension = pluginsManager.getExtension(extensionClass);
        this.control2extensions.put(control, extension);
    }

    @Override
    public void removeStatusBarControl(String name) {
        Component c = this.bEstado.removeControl(name);
        if (c instanceof JComponent) {
            this.removeControl((JComponent)c);
        }
    }

    @Override
    public void removeMenu(Menu menu) {
        JMenuItem delete = (JMenuItem)this.infoCodedMenus.get(menu);
        if (delete == null) {
            throw new NoSuchElementException(menu.getText());
        }
        delete.getParent().remove(delete);
        this.infoCodedMenus.remove(menu);
    }

    @Override
    public void addMenu(Menu menu, ActionListener listener, PluginClassLoader loader) {
        JMenu menuPadre = this.createMenuAncestors(menu, loader);
        JMenuItem nuevoMenu = this.createJMenuItem(loader, menu);
        nuevoMenu.addMouseListener(this.tooltipListener);
        if (listener != null && menu.getName() != null && menu.getName().trim().length() > 0) {
            ActionInfoManager actionManager = PluginsLocator.getActionInfoManager();
            ActionInfo actionInfo = actionManager.getAction(menu.getName());
            if (actionInfo != null) {
                nuevoMenu.removeActionListener(actionInfo);
            }
            nuevoMenu.addActionListener(listener);
        } else if (listener != null && menu.getText() != null && menu.getText().trim().length() > 0) {
            nuevoMenu.addActionListener(listener);
        }
        menuPadre.add(nuevoMenu);
        this.infoCodedMenus.put(menu, nuevoMenu);
    }

    @Override
    public void changeMenuName(String[] menu, String newName, PluginClassLoader loader) {
        ArrayList<String> menuList = new ArrayList<String>();
        for (int i = 0; i < menu.length; ++i) {
            menuList.add(menu[i]);
        }
        javax.swing.JMenuItem newMenu = this.getMenu(menuList, this.menuBar);
        if (newMenu == null) {
            throw new NoSuchMenuException(menu[0]);
        }
        newMenu.setText(PluginServices.getText(this, newName));
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        this.ajustarToolBar();
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    @Override
    public void componentAdded(ContainerEvent arg0) {
        this.ajustarToolBar();
    }

    @Override
    public void componentRemoved(ContainerEvent arg0) {
        this.ajustarToolBar();
    }

    public String getTitlePrefix() {
        return this.titlePrefix;
    }

    public void setTitlePrefix(String titlePrefix) {
        this.titlePrefix = titlePrefix;
    }

    public Map getSelectedTools() {
        return this.selectedTool;
    }

    public HashMap getInitialSelectedTools() {
        return this.initialSelectedTools;
    }

    @Override
    public JComponent getComponentByName(String name) {
        Iterator<JComponent> e = this.controlsIterator();
        while (e.hasNext()) {
            JComponent control = e.next();
            String nameCtrl = control.getName();
            if (nameCtrl == null || nameCtrl.compareTo(name) != 0) continue;
            return control;
        }
        for (JComponent t : this.toolBarMap.values()) {
            String nameCtrl = t.getName();
            if (nameCtrl == null || nameCtrl.compareTo(name) != 0) continue;
            return t;
        }
        return null;
    }

    @Override
    public SelectableToolBar[] getToolbars() {
        return this.toolBarMap.values().toArray(new SelectableToolBar[0]);
    }

    @Override
    public boolean getToolbarVisibility(String name) {
        JComponent component = PluginServices.getMainFrame().getComponentByName(name);
        if (component != null && component instanceof SelectableToolBar) {
            SelectableToolBar toolBar = (SelectableToolBar)component;
            return toolBar.getAndamiVisibility();
        }
        return false;
    }

    @Override
    public boolean setToolbarVisibility(String name, boolean visibility) {
        JComponent component = PluginServices.getMainFrame().getComponentByName(name);
        if (component != null && component instanceof SelectableToolBar) {
            SelectableToolBar toolBar = (SelectableToolBar)component;
            boolean oldVisibility = toolBar.getAndamiVisibility();
            toolBar.setAndamiVisibility(visibility);
            this.enableControls();
            return oldVisibility;
        }
        return false;
    }

    @Override
    public javax.swing.JMenuItem getMenuEntry(String[] menuPath) {
        ArrayList<String> menu = new ArrayList<String>();
        for (int i = 0; i < menuPath.length; ++i) {
            menu.add(menuPath[i]);
        }
        return this.getMenu(menu, this.menuBar);
    }

    public void messageDialog(String message, String title, int messageType) {
        DefaultThreadSafeDialogs helper = new DefaultThreadSafeDialogs(this, this.bEstado);
        helper.messageDialog(message, title, messageType);
    }

    public void messageDialog(String message, String[] messageArgs, String title, int messageType) {
        DefaultThreadSafeDialogs helper = new DefaultThreadSafeDialogs(this, this.bEstado);
        helper.messageDialog(message, messageArgs, title, messageType);
    }

    @Override
    public void messageDialog(String message, String[] messageArgs, String title, int messageType, String msgid) {
        DefaultThreadSafeDialogs helper = new DefaultThreadSafeDialogs(this, this.bEstado);
        helper.messageDialog(message, messageArgs, title, messageType, msgid);
    }

    public int confirmDialog(String message, String title, int optionType, int messageType) {
        DefaultThreadSafeDialogs helper = new DefaultThreadSafeDialogs(this, this.bEstado);
        return helper.confirmDialog(message, title, optionType, messageType);
    }

    @Override
    public int confirmDialog(String message, String title, int optionType, int messageType, String msgid) {
        DefaultThreadSafeDialogs helper = new DefaultThreadSafeDialogs(this, this.bEstado);
        return helper.confirmDialog(message, title, optionType, messageType, msgid);
    }

    public String inputDialog(String message, String title, int messageType, String initialValue) {
        DefaultThreadSafeDialogs helper = new DefaultThreadSafeDialogs(this, this.bEstado);
        return helper.inputDialog(message, title, messageType, initialValue);
    }

    public String inputDialog(String message, String title) {
        DefaultThreadSafeDialogs helper = new DefaultThreadSafeDialogs(this, this.bEstado);
        return helper.inputDialog(message, title);
    }

    @Override
    public void showDialog(Component contents, String title) {
        DefaultThreadSafeDialogs helper = new DefaultThreadSafeDialogs(this, this.bEstado);
        helper.showDialog(contents, title);
    }

    public Component createComponent(Class<? extends Component> theClass, Object ... parameters) {
        DefaultThreadSafeDialogs helper = new DefaultThreadSafeDialogs(this, this.bEstado);
        return helper.createComponentWithParams(theClass, parameters);
    }

    public Component createComponentWithParams(Class<? extends Component> theClass, Object[] parameters) {
        DefaultThreadSafeDialogs helper = new DefaultThreadSafeDialogs(this, this.bEstado);
        return helper.createComponentWithParams(theClass, parameters);
    }

    public File[] showChooserDialog(String title, int type, int selectionMode, boolean multiselection, File initialPath, FileFilter filter, boolean fileHidingEnabled) {
        DefaultThreadSafeDialogs helper = new DefaultThreadSafeDialogs(this, this.bEstado);
        return helper.showChooserDialog(title, type, selectionMode, multiselection, initialPath, filter, fileHidingEnabled);
    }

    public ImmutablePair<File[], Charset> showChooserDialog(String title, int type, int selectionMode, boolean multiselection, File initialPath, FileFilter filter, boolean fileHidingEnabled, boolean askCharset) {
        DefaultThreadSafeDialogs helper = new DefaultThreadSafeDialogs(this, this.bEstado);
        return helper.showChooserDialog(title, type, selectionMode, multiselection, initialPath, filter, fileHidingEnabled, askCharset);
    }

    public File[] showChooserDialog(String title, int type, int selectionMode, boolean multiselection, File initialPath, FileFilter filter, boolean fileHidingEnabled, JComponent accesory) {
        DefaultThreadSafeDialogs helper = new DefaultThreadSafeDialogs(this, this.bEstado);
        return helper.showChooserDialog(title, type, selectionMode, multiselection, initialPath, filter, fileHidingEnabled, accesory);
    }

    public File[] showOpenDirectoryDialog(String title, File initialPath) {
        return this.showChooserDialog(title, 0, 1, false, initialPath, null, false);
    }

    public File[] showOpenFileDialog(String title, File initialPath) {
        return this.showChooserDialog(title, 0, 0, false, initialPath, null, false);
    }

    public File[] showSaveFileDialog(String title, File initialPath) {
        return this.showChooserDialog(title, 1, 0, false, initialPath, null, false);
    }

    private void addControl(JComponent control) {
        this.controls.add(control);
    }

    private void removeControl(JComponent control) {
        this.controls.remove(control);
    }

    private Iterator<JComponent> controlsIterator() {
        return this.controls.iterator();
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        MDIManager mdiManager = MDIManagerFactory.createManager();
        mdiManager.setLocale(locale);
        if (this.controls != null && !this.controls.isEmpty()) {
            this.refreshControls();
        }
    }

    public class TooltipListener
    extends MouseAdapter {
        @Override
        public void mouseEntered(MouseEvent e) {
            JComponent control = (JComponent)e.getSource();
            EnableTextSupport ets = (EnableTextSupport)e.getSource();
            String texto = null;
            texto = control.getToolTipText();
            if (texto != null) {
                MDIFrame.this.bEstado.setInfoTextTemporal(texto);
            }
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            MDIFrame.this.bEstado.restaurarTexto();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            MDIFrame.this.bEstado.restaurarTexto();
        }
    }

    private class JMenuTraslatable
    extends JMenu
    implements TranslatableButtonHelper.TranslatableButton {
        private TranslatableButtonHelper i18nHelper;

        public JMenuTraslatable(String text) {
            super(text);
            this.i18nHelper = new TranslatableButtonHelper();
        }

        @Override
        public void setTextKey(String key) {
            this.i18nHelper.setText(key);
        }

        @Override
        public void setToolTipKey(String key) {
            this.i18nHelper.setTooltip(key);
        }

        @Override
        public void translate() {
            if (this.i18nHelper.needTranslation()) {
                this.i18nHelper.translate();
                this.setText(this.i18nHelper.getText());
            }
        }
    }
}

