/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.ui.theme;

import java.awt.Color;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.Launcher;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Theme {
    private static final Logger logger = LoggerFactory.getLogger(Theme.class);
    public static final String CENTERED = "CENTERED";
    public static final String EXPAND = "EXPAND";
    public static final String MOSAIC = "MOSAIC";
    private static final String ANDAMI_PROPERTIES = "AndamiProperties";
    private static final String APPLICATION_IMAGES = "ApplicationImages";
    private static final String SPLASH_IMAGES = "SplashImages";
    private static final String SPLASH = "Splash";
    private static final String PATH = "path";
    private static final String TIMER = "timer";
    private static final String ICON = "Icon";
    private static final String APPLICATION_NAME = "ApplicationName";
    private static final String PRIORITY = "priority";
    private static final String VALUE = "value";
    private static final String BACKGROUND_IMAGE = "BackgroundImage";
    private static final String BACKGROUND_COLOR = "BackgroundColor";
    private static final String WALLPAPER_TYPE = "WallpaperType";
    private static final String VERSION = "version";
    private static final String FONTPOSITIONX = "x";
    private static final String FONTPOSITIONY = "y";
    private static final String FONTSIZE = "fontsize";
    private static final String FONTCOLOR = "color";
    private ArrayList<String> images = new ArrayList();
    private String icon;
    private ArrayList<String> timers = new ArrayList();
    private ArrayList<String> versions = new ArrayList();
    private ArrayList<String> fontColors = new ArrayList();
    private ArrayList<String> fontSizes = new ArrayList();
    private ArrayList<String> fontpositionsX = new ArrayList();
    private ArrayList<String> fontpositionsY = new ArrayList();
    private String name = null;
    private String backgroundimage = null;
    private Color backgroundColor = null;
    private String wallpaperType = "CENTERED";
    private int priority = 0;
    private File source = null;
    private StrSubstitutor strSubstitutor = null;

    public Theme() {
    }

    public Theme(Map vars) {
        this();
        this.strSubstitutor = new StrSubstitutor(vars);
    }

    public File getSource() {
        return this.source;
    }

    /*
     * Exception decompiling
     */
    public void readTheme(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String fixPath(File theme, String path) {
        path = path.replace("$GVSIG_INSTALL", Launcher.getApplicationDirectory());
        path = path.replace("$GVSIG_HOME", Launcher.getAppHomeDir());
        path = path.replace("$GVSIG_PLUGINS", Launcher.getAndamiConfig().getPluginsDirectory());
        File parent = theme.getParentFile().getAbsoluteFile();
        File fpath = new File(path);
        if (!fpath.isAbsolute()) {
            fpath = new File(parent, path);
        }
        return fpath.getAbsolutePath();
    }

    public ImageIcon[] getSplashImages() {
        ImageIcon[] imgs = new ImageIcon[this.images.size()];
        for (int i = 0; i < this.images.size(); ++i) {
            imgs[i] = new ImageIcon(this.images.get(i));
        }
        return imgs;
    }

    public String getTypeDesktop() {
        return this.wallpaperType;
    }

    public ImageIcon getIcon() {
        if (this.icon == null) {
            return null;
        }
        try {
            return new ImageIcon(this.icon);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ImageIcon getBackgroundImage() {
        if (this.backgroundimage == null) {
            return null;
        }
        try {
            return new ImageIcon(this.backgroundimage);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Color getBackgroundColor() {
        if (this.backgroundColor == null) {
            this.backgroundColor = (Color)UIManager.get("Desktop.background");
        }
        return this.backgroundColor;
    }

    public int[] getTimers() {
        int[] tms = new int[this.timers.size()];
        for (int i = 0; i < tms.length; ++i) {
            tms[i] = Integer.parseInt(this.timers.get(i));
        }
        return tms;
    }

    public String getName() {
        return this.name;
    }

    public String[] getVersions() {
        return this.versions.toArray(new String[0]);
    }

    public Point[] getPositions() {
        Point[] points = new Point[this.fontpositionsX.size()];
        for (int i = 0; i < points.length; ++i) {
            try {
                points[i] = new Point(Integer.valueOf(this.fontpositionsX.get(i)), Integer.valueOf(this.fontpositionsY.get(i)));
                continue;
            }
            catch (NumberFormatException e) {
                NotificationManager.addInfo(PluginServices.getText(this, "incorrect_position"), e);
            }
        }
        return points;
    }

    public int[] getFontSizes() {
        int[] sizes = new int[this.fontSizes.size()];
        for (int i = 0; i < sizes.length; ++i) {
            try {
                sizes[i] = Integer.valueOf(this.fontSizes.get(i));
                continue;
            }
            catch (NumberFormatException e) {
                NotificationManager.addInfo(PluginServices.getText(this, "incorrect_size"), e);
            }
        }
        return sizes;
    }

    public Color[] getFontColors() {
        Color[] colors = new Color[this.fontColors.size()];
        for (int i = 0; i < colors.length; ++i) {
            try {
                String s = this.fontColors.get(i);
                colors[i] = this.parseColor(s);
                continue;
            }
            catch (Exception e) {
                NotificationManager.addInfo(PluginServices.getText(this, "incorrect_color"), e);
            }
        }
        return colors;
    }

    private Color parseColor(String s) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        if (s.contains(",")) {
            String[] rgb = s.split(",");
            Color color = new Color(Integer.valueOf(rgb[0]), Integer.valueOf(rgb[1]), Integer.valueOf(rgb[2]));
            return color;
        }
        if (s.length() == 6) {
            Color color = new Color(Integer.parseInt(s.substring(0, 2), 16), Integer.parseInt(s.substring(2, 4), 16), Integer.parseInt(s.substring(4, 6), 16));
            return color;
        }
        return null;
    }

    private String expand(String value) {
        if (this.strSubstitutor == null) {
            return value;
        }
        return this.strSubstitutor.replace(value);
    }

    public int getPriority() {
        return this.priority;
    }
}

