/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.algorithm.process;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.SwingUtilities;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.process.CancelEvent;
import org.gvsig.fmap.dal.coverage.process.TaskEventManager;
import org.gvsig.raster.algorithm.gui.IIncrementable;
import org.gvsig.raster.algorithm.gui.IncrementableEvent;
import org.gvsig.raster.algorithm.gui.IncrementableListener;
import org.gvsig.raster.algorithm.gui.IncrementableTask;
import org.gvsig.raster.algorithm.process.IProcessActions;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.algorithm.process.ProcessParamsManagement;
import org.gvsig.tools.dispose.Disposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataProcess
extends ProcessParamsManagement
implements IIncrementable,
IncrementableListener,
Runnable,
Disposable {
    protected IncrementableTask incrementableTask = null;
    protected volatile Thread blinker = null;
    protected TaskEventManager taskEventManager = null;
    protected IProcessActions externalActions = null;
    protected Hashtable<String, Object> taskParams = new Hashtable();
    private String log = "";
    private String lastLine = "";
    private long time = 0L;
    private boolean progressActive = true;
    private IProcessActions queueActions = null;
    protected Logger logger = LoggerFactory.getLogger((String)DataProcess.class.toString());
    private int percent = 0;
    private String processName = null;

    public IncrementableTask getIncrementableTask() {
        if (this.incrementableTask == null) {
            this.incrementableTask = new IncrementableTask(this);
            this.incrementableTask.addIncrementableListener(this);
        }
        return this.incrementableTask;
    }

    public void setCancelable(boolean enabled) {
        this.getIncrementableTask().getButtonsPanel().setEnabled(2, enabled);
    }

    public void showIncrementableWindow() {
        if (this.progressActive) {
            this.getIncrementableTask().showWindow();
            this.getIncrementableTask().start();
        }
    }

    public void start() {
        this.showIncrementableWindow();
        if (this.blinker == null) {
            this.blinker = new Thread(this);
        }
        this.blinker.start();
    }

    public abstract void init();

    public abstract void process() throws ProcessInterruptedException, ProcessException;

    public HashMap<String, Object> getResult() {
        this.outputParameters.put("PROCESS", this);
        this.outputParameters.put(TIME, this.getTime());
        this.outputParameters.put(PROCESS_NAME, this.getName());
        return this.outputParameters;
    }

    protected void addOutputValue(String key, Object value) {
        this.outputParameters.put(key, value);
    }

    public void execute() throws ProcessInterruptedException, ProcessException {
        this.taskEventManager = RasterLocator.getManager().createRasterTask((Object)this);
        this.loadGlobalParameters();
        this.init();
        this.process();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DataProcess.this.externalActions != null) {
                    DataProcess.this.externalActions.end(DataProcess.this.getResult());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long t1 = new Date().getTime();
        try {
            this.execute();
        }
        catch (ProcessInterruptedException e) {
            if (this.externalActions != null) {
                this.externalActions.interrupted();
            }
            Thread.currentThread().interrupt();
        }
        catch (ProcessException e) {
            if (this.progressActive && this.incrementableTask != null) {
                this.getIncrementableTask().processFinalize();
                this.incrementableTask = null;
            }
            this.logger.warn(RasterLocator.getManager().getRasterUtils().getTrace((Exception)e));
            if (e.getMessage() != null && e.getMessage().compareTo("") != 0) {
                this.messageBoxError(e.getMessage(), null);
            } else {
                this.messageBoxError("error_processing", null);
            }
            this.queueActions = null;
        }
        catch (Exception e) {
            if (this.progressActive && this.incrementableTask != null) {
                this.getIncrementableTask().processFinalize();
                this.incrementableTask = null;
            }
            this.logger.warn(RasterLocator.getManager().getRasterUtils().getTrace(e));
            if (e.getMessage() != null && e.getMessage().compareTo("") != 0) {
                this.messageBoxError(e.getMessage(), null);
            } else {
                this.messageBoxError("error_processing", null);
            }
            this.queueActions = null;
        }
        finally {
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {}
            this.taskEventManager.removeTask();
            if (this.progressActive && this.incrementableTask != null) {
                this.getIncrementableTask().processFinalize();
            }
            if (this.queueActions != null) {
                this.queueActions.end(this);
            }
            this.time = new Date().getTime() - t1;
            this.blinker = null;
        }
    }

    public void setProgressActive(boolean active) {
        this.progressActive = active;
    }

    public long getTime() {
        return this.time;
    }

    public IProcessActions getActions() {
        return this.externalActions;
    }

    public void setActions(IProcessActions actions) {
        this.externalActions = actions;
    }

    public IProcessActions getUniqueProcessActions() {
        return this.queueActions;
    }

    public void setUniqueProcessActions(IProcessActions actions) {
        this.queueActions = actions;
    }

    protected void insertLineLog(String line) {
        this.lastLine = line;
        this.log = this.log + line + "\n";
    }

    @Override
    public String getLabel() {
        return this.lastLine;
    }

    @Override
    public String getLog() {
        return this.log;
    }

    @Override
    public void actionCanceled(IncrementableEvent e) {
        this.taskEventManager.setEvent((EventObject)new CancelEvent((Object)this));
    }

    public void updatePercent(int parcial, int total) throws ProcessInterruptedException {
        if (this.taskEventManager != null && this.taskEventManager.getEvent() != null) {
            this.taskEventManager.manageEvent(this.taskEventManager.getEvent());
        }
        if (this.externalActions != null) {
            this.externalActions.updateProgress(parcial, total);
        }
        this.percent = parcial * 100 / total;
    }

    @Override
    public int getPercent() {
        return this.percent;
    }

    @Override
    public void actionResumed(IncrementableEvent e) {
    }

    @Override
    public void actionSuspended(IncrementableEvent e) {
    }

    @Override
    public boolean isCancelable() {
        return true;
    }

    @Override
    public boolean isPausable() {
        return false;
    }

    public String getName() {
        return this.processName;
    }

    public void setName(String name) {
        this.processName = name;
    }

    public void dispose() {
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void finalize() throws Throwable {
        this.incrementableTask = null;
        this.blinker = null;
        this.externalActions = null;
        super.finalize();
    }
}

