/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.algorithm.process;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.dataset.BufferParam;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.BufferCreationException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.fmap.dal.coverage.store.RasterWriter;
import org.gvsig.fmap.dal.coverage.store.parameter.NewRasterStoreParameters;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.roi.ROI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessUtils {
    private Logger log = LoggerFactory.getLogger(ProcessUtils.class);
    protected NoData doubleNODATA = RasterLocator.getManager().getDataStructFactory().createDefaultNoData(1, 5);

    public void debug(String msg, Object parent, Exception exception) {
        if (parent != null) {
            LoggerFactory.getLogger(parent.getClass()).debug(Messages.getText((String)msg), (Throwable)exception);
        }
    }

    public void messageBoxError(String msg, Object parentWindow) {
        String string = Messages.getText((String)"accept");
        Object[] options = new Object[]{string};
        JOptionPane.showOptionDialog((Component)parentWindow, "<html>" + Messages.getText((String)msg).replaceAll("\n", "<br>") + "</html>", Messages.getText((String)"confirmacion"), 0, 0, null, options, string);
    }

    public void messageBoxError(String msg, Object parentWindow, Exception exception) {
        this.debug(msg, parentWindow, exception);
        this.messageBoxError(msg, parentWindow);
    }

    public void messageBoxError(String msg, Object parentWindow, ArrayList<Exception> exception) {
        for (int i = 0; i < exception.size(); ++i) {
            this.debug(msg, parentWindow, exception.get(i));
        }
        this.messageBoxError(msg, parentWindow);
    }

    public void exportRaster(String sFilename, Buffer buf, ColorInterpretation ci, Extent windowExtent, NoData nodata, IProjection proj) {
        nodata.setFileName(sFilename);
        nodata.save();
        buf.setDataExtent(windowExtent.toRectangle2D());
        DataManager manager = DALLocator.getDataManager();
        String provider = "Gdal Store";
        try {
            DataServerExplorerParameters eparams = manager.createServerExplorerParameters("FilesystemExplorer");
            DataServerExplorer serverExplorer = manager.openServerExplorer(eparams.getExplorerName(), eparams);
            NewRasterStoreParameters sparams = (NewRasterStoreParameters)serverExplorer.getAddParameters(provider);
            sparams.setBuffer(buf);
            sparams.setColorInterpretation(ci.getValues());
            sparams.setProjection(proj);
            sparams.setDestination(sFilename);
            serverExplorer.add("Gdal Store", (NewDataStoreParameters)sparams, true);
        }
        catch (InitializeException e) {
            this.log.debug("Error saving the file of the process", (Throwable)e);
        }
        catch (ProviderNotRegisteredException e) {
            this.log.debug("Error saving the file of the process", (Throwable)e);
        }
        catch (ValidateDataParametersException e) {
            this.log.debug("Error saving the file of the process", (Throwable)e);
        }
        catch (DataException e) {
            this.log.debug("Error saving the file of the process", (Throwable)e);
        }
    }

    public boolean exportRaster(String sFilename, Buffer buf, double cellsize, double minX, double minY, NoData nodata) {
        return this.exportRaster(sFilename, buf, cellsize, minX, minY);
    }

    public boolean exportRaster(String sFilename, Buffer buf, double cellsize, double minX, double minY, NoData nodata, IProjection proj) {
        boolean result = this.exportRaster(sFilename, buf, cellsize, minX, minY, proj);
        nodata.setFileName(sFilename);
        nodata.save();
        return result;
    }

    public boolean exportRaster(String sFilename, Buffer buf, Buffer alphaBuffer, double cellsize, double ulx, double uly, IProjection proj) {
        try {
            RasterManager manager = RasterLocator.getManager();
            DataServerWriter writerBufferServer = manager.createDataServerWriter();
            writerBufferServer.setBuffer(buf, -1);
            int nBands = buf.getBandCount();
            ColorInterpretation colorInterpretation = null;
            if (alphaBuffer != null) {
                colorInterpretation = RasterLocator.getManager().getDataStructFactory().createColorInterpretation(new String[]{"Red", "Green", "Blue", "Alpha"});
            } else if (nBands == 1) {
                colorInterpretation = RasterLocator.getManager().getDataStructFactory().createColorInterpretation(new String[]{"Gray"});
            }
            Params params = manager.createWriterParams(sFilename);
            AffineTransform affineTransform = new AffineTransform(cellsize, 0.0, 0.0, -cellsize, ulx, uly);
            RasterWriter writer = manager.createWriter(writerBufferServer, sFilename, nBands, affineTransform, buf.getWidth(), buf.getHeight(), buf.getDataType(), params, proj);
            if (colorInterpretation != null) {
                writer.setColorBandsInterpretation(colorInterpretation.getValues());
            }
            writer.dataWrite();
            writer.writeClose();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean exportRaster(String sFilename, Buffer buf, Buffer alphaBuffer, double cellsize, double ulx, double uly) {
        return this.exportRaster(sFilename, buf, alphaBuffer, cellsize, ulx, uly, null);
    }

    public boolean exportRaster(String sFilename, Buffer buf, double cellsize, double ulx, double uly) {
        return this.exportRaster(sFilename, buf, null, cellsize, ulx, uly);
    }

    public boolean exportRaster(String sFilename, Buffer buf, double cellsize, double ulx, double uly, IProjection proj) {
        return this.exportRaster(sFilename, buf, null, cellsize, ulx, uly, proj);
    }

    protected Rectangle2D[] getIntersectionInPxCoords(RasterDataStore[] dataStoreList) {
        Extent extentIntersect = null;
        int nRectangles = 0;
        for (int i = 0; i < dataStoreList.length; ++i) {
            if (dataStoreList[i] == null) continue;
            extentIntersect = extentIntersect == null ? dataStoreList[i].getExtent() : extentIntersect.intersection(dataStoreList[i].getExtent());
            ++nRectangles;
        }
        Rectangle2D[] result = new Rectangle2D[nRectangles];
        Point2D.Double p1 = new Point2D.Double(extentIntersect.getULX(), extentIntersect.getULY());
        Point2D.Double p2 = new Point2D.Double(extentIntersect.getLRX(), extentIntersect.getLRY());
        int cont = 0;
        for (int i = 0; i < dataStoreList.length; ++i) {
            if (dataStoreList[i] == null) continue;
            Point2D init = dataStoreList[i].worldToRaster((Point2D)p1);
            Point2D end = dataStoreList[i].worldToRaster((Point2D)p2);
            result[cont] = new Rectangle2D.Double(init.getX(), init.getY(), Math.abs(end.getX() - init.getX()), Math.abs(end.getY() - init.getY()));
            ++cont;
        }
        return result;
    }

    public boolean isInsideOfROI(int x, int y, List<ROI> rois, Extent extentResult) {
        if (rois == null || rois.size() == 0) {
            return true;
        }
        ROI roi = rois.get(0);
        int[] shift = this.getROIAnalysisShift(extentResult, roi.getStore().getExtent(), roi.getStore().getCellSize());
        for (int i = 0; i < rois.size(); ++i) {
            if (!rois.get(i).isInsideOfPolygon(x + shift[0], y + shift[1])) continue;
            return true;
        }
        return false;
    }

    private int[] getROIAnalysisShift(Extent extentResult, Extent sourceExtent, double cellsize) {
        double xDistance = Math.abs(extentResult.getULX() - sourceExtent.getULX());
        double yDistance = Math.abs(extentResult.getULY() - sourceExtent.getULY());
        return new int[]{(int)(xDistance / cellsize), (int)(yDistance / cellsize)};
    }

    public Extent getExtentResult(Extent window, List<ROI> rois, RasterDataStore store) {
        if (window != null) {
            return window.intersection(store.getExtent());
        }
        if (rois == null) {
            return store.getExtent();
        }
        Extent maxExtent = null;
        for (int i = 0; i < rois.size(); ++i) {
            maxExtent = i == 0 ? rois.get(i).getROIExtent() : maxExtent.encloseBoundinBoxes(rois.get(i).getROIExtent());
        }
        return maxExtent.intersection(store.getExtent());
    }

    public boolean isAnalizedEntireLayer(Extent window, List<ROI> rois, RasterDataStore store) {
        return window == null && (rois == null || rois.size() == 0);
    }

    public Rectangle2D getSourcePxBox(Extent resultExtent, RasterDataStore store) {
        if (resultExtent == null || resultExtent.equals((Object)store.getExtent())) {
            return new Rectangle2D.Double(0.0, 0.0, store.getWidth(), store.getHeight());
        }
        Point2D p1 = store.worldToRaster((Point2D)new Point2D.Double(resultExtent.getULX(), resultExtent.getULY()));
        Point2D p2 = store.worldToRaster((Point2D)new Point2D.Double(resultExtent.getLRX(), resultExtent.getLRY()));
        return new Rectangle2D.Double(p1.getX(), p1.getY(), Math.abs(p2.getX() - p1.getX()), Math.abs(p2.getY() - p1.getY()));
    }

    public Buffer createOutputBuffer(int w, int h, int bandCount) {
        return this.createOutputBuffer(w, h, bandCount, 5);
    }

    public Buffer createOutputBuffer(int w, int h, int bandCount, int datatype) {
        RasterManager rManager = RasterLocator.getManager();
        BufferParam bParams = rManager.getBufferFactory().createBufferParams(w, h, bandCount, datatype, true);
        Buffer resultBuffer = null;
        try {
            resultBuffer = rManager.getBufferFactory().createBuffer(bParams);
        }
        catch (BufferCreationException e) {
            new ProcessException("Error creating the output buffer", e);
        }
        return resultBuffer;
    }

    public Buffer createSourceBuffer(RasterDataStore store, Rectangle2D sourcePxBBox, boolean[] bands) throws ProcessException {
        RasterManager rManager = RasterLocator.getManager();
        RasterQuery query = rManager.createQuery();
        query.setReadOnly(true);
        int nBands = this.getNumberOfSelectedBands(bands);
        int count = 0;
        int[] drawableBands = new int[nBands];
        for (int i = 0; i < bands.length; ++i) {
            if (!bands[i]) continue;
            drawableBands[count] = i;
            ++count;
        }
        query.setDrawableBands(drawableBands);
        query.setAreaOfInterest(new Rectangle((int)sourcePxBBox.getX(), (int)sourcePxBBox.getY(), (int)sourcePxBBox.getWidth(), (int)sourcePxBBox.getHeight()));
        try {
            Buffer buffer = null;
            try {
                buffer = store.query(query);
            }
            catch (QueryException e) {
                new ProcessException("Error creating the input buffer", e);
            }
            return buffer;
        }
        catch (ProcessInterruptedException processInterruptedException) {
            return null;
        }
    }

    private int getNumberOfSelectedBands(boolean[] b) {
        int bandCount = 0;
        for (int i = 0; i < b.length; ++i) {
            if (!b[i]) continue;
            ++bandCount;
        }
        return bandCount;
    }

    protected double getData(Buffer b, int row, int col, int band) {
        if (b.getDataType() == 0) {
            return b.getElemByte(row, col, band);
        }
        if (b.getDataType() == 5) {
            return b.getElemDouble(row, col, band);
        }
        if (b.getDataType() == 4) {
            return b.getElemFloat(row, col, band);
        }
        if (b.getDataType() == 3) {
            return b.getElemInt(row, col, band);
        }
        if (b.getDataType() == 2) {
            return b.getElemShort(row, col, band);
        }
        return this.doubleNODATA.getValue().doubleValue();
    }
}

