/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.algorithm.util;

import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;

public class Interpolation {
    private Buffer buffer = null;
    private double nodata = 0.0;

    public Interpolation(Buffer buf) {
        this.buffer = buf;
        NoData nodata = RasterLocator.getManager().getDataStructFactory().createDefaultNoData(1, 5);
        this.nodata = nodata.getValue().doubleValue();
    }

    private double[] getKernel(int x, int y, int band) {
        if (this.buffer.getDataType() == 0) {
            return this.getKernelByte(x, y, band);
        }
        if (this.buffer.getDataType() == 5) {
            return this.getKernelByte(x, y, band);
        }
        if (this.buffer.getDataType() == 4) {
            return this.getKernelByte(x, y, band);
        }
        if (this.buffer.getDataType() == 2) {
            return this.getKernelByte(x, y, band);
        }
        if (this.buffer.getDataType() == 3) {
            return this.getKernelByte(x, y, band);
        }
        return null;
    }

    public double getNearestNeighbour(double x, double y, int band) {
        int dy = (int)Math.round(y);
        int dx = (int)Math.round(x);
        dy = dy < this.buffer.getHeight() ? dy : this.buffer.getHeight() - 1;
        int n = dx = dx < this.buffer.getWidth() ? dx : this.buffer.getWidth() - 1;
        if (this.buffer.getDataType() == 0) {
            return this.buffer.getElemByte(dy, dx, band);
        }
        if (this.buffer.getDataType() == 5) {
            return this.buffer.getElemDouble(dy, dx, band);
        }
        if (this.buffer.getDataType() == 4) {
            return this.buffer.getElemFloat(dy, dx, band);
        }
        if (this.buffer.getDataType() == 2) {
            return this.buffer.getElemShort(dy, dx, band);
        }
        if (this.buffer.getDataType() == 3) {
            return this.buffer.getElemInt(dy, dx, band);
        }
        return this.nodata;
    }

    public double getBilinearValue(double x, double y, int band) {
        double[] kernel = this.getKernel((int)x, (int)y, band);
        double dx = x - (double)((int)x);
        double dy = y - (double)((int)y);
        double z = 0.0;
        double n = 0.0;
        double d = (1.0 - dx) * (1.0 - dy);
        z += d * kernel[0];
        n += d;
        d = dx * (1.0 - dy);
        z += d * kernel[1];
        n += d;
        d = (1.0 - dx) * dy;
        z += d * kernel[2];
        n += d;
        d = dx * dy;
        z += d * kernel[3];
        n += d;
        double b = 0.0;
        if (n > 0.0) {
            b = z / n;
        }
        return b;
    }

    public double getInverseDistance(double x, double y, int band) {
        double[] kernel = this.getKernel((int)x, (int)y, band);
        double dx = x - (double)((int)x);
        double dy = y - (double)((int)y);
        double z = 0.0;
        double n = 0.0;
        double d = 1.0 / Math.sqrt(dx * dx + dy * dy);
        z += d * kernel[0];
        n += d;
        d = 1.0 / Math.sqrt((1.0 - dx) * (1.0 - dx) + dy * dy);
        z += d * kernel[1];
        n += d;
        d = 1.0 / Math.sqrt(dx * dx + (1.0 - dy) * (1.0 - dy));
        z += d * kernel[2];
        n += d;
        d = 1.0 / Math.sqrt((1.0 - dx) * (1.0 - dx) + (1.0 - dy) * (1.0 - dy));
        z += d * kernel[3];
        n += d;
        double b = 0.0;
        if (n > 0.0) {
            b = z / n;
        }
        return b;
    }

    private double[] getKernelByte(int x, int y, int band) {
        double[] d = new double[4];
        d[0] = this.buffer.getElemByte(y, x, band) & 0xFF;
        int nextX = x + 1 >= this.buffer.getWidth() ? x : x + 1;
        int nextY = y + 1 >= this.buffer.getHeight() ? y : y + 1;
        d[1] = this.buffer.getElemByte(y, nextX, band) & 0xFF;
        d[2] = this.buffer.getElemByte(nextY, x, band) & 0xFF;
        d[3] = this.buffer.getElemByte(nextY, nextX, band) & 0xFF;
        return d;
    }

    private double[] getKernelShort(int x, int y, int band) {
        double[] d = new double[4];
        d[0] = this.buffer.getElemShort(y, x, band) & 0xFFFF;
        int nextX = x + 1 >= this.buffer.getWidth() ? x : x + 1;
        int nextY = y + 1 >= this.buffer.getHeight() ? y : y + 1;
        d[1] = this.buffer.getElemShort(y, nextX, band) & 0xFFFF;
        d[2] = this.buffer.getElemShort(nextY, x, band) & 0xFFFF;
        d[3] = this.buffer.getElemShort(nextY, nextX, band) & 0xFFFF;
        return d;
    }

    private double[] getKernelInt(int x, int y, int band) {
        double[] d = new double[4];
        d[0] = this.buffer.getElemInt(y, x, band) & 0xFFFFFFFF;
        int nextX = x + 1 >= this.buffer.getWidth() ? x : x + 1;
        int nextY = y + 1 >= this.buffer.getHeight() ? y : y + 1;
        d[1] = this.buffer.getElemInt(y, nextX, band) & 0xFFFFFFFF;
        d[2] = this.buffer.getElemInt(nextY, x, band) & 0xFFFFFFFF;
        d[3] = this.buffer.getElemInt(nextY, nextX, band) & 0xFFFFFFFF;
        return d;
    }

    private double[] getKernelFloat(int x, int y, int band) {
        double[] d = new double[4];
        d[0] = this.buffer.getElemFloat(y, x, band);
        int nextX = x + 1 >= this.buffer.getWidth() ? x : x + 1;
        int nextY = y + 1 >= this.buffer.getHeight() ? y : y + 1;
        d[1] = this.buffer.getElemFloat(y, nextX, band);
        d[2] = this.buffer.getElemFloat(nextY, x, band);
        d[3] = this.buffer.getElemFloat(nextY, nextX, band);
        return d;
    }

    private double[] getKernelDouble(int x, int y, int band) {
        double[] d = new double[4];
        d[0] = this.buffer.getElemDouble(y, x, band);
        int nextX = x + 1 >= this.buffer.getWidth() ? x : x + 1;
        int nextY = y + 1 >= this.buffer.getHeight() ? y : y + 1;
        d[1] = this.buffer.getElemDouble(y, nextX, band);
        d[2] = this.buffer.getElemDouble(nextY, x, band);
        d[3] = this.buffer.getElemDouble(nextY, nextX, band);
        return d;
    }
}

