/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.actions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.FileSpecification;
import org.icepdf.core.pobjects.acroform.FieldDictionary;
import org.icepdf.core.pobjects.acroform.InteractiveForm;
import org.icepdf.core.pobjects.actions.FormAction;
import org.icepdf.core.pobjects.annotations.AbstractWidgetAnnotation;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmitFormAction
extends FormAction {
    private static final Logger logger = Logger.getLogger(SubmitFormAction.class.toString());
    private static final String USER_AGENT = "Mozilla/5.0";
    public int INCLUDE_EXCLUDE_BIT = 1;
    public int INCLUDE_NO_VALUE_FIELDS_BIT = 2;
    public int EXPORT_FORMAT_BIT = 4;
    public int GET_METHOD_BIT = 16;
    public int SUBMIT_COORDINATES_BIT = 4;
    public int XFDF_BIT = 32;
    public int INCLUDE_APPEND_SAVES_BIT = 64;
    public int INCLUDE_ANNOTATIONS_BIT = 64;
    public int SUBMIT_PDF_BIT = 256;
    public int CANONICAL_FORMAT_BIT = 1298;
    public int EXCL_NON_USER_ANNOTS_BIT = 4132;
    public int EXCL_F_KEY_BIT = 8264;
    public int EMBED_FORM_BIT = 33170;

    public SubmitFormAction(Library l, HashMap h) {
        super(l, h);
    }

    public List getFields() {
        List tmp = this.library.getArray(this.entries, FIELDS_KEY);
        if (tmp != null) {
            return tmp;
        }
        return null;
    }

    public FileSpecification getFileSpecification() {
        Object tmp = this.library.getObject(this.entries, F_KEY);
        if (tmp instanceof HashMap) {
            return new FileSpecification(this.library, (HashMap)tmp);
        }
        return null;
    }

    @Override
    public int executeFormAction(int x, int y) {
        if (!(!this.isExportFormat() || this.isXFDF() && this.isSubmitPDF())) {
            return this.executeHTMLSubmission(x, y);
        }
        if (this.isXFDF() && !this.isSubmitPDF()) {
            return this.executeXFDFSubmission(x, y);
        }
        if (this.isSubmitPDF()) {
            return this.executePDFSubmission(x, y);
        }
        if (this.isEmbedForm()) {
            return this.executeFormsDatFormatSubmission(x, y);
        }
        return 0;
    }

    private int executeHTMLSubmission(int x, int y) {
        FileSpecification fileSpecification = this.getFileSpecification();
        if (fileSpecification != null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("HTML Submit form action: " + fileSpecification.getFileSpecification());
            }
            HashMap<String, String> params = new HashMap<String, String>();
            InteractiveForm form = this.library.getCatalog().getInteractiveForm();
            ArrayList<Object> fields = form.getFields();
            for (Object field : fields) {
                this.descendFormTree(field, params);
            }
            if (this.isSubmitCoordinates()) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Including coordinates in submit.");
                }
                params.put("x", String.valueOf(x));
                params.put("y", String.valueOf(y));
            }
            if (this.isCanonicalFormat() && logger.isLoggable(Level.FINEST)) {
                logger.finest("Uses canonical date format.");
            }
            if (this.isGetMethod()) {
                return SubmitFormAction.sendGET(fileSpecification.getFileSpecification(), this.formatParams(params));
            }
            return SubmitFormAction.sendPOST(fileSpecification.getFileSpecification(), this.formatParams(params));
        }
        return 0;
    }

    private int executePDFSubmission(int x, int y) {
        return 0;
    }

    private int executeXFDFSubmission(int x, int y) {
        return 0;
    }

    private int executeFormsDatFormatSubmission(int x, int y) {
        return 0;
    }

    protected void descendFormTree(Object formNode, HashMap<String, String> params) {
        if (!(formNode instanceof AbstractWidgetAnnotation) && formNode instanceof FieldDictionary) {
            FieldDictionary child = (FieldDictionary)formNode;
            Object value = child.getFieldValue();
            if ((value == null || value.equals("")) && child.getKids() != null && child.getKids().size() == 1) {
                value = child.getKids().get(0);
                if (value instanceof AbstractWidgetAnnotation) {
                    value = ((FieldDictionary)((AbstractWidgetAnnotation)value).getFieldDictionary()).getFieldValue();
                } else if (value instanceof FieldDictionary) {
                    value = ((FieldDictionary)value).getFieldValue();
                }
            }
            if (value != null && !value.equals("")) {
                params.put(child.getPartialFieldName(), value.toString());
            } else if (this.isIncludeNoValueFields()) {
                params.put(child.getPartialFieldName(), value == null ? null : value.toString());
            }
        }
    }

    private static int sendGET(String url, String params) {
        int responseCode = 303;
        try {
            URL obj = new URL(url + "?" + params);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", USER_AGENT);
            responseCode = con.getResponseCode();
            if (responseCode == 200) {
                if (logger.isLoggable(Level.FINER)) {
                    String inputLine;
                    BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                    in.close();
                    logger.finer("HTTP GET response: " + response.toString());
                } else if (logger.isLoggable(Level.FINER)) {
                    logger.finer("HTTP GET failed: " + url + ", response " + responseCode);
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error processing GET: " + url, e);
        }
        return responseCode;
    }

    private static int sendPOST(String url, String params) {
        int responseCode = 303;
        try {
            URL urlObject = new URL(url);
            HttpURLConnection urlConnection = (HttpURLConnection)urlObject.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setRequestProperty("User-Agent", USER_AGENT);
            urlConnection.setDoOutput(true);
            OutputStream outputStream = urlConnection.getOutputStream();
            outputStream.write(params.getBytes());
            outputStream.flush();
            outputStream.close();
            responseCode = urlConnection.getResponseCode();
            if (responseCode == 200) {
                if (logger.isLoggable(Level.FINER)) {
                    String inputLine;
                    BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                    in.close();
                    logger.finer("HTTP POST response: " + response.toString());
                }
            } else if (logger.isLoggable(Level.FINER)) {
                logger.finer("HTTP POST failed: " + url + ", response " + responseCode);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error processing POST: " + url, e);
        }
        return responseCode;
    }

    private String formatParams(HashMap<String, String> params) {
        StringBuilder submitParams = new StringBuilder();
        for (String key : params.keySet()) {
            submitParams.append(key).append("=").append(params.get(key));
            submitParams.append("&");
        }
        if (submitParams.length() > 1) {
            return ((Object)submitParams.subSequence(0, submitParams.length() - 1)).toString();
        }
        return "";
    }

    public boolean isIncludeExclude() {
        return (this.getFlags() & this.INCLUDE_EXCLUDE_BIT) == this.INCLUDE_EXCLUDE_BIT;
    }

    public boolean isIncludeNoValueFields() {
        return (this.getFlags() & this.INCLUDE_NO_VALUE_FIELDS_BIT) == this.INCLUDE_NO_VALUE_FIELDS_BIT;
    }

    public boolean isExportFormat() {
        return (this.getFlags() & this.EXPORT_FORMAT_BIT) == this.EXPORT_FORMAT_BIT;
    }

    public boolean isGetMethod() {
        return (this.getFlags() & this.GET_METHOD_BIT) == this.GET_METHOD_BIT;
    }

    public boolean isSubmitCoordinates() {
        return (this.getFlags() & this.SUBMIT_COORDINATES_BIT) == this.SUBMIT_COORDINATES_BIT;
    }

    public boolean isXFDF() {
        return (this.getFlags() & this.XFDF_BIT) == this.XFDF_BIT;
    }

    public boolean isIncludeAppendSaves() {
        return (this.getFlags() & this.INCLUDE_APPEND_SAVES_BIT) == this.INCLUDE_APPEND_SAVES_BIT;
    }

    public boolean isIncludeAnnotations() {
        return (this.getFlags() & this.INCLUDE_ANNOTATIONS_BIT) == this.INCLUDE_ANNOTATIONS_BIT;
    }

    public boolean isSubmitPDF() {
        return (this.getFlags() & this.SUBMIT_PDF_BIT) == this.SUBMIT_PDF_BIT;
    }

    public boolean isCanonicalFormat() {
        return (this.getFlags() & this.CANONICAL_FORMAT_BIT) == this.CANONICAL_FORMAT_BIT;
    }

    public boolean isExcludeNonUserAnnots() {
        return (this.getFlags() & this.EXCL_NON_USER_ANNOTS_BIT) == this.EXCL_NON_USER_ANNOTS_BIT;
    }

    public boolean isExcludeFKey() {
        return (this.getFlags() & this.EXCL_F_KEY_BIT) == this.EXCL_F_KEY_BIT;
    }

    public boolean isEmbedForm() {
        return (this.getFlags() & this.EMBED_FORM_BIT) == this.EMBED_FORM_BIT;
    }
}

