/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics.RasterOps;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class YCbCrARasterOp
implements RasterOp {
    private RenderingHints hints = null;

    public YCbCrARasterOp(RenderingHints hints) {
        this.hints = hints;
    }

    public WritableRaster filter(Raster src, WritableRaster dest) {
        if (dest == null) {
            dest = src.createCompatibleWritableRaster();
        }
        float[] origValues = new float[4];
        int[] rgbaValues = new int[4];
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int gByte;
                int rByte;
                src.getPixel(x, y, origValues);
                float Y = origValues[0];
                float Cb = origValues[1];
                float Cr = origValues[2];
                float K = origValues[3];
                Y = K - Y;
                float Cr_128 = Cr - 128.0f;
                float Cb_128 = Cb - 128.0f;
                float rVal = Y + 1370705.0f * Cr_128 / 1000000.0f;
                float gVal = Y - 337633.0f * Cb_128 / 1000000.0f - 698001.0f * Cr_128 / 1000000.0f;
                float bVal = Y + 1732446.0f * Cb_128 / 1000000.0f;
                byte by = (byte)(rVal < 0.0f ? 0 : (byte)(rByte = (byte)(rVal > 255.0f ? -1 : (byte)rVal)));
                byte by2 = (byte)(gVal < 0.0f ? 0 : (byte)(gByte = (byte)(gVal > 255.0f ? -1 : (byte)gVal)));
                int bByte = (byte)(bVal < 0.0f ? 0 : (byte)(bVal > 255.0f ? -1 : (byte)bVal));
                float alpha = K;
                rgbaValues[0] = rByte;
                rgbaValues[1] = gByte;
                rgbaValues[2] = bByte;
                rgbaValues[3] = (int)alpha;
                dest.setPixel(x, y, rgbaValues);
            }
        }
        return dest;
    }

    public Rectangle2D getBounds2D(Raster src) {
        return null;
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }

    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = (Point2D)srcPt.clone();
        } else {
            dstPt.setLocation(srcPt);
        }
        return dstPt;
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }
}

