/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.api.commands;

import org.apache.commons.lang3.Range;
import org.gvsig.report.lib.api.ReportServer;
import org.gvsig.report.lib.api.ReportServerConfig;
import org.gvsig.report.lib.api.ReportServices;
import org.gvsig.report.lib.api.commands.Command;
import org.gvsig.report.lib.api.commands.CommandFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommand
implements Command {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractCommand.class);
    private final ReportServer server;
    private final CommandFactory factory;

    public AbstractCommand(CommandFactory factory, ReportServer server) {
        this.server = server;
        this.factory = factory;
    }

    protected ReportServices getServices() {
        return this.server.getServices();
    }

    protected ReportServerConfig getConfig() {
        return this.server.getConfig();
    }

    @Override
    public ReportServer getServer() {
        return this.server;
    }

    @Override
    public String getDescription() {
        return this.factory.getDescription().replace("${host}", this.server.getHost());
    }

    @Override
    public String getName() {
        return this.factory.getName();
    }

    @Override
    public Range getNumArgs() {
        return this.factory.getNumArgs();
    }

    @Override
    public String getMimeType() {
        return this.factory.getMimeType();
    }
}

