/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dxf;

import java.io.File;
import java.io.IOException;
import org.cresques.cts.IProjection;
import org.gvsig.dxf.io.DxfFile;
import org.gvsig.dxf.px.dxf.DxfEntityMaker;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.CreateException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.FileNotFoundException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.RemoveException;
import org.gvsig.fmap.dal.resource.ResourceAction;
import org.gvsig.fmap.dal.resource.file.FileResource;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.AbsolutePathRequiredException;
import org.gvsig.fmap.dal.serverexplorer.filesystem.impl.AbstractFilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderServices;
import org.gvsig.fmap.dal.store.dxf.DXFNewStoreParameters;
import org.gvsig.fmap.dal.store.dxf.DXFOpenStoreParameters;

public class DXFFilesystemServerProvider
extends AbstractFilesystemServerExplorerProvider
implements FilesystemServerExplorerProvider,
ResourceConsumer {
    private FilesystemServerExplorerProviderServices serverExplorer;

    public String getDataStoreProviderName() {
        return "DXF";
    }

    public int getMode() {
        return 3;
    }

    public boolean accept(File pathname) {
        return pathname.getName().toLowerCase().endsWith(".dxf");
    }

    public String getDescription() {
        return "DXF file";
    }

    public boolean canCreate() {
        return true;
    }

    public boolean canCreate(NewDataStoreParameters parameters) {
        if (!(parameters instanceof DXFOpenStoreParameters)) {
            throw new IllegalArgumentException();
        }
        DXFOpenStoreParameters dxfParams = (DXFOpenStoreParameters)parameters;
        File file = new File(dxfParams.getFileName());
        if (dxfParams.getCRS() == null) {
            return false;
        }
        if (file.exists()) {
            return file.canWrite();
        }
        return file.getParentFile().canWrite();
    }

    public void create(NewDataStoreParameters parameters, boolean overwrite) throws CreateException {
        FileResource resource;
        final IProjection projection = null;
        DXFNewStoreParameters params = (DXFNewStoreParameters)parameters;
        File file = params.getFile();
        if (!file.isAbsolute()) {
            throw new AbsolutePathRequiredException(file.getPath());
        }
        if (file.exists()) {
            if (overwrite) {
                if (!file.delete()) {
                    throw new CreateException(this.getDataStoreProviderName(), (Throwable)new IOException("cannot delete file"));
                }
            } else {
                throw new CreateException(this.getDataStoreProviderName(), (Throwable)new IOException("file already exist"));
            }
        }
        try {
            resource = (FileResource)this.serverExplorer.getServerExplorerProviderServices().createResource("file", new Object[]{file.getAbsolutePath()});
        }
        catch (InitializeException e1) {
            throw new CreateException(params.getFileName(), (Throwable)e1);
        }
        resource.addConsumer((ResourceConsumer)this);
        try {
            resource.execute(new ResourceAction(){

                public Object run() throws Exception {
                    Builder builder = new Builder().initialice(resource.getFileName(), projection);
                    resource.notifyOpen();
                    builder.begin();
                    builder.create();
                    builder.end();
                    resource.notifyClose();
                    resource.setData(null);
                    resource.notifyChanges();
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new CreateException(params.getFileName(), (Throwable)e);
        }
        finally {
            resource.removeConsumer((ResourceConsumer)this);
        }
    }

    public NewDataStoreParameters getCreateParameters() throws DataException {
        return new DXFNewStoreParameters();
    }

    public void initialize(FilesystemServerExplorerProviderServices serverExplorer) {
        this.serverExplorer = serverExplorer;
    }

    public void remove(DataStoreParameters parameters) throws RemoveException {
        File file = new File(((DXFOpenStoreParameters)parameters).getFileName());
        if (!file.exists()) {
            throw new RemoveException(this.getDataStoreProviderName(), (Throwable)new FileNotFoundException(file));
        }
        if (!file.delete()) {
            // empty if block
        }
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return false;
    }

    public void resourceChanged(ResourceProvider resource) {
    }

    public class Builder {
        private String fileName;
        private IProjection projection;

        public Builder initialice(String fileName, IProjection projection) {
            this.fileName = fileName;
            this.projection = projection;
            return this;
        }

        public void begin() {
        }

        public void end() {
        }

        public void create() throws IOException {
            DxfEntityMaker entityMaker = new DxfEntityMaker(this.projection);
            DxfFile dxfFile = new DxfFile(null, this.fileName, (DxfFile.EntityFactory)entityMaker);
            dxfFile.setCadFlag(true);
            dxfFile.setDxf3DFlag(false);
            dxfFile.save(this.fileName);
        }
    }
}

