/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.a2j.codec.runtime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import java.util.logging.Logger;
import org.jzkit.a2j.codec.runtime.AsnBitString;
import org.jzkit.a2j.codec.runtime.AsnNull;
import org.jzkit.a2j.codec.runtime.ChoiceType;
import org.jzkit.a2j.codec.runtime.CodecStackInfo;
import org.jzkit.a2j.codec.runtime.SerializationManager;
import org.jzkit.a2j.codec.runtime.base_codec;
import org.jzkit.a2j.codec.util.OIDRegister;

public class BEROutputStream
extends ByteArrayOutputStream
implements SerializationManager {
    Stack encoding_info = new Stack();
    public int tag_class = -1;
    public int tag_value = -1;
    public boolean is_constructed = false;
    public String encoding = "US-ASCII";
    private base_codec codec_hint = null;
    private OIDRegister oid_register;
    private int default_lenlen = 1;
    private static Logger log = Logger.getLogger(BEROutputStream.class.getName());

    public BEROutputStream(OIDRegister oid_register) {
        this.oid_register = oid_register;
    }

    public BEROutputStream(String encoding, OIDRegister oid_register) {
        this.oid_register = oid_register;
        this.encoding = encoding;
    }

    public BEROutputStream(int size, OIDRegister oid_register) {
        super(size);
        this.oid_register = oid_register;
    }

    public BEROutputStream(int size, String encoding, OIDRegister oid_register) {
        super(size);
        this.oid_register = oid_register;
        this.encoding = encoding;
    }

    public void setDefaultLengthOfLengthEncoding(int default_lenlen) {
        this.default_lenlen = default_lenlen;
    }

    public int getDirection() {
        return 0;
    }

    public int tag_codec(boolean is_constructed) throws IOException {
        if (this.tag_class == -1) {
            throw new IOException("Trying to write an un-initialized tag");
        }
        int k = this.tag_class;
        if (is_constructed) {
            k |= 0x20;
        }
        if (this.tag_value < 31) {
            this.write(k | this.tag_value);
        } else {
            this.write(k | 0x1F);
            this.encodeBase128Int(this.tag_value);
        }
        this.tag_class = -1;
        this.tag_value = -1;
        return 1;
    }

    public byte[] octetstring_codec(Object instance, boolean is_constructed) throws IOException {
        byte[] enc = (byte[])instance;
        this.encodeLength(enc.length);
        this.write(enc);
        return enc;
    }

    public Boolean boolean_codec(Object instance, boolean is_constructed) throws IOException {
        Boolean retval = (Boolean)instance;
        this.encodeLength(1);
        this.write(retval != false ? 1 : 0);
        return retval;
    }

    public BigInteger integer_codec(Object instance, boolean is_constructed) throws IOException {
        BigInteger intval = (BigInteger)instance;
        if (intval != null) {
            boolean i = false;
            byte[] abyte0 = intval.toByteArray();
            if ((abyte0[0] & 0x80) != 0) {
                throw new IllegalArgumentException("Illegal internal encoding");
            }
            this.encodeLength(abyte0.length);
            this.write(abyte0);
            this.flush();
        }
        return intval;
    }

    public int[] oid_codec(Object instance, boolean is_constructed) throws IOException {
        int[] oid = (int[])instance;
        int len = oid.length;
        int len_pos = this.count;
        this.write(0);
        if (len > 1) {
            byte first_octet = (byte)(oid[0] * 40 + oid[1]);
            this.write(first_octet);
            for (int i = 2; i < len; ++i) {
                this.encodeBase128Int(oid[i]);
            }
            int res = this.rewriteLength(len_pos, this.count - (len_pos + 1), 1);
            if (res != 1) {
                throw new RuntimeException("Length of oid encoding > 1 octet");
            }
        }
        return oid;
    }

    public byte[] any_codec(Object instance, boolean is_constructed) throws IOException {
        byte[] b = (byte[])instance;
        this.encodeLength(b.length);
        this.write(b);
        return b;
    }

    public AsnBitString bitstring_codec(Object instance, boolean is_constructed) throws IOException {
        AsnBitString abs = (AsnBitString)instance;
        int len = abs.getValue().length + 1;
        this.encodeLength(len);
        this.write(0);
        this.write(abs.getValue());
        return abs;
    }

    public AsnNull null_codec(Object instance, boolean is_constructed) throws IOException {
        AsnNull retval = (AsnNull)instance;
        this.encodeLength(0);
        return retval;
    }

    public Object choice(Object current_instance, Object[][] choice_info, String name) throws IOException {
        ChoiceType c = (ChoiceType)current_instance;
        Integer tagmode = (Integer)choice_info[c.which][0];
        Integer tagclass = (Integer)choice_info[c.which][1];
        Integer tagnumber = (Integer)choice_info[c.which][2];
        base_codec codec_to_use = (base_codec)choice_info[c.which][3];
        if (tagmode.equals(SerializationManager.TAGMODE_NONE)) {
            codec_to_use.serialize(this, c.o, false, (String)choice_info[c.which][4]);
        } else if (tagmode.equals(SerializationManager.IMPLICIT)) {
            this.implicit_settag(tagclass, tagnumber);
            codec_to_use.serialize(this, c.o, false, (String)choice_info[c.which][4]);
        } else {
            this.constructedBegin(tagclass, tagnumber);
            codec_to_use.serialize(this, c.o, false, (String)choice_info[c.which][4]);
            this.constructedEnd();
        }
        return current_instance;
    }

    public boolean sequenceBegin() throws IOException {
        if (this.tag_class < 0) {
            this.tag_class = 0;
            this.tag_value = 16;
        }
        return this.constructedBegin(this.tag_class, this.tag_value);
    }

    public boolean sequenceEnd() {
        return this.constructedEnd();
    }

    public boolean constructedBegin(int tagclass, int tagnumber) throws IOException {
        if (this.tag_class < 0) {
            this.tag_class = tagclass;
            this.tag_value = tagnumber;
        }
        this.tag_codec(true);
        CodecStackInfo csi = new CodecStackInfo();
        csi.len_offset = this.count;
        csi.lenlen = this.default_lenlen;
        for (int i = 0; i < csi.lenlen; ++i) {
            this.write(0);
        }
        csi.contents_offset = this.count;
        this.encoding_info.push(csi);
        return true;
    }

    public boolean constructedEnd() {
        CodecStackInfo csi = (CodecStackInfo)this.encoding_info.pop();
        int length_of_contents = this.count - csi.contents_offset;
        int res = this.rewriteLength(csi.len_offset, length_of_contents, csi.lenlen);
        if (res == 0) {
            this.write(0);
            this.write(0);
        }
        return true;
    }

    public Object implicit_tag(base_codec c, Object current_instance, int tag_class, int tag_number, boolean is_optional, String name) throws IOException {
        if (null != current_instance) {
            this.implicit_settag(tag_class, tag_number);
            c.serialize(this, current_instance, is_optional, name);
        } else if (!is_optional) {
            throw new IOException("Missing mandatory member: " + name);
        }
        return current_instance;
    }

    public Object explicit_tag(base_codec c, Object current_instance, int tag_class, int tag_number, boolean is_optional, String name) throws IOException {
        if (null != current_instance) {
            this.constructedBegin(tag_class, tag_number);
            c.serialize(this, current_instance, is_optional, name);
            this.constructedEnd();
        } else if (!is_optional) {
            throw new IOException("Missing mandatory member: " + name);
        }
        return current_instance;
    }

    public ArrayList sequenceOf(ArrayList v, base_codec codec) throws IOException {
        if (null != v && v.size() > 0) {
            Iterator i = v.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                codec.serialize(this, o, true, "SequenceOfElement");
            }
        }
        return v;
    }

    public void implicit_settag(int tagclass, int tagvalue) {
        if (this.tag_class < 0) {
            this.tag_class = tagclass;
            this.tag_value = tagvalue;
        }
    }

    private boolean tag() {
        return true;
    }

    private int encodeLength(int len) {
        if (len >= 128) {
            int byte0 = len >= 0x1000000 ? 4 : (len >= 65536 ? 3 : (len >= 256 ? 2 : 1));
            this.write(0x80 | byte0);
            for (int j = (byte0 - 1) * 8; j >= 0; j -= 8) {
                this.write(len >> j);
            }
            return byte0;
        }
        this.write(len);
        return 1;
    }

    private int rewriteLength(int pos, int len, int max_octets) {
        int len_offset = pos;
        if (max_octets > 1) {
            byte byte0 = (byte)(max_octets - 1);
            this.buf[len_offset++] = (byte)(0x80 | byte0);
            for (int j = (byte0 - 1) * 8; j >= 0; j -= 8) {
                this.buf[len_offset++] = (byte)(len >> j);
            }
            return max_octets;
        }
        if (max_octets == 1) {
            if (len > 127) {
                this.buf[len_offset] = -128;
                return 0;
            }
            this.buf[len_offset] = (byte)len;
            return 1;
        }
        throw new RuntimeException("Cannot have negative max octets");
    }

    private int encodeTag() {
        return 1;
    }

    private void encodeBase128Int(int value) throws IOException {
        byte[] enc = new byte[10];
        int pos = 0;
        while (value > 127 && pos < 9) {
            enc[pos++] = (byte)(value & 0x7F);
            value >>= 7;
        }
        enc[pos] = (byte)value;
        while (pos >= 0) {
            this.write(enc[pos] | (pos == 0 ? 0 : 128));
            --pos;
        }
    }

    public base_codec getHintCodec() {
        return this.codec_hint;
    }

    public void setHintCodec(base_codec c) {
        this.codec_hint = c;
    }

    public String getCharsetEncoding() {
        return this.encoding;
    }

    public OIDRegister getOIDRegister() {
        return this.oid_register;
    }
}

