/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.PrintWriter;
import java.util.Enumeration;
import opendap.dap.Attribute;
import opendap.dap.AttributeBadValueException;
import opendap.dap.AttributeTable;
import opendap.dap.BaseType;
import opendap.dap.DAPNode;
import opendap.dap.NoSuchAttributeException;
import opendap.dap.Server.ServerMethods;
import opendap.dap.XMLparser.DDSXMLParser;
import opendap.util.Debug;
import opendap.util.EscapeStrings;

public class Alias
extends Attribute {
    private String aliasedToAttributeNamed;
    private Attribute targetAttribute;
    private BaseType targetVariable;

    public Alias(String aName, String attributeName) {
        super(aName, 1);
        this.aliasedToAttributeNamed = attributeName;
        this.targetAttribute = null;
        this.targetVariable = null;
    }

    public void setMyAttribute(Attribute a) {
        this.targetAttribute = a;
    }

    public void setMyVariable(BaseType v) {
        this.targetVariable = v;
    }

    private Attribute getMyAttribute() {
        return this.targetAttribute;
    }

    public int getType() {
        return this.getMyAttribute().getType();
    }

    public boolean isContainer() {
        return this.getMyAttribute().getType() == 2;
    }

    public boolean isAlias() {
        return true;
    }

    public String getAliasedTo() {
        return "";
    }

    public String getAliasedToAttributeFieldAsClearString() {
        return this.aliasedToAttributeNamed;
    }

    public String getAliasedToAttributeField() {
        return EscapeStrings.id2www(this.aliasedToAttributeNamed);
    }

    public AttributeTable getContainer() throws NoSuchAttributeException {
        return this.getMyAttribute().getContainer();
    }

    public Enumeration getValues() throws NoSuchAttributeException {
        return this.getMyAttribute().getValues();
    }

    public String getValueAt(int index) throws NoSuchAttributeException {
        return this.getMyAttribute().getValueAt(index);
    }

    public void appendValue(String value) throws AttributeBadValueException {
        throw new AttributeBadValueException("It is illegal to add values to an Alias. Values can only be added to an Attribute");
    }

    public void appendValue(String value, boolean check) throws AttributeBadValueException {
        throw new AttributeBadValueException("It is illegal to add values to an Alias. Values can only be added to an Attribute");
    }

    public void deleteValueAt(int index) throws AttributeBadValueException {
        throw new AttributeBadValueException("It is illegal to remove values from an Alias. Values can only be removed from an Attribute");
    }

    public void print(PrintWriter os, String pad) {
        if (Debug.isSet("Alias")) {
            System.out.println("  Attribute \"" + this.getClearName() + "\" is an Alias.");
        }
        os.println(pad + "Alias " + this.getName() + " " + this.getAliasedToAttributeField() + ";");
    }

    public void printXML(PrintWriter pw, String pad, boolean constrained) {
        ServerMethods sm;
        if (Debug.isSet("Alias")) {
            pw.println("    Printing Alias \"" + this.getClearName() + "\"");
        }
        if (constrained && this.targetVariable != null && this.targetVariable instanceof ServerMethods && !(sm = (ServerMethods)((Object)this.targetVariable)).isProject()) {
            return;
        }
        pw.println(pad + "<Alias name=\"" + DDSXMLParser.normalizeToXML(this.getClearName()) + "\" " + "Attribute=\"" + DDSXMLParser.normalizeToXML(this.getAliasedToAttributeFieldAsClearString()) + "\"/>");
        if (Debug.isSet("Alias")) {
            pw.println("Leaving Alias.print()");
        }
        pw.flush();
    }

    public DAPNode cloneDAG(DAPNode.CloneMap map) throws CloneNotSupportedException {
        Alias a = (Alias)super.cloneDAG(map);
        a.aliasedToAttributeNamed = this.aliasedToAttributeNamed;
        a.targetAttribute = (Attribute)Alias.cloneDAG(map, this.targetAttribute);
        a.targetVariable = (BaseType)Alias.cloneDAG(map, this.targetVariable);
        return a;
    }
}

