/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.PrintWriter;
import java.util.Formatter;
import opendap.dap.ConstraintException;
import opendap.dap.DAPNode;
import opendap.dap.DArray;
import opendap.dap.Server.InvalidParameterException;

public final class DArrayDimension
extends DAPNode {
    private int size;
    private int start;
    private int stride;
    private int stop;
    private boolean constrained = false;
    private DArray container = null;

    public DArrayDimension(int size, String name) {
        this(size, name, true);
    }

    public DArrayDimension(int size, String name, boolean decodeName) {
        super(name, decodeName);
        this.setSize(size);
        this.start = 0;
        this.stride = 1;
        this.stop = size - 1;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getStart() {
        return this.start;
    }

    public int getStride() {
        return this.stride;
    }

    public int getStop() {
        return this.stop;
    }

    public void setContainer(DArray da) {
        this.container = da;
    }

    public DArray getContainer() {
        return this.container;
    }

    public void printConstraint(PrintWriter os) {
        String buf = "[";
        buf = this.stride == 1 && this.start == this.stop ? buf + "" + this.start : (this.stride == 1 ? buf + this.start + ":" + this.stop : buf + this.start + ":" + this.stride + ":" + this.stop);
        buf = buf + "]";
        os.print(buf);
    }

    public void setProjection(int start, int stride, int stop) throws InvalidParameterException {
        String msg = "DArrayDimension.setProjection: Bad Projection Request: ";
        if (this.constrained && (this.start != start || this.stride != stride || this.stop != stop)) {
            Formatter f = new Formatter();
            f.format(" [%d,%d,%d,%d] != [%d,%d,%d,%d]", start, stride, stop, this.size, this.start, this.stride, this.stop, this.size);
            throw new ConstraintException("Conflicting constraint dimensions for: " + this.container.getLongName() + f.toString());
        }
        if (start >= this.size) {
            throw new InvalidParameterException(msg + "start (" + start + ") >= size (" + this.size + ") for " + this._name);
        }
        if (start < 0) {
            throw new InvalidParameterException(msg + "start < 0");
        }
        if (stride <= 0) {
            throw new InvalidParameterException(msg + "stride <= 0");
        }
        if (stop >= this.size) {
            throw new InvalidParameterException(msg + "stop >= size: " + stop + ":" + this.size);
        }
        if (stop < 0) {
            throw new InvalidParameterException(msg + "stop < 0");
        }
        if (stop < start) {
            throw new InvalidParameterException(msg + "stop < start");
        }
        this.start = start;
        this.stride = stride;
        this.stop = stop;
        this.size = 1 + (stop - start) / stride;
        this.constrained = true;
    }

    public DAPNode cloneDAG(DAPNode.CloneMap map) throws CloneNotSupportedException {
        DArrayDimension d = (DArrayDimension)super.cloneDAG(map);
        if (this.container != null) {
            d.container = (DArray)DArrayDimension.cloneDAG(map, this.container);
        }
        return d;
    }
}

