/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import opendap.dap.BaseTypeFactory;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DDS;
import opendap.dap.DDSException;
import opendap.dap.DataDDS;
import opendap.dap.DefaultFactory;
import opendap.dap.ServerVersion;
import opendap.dap.StatusUI;
import opendap.dap.http.HTTPException;
import opendap.dap.http.HTTPMethod;
import opendap.dap.http.HTTPSession;
import opendap.dap.parser.ParseException;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.InvalidCredentialsException;
import org.apache.commons.httpclient.util.URIUtil;

public class DConnect2 {
    private static boolean allowSessions = false;
    private HTTPSession _session = null;
    private String urlString;
    private String filePath = null;
    private InputStream stream = null;
    private String projString;
    private String selString;
    private boolean acceptCompress;
    private String lastModified = null;
    private String lastExtended = null;
    private String lastModifiedInvalid = null;
    private boolean hasSession = false;
    private ServerVersion ver;
    private boolean debugHeaders = false;
    private boolean debugStream = false;

    public static synchronized void setAllowSessions(boolean b) {
        allowSessions = b;
    }

    private void initSession() throws HTTPException {
        if (this._session != null) {
            return;
        }
        this._session = new HTTPSession();
    }

    public void setServerVersion(int major, int minor) {
        this.ver = new ServerVersion(major, minor);
    }

    public DConnect2(String urlString) throws FileNotFoundException {
        this(urlString, true);
    }

    public DConnect2(String urlString, boolean acceptCompress) throws FileNotFoundException {
        int ceIndex = urlString.indexOf(63);
        if (ceIndex != -1) {
            this.urlString = urlString.substring(0, ceIndex);
            String expr = urlString.substring(ceIndex);
            int selIndex = expr.indexOf(38);
            if (selIndex != -1) {
                this.projString = expr.substring(0, selIndex);
                this.selString = expr.substring(selIndex);
            } else {
                this.projString = expr;
                this.selString = "";
            }
        } else {
            this.urlString = urlString;
            this.selString = "";
            this.projString = "";
        }
        this.acceptCompress = acceptCompress;
        try {
            URL testURL = new URL(urlString);
            if ("file".equals(testURL.getProtocol())) {
                this.filePath = testURL.getPath();
                File f = new File(this.filePath + ".dds");
                if (!f.canRead()) {
                    throw new FileNotFoundException("file .dds not readable: " + urlString);
                }
                f = new File(this.filePath + ".dods");
                if (!f.canRead()) {
                    throw new FileNotFoundException("file .dods not readable: " + urlString);
                }
            }
            this.ver = new ServerVersion("3.2", 1);
        }
        catch (DAP2Exception ex) {
            throw new FileNotFoundException("Cannot set server version");
        }
        catch (MalformedURLException e) {
            throw new FileNotFoundException("Malformed URL: " + urlString);
        }
    }

    public DConnect2(InputStream stream) throws DAP2Exception {
        this.stream = stream;
        this.ver = new ServerVersion("3.2", 1);
    }

    public boolean isLocal() {
        return this.stream != null || this.filePath != null;
    }

    public final String CE() {
        return this.projString + this.selString;
    }

    public final String URL() {
        return this.urlString;
    }

    private void openConnection(String urlString, Command command) throws IOException, DAP2Exception, ParseException {
        HTTPMethod method = null;
        InputStream is = null;
        this.initSession();
        try {
            String encoding;
            int statusCode;
            method = this._session.newMethodGet(urlString);
            if (this.acceptCompress) {
                method.setRequestHeader("Accept-Encoding", "deflate,gzip");
            }
            if (allowSessions) {
                method.setRequestHeader("X-Accept-Session", "true");
            }
            if ((statusCode = method.execute()) == HTTPSession.SC_NOT_FOUND) {
                throw new DAP2Exception(1, method.getStatusText());
            }
            if (statusCode == HTTPSession.SC_UNAUTHORIZED) {
                throw new InvalidCredentialsException(method.getStatusText());
            }
            if (statusCode != HTTPSession.SC_OK) {
                throw new DAP2Exception("Method failed:" + method.getStatusText() + " on URL= " + urlString);
            }
            is = method.getResponseAsStream();
            Header header = method.getResponseHeader("Content-Description");
            if (header != null && (header.getValue().equals("dods-error") || header.getValue().equals("dods_error"))) {
                DAP2Exception ds = new DAP2Exception();
                is = this.dumpStream(is);
                ds.parse(is);
                throw ds;
            }
            this.ver = new ServerVersion(method);
            this.checkHeaders(method);
            Header h = method.getResponseHeader("content-encoding");
            String string = encoding = h == null ? null : h.getValue();
            if (encoding != null && encoding.equals("deflate")) {
                is = new BufferedInputStream(new InflaterInputStream(is), 1000);
            } else if (encoding != null && encoding.equals("gzip")) {
                is = new BufferedInputStream(new GZIPInputStream(is), 1000);
            }
            command.process(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DAP2Exception(e);
        }
        finally {
            if (method != null) {
                method.close();
            }
        }
    }

    public void closeSession() {
        try {
            if (allowSessions && this.hasSession) {
                this.openConnection(this.urlString + ".close", new Command(){

                    public void process(InputStream is) throws IOException {
                        byte[] buffer = new byte[4096];
                        while (is.read(buffer) > 0) {
                        }
                    }
                });
            }
            if (this._session != null) {
                this._session.close();
            }
            this._session = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private InputStream dumpStream(InputStream is) throws IOException {
        return is;
    }

    public final ServerVersion getServerVersion() {
        return this.ver;
    }

    public String getLastModifiedHeader() {
        return this.lastModified;
    }

    public String getLastModifiedInvalidHeader() {
        return this.lastModifiedInvalid;
    }

    public String getLastExtendedHeader() {
        return this.lastExtended;
    }

    private void checkHeaders(HTTPMethod method) {
        Cookie[] cookies;
        if (this.debugHeaders) {
            System.out.println("\nOpenConnection Headers for " + method.getPath());
            System.out.println("Status Line: " + method.getStatusLine());
        }
        Header[] responseHeaders = method.getResponseHeaders();
        for (int i1 = 0; i1 < responseHeaders.length; ++i1) {
            Header responseHeader = responseHeaders[i1];
            if (this.debugHeaders) {
                System.out.print("  " + responseHeader);
            }
            String key = responseHeader.getName();
            String value = responseHeader.getValue();
            if (key.equals("Last-Modified")) {
                this.lastModified = value;
                if (!this.debugHeaders) continue;
                System.out.println(" **found lastModified = " + this.lastModified);
                continue;
            }
            if (key.equals("X-Last-Extended")) {
                this.lastExtended = value;
                if (!this.debugHeaders) continue;
                System.out.println(" **found lastExtended = " + this.lastExtended);
                continue;
            }
            if (!key.equals("X-Last-Modified-Invalid")) continue;
            this.lastModifiedInvalid = value;
            if (!this.debugHeaders) continue;
            System.out.println(" **found lastModifiedInvalid = " + this.lastModifiedInvalid);
        }
        if (this.debugHeaders) {
            System.out.println("OpenConnection Headers for " + method.getPath());
        }
        if ((cookies = this._session.getCookies()).length > 0) {
            if (this.debugHeaders) {
                System.out.println("Cookies= ");
            }
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cooky = cookies[i];
                if (this.debugHeaders) {
                    System.out.println("  " + cooky);
                }
                if (!cooky.getName().equalsIgnoreCase("jsessionid")) continue;
                this.hasSession = true;
            }
        }
    }

    public DAS getDAS() throws IOException, ParseException, DAP2Exception {
        DASCommand command = new DASCommand();
        if (this.filePath != null) {
            File daspath = new File(this.filePath + ".das");
            if (daspath.canRead()) {
                command.process(new FileInputStream(daspath));
            }
        } else if (this.stream != null) {
            command.process(this.stream);
        } else {
            try {
                this.openConnection(this.urlString + ".das" + this.projString + this.selString, command);
            }
            catch (DAP2Exception dAP2Exception) {
                // empty catch block
            }
        }
        return command.das;
    }

    public DDS getDDS() throws IOException, ParseException, DAP2Exception {
        return this.getDDS("");
    }

    public DDS getDDS(String CE) throws IOException, ParseException, DAP2Exception {
        DDSCommand command = new DDSCommand();
        if (this.filePath != null) {
            command.process(new FileInputStream(this.filePath + ".dds"));
        } else if (this.stream != null) {
            command.process(this.stream);
        } else {
            this.openConnection(this.urlString + ".dds" + this.getCompleteCE(CE), command);
        }
        return command.dds;
    }

    private String getCompleteCE(String CE) {
        String escCE;
        String localSelString;
        String localProjString;
        int selIndex = CE.indexOf(38);
        if (selIndex != -1) {
            localProjString = CE.indexOf(63) == 0 ? CE.substring(1, selIndex) : CE.substring(0, selIndex);
            localSelString = CE.substring(selIndex);
        } else {
            localProjString = CE.indexOf(63) == 0 ? CE.substring(1) : CE;
            localSelString = "";
        }
        String ce = this.projString;
        if (!localProjString.equals("")) {
            if (!ce.equals("") && localProjString.indexOf(44) != 0) {
                ce = ce + ",";
            }
            ce = ce + localProjString;
        }
        if (!this.selString.equals("")) {
            if (this.selString.indexOf(38) != 0) {
                ce = ce + "&";
            }
            ce = ce + this.selString;
        }
        if (!localSelString.equals("")) {
            if (localSelString.indexOf(38) != 0) {
                ce = ce + "&";
            }
            ce = ce + localSelString;
        }
        if (ce.indexOf(63) != 0) {
            ce = "?" + ce;
        }
        try {
            escCE = URIUtil.encodeQuery(ce);
        }
        catch (URIException e) {
            throw new IllegalStateException(e.getMessage());
        }
        return escCE;
    }

    public DDS getDDX() throws IOException, ParseException, DAP2Exception {
        return this.getDDX("");
    }

    public DDS getDDX(String CE) throws IOException, ParseException, DDSException, DAP2Exception {
        DDXCommand command = new DDXCommand();
        this.openConnection(this.urlString + ".ddx" + this.getCompleteCE(CE), command);
        return command.dds;
    }

    public DataDDS getDataDDX() throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        return this.getDataDDX("", new DefaultFactory());
    }

    public DataDDS getDataDDX(String CE) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        return this.getDataDDX(CE, new DefaultFactory());
    }

    public DataDDS getDataDDX(String CE, BaseTypeFactory btf) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        DataDDXCommand command = new DataDDXCommand(btf);
        this.openConnection(this.urlString + ".ddx" + this.getCompleteCE(CE), command);
        return command.dds;
    }

    public DataDDS getData(String CE, StatusUI statusUI, BaseTypeFactory btf) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        DataDDS dds = new DataDDS(this.ver, btf);
        DataDDSCommand command = new DataDDSCommand(dds, statusUI);
        if (this.filePath != null) {
            File dodspath = new File(this.filePath + ".dods");
            if (dodspath.canRead()) {
                command.process(new FileInputStream(dodspath));
            }
        } else if (this.stream != null) {
            command.process(this.stream);
        } else {
            String urls = this.urlString + ".dods" + this.getCompleteCE(CE);
            this.openConnection(urls, command);
        }
        return command.dds;
    }

    public DataDDS getData(String CE) throws IOException, ParseException, DAP2Exception {
        return this.getData(CE, null, new DefaultFactory());
    }

    public DataDDS getData(String CE, StatusUI statusUI) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        return this.getData(CE, statusUI, new DefaultFactory());
    }

    public final DataDDS getData(StatusUI statusUI) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        return this.getData("", statusUI, new DefaultFactory());
    }

    public static void main(String[] args) {
        for (String url : args) {
            try {
                System.out.println("");
                System.out.println("");
                System.out.println("########################################################");
                System.out.println("\nConnecting to " + url + "\n");
                DConnect2 dc = new DConnect2(url);
                System.out.println("\n- - - - - - - - - - - - - - - - - - -");
                System.out.println("Retrieving DDS:\n");
                DDS dds = dc.getDDS();
                dds.print(System.out);
                System.out.println("\n- - - - - - - - - - - - - - - - - - -");
                System.out.println("Retrieving DAS:\n");
                DAS das = dc.getDAS();
                das.print(System.out);
                System.out.println("\n- - - - - - - - - - - - - - - - - - -");
                System.out.println("Retrieving DATA:\n");
                dds = dc.getData("");
                dds.printVal(System.out, "");
                System.out.println("\n- - - - - - - - - - - - - - - - - - -");
                System.out.println("Retrieving DDX:\n");
                dds = dc.getDDX();
                dds.printXML(System.out);
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
    }

    private class DataDDSCommand
    implements Command {
        DataDDS dds = null;
        StatusUI statusUI;

        DataDDSCommand(DataDDS dds, StatusUI statusUI) {
            this.dds = dds;
            this.statusUI = statusUI;
        }

        public void process(InputStream is) throws ParseException, DAP2Exception, IOException {
            this.dds.parse(is);
            this.dds.readData(is, this.statusUI);
        }
    }

    private class DataDDXCommand
    implements Command {
        DataDDS dds;

        DataDDXCommand(BaseTypeFactory btf) {
            this.dds = new DataDDS(DConnect2.this.ver, btf);
        }

        public void process(InputStream is) throws DAP2Exception, ParseException {
            this.dds.parseXML(is, false);
        }
    }

    private class DDXCommand
    implements Command {
        DDS dds = new DDS();

        private DDXCommand() {
        }

        public void process(InputStream is) throws DAP2Exception, ParseException {
            this.dds.parseXML(is, false);
        }
    }

    private class DDSCommand
    implements Command {
        DDS dds = new DDS();

        private DDSCommand() {
        }

        public void process(InputStream is) throws ParseException, DAP2Exception {
            this.dds.parse(is);
        }
    }

    private class DASCommand
    implements Command {
        DAS das = new DAS();

        private DASCommand() {
        }

        public void process(InputStream is) throws ParseException, DAP2Exception {
            this.das.parse(is);
        }
    }

    private static interface Command {
        public void process(InputStream var1) throws DAP2Exception, ParseException, IOException;
    }
}

