/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.Server;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import opendap.dap.BaseType;
import opendap.dap.ConstraintException;
import opendap.dap.DAP2Exception;
import opendap.dap.DArrayDimension;
import opendap.dap.NoSuchFunctionException;
import opendap.dap.NoSuchVariableException;
import opendap.dap.Server.Clause;
import opendap.dap.Server.ClauseFactory;
import opendap.dap.Server.DAP2ServerSideException;
import opendap.dap.Server.InvalidOperatorException;
import opendap.dap.Server.InvalidParameterException;
import opendap.dap.Server.SBHException;
import opendap.dap.Server.SDArray;
import opendap.dap.Server.SDGrid;
import opendap.dap.Server.ServerDDS;
import opendap.dap.Server.ServerMethods;
import opendap.dap.Server.TopLevelClause;
import opendap.dap.Server.WrongTypeException;
import opendap.dap.parser.CeParser;
import opendap.dap.parser.ParseException;
import opendap.util.Debug;

public class CEEvaluator {
    private static boolean _Debug;
    private ServerDDS _dds;
    private Vector _cv;
    private ClauseFactory clauseFactory;

    public CEEvaluator(ServerDDS dds) {
        this._dds = dds;
        this._cv = new Vector();
        _Debug = Debug.isSet("CE");
        if (_Debug) {
            System.out.println("CE debugging enabled.");
        }
    }

    public CEEvaluator(ServerDDS dds, ClauseFactory clauseFactory) {
        this._dds = dds;
        this._cv = new Vector();
        _Debug = Debug.isSet("CE");
        if (_Debug) {
            System.out.println("CE debugging enabled.");
        }
        this.clauseFactory = clauseFactory;
        _Debug = Debug.isSet("CEEvaluator");
    }

    public ServerDDS getDDS() {
        return this._dds;
    }

    public void parseConstraint(String expression) throws ParseException, DAP2Exception, NoSuchVariableException, NoSuchFunctionException, InvalidOperatorException, InvalidParameterException, SBHException, WrongTypeException {
        StringReader sExpr = new StringReader(expression);
        if (this.clauseFactory == null) {
            this.clauseFactory = new ClauseFactory();
        }
        try {
            CeParser.constraint_expression(this, this._dds.getFactory(), this.clauseFactory, sExpr);
        }
        catch (ConstraintException ce) {
            throw new DAP2Exception(136, ce.getMessage());
        }
        if (_Debug) {
            int it = 0;
            Enumeration ec = this.getClauses();
            System.out.println("Results of clause parsing:");
            if (!ec.hasMoreElements()) {
                System.out.println("    No Clauses Found.");
            }
            while (ec.hasMoreElements()) {
                System.out.println("    Clause " + ++it + ": " + ec.nextElement());
            }
        }
    }

    public void appendClause(Clause c) {
        if (c != null) {
            this._cv.add(c);
        }
    }

    public boolean removeClause(Clause c) {
        if (c != null) {
            return this._cv.remove(c);
        }
        return false;
    }

    public final Enumeration getClauses() {
        return this._cv.elements();
    }

    public void send(String dataset, OutputStream sink, Object specialO) throws NoSuchVariableException, DAP2ServerSideException, IOException {
        Enumeration e = this._dds.getVariables();
        while (e.hasMoreElements()) {
            ServerMethods s = (ServerMethods)e.nextElement();
            if (_Debug) {
                System.out.println("Sending variable: " + ((BaseType)((Object)s)).getName());
            }
            if (!s.isProject()) continue;
            if (_Debug) {
                System.out.println("Calling " + ((BaseType)((Object)s)).getTypeName() + ".serialize() (Name: " + ((BaseType)((Object)s)).getName() + ")");
            }
            s.serialize(dataset, (DataOutputStream)sink, this, specialO);
        }
    }

    public boolean evalClauses(Object specialO) throws NoSuchVariableException, DAP2ServerSideException, IOException {
        boolean result = true;
        Enumeration ec = this.getClauses();
        while (ec.hasMoreElements() && result) {
            Object o = ec.nextElement();
            if (_Debug) {
                System.out.println("Evaluating clause: " + ec.nextElement());
            }
            result = ((TopLevelClause)o).evaluate();
        }
        return result;
    }

    public void markAll(boolean state) throws InvalidParameterException, NoSuchVariableException, SBHException {
        Enumeration e = this._dds.getVariables();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (state) {
                if (o instanceof SDArray) {
                    SDArray SDA = (SDArray)o;
                    Enumeration eSDA = SDA.getDimensions();
                    while (eSDA.hasMoreElements()) {
                        DArrayDimension dad = (DArrayDimension)eSDA.nextElement();
                        dad.setProjection(0, 1, dad.getSize() - 1);
                    }
                } else if (o instanceof SDGrid) {
                    SDGrid SDG = (SDGrid)o;
                    SDArray sdgA = (SDArray)SDG.getVar(0);
                    Enumeration eSDA = sdgA.getDimensions();
                    while (eSDA.hasMoreElements()) {
                        DArrayDimension dad = (DArrayDimension)eSDA.nextElement();
                        dad.setProjection(0, 1, dad.getSize() - 1);
                    }
                }
            }
            ServerMethods s = (ServerMethods)o;
            s.setProject(state);
        }
    }

    public void printConstraint(PrintWriter pw) {
        Enumeration ec = this.getClauses();
        boolean first = true;
        while (ec.hasMoreElements()) {
            Clause cl = (Clause)ec.nextElement();
            if (!first) {
                pw.print(" & ");
            }
            cl.printConstraint(pw);
            first = false;
        }
        pw.flush();
    }
}

