/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.Server;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import opendap.dap.BaseType;
import opendap.dap.DSequence;
import opendap.dap.NoSuchVariableException;
import opendap.dap.Server.CEEvaluator;
import opendap.dap.Server.DAP2ServerSideException;
import opendap.dap.Server.InvalidOperatorException;
import opendap.dap.Server.RegExpException;
import opendap.dap.Server.RelOps;
import opendap.dap.Server.SBHException;
import opendap.dap.Server.ServerMethods;
import opendap.util.Debug;

public abstract class SDSequence
extends DSequence
implements ServerMethods,
RelOps {
    private boolean _Debug = Debug.isSet("SDSequence");
    private boolean Synthesized = false;
    private boolean ReadMe = false;

    public SDSequence() {
    }

    public SDSequence(String n) {
        super(n);
    }

    public Vector getRowVector() throws NoSuchVariableException {
        if (this.getRowCount() == 0) {
            if (this._Debug) {
                System.out.println("This sequence has " + this.getRowCount() + " rows.");
            }
            Vector<BaseType> rv = new Vector<BaseType>();
            for (int i = 0; i < this.elementCount(false); ++i) {
                if (this._Debug) {
                    System.out.println("Building variable " + i + ": " + this.getVar(i).getName());
                }
                rv.add(this.getVar(i));
            }
            if (this._Debug) {
                System.out.println("Adding row to sequence...");
            }
            this.addRow(rv);
        }
        return this.getRow(0);
    }

    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        if (constrained && !this.isProject()) {
            return;
        }
        super.printDecl(os, space, print_semi, constrained);
    }

    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (!this.isProject()) {
            return;
        }
        if (print_decl_p) {
            this.printDecl(os, space, false, true);
            os.print(" = ");
        }
        os.print("{ ");
        try {
            boolean firstPass = true;
            Vector v = this.getRowVector();
            Enumeration e2 = v.elements();
            while (e2.hasMoreElements()) {
                BaseType bt = (BaseType)e2.nextElement();
                if (!((ServerMethods)((Object)bt)).isProject()) continue;
                if (!firstPass) {
                    os.print(", ");
                }
                bt.printVal(os, "", false);
                firstPass = false;
            }
        }
        catch (NoSuchVariableException e) {
            os.println("Very Bad Things Happened When I Tried To Print A Row Of The Sequence: " + this.getName());
        }
        os.print(" }");
        if (print_decl_p) {
            os.println(";");
        }
    }

    public void setProject(boolean state, boolean all) {
        this.setProjected(state);
        if (all) {
            Enumeration e = this.varTemplate.elements();
            while (e.hasMoreElements()) {
                ServerMethods sm = (ServerMethods)e.nextElement();
                sm.setProject(state);
            }
        }
    }

    public boolean equal(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Equals (=) operator does not work with the type SDSequence!");
    }

    public boolean not_equal(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Not Equals (!=) operator does not work with the type SDSequence!");
    }

    public boolean greater(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Greater Than (>)operator does not work with the type SDSequence!");
    }

    public boolean greater_eql(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("GreaterThan or equals (<=) operator does not work with the type SDSequence!");
    }

    public boolean less(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("LessThan (<) operator does not work with the type SDSequence!");
    }

    public boolean less_eql(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("LessThan oe equals (<=) operator does not work with the type SDSequence!");
    }

    public boolean regexp(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Regular Expression's don't work with the type SDSequence!");
    }

    public void setSynthesized(boolean state) {
        this.Synthesized = state;
    }

    public boolean isSynthesized() {
        return this.Synthesized;
    }

    public void setRead(boolean state) {
        this.ReadMe = state;
    }

    public void setAllReadFlags(boolean state) {
        this.ReadMe = state;
        Enumeration e = this.varTemplate.elements();
        while (e.hasMoreElements()) {
            ServerMethods sm = (ServerMethods)e.nextElement();
            sm.setRead(state);
        }
    }

    public boolean isRead() {
        return this.ReadMe;
    }

    public abstract boolean read(String var1, Object var2) throws NoSuchVariableException, IOException, EOFException;

    public void serialize(String dataset, DataOutputStream sink, CEEvaluator ce, Object specialO) throws NoSuchVariableException, DAP2ServerSideException, IOException {
        boolean moreToRead = true;
        while (moreToRead) {
            if (!this.isRead()) {
                moreToRead = this.read(dataset, specialO);
            }
            if (ce.evalClauses(specialO)) {
                this.writeMarker(sink, START_OF_INSTANCE);
                Enumeration e = this.varTemplate.elements();
                while (e.hasMoreElements()) {
                    ServerMethods sm = (ServerMethods)e.nextElement();
                    if (!sm.isProject()) continue;
                    if (this._Debug) {
                        System.out.println("Sending variable: " + ((BaseType)((Object)sm)).getName());
                    }
                    sm.serialize(dataset, sink, ce, specialO);
                }
            }
            if (!moreToRead) continue;
            this.setAllReadFlags(false);
        }
        this.writeMarker(sink, END_OF_SEQUENCE);
    }

    public void printXML(PrintWriter pw, String pad, boolean constrained) {
        if (constrained && !this.isProject()) {
            return;
        }
        super.printXML(pw, pad, constrained);
    }
}

