/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.http;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import opendap.dap.http.EasySSLProtocolSocketFactory;
import opendap.dap.http.HTTPException;
import opendap.dap.http.HTTPMethod;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.Protocol;

public class HTTPSession {
    static int DFALTTHREADCOUNT = 50;
    public static int SC_NOT_FOUND = 404;
    public static int SC_UNAUTHORIZED = 401;
    public static int SC_OK = 200;
    public static String CONNECTION_TIMEOUT = "http.connection.timeout";
    public static String SO_TIMEOUT = "http.socket.timeout";
    public static String USER_AGENT = "http.useragent";
    public static String PROTOCOL_VERSION = "http.protocol.version";
    public static String VIRTUAL_HOST = "http.virtual-host";
    public static String USE_EXPECT_CONTINUE = "http.protocol.expect-continue";
    public static String STRICT_TRANSFER_ENCODING = "http.protocol.strict-transfer-encoding";
    public static String HTTP_ELEMENT_CHARSET = "http.protocol.element-charset";
    public static String HTTP_CONTENT_CHARSET = "http.protocol.content-charset";
    public static String HTTP_CONNECTION = "<undefined>";
    public static String HTTP_PROXY_HOST = "<undefined>";
    public static String HTTP_REQ_SENT = "<undefined>";
    public static String HTTP_REQUEST = "<undefined>";
    public static String HTTP_RESPONSE = "<undefined>";
    public static String HTTP_TARGET_HOST = "<undefined>";
    public static String ORIGIN_SERVER = "<undefined>";
    public static String WAIT_FOR_CONTINUE = "<undefined>";
    protected static MultiThreadedHttpConnectionManager connmgr;
    protected static CredentialsProvider globalProvider;
    protected static String globalAgent;
    protected static int threadcount;
    protected static List<HTTPSession> sessionList;
    protected HttpClient sessionClient = null;
    protected HttpState sessionState = null;
    protected CredentialsProvider sessionProvider;
    protected String sessionAgent = "/NetcdfJava/HttpClient4";
    protected List<HTTPMethod> methodList = new Vector<HTTPMethod>();
    HttpState context = null;
    boolean closed = false;
    String useragent = null;
    HashMap<String, Object> globalmethodparams = new HashMap();
    String identifier = "Session";
    protected Authenticator globalAuthenticator = null;

    public static synchronized CredentialsProvider getGlobalCredentialsProvider() {
        return globalProvider;
    }

    public static synchronized void setGlobalCredentialsProvider(CredentialsProvider p) {
        globalProvider = p;
    }

    public static synchronized void setGlobalUserAgent(String _userAgent) {
        globalAgent = _userAgent;
    }

    public static String getGlobalUserAgent() {
        return globalAgent;
    }

    public static void setThreadCount(int nthreads) {
        connmgr.getParams().setMaxTotalConnections(nthreads);
        connmgr.getParams().setDefaultMaxConnectionsPerHost(nthreads);
    }

    public static int getThreadCount() {
        return connmgr.getParams().getMaxTotalConnections();
    }

    private static synchronized void kill() {
        for (HTTPSession session : sessionList) {
            session.close();
        }
        sessionList.clear();
        connmgr.shutdown();
        connmgr = new MultiThreadedHttpConnectionManager();
        HTTPSession.setThreadCount(DFALTTHREADCOUNT);
    }

    public HTTPSession() throws HTTPException {
        this("Session");
    }

    public HTTPSession(String id) throws HTTPException {
        this.identifier = id;
        try {
            this.sessionClient = new HttpClient(new HttpClientParams(), connmgr);
            this.setProxy();
            if (globalProvider != null && this.sessionClient != null) {
                this.sessionClient.getParams().setParameter("http.authentication.credential-provider", globalProvider);
            }
            if (this.useragent != null && this.sessionClient != null) {
                this.sessionClient.getParams().setParameter(USER_AGENT, this.useragent);
            }
            sessionList.add(this);
        }
        catch (Exception e) {
            throw new HTTPException(e);
        }
    }

    public void setCredentialsProvider(CredentialsProvider provider) {
        this.sessionProvider = provider;
        if (this.sessionClient != null && provider != null) {
            this.sessionClient.getParams().setParameter("http.authentication.credential-provider", provider);
        }
    }

    public void setUserAgent(String agent) {
        this.useragent = agent;
        if (this.useragent != null) {
            this.sessionClient.getParams().setParameter(USER_AGENT, this.useragent);
        }
    }

    public void setConnectionManagerTimeout(long timeout) {
        connmgr.getParams().setConnectionTimeout((int)timeout);
    }

    public void setSoTimeout(int timeout) {
        this.sessionClient.getParams().setSoTimeout(timeout);
    }

    public void setGlobalMethodParameter(String name, Object value) {
        this.globalmethodparams.put(name, value);
    }

    public synchronized void close() {
        this.closed = true;
        if (this.methodList != null) {
            for (HTTPMethod m : this.methodList) {
                m.close();
                this.removeMethod(m);
            }
        }
    }

    public HTTPMethod newMethodGet(String uri) throws HTTPException {
        return this.newMethod(Methods.Get, uri);
    }

    public HTTPMethod newMethodHead(String uri) throws HTTPException {
        return this.newMethod(Methods.Head, uri);
    }

    public HTTPMethod newMethodPut(String uri) throws HTTPException {
        return this.newMethod(Methods.Put, uri);
    }

    public HTTPMethod newMethodPost(String uri) throws HTTPException {
        return this.newMethod(Methods.Post, uri);
    }

    public HTTPMethod newMethodOptions(String uri) throws HTTPException {
        return this.newMethod(Methods.Options, uri);
    }

    public HTTPMethod newMethod(Methods m, String uri) throws HTTPException {
        assert (!this.closed) : "Attempt to use a closed session";
        HTTPMethod method = new HTTPMethod(m, uri, this);
        this.addMethod(method);
        return method;
    }

    public String getCookiePolicy() {
        return this.sessionClient == null ? null : this.sessionClient.getParams().getCookiePolicy();
    }

    public Cookie[] getCookies() {
        if (this.sessionClient == null) {
            return null;
        }
        Cookie[] cookies = this.sessionClient.getState().getCookies();
        return cookies;
    }

    protected synchronized void addMethod(HTTPMethod m) {
        if (!this.methodList.contains(m)) {
            this.methodList.add(m);
        }
    }

    protected synchronized void removeMethod(HTTPMethod m) {
        if (!this.closed) {
            this.methodList.remove(m);
        }
    }

    public void setContext(HttpState cxt) {
        this.context = cxt;
    }

    public HttpState getContext() {
        return this.context;
    }

    public void clearState() {
        this.sessionClient.getState().clearCookies();
        this.sessionClient.getState().clearCredentials();
    }

    public void setProxy() {
        if (this.sessionClient == null) {
            return;
        }
        String host = System.getProperty("http.proxyHost");
        String port = System.getProperty("http.proxyPort");
        if (host != null && (host = host.trim()).length() == 0) {
            host = null;
        }
        int portno = 0;
        if (port != null && (port = port.trim()).length() > 0) {
            portno = Integer.parseInt(port);
        }
        if (host != null && portno > 0) {
            this.sessionClient.getHostConfiguration().setProxy(host, portno);
        }
    }

    public void setGlobalAuthenticator(String user, String password) {
        if (password != null && (password = password.trim()).length() == 0) {
            password = null;
        }
        if (user != null && (user = user.trim()).length() == 0) {
            user = null;
        }
        if (user != null && password != null) {
            final PasswordAuthentication pa = new PasswordAuthentication(user, password.toCharArray());
            this.globalAuthenticator = new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    return pa;
                }
            };
            Authenticator.setDefault(this.globalAuthenticator);
        }
    }

    static {
        globalAgent = "/NetcdfJava/HttpClient3";
        threadcount = DFALTTHREADCOUNT;
        globalProvider = null;
        connmgr = new MultiThreadedHttpConnectionManager();
        HTTPSession.setThreadCount(DFALTTHREADCOUNT);
        Protocol.registerProtocol("https", new Protocol("https", new EasySSLProtocolSocketFactory(), 443));
        sessionList = new ArrayList<HTTPSession>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Methods {
        Get("get"),
        Head("head"),
        Put("put"),
        Post("post"),
        Options("options");

        private final String name;

        private Methods(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

