/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.CatalogSetCallback;
import thredds.catalog.InvCatalogConvertIF;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.MetadataConverterIF;
import thredds.catalog.XMLEntityResolver;
import thredds.catalog.parser.jdom.InvCatalogFactory10;
import thredds.util.PathAliasReplacement;
import ucar.nc2.util.IO;

public class InvCatalogFactory {
    private static Logger log = LoggerFactory.getLogger(InvCatalogFactory.class);
    public static boolean debugURL = false;
    public static boolean debugOpen = false;
    public static boolean debugVersion = false;
    public static boolean showParsedXML = false;
    public static boolean showStackTrace = false;
    public static boolean debugXML = false;
    public static boolean debugDBurl = false;
    public static boolean debugXMLopen = false;
    public static boolean showCatalogXML = false;
    private String name;
    private InvCatalogConvertIF defaultConverter;
    private SAXBuilder saxBuilder;
    private StringBuilder warnMessages;
    private StringBuilder errMessages;
    private StringBuilder fatalMessages;
    private Map<String, InvCatalogConvertIF> converters = new HashMap<String, InvCatalogConvertIF>(10);
    private Map<String, MetadataConverterIF> metadataConverters = new HashMap<String, MetadataConverterIF>(10);
    private List<PathAliasReplacement> dataRootLocAliasExpanders = Collections.emptyList();

    public static InvCatalogFactory getDefaultFactory(boolean validate) {
        return new InvCatalogFactory("default", validate);
    }

    public String getName() {
        return this.name;
    }

    public InvCatalogFactory(String name, boolean validate) {
        this.name = name;
        XMLEntityResolver xml = new XMLEntityResolver(validate);
        this.saxBuilder = xml.getSAXBuilder();
        this.warnMessages = xml.getWarningMessages();
        this.errMessages = xml.getErrorMessages();
        this.fatalMessages = xml.getFatalMessages();
        this.setDefaults();
    }

    public void setDataRootLocationAliasExpanders(List<PathAliasReplacement> dataRootLocAliasExpanders) {
        this.dataRootLocAliasExpanders = dataRootLocAliasExpanders == null ? Collections.emptyList() : new ArrayList<PathAliasReplacement>(dataRootLocAliasExpanders);
        for (InvCatalogConvertIF catConv : this.converters.values()) {
            if (!(catConv instanceof InvCatalogFactory10)) continue;
            ((InvCatalogFactory10)catConv).setDataRootLocationAliasExpanders(this.dataRootLocAliasExpanders);
        }
    }

    public List<PathAliasReplacement> getDataRootLocationAliasExpanders() {
        return Collections.unmodifiableList(this.dataRootLocAliasExpanders);
    }

    private void setDefaults() {
        try {
            Class<?> fac1 = Class.forName("thredds.catalog.parser.jdom.InvCatalogFactory10");
            Object fac1o = fac1.newInstance();
            this.defaultConverter = (InvCatalogConvertIF)fac1o;
            this.registerCatalogConverter("http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", (InvCatalogConvertIF)fac1o);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("InvCatalogFactory: no implementing class found: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("InvCatalogFactory: instantition failed: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("InvCatalogFactory: access failed: " + e.getMessage());
        }
    }

    public void registerCatalogConverter(String namespace, InvCatalogConvertIF converter) {
        this.converters.put(namespace, converter);
    }

    public InvCatalogConvertIF getCatalogConverter(String namespace) {
        return this.converters.get(namespace);
    }

    public void setCatalogConverter(InvCatalogImpl cat, String namespace) {
        cat.setCatalogConverter(this.getCatalogConverter(namespace));
    }

    public void registerMetadataConverter(String key, MetadataConverterIF converter) {
        this.metadataConverters.put(key, converter);
    }

    public void readXMLasynch(String uriString, CatalogSetCallback callback) {
        InvCatalogImpl cat = this.readXML(uriString);
        callback.setCatalog(cat);
    }

    public InvCatalogImpl readXML(String uriString) {
        URI uri;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            InvCatalogImpl cat = new InvCatalogImpl(uriString, null, null);
            cat.appendErrorMessage("**Fatal:  InvCatalogFactory.readXML URISyntaxException on URL (" + uriString + ") " + e.getMessage() + "\n", true);
            return cat;
        }
        return this.readXML(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvCatalogImpl readXML(URI uri) {
        Document jdomDoc;
        this.warnMessages.setLength(0);
        this.errMessages.setLength(0);
        this.fatalMessages.setLength(0);
        InputStream is = null;
        try {
            jdomDoc = this.saxBuilder.build(uri.toURL());
        }
        catch (Exception e) {
            InvCatalogImpl cat = new InvCatalogImpl(uri.toString(), null, null);
            cat.appendErrorMessage("**Fatal:  InvCatalogFactory.readXML failed\n Exception= " + e.getClass().getName() + " " + e.getMessage() + "\n fatalMessages= " + this.fatalMessages.toString() + "\n errMessages= " + this.errMessages.toString() + "\n warnMessages= " + this.warnMessages.toString() + "\n", true);
            InvCatalogImpl invCatalogImpl = cat;
            return invCatalogImpl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.warn("Failed to close input stream [" + uri.toString() + "].");
                }
            }
        }
        if (this.fatalMessages.length() > 0) {
            InvCatalogImpl cat = new InvCatalogImpl(uri.toString(), null, null);
            cat.appendErrorMessage("**Fatal:  InvCatalogFactory.readXML XML Fatal error(s) =\n" + this.fatalMessages.toString() + "\n", true);
            return cat;
        }
        return this.readXML(jdomDoc, uri);
    }

    public InvCatalogImpl readXML(String catAsString, URI baseUri) {
        return this.readXML(new StringReader(catAsString), baseUri);
    }

    public InvCatalogImpl readXML(StringReader catAsStringReader, URI baseUri) {
        Document inDoc;
        XMLEntityResolver resolver = new XMLEntityResolver(false);
        SAXBuilder builder = resolver.getSAXBuilder();
        try {
            inDoc = builder.build(catAsStringReader);
        }
        catch (Exception e) {
            InvCatalogImpl cat = new InvCatalogImpl(baseUri.toString(), null, null);
            cat.appendErrorMessage("**Fatal:  InvCatalogFactory.readXML(String catAsString, URI uri) failed:\n  Exception= " + e.getClass().getName() + " " + e.getMessage() + "\n  fatalMessages= " + this.fatalMessages.toString() + "\n  errMessages= " + this.errMessages.toString() + "\n  warnMessages= " + this.warnMessages.toString() + "\n", true);
            return cat;
        }
        return this.readXML(inDoc, baseUri);
    }

    public InvCatalogImpl readXML(InputStream docIs, URI uri) {
        Document jdomDoc;
        this.warnMessages.setLength(0);
        this.errMessages.setLength(0);
        this.fatalMessages.setLength(0);
        try {
            jdomDoc = this.saxBuilder.build(docIs);
        }
        catch (Exception e) {
            InvCatalogImpl cat = new InvCatalogImpl(uri.toString(), null, uri);
            cat.appendErrorMessage("**Fatal:  InvCatalogFactory.readXML failed\n Exception= " + e.getClass().getName() + " " + e.getMessage() + "\n fatalMessages= " + this.fatalMessages.toString() + "\n errMessages= " + this.errMessages.toString() + "\n warnMessages= " + this.warnMessages.toString() + "\n", true);
            return cat;
        }
        if (this.fatalMessages.length() > 0) {
            InvCatalogImpl cat = new InvCatalogImpl(uri.toString(), null, uri);
            cat.appendErrorMessage("**Fatal:  InvCatalogFactory.readXML XML Fatal error(s) =\n" + this.fatalMessages.toString() + "\n", true);
            return cat;
        }
        return this.readXML(jdomDoc, uri);
    }

    public InvCatalogImpl readXML(Document jdomDoc, URI uri) {
        Element root = jdomDoc.getRootElement();
        if (!root.getName().equalsIgnoreCase("catalog")) {
            throw new IllegalArgumentException("not a catalog");
        }
        String namespace = root.getNamespaceURI();
        InvCatalogConvertIF fac = this.converters.get(namespace);
        if (fac == null) {
            fac = this.defaultConverter;
            if (debugVersion) {
                System.out.println("use default converter " + fac.getClass().getName() + "; no namespace " + namespace);
            }
        } else if (debugVersion) {
            System.out.println("use converter " + fac.getClass().getName() + " based on namespace " + namespace);
        }
        InvCatalogImpl cat = fac.parseXML(this, jdomDoc, uri);
        cat.setCreateFrom(uri.toString());
        cat.setCatalogFactory(this);
        cat.setCatalogConverter(fac);
        cat.finish();
        if (showCatalogXML) {
            System.out.println("*** catalog/showCatalogXML");
            try {
                this.writeXML(cat, System.out);
            }
            catch (IOException ex) {
                log.warn("Error writing catalog for debugging", ex);
            }
        }
        if (this.fatalMessages.length() > 0) {
            cat.appendErrorMessage(this.fatalMessages.toString(), true);
        }
        if (this.errMessages.length() > 0) {
            cat.appendErrorMessage(this.errMessages.toString(), false);
        }
        if (this.warnMessages.length() > 0) {
            cat.appendErrorMessage(this.warnMessages.toString(), false);
        }
        return cat;
    }

    public String writeXML(InvCatalogImpl catalog) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(10000);
        this.writeXML(catalog, os);
        return os.toString();
    }

    public void writeXML(InvCatalogImpl catalog, OutputStream os) throws IOException {
        InvCatalogConvertIF fac = catalog.getCatalogConverter();
        if (fac == null) {
            fac = this.defaultConverter;
        }
        fac.writeXML(catalog, os);
    }

    public void writeXML(InvCatalogImpl catalog, OutputStream os, boolean raw) throws IOException {
        InvCatalogConvertIF fac = catalog.getCatalogConverter();
        if (fac == null) {
            fac = this.defaultConverter;
        }
        fac.writeXML(catalog, os, raw);
    }

    public void writeXML(InvCatalogImpl catalog, String filename) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(filename));
        this.writeXML(catalog, os);
        os.close();
    }

    public String writeXML_1_0(InvCatalogImpl catalog) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(10000);
        this.writeXML_1_0(catalog, os);
        return os.toString();
    }

    public String writeXML_0_6(InvCatalogImpl catalog) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(10000);
        this.writeXML_0_6(catalog, os);
        return os.toString();
    }

    public void writeXML_1_0(InvCatalogImpl catalog, OutputStream os) throws IOException {
        this.writeXML_ver("http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", catalog, os);
    }

    public void writeXML_0_6(InvCatalogImpl catalog, OutputStream os) throws IOException {
        this.writeXML_ver("http://www.unidata.ucar.edu/thredds", catalog, os);
    }

    private void writeXML_ver(String namespace, InvCatalogImpl catalog, OutputStream os) throws IOException {
        InvCatalogConvertIF converter = this.getCatalogConverter(namespace);
        if (converter == null) {
            String tmpMsg = "This Factory <" + this.getName() + "> does not have a converter for the requested namespace <" + namespace + ">.";
            throw new IllegalStateException(tmpMsg);
        }
        converter.writeXML(catalog, os);
    }

    public void appendErr(String err) {
        this.errMessages.append(err);
    }

    public void appendFatalErr(String err) {
        this.fatalMessages.append(err);
    }

    public void appendWarning(String err) {
        this.warnMessages.append(err);
    }

    public MetadataConverterIF getMetadataConverter(String key) {
        if (key == null) {
            return null;
        }
        return this.metadataConverters.get(key);
    }

    private static InvCatalogImpl doOne(InvCatalogFactory fac, String urlString, boolean show) {
        System.out.println("***read " + urlString);
        if (show) {
            System.out.println(" original catalog=\n" + IO.readURLcontents(urlString));
        }
        try {
            InvCatalogImpl cat = fac.readXML(new URI(urlString));
            StringBuilder buff = new StringBuilder();
            boolean isValid = cat.check(buff, false);
            System.out.println("catalog <" + cat.getName() + "> " + (isValid ? "is" : "is not") + " valid");
            System.out.println(" validation output=\n" + buff);
            if (show) {
                System.out.println(" parsed catalog=\n" + fac.writeXML(cat));
            }
            return cat;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory(false);
        InvCatalogFactory.doOne(catFactory, "file:C:/data/work/maurer/atm_mod.xml", true);
    }
}

