/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.decoder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import ucar.jpeg.colorspace.ColorSpace;
import ucar.jpeg.colorspace.ColorSpaceException;
import ucar.jpeg.icc.ICCProfiler;
import ucar.jpeg.jj2000.disp.BlkImgDataSrcImageProducer;
import ucar.jpeg.jj2000.disp.ExitHandler;
import ucar.jpeg.jj2000.disp.ImgKeyListener;
import ucar.jpeg.jj2000.disp.ImgMouseListener;
import ucar.jpeg.jj2000.disp.ImgScrollPane;
import ucar.jpeg.jj2000.disp.TitleUpdater;
import ucar.jpeg.jj2000.j2k.codestream.HeaderInfo;
import ucar.jpeg.jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import ucar.jpeg.jj2000.j2k.codestream.reader.HeaderDecoder;
import ucar.jpeg.jj2000.j2k.entropy.decoder.EntropyDecoder;
import ucar.jpeg.jj2000.j2k.fileformat.reader.FileFormatReader;
import ucar.jpeg.jj2000.j2k.image.BlkImgDataSrc;
import ucar.jpeg.jj2000.j2k.image.ImgDataConverter;
import ucar.jpeg.jj2000.j2k.image.invcomptransf.InvCompTransf;
import ucar.jpeg.jj2000.j2k.image.output.ImgWriter;
import ucar.jpeg.jj2000.j2k.image.output.ImgWriterPGM;
import ucar.jpeg.jj2000.j2k.image.output.ImgWriterPGX;
import ucar.jpeg.jj2000.j2k.image.output.ImgWriterPPM;
import ucar.jpeg.jj2000.j2k.io.BEBufferedRandomAccessFile;
import ucar.jpeg.jj2000.j2k.quantization.dequantizer.Dequantizer;
import ucar.jpeg.jj2000.j2k.roi.ROIDeScaler;
import ucar.jpeg.jj2000.j2k.util.FacilityManager;
import ucar.jpeg.jj2000.j2k.util.ISRandomAccessIO;
import ucar.jpeg.jj2000.j2k.util.MsgLogger;
import ucar.jpeg.jj2000.j2k.util.ParameterList;
import ucar.jpeg.jj2000.j2k.util.StringFormatException;
import ucar.jpeg.jj2000.j2k.wavelet.synthesis.InverseWT;

public class Decoder
implements Runnable {
    private ColorSpace csMap = null;
    TitleUpdater title = null;
    private boolean isChildProcess = false;
    private int exitCode;
    private ParameterList pl;
    private HeaderInfo hi;
    private ParameterList defpl;
    private static final char[] vprfxs = new char[]{'B', 'C', 'R', 'Q', 'M', 'H', 'I'};
    private Frame win = null;
    private ImgScrollPane isp;
    private static final String[][] pinfo = new String[][]{{"u", "[on|off]", "Prints usage information. If specified all other arguments (except 'v') are ignored", "off"}, {"v", "[on|off]", "Prints version and copyright information", "off"}, {"verbose", "[on|off]", "Prints information about the decoded codestream", "on"}, {"pfile", "<filename>", "Loads the arguments from the specified file. Arguments that are specified on the command line override the ones from the file.\nThe arguments file is a simple text file with one argument per line of the following form:\n  <argument name>=<argument value>\nIf the argument is of boolean type (i.e. its presence turns a feature on), then the 'on' value turns it on, while the 'off' value turns it off. The argument name does not include the '-' or '+' character. Long lines can be broken into several lines by terminating them with '\\'. Lines starting with '#' are considered as comments. This option is not recursive: any 'pfile' argument appearing in the file is ignored.", null}, {"res", "<resolution level index>", "The resolution level at which to reconstruct the image  (0 means the lowest available resolution whereas the maximum resolution level corresponds to the original image resolution). If the given index is greater than the number of available resolution levels of the compressed image, the image is reconstructed at its highest resolution (among all tile-components). Note that this option affects only the inverse wavelet transform and not the number  of bytes read by the codestream parser: this number of bytes depends only on options '-nbytes' or '-rate'.", null}, {"i", "<filename or url>", "The file containing the JPEG 2000 compressed data. This can be either a JPEG 2000 codestream or a JP2 file containing a JPEG 2000 codestream. In the latter case the first codestream in the file will be decoded. If an URL is specified (e.g., http://...) the data will be downloaded and cached in memory before decoding. This is intended for easy use in applets, but it is not a very efficient way of decoding network served data.", null}, {"o", "<filename>", "This is the name of the file to which the decompressed image is written. If no output filename is given, the image is displayed on the screen. Output file format is PGX by default. If the extension is '.pgm' then a PGM file is written as output, however this is only permitted if the component bitdepth does not exceed 8. If the extension is '.ppm' then a PPM file is written, however this is only permitted if there are 3 components and none of them has a bitdepth of more than 8. If there is more than 1 component, suffices '-1', '-2', '-3', ... are added to the file name, just before the extension, except for PPM files where all three components are written to the same file.", null}, {"rate", "<decoding rate in bpp>", "Specifies the decoding rate in bits per pixel (bpp) where the number of pixels is related to the image's original size (Note: this number is not affected by the '-res' option). If it is equalto -1, the whole codestream is decoded. The codestream is either parsed (default) or truncated depending the command line option '-parsing'. To specify the decoding rate in bytes, use '-nbytes' options instead.", "-1"}, {"nbytes", "<decoding rate in bytes>", "Specifies the decoding rate in bytes. The codestream is either parsed (default) or truncated depending the command line option '-parsing'. To specify the decoding rate in bits per pixel, use '-rate' options instead.", "-1"}, {"parsing", null, "Enable or not the parsing mode when decoding rate is specified ('-nbytes' or '-rate' options). If it is false, the codestream is decoded as if it were truncated to the given rate. If it is true, the decoder creates, truncates and decodes a virtual layer progressive codestream with the same truncation points in each code-block.", "on"}, {"ncb_quit", "<max number of code blocks>", "Use the ncb and lbody quit conditions. If state information is found for more code blocks than is indicated with this option, the decoder will decode using only information found before that point. Using this otion implies that the 'rate' or 'nbyte' parameter is used to indicate the lbody parameter which is the number of packet body bytes the decoder will decode.", "-1"}, {"l_quit", "<max number of layers>", "Specifies the maximum number of layers to decode for any code-block", "-1"}, {"m_quit", "<max number of bit planes>", "Specifies the maximum number of bit planes to decode for any code-block", "-1"}, {"poc_quit", null, "Specifies the whether the decoder should only decode code-blocks included in the first progression order.", "off"}, {"one_tp", null, "Specifies whether the decoder should only decode the first tile part of each tile.", "off"}, {"comp_transf", null, "Specifies whether the component transform indicated in the codestream should be used.", "on"}, {"debug", null, "Print debugging messages when an error is encountered.", "off"}, {"cdstr_info", null, "Display information about the codestream. This information is: \n- Marker segments value in main and tile-part headers,\n- Tile-part length and position within the code-stream.", "off"}, {"nocolorspace", null, "Ignore any colorspace information in the image.", "off"}, {"colorspace_debug", null, "Print debugging messages when an error is encountered in the colorspace module.", "off"}};

    public Decoder(ParameterList pl, ImgScrollPane isp) {
        this.pl = pl;
        this.defpl = pl.getDefaultParameterList();
        this.isp = isp;
    }

    public Decoder(ParameterList pl) {
        this(pl, null);
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void run() {
        outfile = "";
        outbase = "";
        outext = "";
        out = null;
        imwriter = null;
        decSpec = null;
        disp = false;
        img = null;
        ins = null;
        btitle = "";
        try {
            try {
                if (this.pl.getBooleanParameter("v")) {
                    this.printVersionAndCopyright();
                }
                if (this.pl.getParameter("u").equals("on")) {
                    this.printUsage();
                    return;
                }
                verbose = this.pl.getBooleanParameter("verbose");
            }
            catch (StringFormatException e) {
                this.error("An error occured while parsing the arguments:\n" + e.getMessage(), 1);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            catch (NumberFormatException e) {
                this.error("An error occured while parsing the arguments:\n" + e.getMessage(), 1);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                this.pl.checkList(Decoder.vprfxs, ParameterList.toNameArray(Decoder.pinfo));
            }
            catch (IllegalArgumentException e) {
                this.error(e.getMessage(), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            infile = this.pl.getParameter("i");
            if (infile == null) {
                this.error("Input file ('-i' option) has not been specified", 1);
                return;
            }
            outfile = this.pl.getParameter("o");
            if (outfile == null) {
                disp = true;
            } else if (outfile.lastIndexOf(46) != -1) {
                outext = outfile.substring(outfile.lastIndexOf(46), outfile.length());
                outbase = outfile.substring(0, outfile.lastIndexOf(46));
            } else {
                outbase = outfile;
                outext = ".pgx";
            }
            if (infile.indexOf("/") >= 1 && infile.charAt(infile.indexOf("/") - 1) == ':') {
                try {
                    inurl = new URL(infile);
                }
                catch (MalformedURLException e) {
                    this.error("Malformed URL for input file " + infile, 4);
                    if (this.pl.getParameter("debug").equals("on")) {
                        e.printStackTrace();
                    } else {
                        this.error("Use '-debug' option for more details", 2);
                    }
                    return;
                }
                try {
                    conn = inurl.openConnection();
                    conn.connect();
                }
                catch (IOException e) {
                    this.error("Cannot open connection to " + infile + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 4);
                    if (this.pl.getParameter("debug").equals("on")) {
                        e.printStackTrace();
                    } else {
                        this.error("Use '-debug' option for more details", 2);
                    }
                    return;
                }
                datalen = conn.getContentLength();
                try {
                    is = conn.getInputStream();
                }
                catch (IOException e) {
                    this.error("Cannot get data from connection to " + infile + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 4);
                    if (this.pl.getParameter("debug").equals("on")) {
                        e.printStackTrace();
                    } else {
                        this.error("Use '-debug' option for more details", 2);
                    }
                    return;
                }
                in = datalen != -1 ? new ISRandomAccessIO(is, datalen, 1, datalen) : new ISRandomAccessIO(is);
                try {
                    in.read();
                    in.seek(0);
                }
                catch (IOException e) {
                    this.error("Cannot get input data from " + infile + " Invalid URL?", 4);
                    if (this.pl.getParameter("debug").equals("on")) {
                        e.printStackTrace();
                    } else {
                        this.error("Use '-debug' option for more details", 2);
                    }
                    return;
                }
            }
            try {
                in = new BEBufferedRandomAccessFile(infile, "r");
            }
            catch (IOException e) {
                this.error("Cannot open input file " + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 4);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            ff = new FileFormatReader(in);
            ff.readFileFormat();
            if (ff.JP2FFUsed) {
                in.seek(ff.getFirstCodeStreamPos());
            }
            this.hi = new HeaderInfo();
            try {
                hd = new HeaderDecoder(in, this.pl, this.hi);
            }
            catch (EOFException e) {
                this.error("Codestream too short or bad header, unable to decode.", 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            nCompCod = hd.getNumComps();
            nTiles = this.hi.siz.getNumTiles();
            decSpec = hd.getDecoderSpecs();
            if (verbose) {
                info = nCompCod + " component(s) in codestream, " + nTiles + " tile(s)\n";
                info = info + "Image dimension: ";
                for (c = 0; c < nCompCod; ++c) {
                    info = info + this.hi.siz.getCompImgWidth(c) + "x" + this.hi.siz.getCompImgHeight(c) + " ";
                }
                if (nTiles != 1) {
                    info = info + "\nNom. Tile dim. (in canvas): " + this.hi.siz.xtsiz + "x" + this.hi.siz.ytsiz;
                }
                FacilityManager.getMsgLogger().printmsg(1, info);
            }
            if (this.pl.getBooleanParameter("cdstr_info")) {
                FacilityManager.getMsgLogger().printmsg(1, "Main header:\n" + this.hi.toStringMainHeader());
            }
            depth = new int[nCompCod];
            for (i = 0; i < nCompCod; ++i) {
                depth[i] = hd.getOriginalBitDepth(i);
            }
            try {
                breader = BitstreamReaderAgent.createInstance(in, hd, this.pl, decSpec, this.pl.getBooleanParameter("cdstr_info"), this.hi);
            }
            catch (IOException e) {
                this.error("Error while reading bit stream header or parsing packets" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 4);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            catch (IllegalArgumentException e) {
                this.error("Cannot instantiate bit stream reader" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                entdec = hd.createEntropyDecoder(breader, this.pl);
            }
            catch (IllegalArgumentException e) {
                this.error("Cannot instantiate entropy decoder" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                roids = hd.createROIDeScaler(entdec, this.pl, decSpec);
            }
            catch (IllegalArgumentException e) {
                this.error("Cannot instantiate roi de-scaler." + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                deq = hd.createDequantizer(roids, depth, decSpec);
            }
            catch (IllegalArgumentException e) {
                this.error("Cannot instantiate dequantizer" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                invWT = InverseWT.createInstance(deq, decSpec);
            }
            catch (IllegalArgumentException e) {
                this.error("Cannot instantiate inverse wavelet transform" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            res = breader.getImgRes();
            invWT.setImgResLevel(res);
            converter = new ImgDataConverter(invWT, 0);
            ictransf = new InvCompTransf(converter, decSpec, depth, this.pl);
            if (ff.JP2FFUsed && this.pl.getParameter("nocolorspace").equals("off")) {
                try {
                    this.csMap = new ColorSpace(in, hd, this.pl);
                    channels = hd.createChannelDefinitionMapper(ictransf, this.csMap);
                    resampled = hd.createResampler(channels, this.csMap);
                    palettized = hd.createPalettizedColorSpaceMapper(resampled, this.csMap);
                    color /* !! */  = hd.createColorSpaceMapper(palettized, this.csMap);
                    if (!this.csMap.debugging()) ** GOTO lbl230
                    FacilityManager.getMsgLogger().printmsg(3, "" + this.csMap);
                    FacilityManager.getMsgLogger().printmsg(3, "" + channels);
                    FacilityManager.getMsgLogger().printmsg(3, "" + resampled);
                    FacilityManager.getMsgLogger().printmsg(3, "" + palettized);
                    FacilityManager.getMsgLogger().printmsg(3, "" + color /* !! */ );
                }
                catch (IllegalArgumentException e) {
                    this.error("Could not instantiate ICC profiler" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 1, e);
                    return;
                }
                catch (ColorSpaceException e) {
                    this.error("error processing jp2 colorspace information" + (e.getMessage() != null ? ": " + e.getMessage() : "    "), 1, e);
                    return;
                }
            } else {
                color /* !! */  = ictransf;
            }
lbl230:
            // 3 sources

            decodedImage = color /* !! */ ;
            if (color /* !! */  == null) {
                decodedImage = ictransf;
            }
            nCompImg = decodedImage.getNumComps();
            if (disp) {
                btitle = "JJ2000: " + new File(infile).getName() + " " + decodedImage.getImgWidth() + "x" + decodedImage.getImgHeight();
                if (this.isp == null) {
                    this.win = new Frame(btitle + " @ (0,0) : 1");
                    this.win.setBackground(Color.white);
                    this.win.addWindowListener(new ExitHandler(this));
                    this.isp = new ImgScrollPane(0);
                    this.win.add((Component)this.isp, "Center");
                    this.isp.addKeyListener(new ImgKeyListener(this.isp, this));
                    this.win.addKeyListener(new ImgKeyListener(this.isp, this));
                } else {
                    this.win = null;
                }
                if (this.win != null) {
                    this.win.addNotify();
                    ins = this.win.getInsets();
                    subX = decodedImage.getCompSubsX(0);
                    subY = decodedImage.getCompSubsY(0);
                    w = (decodedImage.getImgWidth() + subX - 1) / subX;
                    h = (decodedImage.getImgHeight() + subY - 1) / subY;
                    winDim = new Dimension(w + ins.left + ins.right, h + ins.top + ins.bottom);
                    scrnDim = this.win.getToolkit().getScreenSize();
                    if ((float)winDim.width > (float)(scrnDim.width * 8) / 10.0f) {
                        winDim.width = (int)((float)(scrnDim.width * 8) / 10.0f);
                    }
                    if ((float)winDim.height > (float)(scrnDim.height * 8) / 10.0f) {
                        winDim.height = (int)((float)(scrnDim.height * 8) / 10.0f);
                    }
                    this.win.setSize(winDim);
                    this.win.validate();
                    this.win.setVisible(true);
                    this.title = new TitleUpdater(this.isp, this.win, btitle);
                    tu = new Thread(this.title);
                    tu.start();
                } else {
                    this.title = null;
                }
            } else {
                if (this.csMap != null) {
                    if (outext.equalsIgnoreCase(".PPM") && (nCompImg != 3 || decodedImage.getNomRangeBits(0) > 8 || decodedImage.getNomRangeBits(1) > 8 || decodedImage.getNomRangeBits(2) > 8 || this.csMap.isOutputSigned(0) || this.csMap.isOutputSigned(1) || this.csMap.isOutputSigned(2))) {
                        this.error("Specified PPM output file but compressed image is not of the correct format for PPM or limited decoded components to less than 3.", 1);
                        return;
                    }
                } else if (outext.equalsIgnoreCase(".PPM") && (nCompImg != 3 || decodedImage.getNomRangeBits(0) > 8 || decodedImage.getNomRangeBits(1) > 8 || decodedImage.getNomRangeBits(2) > 8 || hd.isOriginalSigned(0) || hd.isOriginalSigned(1) || hd.isOriginalSigned(2))) {
                    this.error("Specified PPM output file but compressed image is not of the correct format for PPM or limited decoded components to less than 3.", 1);
                    return;
                }
                out = new String[nCompImg];
                for (i = 0; i < nCompImg; ++i) {
                    out[i] = "";
                }
                if (nCompImg > 1 && !outext.equalsIgnoreCase(".PPM")) {
                    if (outext.equalsIgnoreCase(".PGM")) {
                        for (i = 0; i < nCompImg; ++i) {
                            if (this.csMap != null) {
                                if (!this.csMap.isOutputSigned(i)) continue;
                                this.error("Specified PGM output file but compressed image is not of the correct format for PGM.", 1);
                                return;
                            }
                            if (!hd.isOriginalSigned(i)) continue;
                            this.error("Specified PGM output file but compressed image is not of the correct format for PGM.", 1);
                            return;
                        }
                    }
                    for (i = 0; i < nCompImg; ++i) {
                        out[i] = outbase + "-" + (i + 1) + outext;
                    }
                } else {
                    out[0] = outbase + outext;
                }
                if (outext.equalsIgnoreCase(".PPM")) {
                    imwriter = new ImgWriter[1];
                    try {
                        imwriter[0] = new ImgWriterPPM(out[0], (BlkImgDataSrc)decodedImage, 0, 1, 2);
                    }
                    catch (IOException e) {
                        this.error("Cannot write PPM header or open output file" + i + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                        if (this.pl.getParameter("debug").equals("on")) {
                            e.printStackTrace();
                        } else {
                            this.error("Use '-debug' option for more details", 2);
                        }
                        return;
                    }
                } else {
                    imwriter = new ImgWriter[nCompImg];
                }
                if (this.csMap != null) {
                    if (imwriter.length == 3 && decodedImage.getNomRangeBits(0) <= 8 && decodedImage.getNomRangeBits(1) <= 8 && decodedImage.getNomRangeBits(2) <= 8 && !this.csMap.isOutputSigned(0) && !this.csMap.isOutputSigned(1) && !this.csMap.isOutputSigned(2) && decSpec.cts.isCompTransfUsed()) {
                        this.warning("JJ2000 is quicker with one PPM output file than with 3 PGM/PGX output files when a component transformation is applied.");
                    }
                } else if (imwriter.length == 3 && decodedImage.getNomRangeBits(0) <= 8 && decodedImage.getNomRangeBits(1) <= 8 && decodedImage.getNomRangeBits(2) <= 8 && !hd.isOriginalSigned(0) && !hd.isOriginalSigned(1) && !hd.isOriginalSigned(2) && decSpec.cts.isCompTransfUsed()) {
                    this.warning("JJ2000 is quicker with one PPM output file than with 3 PGM/PGX output files when a component transformation is applied.");
                }
            }
            mrl = decSpec.dls.getMin();
            if (verbose) {
                if (mrl != res) {
                    FacilityManager.getMsgLogger().println("Reconstructing resolution " + res + " on " + mrl + " (" + breader.getImgWidth(res) + "x" + breader.getImgHeight(res) + ")", 8, 8);
                }
                if (this.pl.getFloatParameter("rate") != -1.0f) {
                    FacilityManager.getMsgLogger().println("Target rate = " + breader.getTargetRate() + " bpp (" + breader.getTargetNbytes() + " bytes)", 8, 8);
                }
            }
            if (disp) {
                Thread.currentThread().setPriority(2);
                img = BlkImgDataSrcImageProducer.createImage(decodedImage, this.isp);
                this.isp.setCursor(Cursor.getPredefinedCursor(3));
                if (this.win != null) {
                    this.win.setCursor(Cursor.getPredefinedCursor(3));
                }
                this.isp.setImage(img);
                this.isp.setCursor(Cursor.getPredefinedCursor(0));
                if (this.win != null) {
                    this.win.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (this.win != null) {
                    do {
                        if (((status = this.isp.checkImage(img, null)) & 64) != 0) {
                            FacilityManager.getMsgLogger().printmsg(3, "An unknown error occurred while producing the image");
                            return;
                        }
                        if ((status & 128) != 0) {
                            FacilityManager.getMsgLogger().printmsg(3, "Image production was aborted for some unknown reason");
                            continue;
                        }
                        if ((status & 32) != 0) {
                            iml = new ImgMouseListener(this.isp);
                            this.isp.addMouseListener(iml);
                            this.isp.addMouseMotionListener(iml);
                            continue;
                        }
                        try {
                            Thread.currentThread();
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    } while ((status & 224) == 0);
                }
            } else {
                for (i = 0; i < imwriter.length; ++i) {
                    if (outext.equalsIgnoreCase(".PGM")) {
                        try {
                            imwriter[i] = new ImgWriterPGM(out[i], (BlkImgDataSrc)decodedImage, i);
                        }
                        catch (IOException e) {
                            this.error("Cannot write PGM header or open output file for component " + i + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                            if (this.pl.getParameter("debug").equals("on")) {
                                e.printStackTrace();
                            } else {
                                this.error("Use '-debug' option for more details", 2);
                            }
                            return;
                        }
                    }
                    if (outext.equalsIgnoreCase(".PGX")) {
                        try {
                            imwriter[i] = this.csMap != null ? new ImgWriterPGX(out[i], (BlkImgDataSrc)decodedImage, i, this.csMap.isOutputSigned(i)) : new ImgWriterPGX(out[i], (BlkImgDataSrc)decodedImage, i, hd.isOriginalSigned(i));
                        }
                        catch (IOException e) {
                            this.error("Cannot write PGX header or open output file for component " + i + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                            if (this.pl.getParameter("debug").equals("on")) {
                                e.printStackTrace();
                            } else {
                                this.error("Use '-debug' option for more details", 2);
                            }
                            return;
                        }
                    }
                    try {
                        imwriter[i].writeAll();
                    }
                    catch (IOException e) {
                        this.error("I/O error while writing output file" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                        if (this.pl.getParameter("debug").equals("on")) {
                            e.printStackTrace();
                        } else {
                            this.error("Use '-debug' option for more details", 2);
                        }
                        return;
                    }
                    try {
                        imwriter[i].close();
                        continue;
                    }
                    catch (IOException e) {
                        this.error("I/O error while closing output file (data may be corrupted" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                        if (this.pl.getParameter("debug").equals("on")) {
                            e.printStackTrace();
                        } else {
                            this.error("Use '-debug' option for more details", 2);
                        }
                        return;
                    }
                }
            }
            if (verbose) {
                bitrate = breader.getActualRate();
                numBytes = breader.getActualNbytes();
                if (ff.JP2FFUsed) {
                    imageSize = (int)(8.0f * (float)numBytes / bitrate);
                    bitrate = (float)(numBytes += ff.getFirstCodeStreamPos()) * 8.0f / (float)imageSize;
                }
                if (this.pl.getIntParameter("ncb_quit") == -1) {
                    FacilityManager.getMsgLogger().println("Actual bitrate = " + bitrate + " bpp (i.e. " + numBytes + " bytes)", 8, 8);
                } else {
                    FacilityManager.getMsgLogger().println("Number of packet body bytes read = " + numBytes, 8, 8);
                }
                FacilityManager.getMsgLogger().flush();
            }
        }
        catch (IllegalArgumentException e) {
            this.error(e.getMessage(), 2);
            if (this.pl.getParameter("debug").equals("on")) {
                e.printStackTrace();
            }
            return;
        }
        catch (Error e) {
            if (e.getMessage() != null) {
                this.error(e.getMessage(), 2);
            } else {
                this.error("An error has occured during decoding.", 2);
            }
            if (this.pl.getParameter("debug").equals("on")) {
                e.printStackTrace();
            } else {
                this.error("Use '-debug' option for more details", 2);
            }
            return;
        }
        catch (RuntimeException e) {
            if (e.getMessage() != null) {
                this.error("An uncaught runtime exception has occurred:\n" + e.getMessage(), 2);
            } else {
                this.error("An uncaught runtime exception has occurred.", 2);
            }
            if (this.pl.getParameter("debug").equals("on")) {
                e.printStackTrace();
            } else {
                this.error("Use '-debug' option for more details", 2);
            }
            return;
        }
        catch (Throwable e) {
            this.error("An uncaught exception has occurred.", 2);
            if (this.pl.getParameter("debug").equals("on")) {
                e.printStackTrace();
            } else {
                this.error("Use '-debug' option for more details", 2);
            }
            return;
        }
    }

    private void error(String msg, int code) {
        this.exitCode = code;
        FacilityManager.getMsgLogger().printmsg(3, msg);
    }

    private void error(String msg, int code, Throwable ex) {
        this.exitCode = code;
        FacilityManager.getMsgLogger().printmsg(3, msg);
        if (this.pl.getParameter("debug").equals("on")) {
            ex.printStackTrace();
        } else {
            this.error("Use '-debug' option for more details", 2);
        }
    }

    public String[] getCOMInfo() {
        if (this.hi == null) {
            return null;
        }
        int nCOMMarkers = this.hi.getNumCOM();
        Enumeration com = this.hi.com.elements();
        String[] infoCOM = new String[nCOMMarkers];
        for (int i = 0; i < nCOMMarkers; ++i) {
            infoCOM[i] = com.nextElement().toString();
        }
        return infoCOM;
    }

    public static String[][] getAllParameters() {
        int i;
        Vector<String[]> vec = new Vector<String[]>();
        String[][] str = BitstreamReaderAgent.getParameterInfo();
        if (str != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = EntropyDecoder.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = ROIDeScaler.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = Dequantizer.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = InvCompTransf.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = HeaderDecoder.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = ICCProfiler.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = Decoder.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = new String[vec.size()][4]) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                str[i] = (String[])vec.elementAt(i);
            }
        }
        return str;
    }

    private void warning(String msg) {
        FacilityManager.getMsgLogger().printmsg(2, msg);
    }

    private void printVersionAndCopyright() {
        FacilityManager.getMsgLogger().println("JJ2000's JPEG 2000 Decoder\n", 2, 4);
        FacilityManager.getMsgLogger().println("Version: 5.1\n", 2, 4);
        FacilityManager.getMsgLogger().println("Copyright:\n\nThis software module was originally developed by Rapha\u00ebl Grosbois and Diego Santa Cruz (Swiss Federal Institute of Technology-EPFL); Joel Askel\u00f6f (Ericsson Radio Systems AB); and Bertrand Berthelot, David Bouchard, F\u00e9lix Henry, Gerard Mozelle and Patrice Onno (Canon Research Centre France S.A) in the course of development of the JPEG 2000 standard as specified by ISO/IEC 15444 (JPEG 2000 Standard). This software module is an implementation of a part of the JPEG 2000 Standard. Swiss Federal Institute of Technology-EPFL, Ericsson Radio Systems AB and Canon Research Centre France S.A (collectively JJ2000 Partners) agree not to assert against ISO/IEC and users of the JPEG 2000 Standard (Users) any of their rights under the copyright, not including other intellectual property rights, for this software module with respect to the usage by ISO/IEC and Users of this software module or modifications thereof for use in hardware or software products claiming conformance to the JPEG 2000 Standard. Those intending to use this software module in hardware or software products are advised that their use may infringe existing patents. The original developers of this software module, JJ2000 Partners and ISO/IEC assume no liability for use of this software module or modifications thereof. No license or right to this software module is granted for non JPEG 2000 Standard conforming products. JJ2000 Partners have full right to use this software module for his/her own purpose, assign or donate this software module to any third party and to inhibit third parties from using this software module for non JPEG 2000 Standard conforming products. This copyright notice must be included in all copies or derivative works of this software module.\n\nCopyright (c) 1999/2000 JJ2000 Partners.\n", 2, 4);
        FacilityManager.getMsgLogger().println("Send bug reports to: jj2000-bugs@ltssg3.epfl.ch\n", 2, 4);
    }

    private void printUsage() {
        MsgLogger ml = FacilityManager.getMsgLogger();
        ml.println("Usage:", 0, 0);
        ml.println("JJ2KDecoder args...\n", 10, 12);
        ml.println("The exit code of the decoder is non-zero if an error occurs.", 2, 4);
        ml.println("The following arguments are recongnized:\n", 2, 4);
        this.printParamInfo(ml, Decoder.getAllParameters());
        FacilityManager.getMsgLogger().println("\n\n", 0, 0);
        FacilityManager.getMsgLogger().println("Send bug reports to: jj2000-bugs@ltssg3.epfl.ch\n", 2, 4);
    }

    private void printParamInfo(MsgLogger out, String[][] pinfo) {
        for (int i = 0; i < pinfo.length; ++i) {
            String defval = this.defpl.getParameter(pinfo[i][0]);
            if (defval != null) {
                out.println("-" + pinfo[i][0] + (pinfo[i][1] != null ? " " + pinfo[i][1] + " " : " ") + "(default = " + defval + ")", 4, 8);
            } else {
                out.println("-" + pinfo[i][0] + (pinfo[i][1] != null ? " " + pinfo[i][1] : ""), 4, 8);
            }
            if (pinfo[i][2] == null) continue;
            out.println(pinfo[i][2], 6, 6);
        }
    }

    public void exit() {
        if (this.isChildProcess) {
            if (this.win != null) {
                this.win.dispose();
            }
            if (this.title != null) {
                this.title.done = true;
            }
            return;
        }
        System.exit(0);
    }

    public void setChildProcess(boolean b) {
        this.isChildProcess = b;
    }
}

