/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.AreaFile;
import edu.wisc.ssec.mcidas.McIDASException;
import java.awt.geom.Rectangle2D;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.util.Parameter;

public class McIDASAreaProjection
extends ProjectionImpl {
    public static String ATTR_AREADIR = "AreaDirectory";
    public static String ATTR_NAVBLOCK = "NavBlock";
    public static String ATTR_AUXBLOCK = "AuxBlock";
    public static String GRID_MAPPING_NAME = "mcidas_area";
    private AREAnav anav = null;
    private int lines;
    private int elements;
    private int[] dirBlock;
    private int[] navBlock;
    private int[] auxBlock;

    @Override
    public ProjectionImpl constructCopy() {
        return new McIDASAreaProjection(this.dirBlock, this.navBlock, this.auxBlock);
    }

    public McIDASAreaProjection() {
    }

    public McIDASAreaProjection(AreaFile af) {
        this(af.getDir(), af.getNav(), af.getAux());
    }

    public McIDASAreaProjection(int[] dir, int[] nav) {
        this(dir, nav, null);
    }

    public McIDASAreaProjection(int[] dir, int[] nav, int[] aux) {
        try {
            this.anav = AREAnav.makeAreaNav(nav, aux);
        }
        catch (McIDASException excp) {
            throw new IllegalArgumentException("McIDASAreaProjection: problem creating projection" + excp);
        }
        this.dirBlock = dir;
        this.navBlock = nav;
        this.auxBlock = aux;
        this.anav.setImageStart(dir[5], dir[6]);
        this.anav.setRes(dir[11], dir[12]);
        this.anav.setStart(0, 0);
        this.anav.setMag(1, 1);
        this.lines = dir[8];
        this.elements = dir[9];
        this.anav.setFlipLineCoordinates(dir[8]);
        this.addParameter("grid_mapping_name", GRID_MAPPING_NAME);
        this.addParameter(new Parameter(ATTR_AREADIR, this.makeDoubleArray(dir)));
        this.addParameter(new Parameter(ATTR_NAVBLOCK, this.makeDoubleArray(nav)));
        if (aux != null) {
            this.addParameter(new Parameter(ATTR_AUXBLOCK, this.makeDoubleArray(aux)));
        }
    }

    public int[] getDirBlock() {
        return this.dirBlock;
    }

    public int[] getNavBlock() {
        return this.navBlock;
    }

    public int[] getAuxBlock() {
        return this.auxBlock;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        double[][] xy = this.anav.toLinEle(new double[][]{{fromLat}, {fromLon}});
        double toX = xy[0][0];
        double toY = xy[1][0];
        result.setLocation(toX, toY);
        return result;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double fromX = world.getX();
        double fromY = world.getY();
        double[][] latlon = this.anav.toLatLon(new double[][]{{fromX}, {fromY}});
        double toLat = latlon[0][0];
        double toLon = latlon[1][0];
        result.setLatitude(toLat);
        result.setLongitude(toLon);
        return result;
    }

    @Override
    public float[][] latLonToProj(float[][] from, float[][] to, int latIndex, int lonIndex) {
        float[] fromLatA = from[latIndex];
        float[] fromLonA = from[lonIndex];
        float[][] xy = this.anav.toLinEle(new float[][]{fromLatA, fromLonA});
        to[0] = xy[0];
        to[1] = xy[1];
        return to;
    }

    @Override
    public float[][] projToLatLon(float[][] from, float[][] to) {
        float[] fromXA = from[0];
        float[] fromYA = from[1];
        float[][] latlon = this.anav.toLatLon(new float[][]{fromXA, fromYA});
        to[0] = latlon[0];
        to[1] = latlon[1];
        return to;
    }

    @Override
    public double[][] latLonToProj(double[][] from, double[][] to, int latIndex, int lonIndex) {
        double[] fromLatA = from[latIndex];
        double[] fromLonA = from[lonIndex];
        double[][] xy = this.anav.toLinEle(new double[][]{fromLatA, fromLonA});
        to[0] = xy[0];
        to[1] = xy[1];
        return to;
    }

    @Override
    public double[][] projToLatLon(double[][] from, double[][] to) {
        double[] fromXA = from[0];
        double[] fromYA = from[1];
        double[][] latlon = this.anav.toLatLon(new double[][]{fromXA, fromYA});
        to[0] = latlon[0];
        to[1] = latlon[1];
        return to;
    }

    @Override
    public ProjectionRect getDefaultMapArea() {
        return new ProjectionRect(new Rectangle2D.Float(0.0f, 0.0f, this.elements, this.lines));
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        if (ProjectionPointImpl.isInfinite(pt1) || ProjectionPointImpl.isInfinite(pt2)) {
            return true;
        }
        if (Double.isNaN(pt1.getX()) || Double.isNaN(pt1.getY()) || Double.isNaN(pt2.getX()) || Double.isNaN(pt2.getY())) {
            return true;
        }
        return pt1.getX() * pt2.getX() < 0.0 && Math.abs(pt1.getX() - pt2.getX()) > 5000.0;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof McIDASAreaProjection)) {
            return false;
        }
        McIDASAreaProjection that = (McIDASAreaProjection)obj;
        return this == that || this.anav.equals(that.anav) && this.lines == that.lines && this.elements == that.elements;
    }

    @Override
    public String toString() {
        return "Image (" + this.anav.toString() + ") Projection";
    }

    @Override
    public String paramsToString() {
        return " nav " + this.anav.toString();
    }

    public static void main(String[] args) throws Exception {
        String file = args.length > 0 ? args[0] : "c:/data/satellite/AREA8760";
        AreaFile af = new AreaFile(file);
        McIDASAreaProjection proj = new McIDASAreaProjection(af);
        LatLonPoint llp = new LatLonPointImpl(45.0, -105.0);
        System.out.println("lat/lon = " + llp);
        ProjectionPoint pp = proj.latLonToProj(llp);
        System.out.println("proj point = " + pp);
        llp = proj.projToLatLon(pp);
        System.out.println("reverse llp = " + llp);
        double[][] latlons = new double[][]{{45.0}, {-105.0}};
        double[][] linele = proj.latLonToProj(latlons);
        System.out.println("proj point = " + linele[0][0] + "," + linele[1][0]);
        double[][] outll = proj.projToLatLon(linele);
        System.out.println("proj point = " + outll[0][0] + "," + outll[1][0]);
    }

    private double[] makeDoubleArray(int[] ints) {
        double[] newArray = new double[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            newArray[i] = ints[i];
        }
        return newArray;
    }
}

